<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    @yield('title')

    <link rel="shortcut icon" href="{{ asset($setting->favicon) }}">
    <link rel="stylesheet" href="{{ asset('frontend/fontawesome/css/all.css') }}">
    <link rel="stylesheet" href="{{ asset('frontend/css/bootstrap.min.css') }}">
    <link rel="stylesheet" href="{{ asset('global/select2/select2.min.css') }}">
    <link rel="stylesheet" href="{{ asset('frontend/css/aos.css') }}">
    <link rel="stylesheet" href="{{ asset('frontend/css/slick.css') }}">
    <link rel="stylesheet" href="{{ asset('frontend/css/venobox.min.css') }}">
    <link rel="stylesheet" href="{{ asset('frontend/css/style.css') }}">
    <link rel="stylesheet" href="{{ asset('frontend/css/responsive.css') }}">

    <link rel="stylesheet" href="{{ asset('global/toastr/toastr.min.css') }}">

    @stack('style_section')

    @php use App\Constants\Status; @endphp
    @if ($google_analytic->status == 1)
        <script async src="https://www.googletagmanager.com/gtag/js?id={{ $google_analytic->analytic_id }}"></script>
        <script>
            window.dataLayer = window.dataLayer || [];

            function gtag() {
                dataLayer.push(arguments);
            }

            gtag('js', new Date());
            gtag('config', '{{ $google_analytic->analytic_id }}');
        </script>
    @endif

    @if ($facebook_pixel->status == 1)
        <script>
            !function (f, b, e, v, n, t, s) {
                if (f.fbq) return;
                n = f.fbq = function () {
                    n.callMethod ?
                        n.callMethod.apply(n, arguments) : n.queue.push(arguments)
                };
                if (!f._fbq) f._fbq = n;
                n.push = n;
                n.loaded = !0;
                n.version = '2.0';
                n.queue = [];
                t = b.createElement(e);
                t.async = !0;
                t.src = v;
                s = b.getElementsByTagName(e)[0];
                s.parentNode.insertBefore(t, s)
            }(window, document, 'script',
                'https://connect.facebook.net/en_US/fbevents.js');
            fbq('init', '{{ $facebook_pixel->app_id }}');
            fbq('track', 'PageView');
        </script>
        <noscript><img height="1" width="1" style="display:none"
                       src="https://www.facebook.com/tr?id={{ $facebook_pixel->app_id }}&ev=PageView&noscript=1"
            /></noscript>
    @endif

</head>

<body>

@php
    if (auth()->check()) {
        $userId = auth()->id();
        $totalCart = Modules\Ecommerce\Entities\Cart::where("user_id", $userId)->count();
    } else {
        $sessionId = session()->get("session_id");
        $totalCart = Modules\Ecommerce\Entities\Cart::where("session_id", $sessionId)->count();
    }
@endphp
@if ($setting->preloader_status == 'enable')
    <!-- preloader start -->
    <div id="loader">
        <div id="loader_bar"></div>
    </div>
    <!-- preloader end -->
@endif

@if (Route::is('home'))
    @if (Session::get('selected_theme') == 'theme_three')
        <header class="header header-three">
            <nav class="menu-bg  menu-bg-two ">
                <div class="container">
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="nav-main">
                                <div class="nav-left">

                                    <div class="logo">
                                        <a href="{{ route('home') }}"><img src="{{ custom_asset($setting->logo, '170x40') }}" alt="logo"></a>
                                    </div>

                                    <ul class="menu">
                                        @foreach($header_menuItems as $menuItem)
                                            @php
                                                $childMenuItems = $header_menuItems->where('parent_id', $menuItem?->id)->sortBy('sort_order');
                                            @endphp

                                            @if ($menuItem?->parent_id == null)
                                                <li>
                                                    @if($childMenuItems->count() > 0)
                                                        <a href="javascript:;">{{ $menuItem?->title }} <i class="fa-solid fa-angle-down"></i></a>
                                                        <ul class="sub-menu">
                                                            @foreach($childMenuItems as $childItem)
                                                                <li>
                                                                    <a href="{{ $childItem?->url }}" class="menu-link">{{ $childItem?->title }}</a>
                                                                </li>
                                                            @endforeach
                                                        </ul>
                                                    @else
                                                        <a href="{{ $menuItem?->url }}">{{ $menuItem?->title }}</a>
                                                    @endif
                                                </li>
                                            @endif
                                        @endforeach


                                        <li>
                                            <a href="{{ route('cart.cart') }}">{{ __('translate.Cart') }}
                                                <span class="cart-count">({{ $totalCart  }})</span>
                                            </a>
                                        </li>


                                    </ul>
                                </div>


                                <div class="menu-bg-dropdown-btn-right">
                                    <div class="usd-btn">
                                        <div class="dropdown">
                                            <button class="usd-btnn" type="button" id="dropdownMenuButton112"
                                                    data-bs-toggle="dropdown" aria-expanded="false">
                                                {{ Session::get('currency_name') }}
                                                <span class="arrow ">
                                                        <svg width="12" height="6" viewBox="0 0 12 6" fill="none"
                                                             xmlns="http://www.w3.org/2000/svg">
                                                            <path
                                                                d="M12.0002 0.633816C11.947 0.446997 11.8572 0.28353 11.6808 0.158011C11.3813 -0.0492418 10.9487 -0.0550799 10.6493 0.155092C10.5927 0.195958 10.5361 0.239744 10.4829 0.286449C9.02543 1.56499 7.56465 2.84645 6.10719 4.125C6.07391 4.15419 6.04729 4.18922 5.96743 4.24176C5.94414 4.20673 5.93083 4.16294 5.89755 4.13375C4.42679 2.84062 2.95269 1.5504 1.48192 0.257257C1.22237 0.0295716 0.922896 -0.0579998 0.563523 0.0412478C0.0411014 0.1872 -0.17186 0.776848 0.157565 1.16216C0.194168 1.20595 0.237426 1.24681 0.280683 1.28768C1.97772 2.7764 3.67144 4.26511 5.36848 5.75091C5.67794 6.02238 6.07059 6.07492 6.42663 5.89394C6.51315 5.85015 6.58968 5.78594 6.65956 5.72464C8.30669 4.27971 9.95049 2.83478 11.6009 1.39277C11.784 1.23222 11.947 1.06875 12.0002 0.838149C12.0002 0.771011 12.0002 0.703873 12.0002 0.633816Z"/>
                                                        </svg>
                                                    </span>
                                            </button>
                                            <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton112">
                                                @foreach ($currency_list as $currency_dropdown_item)
                                                    <li><a class="dropdown-item"
                                                           href="{{ route('currency-switcher', ['currency_code' => $currency_dropdown_item->currency_code]) }}">{{ $currency_dropdown_item->currency_name }}</a>
                                                    </li>
                                                @endforeach
                                            </ul>
                                        </div>
                                    </div>

                                    <div class="usd-btn">
                                        <div class="dropdown">
                                            <button class="usd-btnn " type="button" id="dropdownMenuButton125"
                                                    data-bs-toggle="dropdown" aria-expanded="false">
                                                    <span class="dollor ">
                                                        <svg width="17" height="17" viewBox="0 0 17 17" fill="none"
                                                             xmlns="http://www.w3.org/2000/svg">
                                                            <path fill-rule="evenodd" clip-rule="evenodd"
                                                                  d="M6.66412 2.60315C6.35861 3.37316 6.10995 4.30848 5.94194 5.35853C6.75487 5.28407 7.61377 5.24443 8.50002 5.24443C9.38628 5.24443 10.2452 5.28407 11.0581 5.35853C10.8901 4.30848 10.6414 3.37316 10.3359 2.60315C10.0423 1.86305 9.70879 1.30782 9.3715 0.948255C9.0355 0.590067 8.74079 0.469763 8.50002 0.469763C8.25925 0.469763 7.96454 0.590067 7.62854 0.948255C7.29126 1.30782 6.95776 1.86305 6.66412 2.60315ZM5.46486 2.11953C5.08366 3.08031 4.79116 4.23768 4.61189 5.51716C3.72942 5.64837 2.92409 5.82344 2.22562 6.03469C1.4129 6.2805 0.708156 6.58612 0.192177 6.95508C0.126989 7.0017 0.0626463 7.05096 3.89676e-05 7.1029C0.569579 3.55373 3.27347 0.725558 6.74127 1.07475e-06C6.72407 0.0176473 6.70701 0.0354882 6.6901 0.0535149C6.20323 0.57254 5.79453 1.28864 5.46486 2.11953ZM10.2588 0C10.276 0.0176466 10.293 0.0354878 10.3099 0.0535149C10.7968 0.57254 11.2055 1.28864 11.5352 2.11953C11.9164 3.08031 12.2089 4.23768 12.3882 5.51716C13.2706 5.64837 14.0759 5.82344 14.7744 6.03469C15.5871 6.2805 16.2919 6.58612 16.8079 6.95508C16.8731 7.0017 16.9374 7.05097 17 7.10291C16.4305 3.55374 13.7266 0.725556 10.2588 0ZM17 9.89684C16.9374 9.94879 16.8731 9.99807 16.8079 10.0447C16.2919 10.4137 15.5871 10.7193 14.7744 10.9651C14.0759 11.1763 13.2706 11.3514 12.3882 11.4826C12.2089 12.7621 11.9164 13.9195 11.5352 14.8802C11.2055 15.7111 10.7968 16.4272 10.3099 16.9463C10.293 16.9644 10.2758 16.9823 10.2585 17C13.7265 16.2746 16.4306 13.4462 17 9.89684ZM6.74153 17C6.72424 16.9823 6.70709 16.9644 6.6901 16.9463C6.20323 16.4272 5.79453 15.7111 5.46486 14.8802C5.08366 13.9195 4.79116 12.7621 4.61189 11.4826C3.72942 11.3514 2.92409 11.1763 2.22562 10.9651C1.4129 10.7193 0.708156 10.4137 0.192176 10.0447C0.126976 9.99807 0.0626196 9.94879 0 9.89684C0.56947 13.4462 3.27352 16.2745 6.74153 17ZM2.59677 9.71782C3.14458 9.8835 3.77487 10.0271 4.46958 10.1424C4.43026 9.60843 4.40984 9.05941 4.40984 8.49989C4.40984 7.94037 4.43026 7.39135 4.46958 6.85739C3.77488 6.97265 3.14458 7.11627 2.59677 7.28196C1.85121 7.50745 1.29492 7.76302 0.939428 8.01722C0.567161 8.28342 0.534932 8.45596 0.534932 8.49989C0.534932 8.54382 0.567161 8.71636 0.939428 8.98255C1.29492 9.23676 1.85121 9.49233 2.59677 9.71782ZM5.70148 8.49989C5.70148 9.12599 5.72855 9.73404 5.77947 10.3172C6.62855 10.405 7.54363 10.4532 8.50002 10.4532C9.45641 10.4532 10.3715 10.405 11.2206 10.3172C11.2715 9.73404 11.2986 9.12599 11.2986 8.49989C11.2986 7.87379 11.2715 7.26573 11.2206 6.68259C10.3715 6.59481 9.45641 6.54661 8.50002 6.54661C7.54363 6.54661 6.62855 6.59481 5.77947 6.68259C5.72855 7.26573 5.70148 7.87379 5.70148 8.49989ZM6.66412 14.3966C6.35861 13.6266 6.10995 12.6913 5.94194 11.6412C6.75487 11.7157 7.61377 11.7553 8.50002 11.7553C9.38628 11.7553 10.2452 11.7157 11.0581 11.6412C10.8901 12.6913 10.6414 13.6266 10.3359 14.3966C10.0423 15.1367 9.70879 15.692 9.3715 16.0515C9.0355 16.4097 8.74079 16.53 8.50002 16.53C8.25925 16.53 7.96454 16.4097 7.62854 16.0515C7.29126 15.692 6.95776 15.1367 6.66412 14.3966ZM14.4033 9.71782C13.8555 9.8835 13.2252 10.0271 12.5305 10.1424C12.5698 9.60843 12.5902 9.05941 12.5902 8.49989C12.5902 7.94037 12.5698 7.39135 12.5305 6.8574C13.2252 6.97265 13.8555 7.11627 14.4033 7.28196C15.1488 7.50745 15.7051 7.76302 16.0606 8.01722C16.4329 8.28342 16.4651 8.45596 16.4651 8.49989C16.4651 8.54382 16.4329 8.71636 16.0606 8.98256C15.7051 9.23676 15.1488 9.49233 14.4033 9.71782Z"/>
                                                        </svg>
                                                    </span>
                                                {{ Session::get('front_lang_name') }}
                                                <span class="arrow">
                                                        <svg width="12" height="6" viewBox="0 0 12 6" fill="none"
                                                             xmlns="http://www.w3.org/2000/svg">
                                                            <path
                                                                d="M12.0002 0.633816C11.947 0.446997 11.8572 0.28353 11.6808 0.158011C11.3813 -0.0492418 10.9487 -0.0550799 10.6493 0.155092C10.5927 0.195958 10.5361 0.239744 10.4829 0.286449C9.02543 1.56499 7.56465 2.84645 6.10719 4.125C6.07391 4.15419 6.04729 4.18922 5.96743 4.24176C5.94414 4.20673 5.93083 4.16294 5.89755 4.13375C4.42679 2.84062 2.95269 1.5504 1.48192 0.257257C1.22237 0.0295716 0.922896 -0.0579998 0.563523 0.0412478C0.0411014 0.1872 -0.17186 0.776848 0.157565 1.16216C0.194168 1.20595 0.237426 1.24681 0.280683 1.28768C1.97772 2.7764 3.67144 4.26511 5.36848 5.75091C5.67794 6.02238 6.07059 6.07492 6.42663 5.89394C6.51315 5.85015 6.58968 5.78594 6.65956 5.72464C8.30669 4.27971 9.95049 2.83478 11.6009 1.39277C11.784 1.23222 11.947 1.06875 12.0002 0.838149C12.0002 0.771011 12.0002 0.703873 12.0002 0.633816Z"/>
                                                        </svg>
                                                    </span>
                                            </button>
                                            <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton125">
                                                @foreach ($language_list as $language_dropdown_item)
                                                    <li><a class="dropdown-item"
                                                           href="{{ route('language-switcher', ['lang_code' => $language_dropdown_item->lang_code]) }}">{{ $language_dropdown_item->lang_name }}</a>
                                                    </li>
                                                @endforeach
                                            </ul>
                                        </div>
                                    </div>


                                    <a class="main-btn " href="{{ route('user.select-listing-purpose') }}">
                                        <div class="btn_m">
                                            <div class="btn_c">
                                                <div class="btn_t1">{{ __('translate.Post Your Ad') }}</div>
                                                <div class="btn_t2">{{ __('translate.Post Your Ad') }}</div>
                                            </div>
                                        </div>
                                    </a>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </nav>
        </header>
    @else
        <header class="header">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="header-main">
                            <div class="logo">
                                <a href="{{ route('home') }}"><img src="{{ custom_asset($setting->logo, '170x40') }}" alt="logo"></a>
                            </div>

                            @php
                                $topbar_ads = App\Models\AdsBanner::where('position_key', 'top_bar')->first();
                            @endphp

                            @if ($topbar_ads->status == 'enable')
                                <div class="header-ads">
                                    <a target="_blank" href="{{ $topbar_ads->link }}"><img
                                            src="{{ custom_asset($topbar_ads->image, '533x54') }}" alt="img"></a>
                                </div>
                            @endif

                            <div class="header-login-btn">
                                @auth('web')
                                    <a class="main-btn " href="{{ route('user.dashboard') }}">
                                        @else
                                            <a class="main-btn " href="{{ route('login') }}">
                                                @endauth

                                                <div class="btn_m">
                                                    <div class="btn_c">
                                                        <div class="btn_t1">
                                                    <span>
                                                        <svg width="13" height="17" viewBox="0 0 13 17" fill="none"
                                                             xmlns="http://www.w3.org/2000/svg">
                                                            <path fill-rule="evenodd" clip-rule="evenodd"
                                                                  d="M6.5 7.55556C8.55134 7.55556 10.2143 5.86419 10.2143 3.77778C10.2143 1.69137 8.55134 0 6.5 0C4.44866 0 2.78571 1.69137 2.78571 3.77778C2.78571 5.86419 4.44866 7.55556 6.5 7.55556ZM6.5 17C10.0899 17 13 15.3086 13 13.2222C13 11.1358 10.0899 9.44444 6.5 9.44444C2.91015 9.44444 0 11.1358 0 13.2222C0 15.3086 2.91015 17 6.5 17Z"/>
                                                        </svg>
                                                    </span>
                                                            @auth('web')
                                                                {{ __('translate.Dashboard') }}
                                                            @else
                                                                {{ __('translate.Sign In') }}
                                                            @endauth

                                                        </div>
                                                        <div class="btn_t2">
                                                    <span>
                                                        <svg width="13" height="17" viewBox="0 0 13 17" fill="none"
                                                             xmlns="http://www.w3.org/2000/svg">
                                                            <path fill-rule="evenodd" clip-rule="evenodd"
                                                                  d="M6.5 7.55556C8.55134 7.55556 10.2143 5.86419 10.2143 3.77778C10.2143 1.69137 8.55134 0 6.5 0C4.44866 0 2.78571 1.69137 2.78571 3.77778C2.78571 5.86419 4.44866 7.55556 6.5 7.55556ZM6.5 17C10.0899 17 13 15.3086 13 13.2222C13 11.1358 10.0899 9.44444 6.5 9.44444C2.91015 9.44444 0 11.1358 0 13.2222C0 15.3086 2.91015 17 6.5 17Z"/>
                                                        </svg>
                                                    </span>

                                                            @auth('web')
                                                                {{ __('translate.Dashboard') }}
                                                            @else
                                                                {{ __('translate.Sign In') }}
                                                            @endauth
                                                        </div>
                                                    </div>
                                                </div>
                                            </a>
                                    </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            @php
                if (Route::is('listings')) {
                    if(request()->get('classified')){
                        $sidebar_sub_categories = Modules\Category\Entities\SubCategory::where('category_id', 1)->get();
                    }elseif(request()->get('jobpost')){
                        $sidebar_sub_categories = Modules\Category\Entities\SubCategory::where('category_id', 3)->get();
                    }elseif(request()->get('realestate')){
                        $sidebar_sub_categories = Modules\Category\Entities\SubCategory::where('category_id', 2)->get();
                    }elseif(request()->get('ecommerce')){
                        $sidebar_sub_categories = Modules\Category\Entities\SubCategory::where('category_id', 4)->get();
                    }else{
                        $sidebar_sub_categories = Modules\Category\Entities\SubCategory::where('category_id', 1)->get();
                    }

                }else{
                    $selected_theme = Session::get('selected_theme');
                    if($selected_theme == 'theme_one'){
                        $sidebar_sub_categories = Modules\Category\Entities\SubCategory::where('category_id', 1)->get();
                    }elseif($selected_theme == 'theme_two'){
                        $sidebar_sub_categories = Modules\Category\Entities\SubCategory::where('category_id', 3)->get();
                    }elseif($selected_theme == 'theme_three'){
                        $sidebar_sub_categories = Modules\Category\Entities\SubCategory::where('category_id', 2)->get();
                    }elseif($selected_theme == 'theme_four'){
                        $sidebar_sub_categories = Modules\Category\Entities\SubCategory::where('category_id', 4)->get();
                    }else{
                        $sidebar_sub_categories = Modules\Category\Entities\SubCategory::where('category_id', 1)->get();
                    }
                }

            @endphp

            <nav class="menu-bg">
                <div class="container">
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="nav-main">
                                <div class="nav-left">
                                    <div class="menu-bg-dropdown-btn">
                                        <div class="dropdown">
                                            <button class="drop-btn" type="button" id="dropdownMenuButton1"
                                                    data-bs-toggle="dropdown" aria-expanded="false">
                                                {{ __('translate.All Categories') }}
                                                <span class="arrow">
                                                        <span>
                                                            <svg width="12" height="6" viewBox="0 0 12 6" fill="none"
                                                                 xmlns="http://www.w3.org/2000/svg">
                                                                <path
                                                                    d="M12 0.633816C11.9468 0.446997 11.8569 0.28353 11.6806 0.158011C11.3811 -0.0492418 10.9485 -0.0550799 10.649 0.155092C10.5925 0.195958 10.5359 0.239744 10.4826 0.286449C9.02519 1.56499 7.5644 2.84645 6.10694 4.125C6.07367 4.15419 6.04705 4.18922 5.96719 4.24176C5.94389 4.20673 5.93059 4.16294 5.89731 4.13375C4.42654 2.84062 2.95245 1.5504 1.48168 0.257257C1.22213 0.0295716 0.922652 -0.0579998 0.563279 0.0412478C0.0408573 0.1872 -0.172104 0.776848 0.157321 1.16216C0.193924 1.20595 0.237182 1.24681 0.280439 1.28768C1.97748 2.7764 3.67119 4.26511 5.36823 5.75091C5.67769 6.02238 6.07034 6.07492 6.42639 5.89394C6.5129 5.85015 6.58944 5.78594 6.65931 5.72464C8.30644 4.27971 9.95024 2.83478 11.6007 1.39277C11.7837 1.23222 11.9468 1.06875 12 0.838149C12 0.771011 12 0.703873 12 0.633816Z"/>
                                                            </svg>
                                                        </span>
                                                    </span>
                                            </button>
                                            <ul class="dropdown-menu {{ Session::get('selected_theme') }}"
                                                aria-labelledby="dropdownMenuButton1">
                                                @foreach ($sidebar_sub_categories as $index => $sidebar_sub_category)
                                                    <li>
                                                        <a class="dropdown-item"
                                                           href="{{ route('listings', ['sub_category_id' => $sidebar_sub_category->id, 'category' => $sidebar_sub_category->category->slug ]) }}">
                                                                <span class="icon">
                                                                    <span class="thumb">
                                                                        <img
                                                                            src="{{ custom_asset($sidebar_sub_category->icon, '100x100') }}"
                                                                            alt="img">
                                                                    </span>

                                                                    <span> {{ $sidebar_sub_category->name }}</span>

                                                                </span>
                                                            <span class="txt">
                                                                    ({{ $sidebar_sub_category->total_listing }})
                                                                </span>
                                                        </a>
                                                    </li>
                                                @endforeach


                                            </ul>
                                        </div>
                                    </div>

                                    <ul class="menu">
                                        @foreach($header_menuItems as $menuItem)
                                            @php
                                                $childMenuItems = $header_menuItems->where('parent_id', $menuItem?->id)->sortBy('sort_order');
                                            @endphp

                                            @if ($menuItem->parent_id == null)
                                                <li>
                                                    @if($childMenuItems->count() > 0)
                                                        <a href="javascript:;">{{ $menuItem?->title }} <i class="fa-solid fa-angle-down"></i></a>
                                                        <ul class="sub-menu">
                                                            @foreach($childMenuItems as $childItem)
                                                                <li>
                                                                    <a href="{{ $childItem?->url }}" class="menu-link">{{ $childItem?->title }}</a>
                                                                </li>
                                                            @endforeach
                                                        </ul>
                                                    @else
                                                        <a href="{{ $menuItem?->url }}">{{ $menuItem?->title }}</a>
                                                    @endif
                                                </li>
                                            @endif
                                        @endforeach

                                        <li>
                                            <a href="{{ route('cart.cart') }}">{{ __('translate.Cart') }}
                                                <span class="cart-count">({{ $totalCart  }})</span>
                                            </a>
                                        </li>


                                    </ul>
                                </div>


                                <div class="menu-bg-dropdown-btn-right">
                                    <div class="usd-btn">
                                        <div class="dropdown">
                                            <button class="usd-btnn" type="button" id="dropdownMenuButton111"
                                                    data-bs-toggle="dropdown" aria-expanded="false">

                                                {{ Session::get('currency_name') }}
                                                <span class="arrow ">
                                                        <svg width="12" height="6" viewBox="0 0 12 6" fill="none"
                                                             xmlns="http://www.w3.org/2000/svg">
                                                            <path
                                                                d="M12.0002 0.633816C11.947 0.446997 11.8572 0.28353 11.6808 0.158011C11.3813 -0.0492418 10.9487 -0.0550799 10.6493 0.155092C10.5927 0.195958 10.5361 0.239744 10.4829 0.286449C9.02543 1.56499 7.56465 2.84645 6.10719 4.125C6.07391 4.15419 6.04729 4.18922 5.96743 4.24176C5.94414 4.20673 5.93083 4.16294 5.89755 4.13375C4.42679 2.84062 2.95269 1.5504 1.48192 0.257257C1.22237 0.0295716 0.922896 -0.0579998 0.563523 0.0412478C0.0411014 0.1872 -0.17186 0.776848 0.157565 1.16216C0.194168 1.20595 0.237426 1.24681 0.280683 1.28768C1.97772 2.7764 3.67144 4.26511 5.36848 5.75091C5.67794 6.02238 6.07059 6.07492 6.42663 5.89394C6.51315 5.85015 6.58968 5.78594 6.65956 5.72464C8.30669 4.27971 9.95049 2.83478 11.6009 1.39277C11.784 1.23222 11.947 1.06875 12.0002 0.838149C12.0002 0.771011 12.0002 0.703873 12.0002 0.633816Z"/>
                                                        </svg>
                                                    </span>
                                            </button>
                                            <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton1">
                                                @foreach ($currency_list as $currency_dropdown_item)
                                                    <li><a class="dropdown-item"
                                                           href="{{ route('currency-switcher', ['currency_code' => $currency_dropdown_item->currency_code]) }}">{{ $currency_dropdown_item->currency_name }}</a>
                                                    </li>
                                                @endforeach
                                            </ul>
                                        </div>
                                    </div>


                                    <div class="usd-btn">
                                        <div class="dropdown">
                                            <button class="usd-btnn " type="button" id="dropdownMenuButton12"
                                                    data-bs-toggle="dropdown" aria-expanded="false">
                                                    <span class="dollor">
                                                        <svg width="17" height="17" viewBox="0 0 17 17" fill="none"
                                                             xmlns="http://www.w3.org/2000/svg">
                                                            <path fill-rule="evenodd" clip-rule="evenodd"
                                                                  d="M6.66412 2.60315C6.35861 3.37316 6.10995 4.30848 5.94194 5.35853C6.75487 5.28407 7.61377 5.24443 8.50002 5.24443C9.38628 5.24443 10.2452 5.28407 11.0581 5.35853C10.8901 4.30848 10.6414 3.37316 10.3359 2.60315C10.0423 1.86305 9.70879 1.30782 9.3715 0.948255C9.0355 0.590067 8.74079 0.469763 8.50002 0.469763C8.25925 0.469763 7.96454 0.590067 7.62854 0.948255C7.29126 1.30782 6.95776 1.86305 6.66412 2.60315ZM5.46486 2.11953C5.08366 3.08031 4.79116 4.23768 4.61189 5.51716C3.72942 5.64837 2.92409 5.82344 2.22562 6.03469C1.4129 6.2805 0.708156 6.58612 0.192177 6.95508C0.126989 7.0017 0.0626463 7.05096 3.89676e-05 7.1029C0.569579 3.55373 3.27347 0.725558 6.74127 1.07475e-06C6.72407 0.0176473 6.70701 0.0354882 6.6901 0.0535149C6.20323 0.57254 5.79453 1.28864 5.46486 2.11953ZM10.2588 0C10.276 0.0176466 10.293 0.0354878 10.3099 0.0535149C10.7968 0.57254 11.2055 1.28864 11.5352 2.11953C11.9164 3.08031 12.2089 4.23768 12.3882 5.51716C13.2706 5.64837 14.0759 5.82344 14.7744 6.03469C15.5871 6.2805 16.2919 6.58612 16.8079 6.95508C16.8731 7.0017 16.9374 7.05097 17 7.10291C16.4305 3.55374 13.7266 0.725556 10.2588 0ZM17 9.89684C16.9374 9.94879 16.8731 9.99807 16.8079 10.0447C16.2919 10.4137 15.5871 10.7193 14.7744 10.9651C14.0759 11.1763 13.2706 11.3514 12.3882 11.4826C12.2089 12.7621 11.9164 13.9195 11.5352 14.8802C11.2055 15.7111 10.7968 16.4272 10.3099 16.9463C10.293 16.9644 10.2758 16.9823 10.2585 17C13.7265 16.2746 16.4306 13.4462 17 9.89684ZM6.74153 17C6.72424 16.9823 6.70709 16.9644 6.6901 16.9463C6.20323 16.4272 5.79453 15.7111 5.46486 14.8802C5.08366 13.9195 4.79116 12.7621 4.61189 11.4826C3.72942 11.3514 2.92409 11.1763 2.22562 10.9651C1.4129 10.7193 0.708156 10.4137 0.192176 10.0447C0.126976 9.99807 0.0626196 9.94879 0 9.89684C0.56947 13.4462 3.27352 16.2745 6.74153 17ZM2.59677 9.71782C3.14458 9.8835 3.77487 10.0271 4.46958 10.1424C4.43026 9.60843 4.40984 9.05941 4.40984 8.49989C4.40984 7.94037 4.43026 7.39135 4.46958 6.85739C3.77488 6.97265 3.14458 7.11627 2.59677 7.28196C1.85121 7.50745 1.29492 7.76302 0.939428 8.01722C0.567161 8.28342 0.534932 8.45596 0.534932 8.49989C0.534932 8.54382 0.567161 8.71636 0.939428 8.98255C1.29492 9.23676 1.85121 9.49233 2.59677 9.71782ZM5.70148 8.49989C5.70148 9.12599 5.72855 9.73404 5.77947 10.3172C6.62855 10.405 7.54363 10.4532 8.50002 10.4532C9.45641 10.4532 10.3715 10.405 11.2206 10.3172C11.2715 9.73404 11.2986 9.12599 11.2986 8.49989C11.2986 7.87379 11.2715 7.26573 11.2206 6.68259C10.3715 6.59481 9.45641 6.54661 8.50002 6.54661C7.54363 6.54661 6.62855 6.59481 5.77947 6.68259C5.72855 7.26573 5.70148 7.87379 5.70148 8.49989ZM6.66412 14.3966C6.35861 13.6266 6.10995 12.6913 5.94194 11.6412C6.75487 11.7157 7.61377 11.7553 8.50002 11.7553C9.38628 11.7553 10.2452 11.7157 11.0581 11.6412C10.8901 12.6913 10.6414 13.6266 10.3359 14.3966C10.0423 15.1367 9.70879 15.692 9.3715 16.0515C9.0355 16.4097 8.74079 16.53 8.50002 16.53C8.25925 16.53 7.96454 16.4097 7.62854 16.0515C7.29126 15.692 6.95776 15.1367 6.66412 14.3966ZM14.4033 9.71782C13.8555 9.8835 13.2252 10.0271 12.5305 10.1424C12.5698 9.60843 12.5902 9.05941 12.5902 8.49989C12.5902 7.94037 12.5698 7.39135 12.5305 6.8574C13.2252 6.97265 13.8555 7.11627 14.4033 7.28196C15.1488 7.50745 15.7051 7.76302 16.0606 8.01722C16.4329 8.28342 16.4651 8.45596 16.4651 8.49989C16.4651 8.54382 16.4329 8.71636 16.0606 8.98256C15.7051 9.23676 15.1488 9.49233 14.4033 9.71782Z"/>
                                                        </svg>
                                                    </span>
                                                {{ Session::get('front_lang_name') }}
                                                <span class="arrow">
                                                        <svg width="12" height="6" viewBox="0 0 12 6" fill="none"
                                                             xmlns="http://www.w3.org/2000/svg">
                                                            <path
                                                                d="M12.0002 0.633816C11.947 0.446997 11.8572 0.28353 11.6808 0.158011C11.3813 -0.0492418 10.9487 -0.0550799 10.6493 0.155092C10.5927 0.195958 10.5361 0.239744 10.4829 0.286449C9.02543 1.56499 7.56465 2.84645 6.10719 4.125C6.07391 4.15419 6.04729 4.18922 5.96743 4.24176C5.94414 4.20673 5.93083 4.16294 5.89755 4.13375C4.42679 2.84062 2.95269 1.5504 1.48192 0.257257C1.22237 0.0295716 0.922896 -0.0579998 0.563523 0.0412478C0.0411014 0.1872 -0.17186 0.776848 0.157565 1.16216C0.194168 1.20595 0.237426 1.24681 0.280683 1.28768C1.97772 2.7764 3.67144 4.26511 5.36848 5.75091C5.67794 6.02238 6.07059 6.07492 6.42663 5.89394C6.51315 5.85015 6.58968 5.78594 6.65956 5.72464C8.30669 4.27971 9.95049 2.83478 11.6009 1.39277C11.784 1.23222 11.947 1.06875 12.0002 0.838149C12.0002 0.771011 12.0002 0.703873 12.0002 0.633816Z"/>
                                                        </svg>
                                                    </span>
                                            </button>
                                            <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton1">
                                                @foreach ($language_list as $language_dropdown_item)
                                                    <li><a class="dropdown-item"
                                                           href="{{ route('language-switcher', ['lang_code' => $language_dropdown_item->lang_code]) }}">{{ $language_dropdown_item->lang_name }}</a>
                                                    </li>
                                                @endforeach
                                            </ul>
                                        </div>
                                    </div>


                                    <a class="main-btn " href="{{ route('user.select-listing-purpose') }}">
                                        <div class="btn_m">
                                            <div class="btn_c">
                                                <div class="btn_t1">{{ __('translate.Post Your Ad') }}</div>
                                                <div class="btn_t2">{{ __('translate.Post Your Ad') }}</div>
                                            </div>
                                        </div>
                                    </a>


                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </nav>
        </header>
    @endif
@else
    <header class="header">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="header-main">
                        <div class="logo">
                            <a href="{{ route('home') }}"><img src="{{ custom_asset($setting->logo, '170x40') }}" alt="logo"></a>
                        </div>

                        @php
                            $topbar_ads = App\Models\AdsBanner::where('position_key', 'top_bar')->first();
                        @endphp

                        @if ($topbar_ads->status == 'enable')
                            <div class="header-ads">
                                <a target="_blank" href="{{ $topbar_ads->link }}"><img
                                        src="{{ custom_asset($topbar_ads->image, '533x54') }}" alt="img"></a>
                            </div>
                        @endif

                        <div class="header-login-btn">
                            @auth('web')
                                <a class="main-btn " href="{{ route('user.dashboard') }}">
                                    @else
                                        <a class="main-btn " href="{{ route('login') }}">
                                            @endauth
                                            <div class="btn_m">
                                                <div class="btn_c">
                                                    <div class="btn_t1">
                                                <span>
                                                    <svg width="13" height="17" viewBox="0 0 13 17" fill="none"
                                                         xmlns="http://www.w3.org/2000/svg">
                                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                                              d="M6.5 7.55556C8.55134 7.55556 10.2143 5.86419 10.2143 3.77778C10.2143 1.69137 8.55134 0 6.5 0C4.44866 0 2.78571 1.69137 2.78571 3.77778C2.78571 5.86419 4.44866 7.55556 6.5 7.55556ZM6.5 17C10.0899 17 13 15.3086 13 13.2222C13 11.1358 10.0899 9.44444 6.5 9.44444C2.91015 9.44444 0 11.1358 0 13.2222C0 15.3086 2.91015 17 6.5 17Z"/>
                                                    </svg>
                                                </span>
                                                        @auth('web')
                                                            {{ __('translate.Dashboard') }}
                                                        @else
                                                            {{ __('translate.Sign In') }}
                                                        @endauth
                                                    </div>
                                                    <div class="btn_t2">
                                                <span>
                                                    <svg width="13" height="17" viewBox="0 0 13 17" fill="none"
                                                         xmlns="http://www.w3.org/2000/svg">
                                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                                              d="M6.5 7.55556C8.55134 7.55556 10.2143 5.86419 10.2143 3.77778C10.2143 1.69137 8.55134 0 6.5 0C4.44866 0 2.78571 1.69137 2.78571 3.77778C2.78571 5.86419 4.44866 7.55556 6.5 7.55556ZM6.5 17C10.0899 17 13 15.3086 13 13.2222C13 11.1358 10.0899 9.44444 6.5 9.44444C2.91015 9.44444 0 11.1358 0 13.2222C0 15.3086 2.91015 17 6.5 17Z"/>
                                                    </svg>
                                                </span>

                                                        @auth('web')
                                                            {{ __('translate.Dashboard') }}
                                                        @else
                                                            {{ __('translate.Sign In') }}
                                                        @endauth
                                                    </div>
                                                </div>
                                            </div>
                                        </a>
                                </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        @php
            if (Route::is('listings')) {
                if(request()->get('classified')){
                    $sidebar_sub_categories = Modules\Category\Entities\SubCategory::where('category_id', 1)->get();
                }elseif(request()->get('jobpost')){
                    $sidebar_sub_categories = Modules\Category\Entities\SubCategory::where('category_id', 3)->get();
                }elseif(request()->get('realestate')){
                    $sidebar_sub_categories = Modules\Category\Entities\SubCategory::where('category_id', 2)->get();
                 }elseif(request()->get('ecommerce')){
                    $sidebar_sub_categories = Modules\Category\Entities\SubCategory::where('category_id', Status::ECOMMERCE)->get();
                } else{
                    $sidebar_sub_categories = Modules\Category\Entities\SubCategory::where('category_id', 1)->get();
                }

            }else{
                $selected_theme = Session::get('selected_theme');
                if($selected_theme == 'theme_one'){
                    $sidebar_sub_categories = Modules\Category\Entities\SubCategory::where('category_id', 1)->get();
                }elseif($selected_theme == 'theme_two'){
                    $sidebar_sub_categories = Modules\Category\Entities\SubCategory::where('category_id', 3)->get();
                }elseif($selected_theme == 'theme_three'){
                    $sidebar_sub_categories = Modules\Category\Entities\SubCategory::where('category_id', 2)->get();
                }elseif($selected_theme == 'theme_four'){
                    $sidebar_sub_categories = Modules\Category\Entities\SubCategory::where('category_id', Status::ECOMMERCE)->get();
                }else{
                    $sidebar_sub_categories = Modules\Category\Entities\SubCategory::where('category_id', 1)->get();
                }
            }

        @endphp

        <nav class="menu-bg">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="nav-main">
                            <div class="nav-left">
                                <div class="menu-bg-dropdown-btn">
                                    <div class="dropdown">
                                        <button class="drop-btn" type="button" id="dropdownMenuButton1"
                                                data-bs-toggle="dropdown" aria-expanded="false">
                                            {{ __('translate.All Categories') }}
                                            <span class="arrow">
                                                    <span>
                                                        <svg width="12" height="6" viewBox="0 0 12 6" fill="none"
                                                             xmlns="http://www.w3.org/2000/svg">
                                                            <path
                                                                d="M12 0.633816C11.9468 0.446997 11.8569 0.28353 11.6806 0.158011C11.3811 -0.0492418 10.9485 -0.0550799 10.649 0.155092C10.5925 0.195958 10.5359 0.239744 10.4826 0.286449C9.02519 1.56499 7.5644 2.84645 6.10694 4.125C6.07367 4.15419 6.04705 4.18922 5.96719 4.24176C5.94389 4.20673 5.93059 4.16294 5.89731 4.13375C4.42654 2.84062 2.95245 1.5504 1.48168 0.257257C1.22213 0.0295716 0.922652 -0.0579998 0.563279 0.0412478C0.0408573 0.1872 -0.172104 0.776848 0.157321 1.16216C0.193924 1.20595 0.237182 1.24681 0.280439 1.28768C1.97748 2.7764 3.67119 4.26511 5.36823 5.75091C5.67769 6.02238 6.07034 6.07492 6.42639 5.89394C6.5129 5.85015 6.58944 5.78594 6.65931 5.72464C8.30644 4.27971 9.95024 2.83478 11.6007 1.39277C11.7837 1.23222 11.9468 1.06875 12 0.838149C12 0.771011 12 0.703873 12 0.633816Z"/>
                                                        </svg>
                                                    </span>
                                                </span>
                                        </button>
                                        <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton1">
                                            @foreach ($sidebar_sub_categories as $index => $sidebar_sub_category)
                                                <li>
                                                    <a class="dropdown-item"
                                                       href="{{ route('listings', ['sub_category_id' => $sidebar_sub_category->id, 'category' => $sidebar_sub_category->category->slug ]) }}">
                                                            <span class="icon">
                                                                <span class="thumb">
                                                                    <img src="{{ custom_asset($sidebar_sub_category->icon, '86x86') }}"
                                                                         alt="img">
                                                                </span>

                                                                <span> {{ $sidebar_sub_category->name }}</span>

                                                            </span>
                                                        <span class="txt">
                                                                ({{ $sidebar_sub_category->total_listing }})
                                                            </span>
                                                    </a>
                                                </li>
                                            @endforeach
                                        </ul>
                                    </div>
                                </div>

                                <ul class="menu">
                                    @foreach($header_menuItems as $menuItem)
                                        @php
                                            $childMenuItems = $header_menuItems->where('parent_id', $menuItem?->id)->sortBy('sort_order');
                                        @endphp

                                        @if ($menuItem->parent_id == null)
                                            <li>
                                                @if($childMenuItems->count() > 0)
                                                    <a href="javascript:;">{{ $menuItem?->title }} <i class="fa-solid fa-angle-down"></i></a>
                                                    <ul class="sub-menu">
                                                        @foreach($childMenuItems as $childItem)
                                                            <li>
                                                                <a href="{{ $childItem?->url }}" class="menu-link">{{ $childItem?->title }}</a>
                                                            </li>
                                                        @endforeach
                                                    </ul>
                                                @else
                                                    <a href="{{ $menuItem?->url }}">{{ $menuItem?->title }}</a>
                                                @endif
                                            </li>
                                        @endif
                                    @endforeach

                                    <li>
                                        <a href="{{ route('cart.cart') }}">{{ __('translate.Cart') }}
                                            <span class="cart-count">({{ $totalCart  }})</span>
                                        </a>
                                    </li>

                                </ul>
                            </div>


                            <div class="menu-bg-dropdown-btn-right">
                                <div class="usd-btn">
                                    <div class="dropdown">
                                        <button class="usd-btnn" type="button" id="dropdownMenuButton11"
                                                data-bs-toggle="dropdown" aria-expanded="false">
                                            {{ Session::get('currency_name') }}
                                            <span class="arrow ">
                                                    <svg width="12" height="6" viewBox="0 0 12 6" fill="none"
                                                         xmlns="http://www.w3.org/2000/svg">
                                                        <path
                                                            d="M12.0002 0.633816C11.947 0.446997 11.8572 0.28353 11.6808 0.158011C11.3813 -0.0492418 10.9487 -0.0550799 10.6493 0.155092C10.5927 0.195958 10.5361 0.239744 10.4829 0.286449C9.02543 1.56499 7.56465 2.84645 6.10719 4.125C6.07391 4.15419 6.04729 4.18922 5.96743 4.24176C5.94414 4.20673 5.93083 4.16294 5.89755 4.13375C4.42679 2.84062 2.95269 1.5504 1.48192 0.257257C1.22237 0.0295716 0.922896 -0.0579998 0.563523 0.0412478C0.0411014 0.1872 -0.17186 0.776848 0.157565 1.16216C0.194168 1.20595 0.237426 1.24681 0.280683 1.28768C1.97772 2.7764 3.67144 4.26511 5.36848 5.75091C5.67794 6.02238 6.07059 6.07492 6.42663 5.89394C6.51315 5.85015 6.58968 5.78594 6.65956 5.72464C8.30669 4.27971 9.95049 2.83478 11.6009 1.39277C11.784 1.23222 11.947 1.06875 12.0002 0.838149C12.0002 0.771011 12.0002 0.703873 12.0002 0.633816Z"/>
                                                    </svg>
                                                </span>
                                        </button>
                                        <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton1">
                                            @foreach ($currency_list as $currency_dropdown_item)
                                                <li><a class="dropdown-item"
                                                       href="{{ route('currency-switcher', ['currency_code' => $currency_dropdown_item->currency_code]) }}">{{ $currency_dropdown_item->currency_name }}</a>
                                                </li>
                                            @endforeach
                                        </ul>
                                    </div>
                                </div>

                                <div class="usd-btn">
                                    <div class="dropdown">
                                        <button class="usd-btnn " type="button" id="dropdownMenuButton12"
                                                data-bs-toggle="dropdown" aria-expanded="false">
                                                <span class="dollor ">
                                                    <svg width="17" height="17" viewBox="0 0 17 17" fill="none"
                                                         xmlns="http://www.w3.org/2000/svg">
                                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                                              d="M6.66412 2.60315C6.35861 3.37316 6.10995 4.30848 5.94194 5.35853C6.75487 5.28407 7.61377 5.24443 8.50002 5.24443C9.38628 5.24443 10.2452 5.28407 11.0581 5.35853C10.8901 4.30848 10.6414 3.37316 10.3359 2.60315C10.0423 1.86305 9.70879 1.30782 9.3715 0.948255C9.0355 0.590067 8.74079 0.469763 8.50002 0.469763C8.25925 0.469763 7.96454 0.590067 7.62854 0.948255C7.29126 1.30782 6.95776 1.86305 6.66412 2.60315ZM5.46486 2.11953C5.08366 3.08031 4.79116 4.23768 4.61189 5.51716C3.72942 5.64837 2.92409 5.82344 2.22562 6.03469C1.4129 6.2805 0.708156 6.58612 0.192177 6.95508C0.126989 7.0017 0.0626463 7.05096 3.89676e-05 7.1029C0.569579 3.55373 3.27347 0.725558 6.74127 1.07475e-06C6.72407 0.0176473 6.70701 0.0354882 6.6901 0.0535149C6.20323 0.57254 5.79453 1.28864 5.46486 2.11953ZM10.2588 0C10.276 0.0176466 10.293 0.0354878 10.3099 0.0535149C10.7968 0.57254 11.2055 1.28864 11.5352 2.11953C11.9164 3.08031 12.2089 4.23768 12.3882 5.51716C13.2706 5.64837 14.0759 5.82344 14.7744 6.03469C15.5871 6.2805 16.2919 6.58612 16.8079 6.95508C16.8731 7.0017 16.9374 7.05097 17 7.10291C16.4305 3.55374 13.7266 0.725556 10.2588 0ZM17 9.89684C16.9374 9.94879 16.8731 9.99807 16.8079 10.0447C16.2919 10.4137 15.5871 10.7193 14.7744 10.9651C14.0759 11.1763 13.2706 11.3514 12.3882 11.4826C12.2089 12.7621 11.9164 13.9195 11.5352 14.8802C11.2055 15.7111 10.7968 16.4272 10.3099 16.9463C10.293 16.9644 10.2758 16.9823 10.2585 17C13.7265 16.2746 16.4306 13.4462 17 9.89684ZM6.74153 17C6.72424 16.9823 6.70709 16.9644 6.6901 16.9463C6.20323 16.4272 5.79453 15.7111 5.46486 14.8802C5.08366 13.9195 4.79116 12.7621 4.61189 11.4826C3.72942 11.3514 2.92409 11.1763 2.22562 10.9651C1.4129 10.7193 0.708156 10.4137 0.192176 10.0447C0.126976 9.99807 0.0626196 9.94879 0 9.89684C0.56947 13.4462 3.27352 16.2745 6.74153 17ZM2.59677 9.71782C3.14458 9.8835 3.77487 10.0271 4.46958 10.1424C4.43026 9.60843 4.40984 9.05941 4.40984 8.49989C4.40984 7.94037 4.43026 7.39135 4.46958 6.85739C3.77488 6.97265 3.14458 7.11627 2.59677 7.28196C1.85121 7.50745 1.29492 7.76302 0.939428 8.01722C0.567161 8.28342 0.534932 8.45596 0.534932 8.49989C0.534932 8.54382 0.567161 8.71636 0.939428 8.98255C1.29492 9.23676 1.85121 9.49233 2.59677 9.71782ZM5.70148 8.49989C5.70148 9.12599 5.72855 9.73404 5.77947 10.3172C6.62855 10.405 7.54363 10.4532 8.50002 10.4532C9.45641 10.4532 10.3715 10.405 11.2206 10.3172C11.2715 9.73404 11.2986 9.12599 11.2986 8.49989C11.2986 7.87379 11.2715 7.26573 11.2206 6.68259C10.3715 6.59481 9.45641 6.54661 8.50002 6.54661C7.54363 6.54661 6.62855 6.59481 5.77947 6.68259C5.72855 7.26573 5.70148 7.87379 5.70148 8.49989ZM6.66412 14.3966C6.35861 13.6266 6.10995 12.6913 5.94194 11.6412C6.75487 11.7157 7.61377 11.7553 8.50002 11.7553C9.38628 11.7553 10.2452 11.7157 11.0581 11.6412C10.8901 12.6913 10.6414 13.6266 10.3359 14.3966C10.0423 15.1367 9.70879 15.692 9.3715 16.0515C9.0355 16.4097 8.74079 16.53 8.50002 16.53C8.25925 16.53 7.96454 16.4097 7.62854 16.0515C7.29126 15.692 6.95776 15.1367 6.66412 14.3966ZM14.4033 9.71782C13.8555 9.8835 13.2252 10.0271 12.5305 10.1424C12.5698 9.60843 12.5902 9.05941 12.5902 8.49989C12.5902 7.94037 12.5698 7.39135 12.5305 6.8574C13.2252 6.97265 13.8555 7.11627 14.4033 7.28196C15.1488 7.50745 15.7051 7.76302 16.0606 8.01722C16.4329 8.28342 16.4651 8.45596 16.4651 8.49989C16.4651 8.54382 16.4329 8.71636 16.0606 8.98256C15.7051 9.23676 15.1488 9.49233 14.4033 9.71782Z"/>
                                                    </svg>
                                                </span>
                                            {{ Session::get('front_lang_name') }}
                                            <span class="arrow">
                                                    <svg width="12" height="6" viewBox="0 0 12 6" fill="none"
                                                         xmlns="http://www.w3.org/2000/svg">
                                                        <path
                                                            d="M12.0002 0.633816C11.947 0.446997 11.8572 0.28353 11.6808 0.158011C11.3813 -0.0492418 10.9487 -0.0550799 10.6493 0.155092C10.5927 0.195958 10.5361 0.239744 10.4829 0.286449C9.02543 1.56499 7.56465 2.84645 6.10719 4.125C6.07391 4.15419 6.04729 4.18922 5.96743 4.24176C5.94414 4.20673 5.93083 4.16294 5.89755 4.13375C4.42679 2.84062 2.95269 1.5504 1.48192 0.257257C1.22237 0.0295716 0.922896 -0.0579998 0.563523 0.0412478C0.0411014 0.1872 -0.17186 0.776848 0.157565 1.16216C0.194168 1.20595 0.237426 1.24681 0.280683 1.28768C1.97772 2.7764 3.67144 4.26511 5.36848 5.75091C5.67794 6.02238 6.07059 6.07492 6.42663 5.89394C6.51315 5.85015 6.58968 5.78594 6.65956 5.72464C8.30669 4.27971 9.95049 2.83478 11.6009 1.39277C11.784 1.23222 11.947 1.06875 12.0002 0.838149C12.0002 0.771011 12.0002 0.703873 12.0002 0.633816Z"/>
                                                    </svg>
                                                </span>
                                        </button>
                                        <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton1">
                                            @foreach ($language_list as $language_dropdown_item)
                                                <li><a class="dropdown-item"
                                                       href="{{ route('language-switcher', ['lang_code' => $language_dropdown_item->lang_code]) }}">{{ $language_dropdown_item->lang_name }}</a>
                                                </li>
                                            @endforeach
                                        </ul>
                                    </div>
                                </div>


                                <a class="main-btn " href="{{ route('user.select-listing-purpose') }}">
                                    <div class="btn_m">
                                        <div class="btn_c">
                                            <div class="btn_t1">{{ __('translate.Post Your Ad') }}</div>
                                            <div class="btn_t2">{{ __('translate.Post Your Ad') }}</div>
                                        </div>
                                    </div>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </nav>
    </header>
@endif



<!-- mobile navigation start -->
<header class="mobile-header">
    <div class="container-full">
        <div class="mobile-header__container">
            <div class="p-left">
                <div class="logo">
                    <a href="{{ route('home') }}">
                        <img src="{{ custom_asset($setting->logo_2, '170x40') }}" alt="logo">
                    </a>
                </div>

            </div>
            <div class="p-right">
                <button id="nav-opn-btn">
                    <i class="fa-solid fa-bars"></i>
                </button>
            </div>
        </div>
    </div>
</header>
<!-- offcanvas -->

<aside id="offcanvas-nav">
    <nav class="m-nav">
        <button id="nav-cls-btn"><i class="fa-solid fa-xmark"></i></button>
        <div class="logo">
            <a href="{{ route('home') }}">
                <img src="{{ custom_asset($setting->logo, '170x40') }}" alt="logo">
            </a>
        </div>
        <div class="menu-bg-dropdown-btn-right">
            <div class="usd-btn">

                <div class="dropdown">
                    <button class="usd-btnn" type="button" id="dropdownMenuButton11" data-bs-toggle="dropdown"
                            aria-expanded="false">

                        {{ Session::get('currency_name') }}
                        <span class="arrow ">
                                                        <svg width="12" height="6" viewBox="0 0 12 6" fill="none"
                                                             xmlns="http://www.w3.org/2000/svg">
                                                            <path
                                                                d="M12.0002 0.633816C11.947 0.446997 11.8572 0.28353 11.6808 0.158011C11.3813 -0.0492418 10.9487 -0.0550799 10.6493 0.155092C10.5927 0.195958 10.5361 0.239744 10.4829 0.286449C9.02543 1.56499 7.56465 2.84645 6.10719 4.125C6.07391 4.15419 6.04729 4.18922 5.96743 4.24176C5.94414 4.20673 5.93083 4.16294 5.89755 4.13375C4.42679 2.84062 2.95269 1.5504 1.48192 0.257257C1.22237 0.0295716 0.922896 -0.0579998 0.563523 0.0412478C0.0411014 0.1872 -0.17186 0.776848 0.157565 1.16216C0.194168 1.20595 0.237426 1.24681 0.280683 1.28768C1.97772 2.7764 3.67144 4.26511 5.36848 5.75091C5.67794 6.02238 6.07059 6.07492 6.42663 5.89394C6.51315 5.85015 6.58968 5.78594 6.65956 5.72464C8.30669 4.27971 9.95049 2.83478 11.6009 1.39277C11.784 1.23222 11.947 1.06875 12.0002 0.838149C12.0002 0.771011 12.0002 0.703873 12.0002 0.633816Z"></path>
                                                        </svg>
                                                    </span>
                    </button>
                    <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton1">
                        @foreach ($currency_list as $currency_dropdown_item)
                            <li><a class="dropdown-item"
                                   href="{{ route('currency-switcher', ['currency_code' => $currency_dropdown_item->currency_code]) }}">{{ $currency_dropdown_item->currency_name }}</a>
                            </li>
                        @endforeach
                    </ul>
                </div>
            </div>


            <div class="usd-btn">
                <div class="dropdown">
                    <button class="usd-btnn " type="button" id="dropdownMenuButton12" data-bs-toggle="dropdown"
                            aria-expanded="false">
                                                    <span class="dollor ">
                                                        <svg width="17" height="17" viewBox="0 0 17 17" fill="none"
                                                             xmlns="http://www.w3.org/2000/svg">
                                                            <path fill-rule="evenodd" clip-rule="evenodd"
                                                                  d="M6.66412 2.60315C6.35861 3.37316 6.10995 4.30848 5.94194 5.35853C6.75487 5.28407 7.61377 5.24443 8.50002 5.24443C9.38628 5.24443 10.2452 5.28407 11.0581 5.35853C10.8901 4.30848 10.6414 3.37316 10.3359 2.60315C10.0423 1.86305 9.70879 1.30782 9.3715 0.948255C9.0355 0.590067 8.74079 0.469763 8.50002 0.469763C8.25925 0.469763 7.96454 0.590067 7.62854 0.948255C7.29126 1.30782 6.95776 1.86305 6.66412 2.60315ZM5.46486 2.11953C5.08366 3.08031 4.79116 4.23768 4.61189 5.51716C3.72942 5.64837 2.92409 5.82344 2.22562 6.03469C1.4129 6.2805 0.708156 6.58612 0.192177 6.95508C0.126989 7.0017 0.0626463 7.05096 3.89676e-05 7.1029C0.569579 3.55373 3.27347 0.725558 6.74127 1.07475e-06C6.72407 0.0176473 6.70701 0.0354882 6.6901 0.0535149C6.20323 0.57254 5.79453 1.28864 5.46486 2.11953ZM10.2588 0C10.276 0.0176466 10.293 0.0354878 10.3099 0.0535149C10.7968 0.57254 11.2055 1.28864 11.5352 2.11953C11.9164 3.08031 12.2089 4.23768 12.3882 5.51716C13.2706 5.64837 14.0759 5.82344 14.7744 6.03469C15.5871 6.2805 16.2919 6.58612 16.8079 6.95508C16.8731 7.0017 16.9374 7.05097 17 7.10291C16.4305 3.55374 13.7266 0.725556 10.2588 0ZM17 9.89684C16.9374 9.94879 16.8731 9.99807 16.8079 10.0447C16.2919 10.4137 15.5871 10.7193 14.7744 10.9651C14.0759 11.1763 13.2706 11.3514 12.3882 11.4826C12.2089 12.7621 11.9164 13.9195 11.5352 14.8802C11.2055 15.7111 10.7968 16.4272 10.3099 16.9463C10.293 16.9644 10.2758 16.9823 10.2585 17C13.7265 16.2746 16.4306 13.4462 17 9.89684ZM6.74153 17C6.72424 16.9823 6.70709 16.9644 6.6901 16.9463C6.20323 16.4272 5.79453 15.7111 5.46486 14.8802C5.08366 13.9195 4.79116 12.7621 4.61189 11.4826C3.72942 11.3514 2.92409 11.1763 2.22562 10.9651C1.4129 10.7193 0.708156 10.4137 0.192176 10.0447C0.126976 9.99807 0.0626196 9.94879 0 9.89684C0.56947 13.4462 3.27352 16.2745 6.74153 17ZM2.59677 9.71782C3.14458 9.8835 3.77487 10.0271 4.46958 10.1424C4.43026 9.60843 4.40984 9.05941 4.40984 8.49989C4.40984 7.94037 4.43026 7.39135 4.46958 6.85739C3.77488 6.97265 3.14458 7.11627 2.59677 7.28196C1.85121 7.50745 1.29492 7.76302 0.939428 8.01722C0.567161 8.28342 0.534932 8.45596 0.534932 8.49989C0.534932 8.54382 0.567161 8.71636 0.939428 8.98255C1.29492 9.23676 1.85121 9.49233 2.59677 9.71782ZM5.70148 8.49989C5.70148 9.12599 5.72855 9.73404 5.77947 10.3172C6.62855 10.405 7.54363 10.4532 8.50002 10.4532C9.45641 10.4532 10.3715 10.405 11.2206 10.3172C11.2715 9.73404 11.2986 9.12599 11.2986 8.49989C11.2986 7.87379 11.2715 7.26573 11.2206 6.68259C10.3715 6.59481 9.45641 6.54661 8.50002 6.54661C7.54363 6.54661 6.62855 6.59481 5.77947 6.68259C5.72855 7.26573 5.70148 7.87379 5.70148 8.49989ZM6.66412 14.3966C6.35861 13.6266 6.10995 12.6913 5.94194 11.6412C6.75487 11.7157 7.61377 11.7553 8.50002 11.7553C9.38628 11.7553 10.2452 11.7157 11.0581 11.6412C10.8901 12.6913 10.6414 13.6266 10.3359 14.3966C10.0423 15.1367 9.70879 15.692 9.3715 16.0515C9.0355 16.4097 8.74079 16.53 8.50002 16.53C8.25925 16.53 7.96454 16.4097 7.62854 16.0515C7.29126 15.692 6.95776 15.1367 6.66412 14.3966ZM14.4033 9.71782C13.8555 9.8835 13.2252 10.0271 12.5305 10.1424C12.5698 9.60843 12.5902 9.05941 12.5902 8.49989C12.5902 7.94037 12.5698 7.39135 12.5305 6.8574C13.2252 6.97265 13.8555 7.11627 14.4033 7.28196C15.1488 7.50745 15.7051 7.76302 16.0606 8.01722C16.4329 8.28342 16.4651 8.45596 16.4651 8.49989C16.4651 8.54382 16.4329 8.71636 16.0606 8.98256C15.7051 9.23676 15.1488 9.49233 14.4033 9.71782Z"></path>
                                                        </svg>
                                                    </span>
                        {{ Session::get('front_lang_name') }}
                        <span class="arrow">
                                                        <svg width="12" height="6" viewBox="0 0 12 6" fill="none"
                                                             xmlns="http://www.w3.org/2000/svg">
                                                            <path
                                                                d="M12.0002 0.633816C11.947 0.446997 11.8572 0.28353 11.6808 0.158011C11.3813 -0.0492418 10.9487 -0.0550799 10.6493 0.155092C10.5927 0.195958 10.5361 0.239744 10.4829 0.286449C9.02543 1.56499 7.56465 2.84645 6.10719 4.125C6.07391 4.15419 6.04729 4.18922 5.96743 4.24176C5.94414 4.20673 5.93083 4.16294 5.89755 4.13375C4.42679 2.84062 2.95269 1.5504 1.48192 0.257257C1.22237 0.0295716 0.922896 -0.0579998 0.563523 0.0412478C0.0411014 0.1872 -0.17186 0.776848 0.157565 1.16216C0.194168 1.20595 0.237426 1.24681 0.280683 1.28768C1.97772 2.7764 3.67144 4.26511 5.36848 5.75091C5.67794 6.02238 6.07059 6.07492 6.42663 5.89394C6.51315 5.85015 6.58968 5.78594 6.65956 5.72464C8.30669 4.27971 9.95049 2.83478 11.6009 1.39277C11.784 1.23222 11.947 1.06875 12.0002 0.838149C12.0002 0.771011 12.0002 0.703873 12.0002 0.633816Z"></path>
                                                        </svg>
                                                    </span>
                    </button>
                    <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton1">
                        @foreach ($language_list as $language_dropdown_item)
                            <li><a class="dropdown-item"
                                   href="{{ route('language-switcher', ['lang_code' => $language_dropdown_item->lang_code]) }}">{{ $language_dropdown_item->lang_name }}</a>
                            </li>
                        @endforeach
                    </ul>
                </div>
            </div>
        </div>
        <ul class="nav-links">

            @if ($setting->selected_theme == 'all_theme')
                <li class="dropdown"><a href="javascript:;">{{ __('translate.Home') }} <i
                            class="fa-solid fa-angle-down"></i></a>

                    <ul class="d-menu">
                        <li><a href="{{ route('home', ['theme' => 'one']) }}">{{ __('translate.Home-01') }} </a></li>
                        <li><a href="{{ route('home', ['theme' => 'two']) }}">{{ __('translate.Home-02') }} </a></li>
                        <li><a href="{{ route('home', ['theme' => 'three']) }}">{{ __('translate.Home-03') }} </a></li>
                        <li><a href="{{ route('home', ['theme' => 'four']) }}">{{ __('translate.Home-04') }} </a></li>
                    </ul>
                </li>
            @else
                <li><a href="{{ route('home') }}">{{ __('translate.Home') }}</a></li>
            @endif

            <li class="dropdown"><a href="javascript:;">{{ __('translate.Listings') }} <i
                        class="fa-solid fa-angle-down"></i></a>

                <ul class="d-menu">
                    <li>
                        <a href="{{ route('listings', ['category' => 'classified']) }}"> {{ __('translate.Classified') }}</a>
                    </li>
                    <li>
                        <a href="{{ route('listings', ['category' => 'jobpost']) }}"> {{ __('translate.Job Post') }}</a>
                    </li>
                    <li>
                        <a href="{{ route('listings', ['category' => 'realestate']) }}"> {{ __('translate.Real Estate') }}</a>
                    </li>
                    <li>
                        <a href="{{ route('listings', ['category' => 'ecommerce']) }}"> {{ __('translate.Ecommerce') }}</a>
                    </li>
                </ul>

            </li>

            <li class="dropdown"><a href="javascript:;">{{ __('translate.Pages') }} <i
                        class="fa-solid fa-angle-down"></i> </a>
                <ul class="d-menu">
                    <li><a href="{{ route('about-us') }}">{{ __('translate.About Us') }}</a></li>

                    <li><a href="{{ route('blogs') }}">{{ __('translate.Our Blogs') }}</a></li>

                    <li><a href="{{ route('faq') }}">{{ __('translate.FAQ') }}</a></li>

                    <li><a href="{{ route('pricing-plan') }}">{{ __('translate.Subscription Plan') }}</a></li>

                    <li><a href="{{ route('terms-conditions') }}">{{ __('translate.Terms & Conditions') }}</a></li>

                    <li><a href="{{ route('privacy-policy') }}">{{ __('translate.Privacy Policy') }}</a></li>

                    @foreach ($custom_pages as $custom_page)
                        <li><a href="{{ route('custom-page', $custom_page->slug) }}">{{ $custom_page->page_name }}</a>
                        </li>
                    @endforeach

                </ul>

            </li>
            <li><a href="{{ route('contact-us') }}">{{ __('translate.Contact Us') }}</a></li>

        </ul>

        <div class="header-login-btn">

            @auth('web')
                <a href="{{ route('user.dashboard') }}">
                        <span>
                            <svg width="13" height="17" viewBox="0 0 13 17" fill="none"
                                 xmlns="http://www.w3.org/2000/svg">
                                <path fill-rule="evenodd" clip-rule="evenodd"
                                      d="M6.5 7.55556C8.55134 7.55556 10.2143 5.86419 10.2143 3.77778C10.2143 1.69137 8.55134 0 6.5 0C4.44866 0 2.78571 1.69137 2.78571 3.77778C2.78571 5.86419 4.44866 7.55556 6.5 7.55556ZM6.5 17C10.0899 17 13 15.3086 13 13.2222C13 11.1358 10.0899 9.44444 6.5 9.44444C2.91015 9.44444 0 11.1358 0 13.2222C0 15.3086 2.91015 17 6.5 17Z">
                                </path>
                            </svg>
                        </span>

                    {{ __('translate.Dashboard') }}
                </a>
            @else
                <a href="{{ route('login') }}">
                        <span>
                            <svg width="13" height="17" viewBox="0 0 13 17" fill="none"
                                 xmlns="http://www.w3.org/2000/svg">
                                <path fill-rule="evenodd" clip-rule="evenodd"
                                      d="M6.5 7.55556C8.55134 7.55556 10.2143 5.86419 10.2143 3.77778C10.2143 1.69137 8.55134 0 6.5 0C4.44866 0 2.78571 1.69137 2.78571 3.77778C2.78571 5.86419 4.44866 7.55556 6.5 7.55556ZM6.5 17C10.0899 17 13 15.3086 13 13.2222C13 11.1358 10.0899 9.44444 6.5 9.44444C2.91015 9.44444 0 11.1358 0 13.2222C0 15.3086 2.91015 17 6.5 17Z">
                                </path>
                            </svg>
                        </span>

                    {{ __('translate.Sign In') }}
                </a>
            @endauth

        </div>
    </nav>
</aside>


@yield('body-content')



@if ($tawk_chat->status == 1)
    <script type="text/javascript">
        var Tawk_API = Tawk_API || {}, Tawk_LoadStart = new Date();
        (function () {
            var s1 = document.createElement("script"), s0 = document.getElementsByTagName("script")[0];
            s1.async = true;
            s1.src = '{{ $tawk_chat->chat_link }}';
            s1.charset = 'UTF-8';
            s1.setAttribute('crossorigin', '*');
            s0.parentNode.insertBefore(s1, s0);
        })();
    </script>
@endif


@if ($cookie_consent->status == 1)
    <!-- common-modal start  -->
    <div class="common-modal cookie_consent_modal d-none">
        <button type="button" class="btn-close cookie_consent_close_btn" aria-label="Close"></button>

        <h5>{{ __('translate.Cookies') }}</h5>
        <p>{{ $cookie_consent->message }}</p>

        <div class="common-modal-btn">
            <a href="javascript:;" class="report-modal-btn cookie_consent_accept_btn">{{ __('translate.Accept') }}</a>
        </div>

    </div>
    <!-- common-modal end  -->
@endif



<!-- footer part start  -->


<footer class="footer ecommerce_footer">
    <div class="container">
        <div class="row justify-content-center">

            <div class="col-lg-10">
                <div class="cta-banner">


                    <h2 class="newsletter">{{ __('translate.Subscribe to Our Newsletter') }}</h2>

                    <form class="footer-form" id="newsletter_form" action="{{ route('newsletter-request') }}"
                          method="POST">
                        @csrf
                        <input type="email" class="form-control" id="exampleFormControlInput3"
                               placeholder="{{ __('translate.Enter your email address') }}" name="email">

                        <a href="javascript:;" class="main-btn" id="newsletter_btn">
                            <div class="btn_m">
                                <div class="btn_c">
                                    <div class="btn_t1"> {{ __('translate.Subscribe') }}</div>
                                    <div class="btn_t2"> {{ __('translate.Subscribe') }}</div>
                                </div>
                            </div>
                        </a>
                    </form>


                </div>
            </div>

        </div>

        <div class="row footer-border ">
            <div class="col-lg-3 col-sm-6 " data-aos="fade-right" data-aos-delay="50">
                <div class="footer-logo">
                    <a href="{{ route('home') }}">
                        <img src="{{ custom_asset($setting->logo_2, '170x40') }}" alt="logo">
                    </a>
                </div>

                <p class="footer-dec">{{ $setting->about_us }}</p>

                <div class="follow">
                    <div class="txt">
                        <h3>{{ __('translate.Follow Us') }}:</h3>
                    </div>

                    <div class="icon">
                        <ul>
                            <li>
                                <a href="{{ $setting->facebook }}" target="_blank">
                                        <span>
                                            <svg width="9" height="19" viewBox="0 0 9 19" fill="none"
                                                 xmlns="http://www.w3.org/2000/svg">
                                                <path
                                                    d="M8.02329 9.03851H5.54365V18.1119H1.78678V9.03851H0V5.84976H1.78678V3.78627C1.78678 2.31066 2.48856 0 5.57709 0L8.35994 0.0116285V3.10686H6.3408C6.0096 3.10686 5.5439 3.27213 5.5439 3.97605V5.85273H8.35152L8.02329 9.03851Z"/>
                                            </svg>
                                        </span>
                                </a>
                            </li>
                            <li>
                                <a href="{{ $setting->twitter }}" target="_blank">
                                        <span>
                                            <svg width="17" height="14" viewBox="0 0 17 14" fill="none"
                                                 xmlns="http://www.w3.org/2000/svg">
                                                <path
                                                    d="M16.4803 1.5837C15.8742 1.85217 15.2221 2.03376 14.5382 2.11486C15.2365 1.69703 15.7723 1.03591 16.0252 0.246849C15.3719 0.63395 14.6479 0.914769 13.8781 1.06613C13.2613 0.410051 12.3826 3.05176e-05 11.4095 3.05176e-05C9.54255 3.05176e-05 8.02836 1.51242 8.02836 3.37716C8.02836 3.64186 8.05836 3.89951 8.11636 4.14683C5.30635 4.00604 2.8148 2.66164 1.14705 0.617831C0.856066 1.1165 0.689139 1.69703 0.689139 2.31584C0.689139 3.48722 1.28649 4.52134 2.19324 5.1268C1.63926 5.10942 1.11755 4.95755 0.661906 4.70393C0.661654 4.71829 0.661654 4.73264 0.661654 4.74675C0.661654 6.38305 1.82762 7.74786 3.37408 8.05789C3.09066 8.13546 2.79135 8.17651 2.48347 8.17651C2.26511 8.17651 2.05355 8.15561 1.84729 8.11632C2.27746 9.4577 3.52588 10.4341 5.00578 10.4616C3.84839 11.3675 2.39068 11.9072 0.806139 11.9072C0.533811 11.9072 0.264006 11.8914 0 11.8599C1.49553 12.8185 3.27322 13.3773 5.18254 13.3773C11.4017 13.3773 14.8028 8.23142 14.8028 3.76829C14.8028 3.62196 14.7995 3.47614 14.7929 3.33157C15.4541 2.85557 16.0272 2.26094 16.4803 1.5837Z"/>
                                            </svg>
                                        </span>
                                </a>
                            </li>
                            <li>
                                <a href="{{ $setting->linkedin }}" target="_blank">
                                        <span>
                                            <svg width="16" height="15" viewBox="0 0 16 15" fill="none"
                                                 xmlns="http://www.w3.org/2000/svg">
                                                <path
                                                    d="M15.1381 8.85755V14.4483H11.8928V9.23223C11.8928 7.92253 11.4242 7.02812 10.2492 7.02812C9.35251 7.02812 8.81982 7.63027 8.58457 8.21333C8.49914 8.4217 8.47711 8.71106 8.47711 9.00331V14.4481H5.23158C5.23158 14.4481 5.27514 5.61375 5.23158 4.69927H8.47735V6.08077C8.47082 6.09165 8.46162 6.10229 8.45581 6.11268H8.47735V6.08077C8.90864 5.41794 9.67779 4.47035 11.4022 4.47035C13.5373 4.47035 15.1381 5.8637 15.1381 8.85755ZM1.83647 0C0.726312 0 0 0.727856 0 1.68415C0 2.62013 0.705256 3.36902 1.79388 3.36902H1.81493C2.94688 3.36902 3.65068 2.62013 3.65068 1.68415C3.62914 0.727856 2.94688 0 1.83647 0ZM0.192892 14.4483H3.43722V4.69927H0.192892V14.4483Z"/>
                                            </svg>
                                        </span>
                                </a>
                            </li>
                            <li>
                                <a href="{{ $setting->instagram }}" target="_blank">
                                        <span>
                                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                                 xmlns="http://www.w3.org/2000/svg">
                                                <rect x="2" y="2" width="20" height="20" rx="4" stroke="#28303F"
                                                      stroke-width="1.5"/>
                                                <circle cx="18" cy="6" r="1" fill="#28303F"/>
                                                <circle cx="12" cy="12" r="5" stroke="#28303F" stroke-width="1.5"/>
                                            </svg>
                                        </span>
                                </a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>

            <div class="col-lg-9 ">
                <div class="row footer-ml  ">
                    <div class="col-lg-4 col-sm-6 col-md-4" data-aos="fade-right" data-aos-delay="100">
                        @foreach($footer_one_menuItems as $menuItem)
                            @php
                                $childItems = $footer_one_menuItems->where('parent_id', $menuItem?->id);
                            @endphp
                            @if ($menuItem?->parent_id == null)
                                <li>
                                    @if($childItems->count() > 0)
                                        <h3 class="footer-txt">{{ $menuItem?->title }}</h3>
                                        <ul class="footer-menu-box">
                                            @foreach($childItems as $child)
                                            <li>
                                                <a href="{{ $child?->url }}"><span></span>{{ $child?->title }}</a>
                                            </li>
                                            @endforeach
                                        </ul>
                                    @else
                                        <a href="{{ $menuItem?->url }}"><span></span>{{ $menuItem?->title }}</a>
                                    @endif
                                </li>



                            @endif
                        @endforeach

                    </div>
                    <div class="col-lg-4  col-sm-6  col-md-4" data-aos="fade-right" data-aos-delay="150">

                        @foreach($footer_two_menuItems as $menuItem)
                            @php
                                $childItems = $footer_two_menuItems->where('parent_id', $menuItem?->id);
                            @endphp
                            @if ($menuItem?->parent_id == null)
                                <li>
                                    @if($childItems->count() > 0)
                                        <h3 class="footer-txt">{{ $menuItem?->title }}</h3>
                                        <ul class="footer-menu-box">
                                            @foreach($childItems as $child)
                                            <li>
                                                <a href="{{ $child?->url }}"><span></span>{{ $child?->title }}</a>
                                            </li>
                                            @endforeach
                                        </ul>
                                    @else
                                        <a href="{{ $menuItem?->url }}"><span></span>{{ $menuItem?->title }}</a>
                                    @endif
                                </li>
                            @endif
                        @endforeach

                    </div>


                    <div class="col-lg-4  col-sm-6  col-md-4 md-ml" data-aos="fade-up" data-aos-delay="200">
                        <h3 class="footer-txt">{{ __('translate.Download App') }}</h3>

                        <div class="footer-btn">
                            <a href="{{ $setting->mobile_playstore }}">
                                    <span>
                                    <svg width="200" height="61" viewBox="0 0 200 61" fill="none"
                                         xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M192.593 61H7.40741C3.33519 61 0 57.5668 0 53.375V7.625C0 3.43316 3.33519 5.72205e-06 7.40741 5.72205e-06H192.593C196.665 5.72205e-06 200 3.43316 200 7.625V53.375C200 57.5668 196.665 61 192.593 61Z"
                                        fill="black"/>
                                    <path
                                        d="M192.593 1.22191C196.022 1.22191 198.813 4.09463 198.813 7.625V53.375C198.813 56.9054 196.022 59.7781 192.593 59.7781H7.40741C3.97778 59.7781 1.18704 56.9054 1.18704 53.375V7.625C1.18704 4.09463 3.97778 1.22191 7.40741 1.22191H192.593ZM192.593 5.72205e-06H7.40741C3.33519 5.72205e-06 0 3.43316 0 7.625V53.375C0 57.5668 3.33519 61 7.40741 61H192.593C196.665 61 200 57.5668 200 53.375V7.625C200 3.43316 196.665 5.72205e-06 192.593 5.72205e-06Z"
                                        fill="#A6A6A6"/>
                                    <path
                                        d="M14.3472 11.4966C13.912 11.9656 13.6602 12.6957 13.6602 13.6412V47.3665C13.6602 48.312 13.912 49.0421 14.3472 49.5111L14.4546 49.614L32.8138 30.7231V30.277L14.4546 11.3861L14.3472 11.4966Z"
                                        fill="white"/>
                                    <path
                                        d="M41.1481 37.0232L35.0352 30.723V30.277L41.1555 23.9768L41.2926 24.0588L48.5407 28.304C50.6092 29.5088 50.6092 31.4913 48.5407 32.7036L41.2926 36.9412L41.1481 37.0232Z"
                                        fill="white"/>
                                    <path
                                        d="M40.1811 38.1144L33.9237 31.6732L15.457 50.6842C16.1441 51.4276 17.2644 51.5172 18.5385 50.7738L40.1811 38.1144Z"
                                        fill="white"/>
                                    <path
                                        d="M40.1811 22.8857L18.5385 10.2263C17.2644 9.49047 16.1441 9.58007 15.457 10.3235L33.9237 29.3269L40.1811 22.8857Z"
                                        fill="white"/>
                                    <path
                                        d="M70.2469 15.6216C70.2469 16.895 69.8765 17.9148 69.1469 18.6754C68.308 19.5771 67.2154 20.0307 65.8765 20.0307C64.5969 20.0307 63.5043 19.5694 62.608 18.6601C61.7099 17.7375 61.2617 16.6052 61.2617 15.2499C61.2617 13.8945 61.7099 12.7622 62.608 11.8472C63.5043 10.9303 64.5969 10.469 65.8765 10.469C66.5136 10.469 67.121 10.6043 67.7006 10.856C68.2784 11.1095 68.7488 11.4526 69.0895 11.8758L68.3154 12.6802C67.721 11.9578 66.9117 11.6013 65.8765 11.6013C64.9432 11.6013 64.1339 11.9368 63.4469 12.6135C62.7673 13.2921 62.4265 14.1709 62.4265 15.2499C62.4265 16.3288 62.7673 17.2152 63.4469 17.8938C64.1339 18.5629 64.9432 18.9061 65.8765 18.9061C66.8673 18.9061 67.7006 18.5629 68.358 17.8862C68.7913 17.4382 69.0376 16.8206 69.1025 16.0314H65.8765V14.9296H70.1802C70.2321 15.1679 70.2469 15.3986 70.2469 15.6216Z"
                                        fill="white" stroke="white" stroke-width="0.16" stroke-miterlimit="10"/>
                                    <path
                                        d="M77.0738 11.8015H73.0312V14.699H76.6756V15.8008H73.0312V18.6983H77.0738V19.8211H71.8867V10.6787H77.0738V11.8015Z"
                                        fill="white" stroke="white" stroke-width="0.16" stroke-miterlimit="10"/>
                                    <path d="M81.8936 19.8211H80.7492V11.8015H78.2695V10.6787H84.3751V11.8015H81.8936V19.8211Z" fill="white" stroke="white"
                                        stroke-width="0.16" stroke-miterlimit="10"/>
                                    <path d="M88.793 19.8211V10.6787H89.9356V19.8211H88.793Z" fill="white" stroke="white" stroke-width="0.16"
                                        stroke-miterlimit="10"/>
                                    <path d="M94.9991 19.8211H93.8639V11.8015H91.375V10.6787H97.4879V11.8015H94.9991V19.8211Z" fill="white" stroke="white"
                                        stroke-width="0.16" stroke-miterlimit="10"/>
                                    <path
                                        d="M109.05 18.6449C108.175 19.5694 107.089 20.0307 105.795 20.0307C104.493 20.0307 103.408 19.5694 102.532 18.6449C101.658 17.7223 101.223 16.59 101.223 15.2499C101.223 13.9098 101.658 12.7775 102.532 11.8548C103.408 10.9303 104.493 10.469 105.795 10.469C107.082 10.469 108.167 10.9303 109.043 11.8625C109.925 12.7927 110.36 13.9174 110.36 15.2499C110.36 16.59 109.925 17.7223 109.05 18.6449ZM103.378 17.8786C104.037 18.5629 104.839 18.9061 105.795 18.9061C106.743 18.9061 107.552 18.5629 108.204 17.8786C108.862 17.1942 109.195 16.3155 109.195 15.2499C109.195 14.1843 108.862 13.3055 108.204 12.6212C107.552 11.9368 106.743 11.5937 105.795 11.5937C104.839 11.5937 104.037 11.9368 103.378 12.6212C102.721 13.3055 102.387 14.1843 102.387 15.2499C102.387 16.3155 102.721 17.1942 103.378 17.8786Z"
                                        fill="white" stroke="white" stroke-width="0.16" stroke-miterlimit="10"/>
                                    <path
                                        d="M111.965 19.8211V10.6787H113.354L117.672 17.789H117.722L117.672 16.0315V10.6787H118.815V19.8211H117.622L113.1 12.36H113.05L113.1 14.1252V19.8211H111.965Z"
                                        fill="white" stroke="white" stroke-width="0.16" stroke-miterlimit="10"/>
                                    <path
                                        d="M100.942 33.1726C97.4619 33.1726 94.6193 35.8986 94.6193 39.6596C94.6193 43.3901 97.4619 46.1447 100.942 46.1447C104.429 46.1447 107.271 43.3901 107.271 39.6596C107.271 35.8986 104.429 33.1726 100.942 33.1726ZM100.942 43.5903C99.0322 43.5903 97.3897 41.9681 97.3897 39.6596C97.3897 37.3206 99.0322 35.727 100.942 35.727C102.851 35.727 104.501 37.3206 104.501 39.6596C104.501 41.9681 102.851 43.5903 100.942 43.5903ZM87.1471 33.1726C83.66 33.1726 80.8248 35.8986 80.8248 39.6596C80.8248 43.3901 83.66 46.1447 87.1471 46.1447C90.6323 46.1447 93.4693 43.3901 93.4693 39.6596C93.4693 35.8986 90.6323 33.1726 87.1471 33.1726ZM87.1471 43.5903C85.236 43.5903 83.5878 41.9681 83.5878 39.6596C83.5878 37.3206 85.236 35.727 87.1471 35.727C89.0563 35.727 90.6989 37.3206 90.6989 39.6596C90.6989 41.9681 89.0563 43.5903 87.1471 43.5903ZM70.7323 35.1609V37.9173H77.1267C76.9397 39.4575 76.4397 40.5899 75.673 41.379C74.7397 42.3322 73.286 43.3901 70.7323 43.3901C66.7971 43.3901 63.7156 40.1209 63.7156 36.0701C63.7156 32.0194 66.7971 28.7501 70.7323 28.7501C72.86 28.7501 74.4082 29.6061 75.5508 30.7155L77.4378 28.773C75.8397 27.2023 73.7137 25.9956 70.7323 25.9956C65.336 25.9956 60.8008 30.5153 60.8008 36.0701C60.8008 41.625 65.336 46.1447 70.7323 46.1447C73.6489 46.1447 75.8397 45.161 77.5619 43.3158C79.3267 41.4991 79.8767 38.9448 79.8767 36.8822C79.8767 36.2417 79.8248 35.6527 79.7323 35.1609H70.7323ZM137.854 37.2978C137.334 35.8471 135.729 33.1726 132.458 33.1726C129.217 33.1726 126.519 35.8014 126.519 39.6596C126.519 43.2929 129.19 46.1447 132.769 46.1447C135.664 46.1447 137.334 44.328 138.021 43.27L135.873 41.7965C135.156 42.8755 134.18 43.5903 132.769 43.5903C131.367 43.5903 130.362 42.9288 129.717 41.625L138.145 38.0355L137.854 37.2978ZM129.262 39.4575C129.19 36.9565 131.149 35.6755 132.553 35.6755C133.653 35.6755 134.586 36.2417 134.897 37.0519L129.262 39.4575ZM122.412 45.7501H125.182V26.6876H122.412V45.7501ZM117.875 34.6176H117.782C117.16 33.8589 115.973 33.1726 114.469 33.1726C111.314 33.1726 108.429 36.0244 108.429 39.6806C108.429 43.3158 111.314 46.1447 114.469 46.1447C115.973 46.1447 117.16 45.4527 117.782 44.6711H117.875V45.6014C117.875 48.0814 116.588 49.4139 114.512 49.4139C112.819 49.4139 111.769 48.1558 111.336 47.0978L108.927 48.1329C109.621 49.8523 111.46 51.9683 114.512 51.9683C117.76 51.9683 120.501 50.001 120.501 45.2144V33.5672H117.875V34.6176ZM114.706 43.5903C112.797 43.5903 111.199 41.9452 111.199 39.6806C111.199 37.395 112.797 35.727 114.706 35.727C116.588 35.727 118.071 37.395 118.071 39.6806C118.071 41.9452 116.588 43.5903 114.706 43.5903ZM150.825 26.6876H144.199V45.7501H146.962V38.5273H150.825C153.893 38.5273 156.903 36.2417 156.903 32.6065C156.903 28.9732 153.886 26.6876 150.825 26.6876ZM150.897 35.8757H146.962V29.3392H150.897C152.96 29.3392 154.138 31.1025 154.138 32.6065C154.138 34.0819 152.96 35.8757 150.897 35.8757ZM167.977 33.1364C165.98 33.1364 163.904 34.0438 163.051 36.0549L165.503 37.1129C166.03 36.0549 167.001 35.7118 168.027 35.7118C169.46 35.7118 170.914 36.5982 170.936 38.1632V38.3634C170.436 38.066 169.366 37.6256 168.049 37.6256C165.408 37.6256 162.717 39.122 162.717 41.9147C162.717 44.4691 164.88 46.1142 167.312 46.1142C169.171 46.1142 170.197 45.2506 170.841 44.246H170.936V45.7196H173.604V38.4072C173.604 35.0274 171.153 33.1364 167.977 33.1364ZM167.643 43.5827C166.74 43.5827 165.48 43.1214 165.48 41.9681C165.48 40.4926 167.051 39.9265 168.41 39.9265C169.627 39.9265 170.197 40.2029 170.936 40.567C170.719 42.3322 169.243 43.5827 167.643 43.5827ZM183.327 33.5539L180.151 41.8175H180.056L176.773 33.5539H173.793L178.727 45.102L175.912 51.5279H178.799L186.401 33.5539H183.327ZM158.421 45.7501H161.191V26.6876H158.421V45.7501Z"
                                        fill="white"/>
                                    </svg>


                                    </span>
                            </a>
                            <a href="{{ $setting->mobile_appstore }}">
                                    <span>
                                    <svg width="200" height="61" viewBox="0 0 200 61" fill="none"
                                         xmlns="http://www.w3.org/2000/svg">
                                        <path
                                            d="M198.887 53.965C198.887 57.2158 196.341 59.849 193.192 59.849H6.81208C3.66438 59.849 1.10938 57.2158 1.10938 53.965V7.04251C1.10938 3.79328 3.66438 1.15088 6.81208 1.15088H193.19C196.341 1.15088 198.886 3.79328 198.886 7.04251L198.887 53.965Z"
                                            fill="black"/>
                                        <path
                                            d="M192.593 1.22191C196.022 1.22191 198.813 4.09463 198.813 7.62501V53.375C198.813 56.9054 196.022 59.7781 192.593 59.7781H7.40741C3.97778 59.7781 1.18704 56.9054 1.18704 53.375V7.62501C1.18704 4.09463 3.97778 1.22191 7.40741 1.22191H192.593ZM192.593 7.62939e-06H7.40741C3.33519 7.62939e-06 0 3.43316 0 7.62501V53.375C0 57.5668 3.33519 61 7.40741 61H192.593C196.665 61 200 57.5668 200 53.375V7.62501C200 3.43316 196.665 7.62939e-06 192.593 7.62939e-06Z"
                                            fill="#A6A6A6"/>
                                        <path
                                            d="M44.6323 30.1706C44.5894 25.2556 48.542 22.8644 48.7227 22.753C46.4842 19.3935 43.0145 18.9344 41.7953 18.8978C38.8812 18.5822 36.0545 20.6928 34.5701 20.6928C33.056 20.6928 30.7701 18.9283 28.3064 18.9802C25.136 19.0305 22.1701 20.92 20.5434 23.8541C17.1864 29.8367 19.6901 38.6283 22.9064 43.4641C24.5153 45.8324 26.3953 48.4767 28.856 48.3837C31.2634 48.2815 32.1627 46.8038 35.0679 46.8038C37.9464 46.8038 38.7908 48.3837 41.3005 48.3242C43.8842 48.2815 45.5108 45.9452 47.0634 43.5556C48.9227 40.8411 49.6694 38.1677 49.699 38.0305C49.6382 38.0091 44.6812 36.0617 44.6323 30.1706Z"
                                            fill="white"/>
                                        <path
                                            d="M39.8916 15.7167C41.1864 14.0499 42.0723 11.7822 41.8264 9.48096C39.9523 9.56636 37.6086 10.8153 36.259 12.4456C35.0649 13.8821 33.9982 16.2367 34.2738 18.451C36.379 18.6127 38.5405 17.3576 39.8916 15.7167Z"
                                            fill="white"/>
                                        <path
                                            d="M72.6685 15.2635C72.6685 17.0584 72.1456 18.4096 71.1011 19.317C70.1337 20.1542 68.7589 20.5736 66.9781 20.5736C66.0952 20.5736 65.3396 20.5339 64.707 20.4546V10.6473C65.5322 10.5101 66.4211 10.4399 67.3811 10.4399C69.0774 10.4399 70.3559 10.8197 71.2181 11.5791C72.1841 12.4377 72.6685 13.6653 72.6685 15.2635ZM71.0315 15.3077C71.0315 14.1442 70.7322 13.252 70.1337 12.6298C69.5352 12.0092 68.6611 11.6981 67.51 11.6981C67.0211 11.6981 66.6048 11.7316 66.2596 11.8018V19.2575C66.4507 19.288 66.8004 19.3017 67.3085 19.3017C68.4967 19.3017 69.4137 18.9616 70.0596 18.2815C70.7056 17.6013 71.0315 16.6101 71.0315 15.3077Z"
                                            fill="white"/>
                                        <path
                                            d="M81.3478 16.8313C81.3478 17.9369 81.0411 18.8427 80.4278 19.5534C79.7849 20.2839 78.933 20.6483 77.8693 20.6483C76.8441 20.6483 76.0278 20.2991 75.4189 19.5976C74.8115 18.8976 74.5078 18.0147 74.5078 16.9502C74.5078 15.837 74.8204 14.9235 75.4486 14.2144C76.0767 13.5052 76.9211 13.1499 77.9849 13.1499C79.01 13.1499 79.8337 13.4991 80.4574 14.1991C81.05 14.8793 81.3478 15.7577 81.3478 16.8313ZM79.7374 16.8831C79.7374 16.2197 79.5982 15.6509 79.3212 15.1766C78.9952 14.6032 78.5315 14.3165 77.9286 14.3165C77.3049 14.3165 76.8308 14.6032 76.5049 15.1766C76.2263 15.6509 76.0886 16.2289 76.0886 16.9121C76.0886 17.5755 76.2278 18.1443 76.5049 18.6186C76.8411 19.192 77.3093 19.4787 77.9137 19.4787C78.5063 19.4787 78.9715 19.1874 79.3063 18.6033C79.5937 18.1199 79.7374 17.5465 79.7374 16.8831Z"
                                            fill="white"/>
                                        <path
                                            d="M92.9857 13.2964L90.8005 20.4852H89.3783L88.4731 17.3636C88.2435 16.5843 88.0568 15.8096 87.9116 15.041H87.8835C87.7487 15.8309 87.562 16.6041 87.322 17.3636L86.3605 20.4852H84.922L82.8672 13.2964H84.4627L85.2524 16.7139C85.4435 17.5222 85.6005 18.2923 85.7264 19.0212H85.7546C85.8701 18.4204 86.0613 17.6548 86.3309 16.7292L87.322 13.2979H88.5872L89.5368 16.656C89.7664 17.4749 89.9531 18.2633 90.0968 19.0228H90.1398C90.245 18.2831 90.4035 17.4947 90.6139 16.656L91.4613 13.2979H92.9857V13.2964Z"
                                            fill="white"/>
                                        <path
                                            d="M101.036 20.4853H99.4829V16.3678C99.4829 15.099 99.0148 14.4646 98.0755 14.4646C97.6148 14.4646 97.2429 14.6385 96.9541 14.9877C96.6681 15.3369 96.5229 15.7487 96.5229 16.2199V20.4838H94.9704V15.3507C94.9704 14.7193 94.9511 14.0346 94.9141 13.2934H96.2785L96.3511 14.4174H96.3941C96.5748 14.0681 96.8444 13.7799 97.1985 13.5496C97.6192 13.2812 98.0903 13.1455 98.6059 13.1455C99.2578 13.1455 99.8 13.3621 100.231 13.7967C100.767 14.3289 101.036 15.1234 101.036 16.1787V20.4853Z"
                                            fill="white"/>
                                        <path d="M105.317 20.4852H103.766V9.9978H105.317V20.4852Z" fill="white"/>
                                        <path
                                            d="M114.457 16.8313C114.457 17.9369 114.151 18.8427 113.537 19.5534C112.894 20.2839 112.041 20.6483 110.979 20.6483C109.952 20.6483 109.136 20.2991 108.528 19.5976C107.921 18.8976 107.617 18.0147 107.617 16.9502C107.617 15.837 107.93 14.9235 108.558 14.2144C109.186 13.5052 110.031 13.1499 111.093 13.1499C112.119 13.1499 112.942 13.4991 113.567 14.1991C114.159 14.8793 114.457 15.7577 114.457 16.8313ZM112.845 16.8831C112.845 16.2197 112.706 15.6509 112.429 15.1766C112.105 14.6032 111.639 14.3165 111.038 14.3165C110.413 14.3165 109.939 14.6032 109.614 15.1766C109.336 15.6509 109.198 16.2289 109.198 16.9121C109.198 17.5755 109.337 18.1443 109.614 18.6186C109.951 19.192 110.419 19.4787 111.023 19.4787C111.616 19.4787 112.079 19.1874 112.414 18.6033C112.703 18.1199 112.845 17.5465 112.845 16.8831Z"
                                            fill="white"/>
                                        <path
                                            d="M121.972 20.4852H120.578L120.462 19.6571H120.419C119.942 20.3174 119.262 20.6483 118.379 20.6483C117.72 20.6483 117.186 20.4303 116.785 19.9972C116.421 19.6037 116.238 19.1142 116.238 18.5332C116.238 17.6548 116.594 16.9853 117.309 16.5217C118.023 16.0581 119.028 15.8309 120.321 15.8415V15.7073C120.321 14.7603 119.838 14.2876 118.871 14.2876C118.182 14.2876 117.575 14.466 117.05 14.8198L116.735 13.7706C117.383 13.3573 118.185 13.1499 119.13 13.1499C120.955 13.1499 121.871 14.1412 121.871 16.1237V18.7711C121.871 19.4893 121.905 20.0612 121.972 20.4852ZM120.36 18.0147V16.906C118.647 16.8755 117.791 17.3589 117.791 18.3547C117.791 18.7299 117.889 19.0105 118.089 19.1981C118.289 19.3856 118.543 19.4787 118.847 19.4787C119.188 19.4787 119.506 19.3673 119.797 19.1462C120.089 18.9236 120.268 18.6414 120.335 18.2953C120.351 18.2175 120.36 18.1229 120.36 18.0147Z"
                                            fill="white"/>
                                        <path
                                            d="M130.796 20.4852H129.418L129.345 19.3308H129.302C128.862 20.2092 128.113 20.6484 127.059 20.6484C126.218 20.6484 125.517 20.3083 124.961 19.6282C124.406 18.948 124.129 18.0651 124.129 16.9808C124.129 15.8172 124.43 14.8748 125.034 14.155C125.619 13.484 126.336 13.1485 127.19 13.1485C128.127 13.1485 128.784 13.4733 129.157 14.1245H129.187V9.9978H130.741V18.5485C130.741 19.2485 130.759 19.8935 130.796 20.4852ZM129.187 17.4535V16.2549C129.187 16.0475 129.172 15.8797 129.144 15.7516C129.056 15.3673 128.868 15.044 128.582 14.7833C128.293 14.5225 127.945 14.3913 127.544 14.3913C126.964 14.3913 126.511 14.6277 126.178 15.102C125.847 15.5763 125.68 16.1817 125.68 16.9213C125.68 17.632 125.839 18.2084 126.157 18.6522C126.493 19.1249 126.947 19.3613 127.514 19.3613C128.024 19.3613 128.431 19.1646 128.741 18.7696C129.04 18.4051 129.187 17.9659 129.187 17.4535Z"
                                            fill="white"/>
                                        <path
                                            d="M144.074 16.8313C144.074 17.9369 143.768 18.8427 143.154 19.5534C142.511 20.2839 141.661 20.6483 140.596 20.6483C139.572 20.6483 138.756 20.2991 138.145 19.5976C137.538 18.8976 137.234 18.0147 137.234 16.9502C137.234 15.837 137.547 14.9235 138.175 14.2144C138.803 13.5052 139.648 13.1499 140.713 13.1499C141.737 13.1499 142.562 13.4991 143.184 14.1991C143.777 14.8793 144.074 15.7577 144.074 16.8313ZM142.465 16.8831C142.465 16.2197 142.326 15.6509 142.049 15.1766C141.722 14.6032 141.26 14.3165 140.655 14.3165C140.033 14.3165 139.559 14.6032 139.231 15.1766C138.953 15.6509 138.815 16.2289 138.815 16.9121C138.815 17.5755 138.954 18.1443 139.231 18.6186C139.568 19.192 140.036 19.4787 140.64 19.4787C141.233 19.4787 141.7 19.1874 142.034 18.6033C142.32 18.1199 142.465 17.5465 142.465 16.8831Z"
                                            fill="white"/>
                                        <path
                                            d="M152.421 20.4853H150.87V16.3678C150.87 15.099 150.402 14.4646 149.461 14.4646C149 14.4646 148.628 14.6385 148.341 14.9877C148.053 15.3369 147.91 15.7487 147.91 16.2199V20.4838H146.356V15.3507C146.356 14.7193 146.338 14.0346 146.301 13.2934H147.664L147.736 14.4174H147.779C147.962 14.0681 148.231 13.7799 148.584 13.5496C149.006 13.2812 149.476 13.1455 149.993 13.1455C150.643 13.1455 151.185 13.3621 151.616 13.7967C152.154 14.3289 152.421 15.1234 152.421 16.1787V20.4853Z"
                                            fill="white"/>
                                        <path
                                            d="M162.871 14.4936H161.161V17.9858C161.161 18.8734 161.465 19.3172 162.066 19.3172C162.345 19.3172 162.576 19.2928 162.758 19.2424L162.798 20.4548C162.491 20.5738 162.088 20.6332 161.592 20.6332C160.979 20.6332 160.502 20.4411 160.156 20.0568C159.81 19.6725 159.638 19.0259 159.638 18.1185V14.4936H158.617V13.2965H159.638V11.9789L161.159 11.5061V13.2949H162.869V14.4936H162.871Z"
                                            fill="white"/>
                                        <path
                                            d="M171.089 20.4852H169.535V16.3982C169.535 15.1096 169.066 14.4645 168.129 14.4645C167.409 14.4645 166.917 14.8382 166.647 15.5854C166.601 15.7425 166.575 15.9346 166.575 16.1603V20.4837H165.023V9.9978H166.575V14.3303H166.604C167.093 13.5419 167.794 13.1485 168.702 13.1485C169.345 13.1485 169.877 13.365 170.299 13.7996C170.825 14.341 171.089 15.1462 171.089 16.2107V20.4852Z"
                                            fill="white"/>
                                        <path
                                            d="M179.568 16.5507C179.568 16.8374 179.548 17.0784 179.51 17.2751H174.854C174.875 17.9857 175.097 18.5271 175.528 18.9023C175.922 19.2378 176.43 19.4055 177.053 19.4055C177.742 19.4055 178.37 19.2927 178.936 19.0654L179.179 20.1756C178.516 20.4715 177.737 20.6194 176.835 20.6194C175.753 20.6194 174.902 20.2915 174.285 19.6358C173.666 18.98 173.359 18.1001 173.359 16.996C173.359 15.9117 173.645 15.0089 174.222 14.2891C174.823 13.5205 175.636 13.1362 176.663 13.1362C177.668 13.1362 178.43 13.5205 178.946 14.2891C179.362 14.8991 179.568 15.654 179.568 16.5507ZM178.087 16.1374C178.099 15.6632 177.996 15.2545 177.786 14.9098C177.516 14.466 177.106 14.2434 176.55 14.2434C176.044 14.2434 175.63 14.4599 175.315 14.8946C175.057 15.2407 174.905 15.654 174.854 16.1374H178.087Z"
                                            fill="white"/>
                                        <path
                                            d="M79.4726 48.0435H76.1081L74.2652 42.0823H67.8592L66.1037 48.0435H62.8281L69.1748 27.7488H73.0948L79.4726 48.0435ZM73.7096 39.5813L72.0429 34.2819C71.8666 33.7405 71.5363 32.4656 71.0489 30.4587H70.9896C70.7955 31.3219 70.4829 32.5968 70.0533 34.2819L68.4163 39.5813H73.7096Z"
                                            fill="white"/>
                                        <path
                                            d="M95.7958 40.5466C95.7958 43.0354 95.1425 45.0026 93.8358 46.4468C92.6655 47.7324 91.2121 48.3744 89.4773 48.3744C87.6047 48.3744 86.2595 47.682 85.4403 46.2973H85.381V54.0062H82.2225V38.227C82.2225 36.6624 82.1825 35.0566 82.1055 33.4096H84.8832L85.0595 35.7291H85.1188C86.1721 33.9814 87.7707 33.1091 89.9158 33.1091C91.5929 33.1091 92.9929 33.7908 94.1129 35.1557C95.2358 36.5221 95.7958 38.3185 95.7958 40.5466ZM92.5781 40.6655C92.5781 39.2412 92.2669 38.0669 91.6418 37.1428C90.9588 36.179 90.0418 35.6971 88.8921 35.6971C88.1129 35.6971 87.4047 35.9655 86.7721 36.4946C86.1381 37.0284 85.7232 37.7253 85.5292 38.5885C85.4314 38.9911 85.3825 39.3205 85.3825 39.5797V42.0197C85.3825 43.0842 85.6995 43.9824 86.3336 44.7159C86.9677 45.4494 87.7914 45.8154 88.8047 45.8154C89.9944 45.8154 90.9203 45.3427 91.5825 44.4002C92.2462 43.4563 92.5781 42.2119 92.5781 40.6655Z"
                                            fill="white"/>
                                        <path
                                            d="M112.146 40.5466C112.146 43.0354 111.493 45.0026 110.184 46.4468C109.016 47.7324 107.562 48.3744 105.827 48.3744C103.955 48.3744 102.61 47.682 101.792 46.2973H101.733V54.0062H98.5741V38.227C98.5741 36.6624 98.5341 35.0566 98.457 33.4096H101.235L101.411 35.7291H101.47C102.522 33.9814 104.121 33.1091 106.267 33.1091C107.943 33.1091 109.343 33.7908 110.466 35.1557C111.584 36.5221 112.146 38.3185 112.146 40.5466ZM108.928 40.6655C108.928 39.2412 108.616 38.0669 107.99 37.1428C107.307 36.179 106.393 35.6971 105.242 35.6971C104.461 35.6971 103.755 35.9655 103.121 36.4946C102.487 37.0284 102.073 37.7253 101.879 38.5885C101.783 38.9911 101.733 39.3205 101.733 39.5797V42.0197C101.733 43.0842 102.05 43.9824 102.681 44.7159C103.315 45.4479 104.139 45.8154 105.155 45.8154C106.344 45.8154 107.27 45.3427 107.933 44.4002C108.596 43.4563 108.928 42.2119 108.928 40.6655Z"
                                            fill="white"/>
                                        <path
                                            d="M130.426 42.3522C130.426 44.0785 129.844 45.483 128.675 46.5673C127.391 47.7522 125.603 48.3439 123.305 48.3439C121.183 48.3439 119.483 47.923 118.195 47.0797L118.927 44.3698C120.314 45.2329 121.835 45.666 123.493 45.666C124.683 45.666 125.609 45.3885 126.274 44.8364C126.936 44.2844 127.266 43.5432 127.266 42.6191C127.266 41.7956 126.994 41.1017 126.447 40.539C125.903 39.9762 124.995 39.4532 123.727 38.9697C120.275 37.6445 118.551 35.7032 118.551 33.1503C118.551 31.482 119.155 30.1141 120.366 29.0496C121.572 27.9836 123.18 27.4514 125.192 27.4514C126.986 27.4514 128.477 27.7732 129.666 28.4152L128.877 31.0657C127.766 30.4435 126.509 30.1324 125.103 30.1324C123.992 30.1324 123.124 30.4145 122.502 30.9757C121.976 31.4774 121.712 32.0889 121.712 32.8133C121.712 33.6155 122.013 34.2788 122.618 34.8004C123.143 35.2823 124.099 35.8038 125.486 36.3666C127.182 37.0696 128.428 37.8916 129.229 38.834C130.028 39.7734 130.426 40.9492 130.426 42.3522Z"
                                            fill="white"/>
                                        <path
                                            d="M140.869 35.8495H137.387V42.9544C137.387 44.7616 138.001 45.6644 139.23 45.6644C139.795 45.6644 140.263 45.614 140.633 45.5134L140.721 47.9824C140.098 48.2218 139.279 48.3423 138.264 48.3423C137.017 48.3423 136.042 47.9503 135.338 47.168C134.638 46.3842 134.285 45.0696 134.285 43.2228V35.8464H132.211V33.4064H134.285V30.727L137.387 29.7632V33.4064H140.869V35.8495Z"
                                            fill="white"/>
                                        <path
                                            d="M156.577 40.606C156.577 42.8553 155.952 44.7021 154.704 46.1463C153.396 47.6332 151.66 48.3743 149.495 48.3743C147.409 48.3743 145.749 47.6621 144.51 46.2378C143.272 44.8134 142.652 43.0155 142.652 40.8484C142.652 38.5808 143.289 36.7233 144.568 35.2791C145.843 33.8334 147.565 33.1106 149.729 33.1106C151.815 33.1106 153.494 33.8228 154.76 35.2486C155.972 36.6318 156.577 38.4176 156.577 40.606ZM153.3 40.7112C153.3 39.3616 153.02 38.2041 152.452 37.2388C151.79 36.0706 150.843 35.4881 149.617 35.4881C148.347 35.4881 147.383 36.0721 146.72 37.2388C146.153 38.2056 145.873 39.3814 145.873 40.7722C145.873 42.1218 146.153 43.2793 146.72 44.2431C147.403 45.4112 148.358 45.9938 149.589 45.9938C150.795 45.9938 151.741 45.399 152.424 44.2126C153.006 43.229 153.3 42.0593 153.3 40.7112Z"
                                            fill="white"/>
                                        <path
                                            d="M166.844 36.2689C166.532 36.2095 166.198 36.179 165.849 36.179C164.738 36.179 163.878 36.6105 163.274 37.4752C162.748 38.2377 162.484 39.2015 162.484 40.3651V48.0435H159.327L159.357 38.0181C159.357 36.3315 159.317 34.7958 159.238 33.4111H161.989L162.105 36.211H162.192C162.526 35.2487 163.052 34.474 163.772 33.893C164.475 33.3699 165.235 33.1091 166.055 33.1091C166.346 33.1091 166.61 33.1305 166.844 33.1686V36.2689Z"
                                            fill="white"/>
                                        <path
                                            d="M180.97 40.0343C180.97 40.6168 180.933 41.1079 180.854 41.5089H171.379C171.416 42.9546 171.874 44.0603 172.754 44.8228C173.552 45.5044 174.585 45.846 175.853 45.846C177.256 45.846 178.536 45.6158 179.687 45.1537L180.182 47.4107C178.837 48.0146 177.249 48.315 175.416 48.315C173.211 48.315 171.481 47.6471 170.222 46.3127C168.966 44.9783 168.336 43.1864 168.336 40.9386C168.336 38.7319 168.921 36.8943 170.093 35.4288C171.32 33.8641 172.977 33.0818 175.063 33.0818C177.112 33.0818 178.663 33.8641 179.717 35.4288C180.551 36.6716 180.97 38.2088 180.97 40.0343ZM177.958 39.1909C177.979 38.2271 177.773 37.3945 177.345 36.6915C176.798 35.7871 175.958 35.3357 174.828 35.3357C173.795 35.3357 172.955 35.7765 172.314 36.661C171.788 37.364 171.475 38.2073 171.379 39.1894H177.958V39.1909Z"
                                            fill="white"/>
                                        </svg>


                                    </span>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>


    <div class="copy-write">
        <div class="container">
            <div class="row">
                <div class="col-lg-6 col-sm-6">
                    <p class="copy-write-txt">{{ $setting->copyright }}</p>
                </div>
                <div class="col-lg-6 col-sm-6">
                    <div class="copy-write-item">
                        <a href="{{ route('privacy-policy') }}">{{ __('translate.Privacy Policy') }} </a>
                        <a href="{{ route('terms-conditions') }}">{{ __('translate.Terms & Conditions') }} </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</footer>

<!-- footer part end  -->
<!-- back-to-top part start  -->

<div class="back-to-top">
        <span>
            <svg width="39" height="75" viewBox="0 0 39 75" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path
                    d="M17.235 75.0001L18.3095 74.9C18.3095 74.8834 18.3144 74.8667 18.3168 74.85C18.0878 74.8262 17.8612 74.7833 17.6322 74.7809C15.744 74.7738 13.9751 74.2427 12.2526 73.5521C8.50789 72.0493 5.51357 69.6272 3.26965 66.3311C1.58854 63.8591 0.51897 61.1417 0.192494 58.1885C0.0268193 56.6881 0.0195101 55.1687 0.0146374 53.6564C-0.00485375 47.2785 0.0073282 40.9007 1.90292e-05 34.5228C-0.00485375 30.6361 0.925847 27.0066 3.08205 23.72C5.88146 19.4546 9.78943 16.6515 14.7986 15.3655C16.9281 14.8201 19.0989 14.6224 21.3014 14.8606C27.6384 15.5465 32.5185 18.5496 36.0001 23.7534C37.4546 25.9277 38.3902 28.3212 38.7678 30.8957C38.9311 32.015 38.9847 33.1582 38.9896 34.2918C39.0066 41.1365 38.9993 47.9787 38.992 54.8234C38.992 55.8498 39.0066 56.8834 38.9092 57.9027C38.7021 60.0652 38.0735 62.1205 37.0965 64.071C35.2741 67.7077 32.5843 70.5537 28.9809 72.5351C26.793 73.7402 24.4443 74.5214 21.9348 74.7857C21.4987 74.831 21.0553 74.8286 20.6119 74.8881C20.7386 74.9238 20.8653 74.9619 20.9919 74.9977H17.2399L17.235 75.0001ZM3.08449 44.8374H3.08692C3.08692 48.3288 3.06743 51.8202 3.09911 55.3116C3.10885 56.3952 3.18925 57.486 3.3598 58.5553C3.7618 61.1107 4.80458 63.428 6.40772 65.4714C9.05851 68.8532 12.5133 70.9847 16.8355 71.6968C18.8869 72.035 20.9432 72.0207 22.9654 71.5754C26.8271 70.7227 30.0236 68.7865 32.4649 65.7119C34.8891 62.6587 36.0001 59.1864 35.9831 55.3187C35.9489 48.2193 35.9684 41.1174 35.9757 34.0156C35.9757 32.7533 35.8344 31.5078 35.5372 30.286C34.7015 26.8565 32.94 23.9653 30.1698 21.6957C26.1522 18.402 21.5401 17.1802 16.3994 18.1209C12.8374 18.7735 9.82841 20.4715 7.38959 23.1294C4.53901 26.235 3.12103 29.8764 3.09423 34.037C3.07231 37.6379 3.08936 41.2365 3.08936 44.8374H3.08449Z"
                    fill="#FFC13D"/>
                <path
                    d="M38.9366 56.4832C38.9221 56.3784 38.8906 56.2736 38.8906 56.1712C38.8882 48.8645 38.8858 41.5578 38.8882 34.2512C38.8882 34.0463 38.9196 33.8415 38.9366 33.6367V56.4855V56.4832Z"
                    fill="#FFC13D"/>
                <path
                    d="M11.0357 8.95451C10.999 8.54541 11.2848 8.24485 11.5533 7.94116C13.5496 5.68071 15.5481 3.42338 17.5466 1.16501C17.7569 0.927071 17.9575 0.68078 18.1807 0.455361C18.7965 -0.167673 19.5601 -0.150976 20.1404 0.503367C22.4106 3.06229 24.6765 5.62435 26.9403 8.18954C27.4321 8.74683 27.3997 9.4857 26.8831 9.91462C26.3342 10.3696 25.6472 10.3133 25.123 9.72573C23.2669 7.64686 21.4227 5.5586 19.5763 3.47243C19.132 2.97046 19.1395 2.9715 18.6758 3.49748C16.8801 5.53251 15.08 7.56546 13.2822 9.6005C12.9888 9.93237 12.6556 10.1693 12.1756 10.1453C11.5188 10.114 11.0357 9.62972 11.0357 8.95451Z"
                    fill="#FFC13D"/>
                <path
                    d="M16.0445 34.8729C16.0445 34.0632 16.0006 33.2487 16.0542 32.4413C16.1614 30.798 17.5234 29.481 19.2045 29.4429C20.9611 29.4024 22.267 30.6123 22.5277 32.0769C22.6081 32.5318 22.6398 33.001 22.6398 33.463C22.6398 34.7372 22.652 36.0137 22.5911 37.2878C22.5082 38.9835 21.0245 40.3196 19.319 40.3077C17.5697 40.2957 16.1419 38.9716 16.0591 37.2449C16.0226 36.4566 16.0518 35.6636 16.0518 34.8729C16.0518 34.8729 16.0494 34.8729 16.0469 34.8729H16.0445Z"
                    fill="#FFC13D"/>
            </svg>
        </span>
</div>
<!-- back-to-top part end  -->


<script src="{{ asset('global/js/jquery-3.7.1.min.js') }}"></script>
<script src="{{ asset('frontend/fontawesome/js/all.js') }}"></script>
<script src="{{ asset('frontend/assets/js/bootstrap.bundle.min.js') }}"></script>
<script src="{{ asset('global/select2/select2.min.js') }}"></script>
<script src="{{ asset('frontend/assets/js/jquery.shuffle.min.js') }}"></script>
<script src="{{ asset('frontend/assets/js/aos.js') }}"></script>
<script src="{{ asset('frontend/assets/js/venobox.js') }}"></script>
<script src="{{ asset('frontend/assets/js/slick.min.js') }}"></script>
<script src="{{ asset('frontend/assets/js/custom.js') }}"></script>

<script src="{{ asset('global/toastr/toastr.min.js') }}"></script>

<script>
    @if(Session::has('messege'))
    var type = "{{Session::get('alert-type','info') }}"
    switch (type) {
        case 'info':
            toastr.info("{{ Session::get('messege') }}");
            break;
        case 'success':
            toastr.success("{{ Session::get('messege') }}");
            break;
        case 'warning':
            toastr.warning("{{ Session::get('messege') }}");
            break;
        case 'error':
            toastr.error("{{ Session::get('messege') }}");
            break;
    }
    @endif
</script>

@if ($errors->any())
    @foreach ($errors->all() as $error)
        <script>
            toastr.error('{{ $error }}');
        </script>
    @endforeach
@endif

@stack('js_section')

<script>
    (function ($) {
        "use strict"
        $(document).ready(function () {

            $('.select2').select2();

            $('#intro_form_submit').on("click", function () {
                $("#intro_search_form").submit();
            });

            $('#newsletter_btn').on("click", function () {
                $("#newsletter_form").submit();
            });

            $('.before_auth_wishlist').on("click", function () {
                toastr.error("{{ __('translate.Please login first') }}")
            });

            $('.cookie_consent_close_btn').on('click', function () {
                $('.cookie_consent_modal').addClass('d-none');
            });

            $('.cookie_consent_accept_btn').on('click', function () {
                localStorage.setItem('addfirst-cookie', '1');
                $('.cookie_consent_modal').addClass('d-none');
            });

        });
    })(jQuery);

    if (localStorage.getItem('addfirst-cookie') != '1') {
        $('.cookie_consent_modal').removeClass('d-none');
    }

    // Cart Related Code
    $(document).on('click', '.cart-add-btn', function (e) {
        e.preventDefault(); // Prevent any default action if a link was clicked

        var productId = $(this).data('product-id');
        var quantity = $('input[name="quantity"]').val() || 1; // Adjust to match your quantity input field

        var $this = $(this);

        // Create FormData
        let formData = new FormData();
        formData.append('product_id', productId);
        formData.append('quantity', quantity);

        $.ajax({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            url: "{{ route('cart.add') }}",  // URL for add-to-cart route
            type: 'POST',
            data: formData,
            cache: false,
            contentType: false,
            processData: false,
            beforeSend: function () {
                $this.attr("disabled", true); // Disable button to prevent double-clicking
            },
            complete: function () {
                $this.attr("disabled", false); // Re-enable button
            },
            success: function (response) {
                if (response.success) {
                    $('.cart-count').text(`(${response.totalCartItem})`);
                    toastr.success("{{ __('translate.Cart Added Successfully') }}");
                } else {
                    toastr.error("{{ __('translate.Something Went Wrong') }}");
                }
            },
            error: function (xhr, status, error) {
                console.error("AJAX error:", xhr.responseText);
            }
        });
    });
</script>
</body>

</html>
