@extends('layout')
@section('title')
    <title>{{ $seo_setting->seo_title }}</title>
    <meta name="title" content="{{ $seo_setting->seo_title }}">
    <meta name="description" content="{!! strip_tags(clean($seo_setting->seo_description)) !!}">
@endsection

@section('body-content')
<main>


    <!-- inner-bg  part start  -->

    <div class="inner-bg common-class"
    style="    background-image:  url({{ custom_asset($breadcrumb, '1905x408') }});">
        <div class="container">
            <div class="row">
                <div class="col-lg-3">
                    <div class="inner-bg-txt">
                        <h1>{{ __('translate.Blogs') }}</h1>

                        <ul>
                            <li><a href="{{ route('home') }}">{{ __('translate.Home') }}</a></li>
                            <li><span>
                                    <svg width="6" height="12" viewBox="0 0 6 12" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <path
                                            d="M0.633816 2.7705e-08C0.446997 0.0532405 0.28353 0.143084 0.158011 0.319443C-0.0492418 0.618921 -0.0550799 1.0515 0.155092 1.35098C0.195958 1.40755 0.239744 1.46411 0.286449 1.51735C1.56499 2.97481 2.84645 4.4356 4.125 5.89306C4.15419 5.92633 4.18922 5.95295 4.24176 6.03281C4.20673 6.0561 4.16295 6.06941 4.13375 6.10269C2.84062 7.57346 1.5504 9.04755 0.257258 10.5183C0.0295721 10.7779 -0.0579994 11.0773 0.0412483 11.4367C0.187201 11.9591 0.776848 12.1721 1.16216 11.8427C1.20595 11.8061 1.24682 11.7628 1.28768 11.7196C2.7764 10.0225 4.26511 8.32881 5.75091 6.63177C6.02238 6.32231 6.07492 5.92966 5.89394 5.57361C5.85015 5.4871 5.78594 5.41056 5.72464 5.34069C4.27971 3.69356 2.83478 2.04976 1.39277 0.399304C1.23222 0.216289 1.06875 0.0532405 0.838149 3.66367e-08C0.771011 3.3702e-08 0.703873 3.07673e-08 0.633816 2.7705e-08Z" />
                                    </svg>

                                </span></li>
                            <li><a href="javascript:;" class="active">{{ __('translate.Blogs') }}</a></li>
                        </ul>
                    </div>

                </div>
            </div>
        </div>
    </div>


    <!-- inner-bg  part end  -->




    <!-- profile-details part start  -->
    <section class="profile-details   blog footer-top-pad">
        <div class="container">
            <div class="row  mt-20px g-3  ">
                @foreach ($blogs as $index => $blog)
                    <div class="  col-xxl-3   col-xl-4  col-lg-6 col-sm-6"  @if ($index > 3)  data-aos="fade-right" data-aos-delay="50" @endif >
                        <div class="features-single-box ">
                            <div class="features-thumb">
                                <img src="{{ custom_asset($blog->image, '315x230') }}" alt="img">
                            </div>
                            <div class="features-single-box-inner">
                                <div class="features-single-box-inner-txt">
                                    <p>

                                        <span>
                                            <svg width="11" height="12" viewBox="0 0 11 12" fill="none"
                                                xmlns="http://www.w3.org/2000/svg">
                                                <path
                                                    d="M10.9992 3.43661C10.9992 4.03851 11.001 4.63998 10.9984 5.24188C10.9971 5.59777 10.8734 5.90712 10.6216 6.16046C10.253 6.53143 9.88231 6.89981 9.51201 7.26948C8.1817 8.59823 6.8514 9.92699 5.52152 11.2562C5.40297 11.3747 5.27925 11.485 5.11717 11.5405C4.78523 11.6543 4.47658 11.6069 4.21276 11.3772C3.99593 11.1881 3.79548 10.9796 3.59158 10.7762C2.52854 9.71458 1.46636 8.65166 0.405044 7.58874C0.330468 7.51421 0.257184 7.43708 0.192523 7.35393C-0.0816435 6.99977 -0.0622449 6.50946 0.245976 6.18287C0.471862 5.94331 0.708524 5.71367 0.941737 5.48058C2.27248 4.14967 3.60365 2.81919 4.93439 1.48872C5.11415 1.30905 5.29089 1.12594 5.47453 0.949719C5.70904 0.724383 5.99527 0.604606 6.31815 0.602882C7.545 0.597712 8.77142 0.600728 9.99827 0.600728C10.275 0.600728 10.5255 0.673111 10.7251 0.876474C10.8854 1.03977 10.982 1.23494 10.9885 1.46502C10.9971 1.79979 10.9975 2.13457 10.9992 2.46934C11.001 2.79162 10.9992 3.1139 10.9992 3.43618V3.43661ZM9.16327 3.35733C9.1706 2.86228 8.77271 2.45254 8.28603 2.4353C7.76571 2.41678 7.3355 2.82695 7.33075 3.34656C7.32644 3.83773 7.72562 4.24963 8.21059 4.26902C8.72616 4.2897 9.17318 3.86703 9.16327 3.35733Z">
                                                </path>
                                            </svg>
                                        </span>
                                        {{ $blog?->category?->name }}
                                    </p>

                                </div>


                                <a href="{{ route('blog', $blog->slug) }}">
                                    <h3>{{ $blog->title }}</h3>
                                </a>


                                <div class="features-single-box-contact">


                                    <div class="contact">
                                        <p>
                                            <a href="javascript:;">
                                                <span>
                                                    <svg width="13" height="16" viewBox="0 0 13 16" fill="none"
                                                        xmlns="http://www.w3.org/2000/svg">
                                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                                            d="M6.22222 7.11111C8.1859 7.11111 9.77778 5.51923 9.77778 3.55556C9.77778 1.59188 8.1859 0 6.22222 0C4.25854 0 2.66667 1.59188 2.66667 3.55556C2.66667 5.51923 4.25854 7.11111 6.22222 7.11111ZM6.22222 16C9.65866 16 12.4444 14.4081 12.4444 12.4444C12.4444 10.4808 9.65866 8.88889 6.22222 8.88889C2.78578 8.88889 0 10.4808 0 12.4444C0 14.4081 2.78578 16 6.22222 16Z">
                                                        </path>
                                                    </svg>
                                                </span>
                                                {{ $blog?->author?->name }}
                                            </a>
                                        </p>
                                        <p>
                                            <a href="javascript:;">
                                                <span>
                                                    <svg width="15" height="17" viewBox="0 0 15 17" fill="none"
                                                        xmlns="http://www.w3.org/2000/svg">
                                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                                            d="M4.64157 0.605422C4.64157 0.271056 4.37051 0 4.03614 0C3.70178 0 3.43072 0.271057 3.43072 0.605422V1.85647C1.54458 2.12521 0.0823859 3.70969 0.00336393 5.65071H14.5268C14.4477 3.70969 12.9855 2.12521 11.0994 1.85647V0.605422C11.0994 0.271057 10.8283 0 10.494 0C10.1596 0 9.88855 0.271057 9.88855 0.605422V1.81627H4.64157L4.64157 0.605422ZM1.54674e-05 6.86155H14.5301V12.75C14.5301 14.9591 12.7393 16.75 10.5301 16.75H4C1.79086 16.75 0 14.9591 0 12.75V6.86155H1.54674e-05ZM7.26508 11.9066C7.7109 11.9066 8.0723 11.5452 8.0723 11.0994C8.0723 10.6536 7.7109 10.2922 7.26508 10.2922C6.81926 10.2922 6.45785 10.6536 6.45785 11.0994C6.45785 11.5452 6.81926 11.9066 7.26508 11.9066ZM11.3012 11.0994C11.3012 11.5452 10.9398 11.9066 10.494 11.9066C10.0482 11.9066 9.68676 11.5452 9.68676 11.0994C9.68676 10.6536 10.0482 10.2922 10.494 10.2922C10.9398 10.2922 11.3012 10.6536 11.3012 11.0994ZM4.03616 11.9066C4.48198 11.9066 4.84339 11.5452 4.84339 11.0994C4.84339 10.6536 4.48198 10.2922 4.03616 10.2922C3.59034 10.2922 3.22893 10.6536 3.22893 11.0994C3.22893 11.5452 3.59034 11.9066 4.03616 11.9066Z">
                                                        </path>
                                                    </svg>
                                                </span>
                                                {{ $blog->created_at->diffForHumans() }}
                                            </a>
                                        </p>
                                    </div>
                                </div>

                            </div>

                        </div>
                    </div>
                @endforeach

            </div>

            @if ($blogs->hasPages())
            <div class="row">
                <div class="col-lg-12">
                    {{ $blogs->links('pagination_box') }}
                </div>
            </div>
            @endif




        </div>
    </section>
    <!--profile-details part end  -->


</main>
@endsection
