<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class MenuItemTranslationSeeder extends Seeder
{
    public function run(): void
    {
        $translations = [
            ['id'=>7,  'menu_item_id'=>5,  'locale'=>'en', 'title'=>'Home'],
            ['id'=>8,  'menu_item_id'=>5,  'locale'=>'hd', 'title'=>'Home'],
            ['id'=>9,  'menu_item_id'=>5,  'locale'=>'bn', 'title'=>'Home'],
            ['id'=>10, 'menu_item_id'=>6,  'locale'=>'en', 'title'=>'Home-01'],
            ['id'=>11, 'menu_item_id'=>6,  'locale'=>'hd', 'title'=>'Home-01'],
            ['id'=>12, 'menu_item_id'=>6,  'locale'=>'bn', 'title'=>'Home-01'],
            ['id'=>13, 'menu_item_id'=>7,  'locale'=>'en', 'title'=>'Home-02'],
            ['id'=>14, 'menu_item_id'=>7,  'locale'=>'hd', 'title'=>'Home-02'],
            ['id'=>15, 'menu_item_id'=>7,  'locale'=>'bn', 'title'=>'Home-02'],
            ['id'=>16, 'menu_item_id'=>8,  'locale'=>'en', 'title'=>'Listing'],
            ['id'=>17, 'menu_item_id'=>8,  'locale'=>'hd', 'title'=>'Listing'],
            ['id'=>18, 'menu_item_id'=>8,  'locale'=>'bn', 'title'=>'Listing'],
            ['id'=>19, 'menu_item_id'=>9,  'locale'=>'en', 'title'=>'Classified'],
            ['id'=>20, 'menu_item_id'=>9,  'locale'=>'hd', 'title'=>'Classified'],
            ['id'=>21, 'menu_item_id'=>9,  'locale'=>'bn', 'title'=>'Classified'],
            ['id'=>22, 'menu_item_id'=>10, 'locale'=>'en', 'title'=>'Page'],
            ['id'=>23, 'menu_item_id'=>10, 'locale'=>'hd', 'title'=>'Page'],
            ['id'=>24, 'menu_item_id'=>10, 'locale'=>'bn', 'title'=>'Page'],
            ['id'=>25, 'menu_item_id'=>11, 'locale'=>'en', 'title'=>'About Us'],
            ['id'=>26, 'menu_item_id'=>11, 'locale'=>'hd', 'title'=>'About Us'],
            ['id'=>27, 'menu_item_id'=>11, 'locale'=>'bn', 'title'=>'About Us'],
            ['id'=>28, 'menu_item_id'=>12, 'locale'=>'en', 'title'=>'Contact Us'],
            ['id'=>29, 'menu_item_id'=>12, 'locale'=>'hd', 'title'=>'Contact Us'],
            ['id'=>30, 'menu_item_id'=>12, 'locale'=>'bn', 'title'=>'Contact Us'],
            ['id'=>34, 'menu_item_id'=>14, 'locale'=>'en', 'title'=>'Home-03'],
            ['id'=>35, 'menu_item_id'=>14, 'locale'=>'hd', 'title'=>'Home-03'],
            ['id'=>36, 'menu_item_id'=>14, 'locale'=>'bn', 'title'=>'Home-03'],
            ['id'=>37, 'menu_item_id'=>15, 'locale'=>'en', 'title'=>'Home-04'],
            ['id'=>38, 'menu_item_id'=>15, 'locale'=>'hd', 'title'=>'Home-04'],
            ['id'=>39, 'menu_item_id'=>15, 'locale'=>'bn', 'title'=>'Home-04'],
            ['id'=>40, 'menu_item_id'=>16, 'locale'=>'en', 'title'=>'Job PostS'],
            ['id'=>41, 'menu_item_id'=>16, 'locale'=>'hd', 'title'=>'Job Post'],
            ['id'=>42, 'menu_item_id'=>16, 'locale'=>'bn', 'title'=>'Job Post'],
            ['id'=>52, 'menu_item_id'=>20, 'locale'=>'en', 'title'=>'Real Estate'],
            ['id'=>53, 'menu_item_id'=>20, 'locale'=>'hd', 'title'=>'Real Estate'],
            ['id'=>54, 'menu_item_id'=>20, 'locale'=>'bn', 'title'=>'Real Estate'],
            ['id'=>55, 'menu_item_id'=>21, 'locale'=>'en', 'title'=>'Ecommerce'],
            ['id'=>56, 'menu_item_id'=>21, 'locale'=>'hd', 'title'=>'Ecommerce'],
            ['id'=>57, 'menu_item_id'=>21, 'locale'=>'bn', 'title'=>'Ecommerce'],
            ['id'=>58, 'menu_item_id'=>22, 'locale'=>'en', 'title'=>'Our Blogs'],
            ['id'=>59, 'menu_item_id'=>22, 'locale'=>'hd', 'title'=>'Our Blogs'],
            ['id'=>60, 'menu_item_id'=>22, 'locale'=>'bn', 'title'=>'Our Blogs'],
            ['id'=>61, 'menu_item_id'=>23, 'locale'=>'en', 'title'=>'FAQ'],
            ['id'=>62, 'menu_item_id'=>23, 'locale'=>'hd', 'title'=>'FAQ'],
            ['id'=>63, 'menu_item_id'=>23, 'locale'=>'bn', 'title'=>'FAQ'],
            ['id'=>64, 'menu_item_id'=>24, 'locale'=>'en', 'title'=>'Subscription Plan'],
            ['id'=>65, 'menu_item_id'=>24, 'locale'=>'hd', 'title'=>'Subscription Plan'],
            ['id'=>66, 'menu_item_id'=>24, 'locale'=>'bn', 'title'=>'Subscription Plan'],
            ['id'=>67, 'menu_item_id'=>25, 'locale'=>'en', 'title'=>'Terms & Conditions'],
            ['id'=>68, 'menu_item_id'=>25, 'locale'=>'hd', 'title'=>'Terms & Conditions'],
            ['id'=>69, 'menu_item_id'=>25, 'locale'=>'bn', 'title'=>'Terms & Conditions'],
            ['id'=>70, 'menu_item_id'=>26, 'locale'=>'en', 'title'=>'Privacy Policy'],
            ['id'=>71, 'menu_item_id'=>26, 'locale'=>'hd', 'title'=>'Privacy Policy'],
            ['id'=>72, 'menu_item_id'=>26, 'locale'=>'bn', 'title'=>'Privacy Policy'],
            ['id'=>73, 'menu_item_id'=>27, 'locale'=>'en', 'title'=>'Custom Page One'],
            ['id'=>74, 'menu_item_id'=>27, 'locale'=>'hd', 'title'=>'Custom Page One'],
            ['id'=>75, 'menu_item_id'=>27, 'locale'=>'bn', 'title'=>'Custom Page One'],
            ['id'=>76, 'menu_item_id'=>28, 'locale'=>'en', 'title'=>'Custom Page Two'],
            ['id'=>77, 'menu_item_id'=>28, 'locale'=>'hd', 'title'=>'Custom Page Two'],
            ['id'=>78, 'menu_item_id'=>28, 'locale'=>'bn', 'title'=>'Custom Page Two'],
            ['id'=>82, 'menu_item_id'=>30, 'locale'=>'en', 'title'=>'Cart ( 0 )'],
            ['id'=>83, 'menu_item_id'=>30, 'locale'=>'hd', 'title'=>'Cart ( 0 )'],
            ['id'=>84, 'menu_item_id'=>30, 'locale'=>'bn', 'title'=>'Cart ( 0 )'],
            ['id'=>85, 'menu_item_id'=>31, 'locale'=>'en', 'title'=>'My Profile'],
            ['id'=>86, 'menu_item_id'=>31, 'locale'=>'hd', 'title'=>'My Profile'],
            ['id'=>87, 'menu_item_id'=>31, 'locale'=>'bn', 'title'=>'My Profile'],
            ['id'=>88, 'menu_item_id'=>32, 'locale'=>'en', 'title'=>'My Dashboard'],
            ['id'=>89, 'menu_item_id'=>32, 'locale'=>'hd', 'title'=>'My Dashboard'],
            ['id'=>90, 'menu_item_id'=>32, 'locale'=>'bn', 'title'=>'My Dashboard'],
            ['id'=>91, 'menu_item_id'=>33, 'locale'=>'en', 'title'=>'Post Your Ad'],
            ['id'=>92, 'menu_item_id'=>33, 'locale'=>'hd', 'title'=>'Post Your Ad'],
            ['id'=>93, 'menu_item_id'=>33, 'locale'=>'bn', 'title'=>'Post Your Ad'],
            ['id'=>94, 'menu_item_id'=>34, 'locale'=>'en', 'title'=>'Change Password'],
            ['id'=>95, 'menu_item_id'=>34, 'locale'=>'hd', 'title'=>'Change Password'],
            ['id'=>96, 'menu_item_id'=>34, 'locale'=>'bn', 'title'=>'Change Password'],
            ['id'=>97, 'menu_item_id'=>35, 'locale'=>'en', 'title'=>'Edit Profile'],
            ['id'=>98, 'menu_item_id'=>35, 'locale'=>'hd', 'title'=>'Edit Profile'],
            ['id'=>99, 'menu_item_id'=>35, 'locale'=>'bn', 'title'=>'Edit Profile'],
            ['id'=>100,'menu_item_id'=>36, 'locale'=>'en', 'title'=>'Wishlist'],
            ['id'=>101,'menu_item_id'=>36, 'locale'=>'hd', 'title'=>'Wishlist'],
            ['id'=>102,'menu_item_id'=>36, 'locale'=>'bn', 'title'=>'Wishlist'],
            ['id'=>103,'menu_item_id'=>37, 'locale'=>'en', 'title'=>'Useful Links'],
            ['id'=>104,'menu_item_id'=>37, 'locale'=>'hd', 'title'=>'Useful Links'],
            ['id'=>105,'menu_item_id'=>37, 'locale'=>'bn', 'title'=>'Useful Links'],
            ['id'=>106,'menu_item_id'=>38, 'locale'=>'en', 'title'=>'About Us'],
            ['id'=>107,'menu_item_id'=>38, 'locale'=>'hd', 'title'=>'About Us'],
            ['id'=>108,'menu_item_id'=>38, 'locale'=>'bn', 'title'=>'About Us'],
            ['id'=>109,'menu_item_id'=>39, 'locale'=>'en', 'title'=>'Contact Us'],
            ['id'=>110,'menu_item_id'=>39, 'locale'=>'hd', 'title'=>'Contact Us'],
            ['id'=>111,'menu_item_id'=>39, 'locale'=>'bn', 'title'=>'Contact Us'],
            ['id'=>112,'menu_item_id'=>40, 'locale'=>'en', 'title'=>'Our Blog'],
            ['id'=>113,'menu_item_id'=>40, 'locale'=>'hd', 'title'=>'Our Blog'],
            ['id'=>114,'menu_item_id'=>40, 'locale'=>'bn', 'title'=>'Our Blog'],
            ['id'=>115,'menu_item_id'=>41, 'locale'=>'en', 'title'=>'FAQ'],
            ['id'=>116,'menu_item_id'=>41, 'locale'=>'hd', 'title'=>'FAQ'],
            ['id'=>117,'menu_item_id'=>41, 'locale'=>'bn', 'title'=>'FAQ'],
            ['id'=>118,'menu_item_id'=>42, 'locale'=>'en', 'title'=>'Membership'],
            ['id'=>119,'menu_item_id'=>42, 'locale'=>'hd', 'title'=>'Membership'],
            ['id'=>120,'menu_item_id'=>42, 'locale'=>'bn', 'title'=>'Membership'],
        ];

        foreach ($translations as $translation) {
            $exists = DB::table('menu_item_translations')
                ->where('menu_item_id', $translation['menu_item_id'])
                ->where('locale', $translation['locale'])
                ->first();

            if ($exists) {
                $this->command->info("Translation for menu_item_id {$translation['menu_item_id']} ({$translation['locale']}) already exists.");
            } else {
                DB::table('menu_item_translations')->insert(array_merge($translation, [
                    'created_at' => now(),
                    'updated_at' => now(),
                ]));
                $this->command->info("Translation for menu_item_id {$translation['menu_item_id']} ({$translation['locale']}) inserted.");
            }
        }
    }
}

