<?php

namespace App\Http\Controllers;

use App\Constants\Status;
use App\Models\User;

use App\Models\Review;
use App\Rules\Captcha;
use App\Models\AdsBanner;
use App\Models\JobRequest;
use Illuminate\Http\Request;
use App\Models\ListingReport;
use Modules\Ecommerce\Entities\Product;
use Modules\Page\Entities\EcomBanner;
use Modules\Page\Entities\Faq;
use Modules\Blog\Entities\Blog;
use Modules\City\Entities\City;
use Modules\Page\Entities\AboutUs;
use Modules\Page\Entities\HomePage;
use Modules\Page\Entities\ContactUs;
use Modules\Country\Entities\Country;
use Modules\Feature\Entities\Feature;
use Modules\Listing\Entities\Listing;
use Modules\Page\Entities\CustomPage;
use Modules\Blog\Entities\BlogComment;
use Modules\Blog\Entities\BlogCategory;
use Modules\Language\Entities\Language;
use Modules\Page\Entities\PrivacyPolicy;
use Modules\Category\Entities\SubCategory;
use Modules\Page\Entities\Slider;
use Modules\Page\Entities\TermAndCondition;
use Modules\Category\Entities\ChildCategory;

use Modules\GeneralSetting\Entities\Setting;
use Modules\Listing\Entities\ListingGallery;
use Modules\Testimonial\Entities\Testimonial;
use Modules\Currency\app\Models\MultiCurrency;
use Modules\GeneralSetting\Entities\SeoSetting;
use Str, Mail, Hash, Auth, Session,Config, File;
use Modules\Subscription\Entities\SubscriptionPlan;

class HomeController extends Controller
{

    public function index(Request $request){

        $setting = Setting::select('selected_theme')->first();
        if($setting->selected_theme == 'all_theme'){
            if($request->has('theme')){
                $theme = $request->theme;
                if($theme == 'one'){
                    Session::put('selected_theme', 'theme_one');
                }elseif($theme == 'two'){
                    Session::put('selected_theme', 'theme_two');
                }elseif($theme == 'three'){
                    Session::put('selected_theme', 'theme_three');
                }elseif($theme == 'four'){
                    Session::put('selected_theme', 'theme_four');
                }else{
                    if(!Session::has('selected_theme')){
                        Session::put('selected_theme', 'theme_one');
                    }
                }
            }else{
                Session::put('selected_theme', 'theme_one');
            }
        }else{
            if($setting->selected_theme == 'theme_one'){
                Session::put('selected_theme', 'theme_one');
            }elseif($setting->selected_theme == 'theme_two'){
                Session::put('selected_theme', 'theme_two');
            }elseif($setting->selected_theme == 'theme_three'){
                Session::put('selected_theme', 'theme_three');
            } elseif($setting->selected_theme == 'theme_four'){
                Session::put('selected_theme', 'theme_four');
            }
        }

        $seo_setting = SeoSetting::where('id', 1)->first();

        $homepage = HomePage::with('front_translate')->first();

        $cities = City::latest()->take(15)->get();

        $sub_categories = SubCategory::where(['status' => 'enable', 'category_id' => 1])->latest()->get();

        $sub_categories_2 = SubCategory::where(['status' => 'enable', 'category_id' => 1])->get();

        $jobpost_sub_categories = SubCategory::where(['status' => 'enable', 'category_id' => 3])->latest()->get();

        $realestate_sub_categories = SubCategory::where(['status' => 'enable', 'category_id' => 2])->latest()->get();

        $featured_listings = Listing::with('agent', 'sub_category')->where(function ($query) {
            $query->where('expired_date', null)
                ->orWhere('expired_date', '>=', date('Y-m-d'));
        })->where(['is_featured' => 'enable', 'status' => 'enable', 'approved_by_admin' => 'approved', 'category_id' => 1])->get()->take(6);

        $jobpost_featured_listings = Listing::with('agent', 'sub_category')->where(function ($query) {
            $query->where('expired_date', null)
                ->orWhere('expired_date', '>=', date('Y-m-d'));
        })->where(['is_featured' => 'enable', 'status' => 'enable', 'approved_by_admin' => 'approved', 'category_id' => 3])->get()->take(6);

        $realestate_featured_listings = Listing::with('agent', 'sub_category')->where(function ($query) {
            $query->where('expired_date', null)
                ->orWhere('expired_date', '>=', date('Y-m-d'));
        })->where(['is_featured' => 'enable', 'status' => 'enable', 'approved_by_admin' => 'approved', 'category_id' => 2])->get()->take(6);

        $latest_listings = Listing::with('agent', 'sub_category')->where(function ($query) {
            $query->where('expired_date', null)
                ->orWhere('expired_date', '>=', date('Y-m-d'));
        })->where(['status' => 'enable', 'approved_by_admin' => 'approved', 'category_id' => 1])->latest()->get()->take(9);

        $jobpost_latest_listings = Listing::with('agent', 'sub_category')->where(function ($query) {
            $query->where('expired_date', null)
                ->orWhere('expired_date', '>=', date('Y-m-d'));
        })->where(['status' => 'enable', 'approved_by_admin' => 'approved', 'category_id' => 3])->latest()->get()->take(9);

        $realestate_latest_listings = Listing::with('agent', 'sub_category')->where(function ($query) {
            $query->where('expired_date', null)
                ->orWhere('expired_date', '>=', date('Y-m-d'));
        })->where(['status' => 'enable', 'approved_by_admin' => 'approved', 'category_id' => 2])->latest()->get()->take(12);

        $testimonials = Testimonial::where('status', 'active')->orderBy('id','desc')->get();

        $home1_featured1_ads = AdsBanner::where('position_key', 'home1_featured_listing_sidebar')->first();
        $home1_featured2_ads = AdsBanner::where('position_key', 'home1_featured_listing_sidebar_2')->first();
        $home1_featured3_ads = AdsBanner::where('position_key', 'home1_featured_listing_bottom')->first();
        $home1_explore_ads = AdsBanner::where('position_key', 'home1_explore_side')->first();
        $home2_ads = AdsBanner::where('position_key', 'home2_featured_listing_top')->first();
        $home3_ads = AdsBanner::where('position_key', 'home3_city_top')->first();

        $selected_theme = Session::get('selected_theme');

        $countries = Country::latest()->get();

        $sliders = Slider::with('translate')->active()->get();

        $products = Product::with('translate')->active()->latest()->get();
        $subCategories = SubCategory::withCount(['products' => function ($query) {
            $query->where('status', Status::ENABLE);
        }])->where(['status' => 'enable', 'category_id' => Status::ECOMMERCE])
            ->latest()
            ->get();

        $banners = EcomBanner::with('translate')->get();

        if ($selected_theme == 'theme_one'){
            return view('index', [
                'seo_setting' => $seo_setting,
                'homepage' => $homepage,
                'countries' => $countries,
                'cities' => $cities,
                'sub_categories' => $sub_categories,
                'sub_categories_2' => $sub_categories_2,
                'jobpost_sub_categories' => $jobpost_sub_categories,
                'realestate_sub_categories' => $realestate_sub_categories,
                'featured_listings' => $featured_listings,
                'jobpost_featured_listings' => $jobpost_featured_listings,
                'latest_listings' => $latest_listings,
                'jobpost_latest_listings' => $jobpost_latest_listings,
                'realestate_latest_listings' => $realestate_latest_listings,
                'realestate_featured_listings' => $realestate_featured_listings,
                'testimonials' => $testimonials,
                'home1_featured1_ads' => $home1_featured1_ads,
                'home1_featured2_ads' => $home1_featured2_ads,
                'home1_featured3_ads' => $home1_featured3_ads,
                'home1_explore_ads' => $home1_explore_ads,

            ]);
        }elseif($selected_theme == 'theme_two'){
            return view('index2', [
                'seo_setting' => $seo_setting,
                'homepage' => $homepage,
                'cities' => $cities,
                'countries' => $countries,
                'sub_categories' => $sub_categories,
                'sub_categories_2' => $sub_categories_2,
                'jobpost_sub_categories' => $jobpost_sub_categories,
                'realestate_sub_categories' => $realestate_sub_categories,
                'featured_listings' => $featured_listings,
                'jobpost_featured_listings' => $jobpost_featured_listings,
                'latest_listings' => $latest_listings,
                'jobpost_latest_listings' => $jobpost_latest_listings,
                'realestate_latest_listings' => $realestate_latest_listings,
                'realestate_featured_listings' => $realestate_featured_listings,
                'testimonials' => $testimonials,
                'home2_ads' => $home2_ads,
            ]);
        }elseif($selected_theme == 'theme_three'){
            return view('index3', [
                'seo_setting' => $seo_setting,
                'homepage' => $homepage,
                'cities' => $cities,
                'countries' => $countries,
                'sub_categories' => $sub_categories,
                'sub_categories_2' => $sub_categories_2,
                'jobpost_sub_categories' => $jobpost_sub_categories,
                'realestate_sub_categories' => $realestate_sub_categories,
                'featured_listings' => $featured_listings,
                'jobpost_featured_listings' => $jobpost_featured_listings,
                'latest_listings' => $latest_listings,
                'jobpost_latest_listings' => $jobpost_latest_listings,
                'realestate_latest_listings' => $realestate_latest_listings,
                'realestate_featured_listings' => $realestate_featured_listings,
                'testimonials' => $testimonials,
                'home3_ads' => $home3_ads,
            ]);
        } elseif($selected_theme == 'theme_four') {
            return view('frontend.theme_four.index4', [
                'seo_setting' => $seo_setting,
                'homepage' => $homepage,
                'sliders' => $sliders,
                'products' => $products,
                'subCategories' => $subCategories,
                'cities' => $cities,
                'countries' => $countries,
                'sub_categories' => $sub_categories,
                'sub_categories_2' => $sub_categories_2,
                'jobpost_sub_categories' => $jobpost_sub_categories,
                'realestate_sub_categories' => $realestate_sub_categories,
                'featured_listings' => $featured_listings,
                'jobpost_featured_listings' => $jobpost_featured_listings,
                'latest_listings' => $latest_listings,
                'jobpost_latest_listings' => $jobpost_latest_listings,
                'realestate_latest_listings' => $realestate_latest_listings,
                'realestate_featured_listings' => $realestate_featured_listings,
                'testimonials' => $testimonials,
                'home3_ads' => $home3_ads,
                'banners' => $banners,
            ]);
        }else {
            return view('index', [
                'seo_setting' => $seo_setting,
                'homepage' => $homepage,
                'cities' => $cities,
                'countries' => $countries,
                'sub_categories' => $sub_categories,
                'sub_categories_2' => $sub_categories_2,
                'jobpost_sub_categories' => $jobpost_sub_categories,
                'realestate_sub_categories' => $realestate_sub_categories,
                'featured_listings' => $featured_listings,
                'jobpost_featured_listings' => $jobpost_featured_listings,
                'latest_listings' => $latest_listings,
                'jobpost_latest_listings' => $jobpost_latest_listings,
                'realestate_latest_listings' => $realestate_latest_listings,
                'realestate_featured_listings' => $realestate_featured_listings,
                'testimonials' => $testimonials,
                'home1_featured1_ads' => $home1_featured1_ads,
                'home1_featured2_ads' => $home1_featured2_ads,
                'home1_featured3_ads' => $home1_featured3_ads,
                'banners' => $banners,
            ]);
        }
    }

    public function about_us(){

        $seo_setting = SeoSetting::where('id', 3)->first();

        $about_us = AboutUs::first();

        $homepage = HomePage::first();

        $testimonials = Testimonial::where('status', 'active')->orderBy('id','desc')->get();

        return view('about_us')->with([
            'seo_setting' => $seo_setting,
            'about_us' => $about_us,
            'homepage' => $homepage,
            'testimonials' => $testimonials,
        ]);
    }

    public function contact_us(){
        $seo_setting = SeoSetting::where('id', 4)->first();

        $contact_us = ContactUs::first();

        return view('contact_us')->with([
            'seo_setting' => $seo_setting,
            'contact_us' => $contact_us,
        ]);
    }

    public function terms_conditions(){
        $seo_setting = SeoSetting::where('id', 6)->first();

        $terms_condition = TermAndCondition::where('lang_code', Session::get('front_lang'))->first();

        return view('terms_conditions')->with([
            'seo_setting' => $seo_setting,
            'terms_condition' => $terms_condition,
        ]);
    }

    public function privacy_policy(){
        $seo_setting = SeoSetting::where('id', 7)->first();

        $privacy_policy = PrivacyPolicy::where('lang_code', Session::get('front_lang'))->first();

        return view('privacy_policy')->with([
            'seo_setting' => $seo_setting,
            'privacy_policy' => $privacy_policy,
        ]);
    }

    public function faq(){
        $seo_setting = SeoSetting::where('id', 5)->first();

        $general_faqs = Faq::where('category', 'general-questions')->latest()->get();
        $community_faqs = Faq::where('category', 'community')->latest()->get();
        $support_faqs = Faq::where('category', 'support')->latest()->get();

        $homepage = HomePage::first();

        return view('faq')->with([
            'seo_setting' => $seo_setting,
            'general_faqs' => $general_faqs,
            'community_faqs' => $community_faqs,
            'support_faqs' => $support_faqs,
            'homepage' => $homepage,
        ]);
    }

    public function blogs(Request $request){

        $seo_setting = SeoSetting::where('id', 2)->first();

        $blogs = Blog::with('author')->orderBy('id','desc')->where('status', 1)->paginate(9);

        return view('blog')->with([
            'seo_setting' => $seo_setting,
            'blogs' => $blogs
        ]);
    }

    public function blog_show(Request $request, $slug){
        $blog = Blog::where('status', 1)->where(['slug' => $slug])->first();
        $blog->views += 1;
        $blog->save();

        $blog_comments = BlogComment::orderBy('id','desc')->where('blog_id', $blog->id)->where('status', 1)->get();

        $popular_blogs = Blog::where('is_popular', 'yes')->where('status', 1)->orderBy('id','desc')->get();

        $categories = BlogCategory::where('status', 1)->get();

        return view('blog_detail')->with([
            'blog' => $blog,
            'blog_comments' => $blog_comments,
            'popular_blogs' => $popular_blogs,
            'categories' => $categories,
        ]);
    }

    public function store_comment(Request $request){
        $rules = [
            'blog_id'=>'required',
            'name'=>'required',
            'email'=>'required',
            'comment'=>'required',
            'g-recaptcha-response'=>new Captcha()
        ];
        $customMessages = [
            'name.required' => trans('translate.Name is required'),
            'email.required' => trans('translate.Email is required'),
            'comment.required' => trans('translate.Comment is required')
        ];
        $this->validate($request, $rules,$customMessages);

        $blog_comment = new BlogComment();
        $blog_comment->blog_id = $request->blog_id;
        $blog_comment->name = $request->name;
        $blog_comment->email = $request->email;
        $blog_comment->comment = $request->comment;
        $blog_comment->save();

        $notification= trans('translate.Blog comment has submited');
        $notification=array('messege'=>$notification,'alert-type'=>'success');
        return redirect()->back()->with($notification);
    }

    public function custom_page($slug){

        $custom_page = CustomPage::where('slug', $slug)->firstOrFail();

        return view('custom_page')->with([
            'custom_page' => $custom_page,
        ]);
    }

    public function listings(Request $request)
    {
        $seo_setting = SeoSetting::where('id', 10)->first();

        if (!$request->category) {
            abort(404);
        }

        $category_id = 0;
        $listings = [];
        $is_ecommerce = false;

        if ($request->category == 'classified') {
            $sub_categories = SubCategory::where(['status' => 'enable', 'category_id' => 1])->latest()->get();
            $aminities = Feature::with('translate')->where('category_id', 1)->get();
            $category_id = 1;
            $products = null;

        } elseif ($request->category == 'jobpost') {
            $sub_categories = SubCategory::where(['status' => 'enable', 'category_id' => 3])->latest()->get();
            $aminities = Feature::with('translate')->where('category_id', 3)->get();
            $category_id = 3;
            $products = null;

        } elseif ($request->category == 'realestate') {
            $sub_categories = SubCategory::where(['status' => 'enable', 'category_id' => 2])->latest()->get();
            $aminities = Feature::with('translate')->where('category_id', 2)->get();
            $category_id = 2;
            $products = null;

        } elseif ($request->category == 'ecommerce') {
            // Handle eCommerce case
            $is_ecommerce = true; // Flag to indicate we're working with Product model
            $sub_categories = SubCategory::where(['status' => 'enable', 'category_id' => Status::ECOMMERCE])->latest()->get();
            $aminities = Feature::with('translate')->where('category_id', Status::ECOMMERCE)->get();
            $category_id = 4;

            // Fetch products instead of listings
            $products = Product::where('status', '1');



            if ($request->sub_category_id) {
                $products->where('sub_category_id', $request->sub_category_id);
            }

            if ($request->child_category_id) {
                $products->where('child_category_id', $request->child_category_id);
            }

            if ($request->min_price) {
                $products->where('price', '>=', $request->min_price / Session::get('currency_rate', 1));
            }

            if ($request->max_price) {
                $products->where('price', '<=', $request->max_price / Session::get('currency_rate', 1));
            }

            if ($request->keyword) {
                $products->where('name', 'like', '%' . $request->keyword . '%');
            }

            $listings = $products->latest()->paginate(12); // Use products in place of listings

        } else {
            abort(404);
        }

        if (!$is_ecommerce) {
            // Default Listing Query
            $listings = Listing::with('agent', 'sub_category')->where(function ($query) {
                $query->where('expired_date', null)
                    ->orWhere('expired_date', '>=', date('Y-m-d'));
            })->where(['status' => 'enable', 'approved_by_admin' => 'approved']);

            $listings = $listings->where('category_id', $category_id);

            if ($request->location) {
                $listings = $listings->where('city_id', $request->location);
            }

            if ($request->country) {
                $listings = $listings->where('country_id', $request->country);
            }

            if ($request->sub_categories) {
                $listings = $listings->whereIn('sub_category_id', $request->sub_categories);
            }

            if ($request->aminities) {
                $listings = $listings->whereJsonContains('features', $request->aminities);
            }

            if ($request->price_filter) {
                if ($request->price_filter == 'low_to_high') {
                    $listings = $listings->orderBy('regular_price', 'asc');
                } elseif ($request->price_filter == 'high_to_low') {
                    $listings = $listings->orderBy('regular_price', 'desc');
                }
            }

            if ($request->search) {
                $listings = $listings->whereHas('front_translate', function ($query) use ($request) {
                    $query->where('title', 'like', '%' . $request->search . '%')
                        ->orWhere('description', 'like', '%' . $request->search . '%');
                });
            }

            $listings = $listings->latest()->paginate(12);
        }

        $max_price_list = !$is_ecommerce
            ? Listing::orderBy('regular_price', 'desc')->first()
            : Product::orderBy('price', 'desc')->first();

        $max_price = $max_price_list ? ($is_ecommerce ? $max_price_list->price : $max_price_list->regular_price) : 0;

        $selected_min_price = $request->min_price ?? 0;
        $selected_max_price = $request->max_price ?? $max_price;

        $listing_ads = AdsBanner::where('position_key', 'listing_sidebar')->first();

        $countries = Country::latest()->get();

        $cities = [];
        if ($request->has('country')) {
            $cities = City::with('translate')->where('country_id', $request->country)->get();
        }

        $child_categories = [];
        if ($request->sub_category_id) {
            $child_categories = ChildCategory::where(['sub_category_id' => $request->sub_category_id, 'status' => 'enable'])->latest()->get();
        }

        return view('listing', [
            'seo_setting' => $seo_setting,
            'cities' => $cities,
            'countries' => $countries,
            'sub_categories' => $sub_categories,
            'child_categories' => $child_categories,
            'aminities' => $aminities,
            'max_price' => $max_price,
            'selected_min_price' => $selected_min_price,
            'selected_max_price' => $selected_max_price,
            'listings' => $listings,
            'listing_ads' => $listing_ads,
            'products'=> $products,
            'is_ecommerce' => $is_ecommerce,
            'category_id' => $category_id,
        ]);
    }

    public function listing($slug){

        $listing = Listing::with('agent', 'sub_category')->where(function ($query) {
            $query->where('expired_date', null)
                ->orWhere('expired_date', '>=', date('Y-m-d'));
        })->where(['status' => 'enable', 'approved_by_admin' => 'approved'])->where('slug', $slug)->firstOrFail();

        $listing->total_view +=1;
        $listing->save();

        $galleries = ListingGallery::where('listing_id', $listing->id)->get();

        $feature_json_array = array();

        if($listing->features != 'null'){
            $feature_json_array = json_decode($listing->features);
        }

        $listing_features = Feature::whereIn('id', $feature_json_array)->get();

        $related_listings = Listing::with('agent', 'sub_category')->where(function ($query) {
            $query->where('expired_date', null)
                ->orWhere('expired_date', '>=', date('Y-m-d'));
        })->where(['status' => 'enable', 'approved_by_admin' => 'approved'])->where('sub_category_id', $listing->sub_category_id)->where('id', '!=', $listing->id)->get()->take(6);

        $agent = User::where(['status' => 'enable' , 'is_banned' => 'no', 'is_dealer' => 1])->where('email_verified_at', '!=', null)->orderBy('id','desc')->select('id','name','username','designation','image','status','is_banned','is_dealer', 'address', 'email', 'phone', 'created_at', 'whatsapp_phone')->where('id', $listing->agent_id)->first();

        $reviews = Review::with('user')->where('listing_id', $listing->id)->where('reviewType', 'listing')->where('status', 'enable')->latest()->get();

        $listing_top_ads = AdsBanner::where('position_key', 'listing_detail_topbar')->first();
        $listing_sidebar_ads = AdsBanner::where('position_key', 'listing_detail_sidebar')->first();

        return view('listing_detail', [
            'listing' => $listing,
            'galleries' => $galleries,
            'listing_features' => $listing_features,
            'related_listings' => $related_listings,
            'agent' => $agent,
            'reviews' => $reviews,
            'listing_top_ads' => $listing_top_ads,
            'listing_sidebar_ads' => $listing_sidebar_ads,
        ]);

    }

    public function store_report(Request $request){

        $rules = [
            'name'=>'required',
            'email'=>'required',
            'message'=>'required',
            'listing_id'=>'required',
            'agent_id'=>'required',
            'g-recaptcha-response'=>new Captcha()
        ];

        $customMessages = [
            'name.required' => trans('translate.Name is required'),
            'email.required' => trans('translate.Email is required'),
            'message.required' => trans('translate.Reason is required'),
            'listing_id.required' => trans('translate.Listing is required'),
        ];

        $this->validate($request, $rules,$customMessages);

        $report = new ListingReport();
        $report->name = $request->name;
        $report->email = $request->email;
        $report->message = $request->message;
        $report->listing_id = $request->listing_id;
        $report->agent_id = $request->agent_id;
        $report->save();

        $notification = trans('translate.Report submited successfully');
        $notification=array('messege'=>$notification,'alert-type'=>'success');
        return redirect()->back()->with($notification);

    }

    public function store_job_request(Request $request){

        $rules = [
            'description'=>'required',
            'listing_id'=>'required',
            'agent_id'=>'required',
            'g-recaptcha-response'=>new Captcha()
        ];

        $customMessages = [
            'description.required' => trans('translate.Message is required'),
            'listing_id.required' => trans('translate.Listing is required'),
        ];

        $this->validate($request, $rules,$customMessages);

        $auth_user = Auth::guard('web')->user();

        if($request->agent_id == $auth_user->id){
            $notification = trans('translate.You can not applied to your own job post');
            $notification=array('messege'=>$notification,'alert-type'=>'error');
            return redirect()->back()->with($notification);
        }

        $is_exist = JobRequest::where(['user_id' => $auth_user->id, 'listing_id' => $request->listing_id])->count();
        if($is_exist > 0){
            $notification = trans('translate.Application already submited');
            $notification=array('messege'=>$notification,'alert-type'=>'error');
            return redirect()->back()->with($notification);
        }

        $approval_check = JobRequest::where('listing_id', $request->listing_id)->where('status', 'approved')->count();

        if($approval_check > 0){
            $notification = trans('translate.Job already has assigned, so you can not apply');
            $notification = array('messege'=>$notification,'alert-type'=>'error');
            return redirect()->back()->with($notification);
        }

        $job_request = new JobRequest();
        $job_request->user_id = $auth_user->id;
        $job_request->agent_id = $request->agent_id;
        $job_request->listing_id = $request->listing_id;
        $job_request->description = $request->description;
        $job_request->save();

        $notification = trans('translate.Your application has submited successfully, please wait for agent approval');
        $notification=array('messege'=>$notification,'alert-type'=>'success');
        return redirect()->back()->with($notification);

    }

    public function agent(Request $request, $username){

        $agent = User::where(['status' => 'enable' , 'is_banned' => 'no', 'is_dealer' => 1])->where('email_verified_at', '!=', null)->orderBy('id','desc')->select('id','name','username','designation','image','status','is_banned','is_dealer', 'address', 'email', 'phone','facebook','linkedin','twitter','instagram', 'about_me','created_at','sunday','monday','tuesday','wednesday','thursday','friday','saturday','google_map', 'whatsapp_phone')->where('username', $username)->firstOrFail();

        $total_agent_rating = Review::where('agent_id', $agent->id)->where('reviewType', 'listing')->where('status', 'enable')->count();

        $listings = Listing::with('agent', 'sub_category')->where(function ($query) {
            $query->where('expired_date', null)
                ->orWhere('expired_date', '>=', date('Y-m-d'));
        })->where(['status' => 'enable', 'approved_by_admin' => 'approved'])->where('agent_id', $agent->id)->latest()->get();

        $dealer_ads = AdsBanner::where('position_key', 'dealer_detail_page_banner')->first();

        return view('agent_detail', [
            'agent' => $agent,
            'listings' => $listings,
            'total_agent_rating' => $total_agent_rating,
            'dealer_ads' => $dealer_ads,
        ]);
    }

    public function pricing_plan(){

        $subscription_plans = SubscriptionPlan::orderBy('serial', 'asc')->where('status', 'active')->get();

        return view('pricing_plan', ['subscription_plans' => $subscription_plans]);
    }

    public function language_switcher(Request $request){
        
        $request_lang = Language::where('lang_code', $request->lang_code)->first();

        Session::put('front_lang', $request->lang_code);
        Session::put('front_lang_name', $request_lang->lang_name);
        Session::put('lang_dir', $request_lang->lang_direction);

        app()->setLocale($request->lang_code);

        $notification= trans('translate.Language switched successfully');
        $notification=array('messege'=>$notification,'alert-type'=>'success');
        return redirect()->back()->with($notification);

    }

    public function currency_switcher(Request $request){

        $request_currency = MultiCurrency::where('currency_code', $request->currency_code)->first();
        Session::put('currency_name', $request_currency->currency_name);
        Session::put('currency_code', $request_currency->currency_code);
        Session::put('currency_icon', $request_currency->currency_icon);
        Session::put('currency_rate', $request_currency->currency_rate);
        Session::put('currency_position', $request_currency->currency_position);

        $notification= trans('translate.Currency switched successfully');
        $notification=array('messege'=>$notification,'alert-type'=>'success');
        return redirect()->back()->with($notification);

    }

    public function download_resume($file){
        $filepath= public_path() . "/uploads/custom-images/".$file;
        return response()->download($filepath);
    }

    public function cities_by_country($country_id){

        $cities = City::where('country_id', $country_id)->get();

        $html_response = "<option value=''>".trans('translate.Select City')."</option>";

        foreach($cities as $ciy){
            $new_item = "<option value='$ciy->id'>".$ciy->name."</option>";

            $html_response .= $new_item;
        }

        return response()->json($html_response);

    }

     public function child_categories_by_sub_category($sub_category_id){

        $child_categories = ChildCategory::where(['sub_category_id' => $sub_category_id, 'status' => 'enable'])->latest()->get();


        $html_response = "<option value=''>".trans('translate.Select')."</option>";

        foreach($child_categories as $child_category){
            $new_item = "<option value='$child_category->id'>".$child_category->name."</option>";

            $html_response .= $new_item;
        }

        return response()->json($html_response);

    }


}
