<?php

namespace Modules\Page\Http\Controllers;

use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\Page\Entities\HomePage;
use Modules\Page\Entities\HomePageTranslation;
use Modules\Page\Http\Requests\ExploreRequest;
use Modules\Page\Http\Requests\Explore2Request;
use Modules\Page\Http\Requests\Explore3Request;
use Image, File, Str;

class ExploreController extends Controller
{

    public function index(Request $request)
    {
        $homepage = HomePage::first();
        $translate = HomePageTranslation::where(['home_page_id' => $homepage->id, 'lang_code' => $request->lang_code])->first();

        return view('page::section.home1_explore', compact('homepage', 'translate'));
    }


    public function update(ExploreRequest $request)
    {
        $translate = HomePageTranslation::where(['id' => $request->translate_id])->first();
        $translate->home1_explore_title = $request->home1_explore_title;
        $translate->home1_explore_des = $request->home1_explore_des;
        $translate->save();

        $homepage = HomePage::first();

        if ($request->hasFile('home1_explore_image')) {
            $image_path = uploadFile($request->file('home1_explore_image'), 'uploads/website-images', $homepage->home1_explore_image);
            $homepage->home1_explore_image = $image_path;
            $homepage->save();
        }

        $notification = trans('translate.Updated Successfully');
        $notification = array('messege'=>$notification,'alert-type'=>'success');
        return redirect()->back()->with($notification);
    }

    public function home2_index(Request $request)
    {
        $homepage = HomePage::first();
        $translate = HomePageTranslation::where(['home_page_id' => $homepage->id, 'lang_code' => $request->lang_code])->first();

        return view('page::section.home2_explore', compact('homepage', 'translate'));
    }

    public function home2_update(Explore2Request $request)
    {
        $translate = HomePageTranslation::where(['id' => $request->translate_id])->first();
        $translate->home2_explore_title = $request->home2_explore_title;
        $translate->home2_explore_des = $request->home2_explore_des;
        $translate->save();

        $homepage = HomePage::first();

        if ($request->hasFile('home2_explore_image')) {
            $image_path = uploadFile($request->file('home2_explore_image'), 'uploads/website-images', $homepage->home2_explore_image);
            $homepage->home2_explore_image = $image_path;
            $homepage->save();
        }

        $notification = trans('translate.Updated Successfully');
        $notification = array('messege'=>$notification,'alert-type'=>'success');
        return redirect()->back()->with($notification);
    }


    public function home3_index(Request $request)
    {
        $homepage = HomePage::first();
        $translate = HomePageTranslation::where(['home_page_id' => $homepage->id, 'lang_code' => $request->lang_code])->first();

        return view('page::section.home3_explore', compact('homepage', 'translate'));
    }

    public function home3_update(Explore3Request $request)
    {
        $translate = HomePageTranslation::where(['id' => $request->translate_id])->first();
        $translate->home3_explore_title = $request->home3_explore_title;
        $translate->save();

        $homepage = HomePage::first();

        if ($request->hasFile('home3_explore_image')) {
            $image_path = uploadFile($request->file('home3_explore_image'), 'uploads/website-images', $homepage->home3_explore_image);
            $homepage->home3_explore_image = $image_path;
            $homepage->save();
        }

        $notification = trans('translate.Updated Successfully');
        $notification = array('messege'=>$notification,'alert-type'=>'success');
        return redirect()->back()->with($notification);
    }
}
