<?php

namespace Modules\Listing\Http\Controllers\Frontend;

use App\Models\User;
use App\Models\Review;
use App\Models\JobRequest;
use Auth, Image, File, Str;
use Illuminate\Http\Request;
use App\Models\ListingReport;

use Modules\City\Entities\City;
use Illuminate\Routing\Controller;
use Intervention\Image\ImageManager;
use Modules\Country\Entities\Country;
use Modules\Feature\Entities\Feature;
use Modules\Listing\Entities\Listing;
use Modules\Language\Entities\Language;
use Modules\Category\Entities\SubCategory;
use Illuminate\Contracts\Support\Renderable;

use Modules\Category\Entities\ChildCategory;

use Modules\Listing\Entities\ListingGallery;
use Modules\Listing\Entities\ListingTranslation;
use Modules\Listing\Http\Requests\ListingRequest;
use Modules\Subscription\Entities\SubscriptionHistory;

class ListingController extends Controller
{
    /**
     * Display a listing of the resource.
     * @return Renderable
     */
    public function index()
    {
        $user = Auth::guard('web')->user();

        $listings = Listing::where('agent_id', $user->id)->latest()->get();

        return view('listing::frontend.index', ['listings' => $listings]);
    }

    public function select_listing_purpose()
    {
        return view('listing::frontend.select_listing_purpose');
    }



    /**
     * Show the form for creating a new resource.
     * @return Renderable
     */
    public function create(Request $request)
    {

        $countries = Country::latest()->get();

        $user = Auth::guard('web')->user();

        $active_plan = SubscriptionHistory::where('user_id', $user->id)->latest()->first();

        if(!$active_plan){
            $notification=  trans('translate.Please enroll first');
            $notification=array('messege'=>$notification,'alert-type'=>'error');
            return redirect()->route('pricing-plan')->with($notification);
        }

        $expiration_date = $active_plan->expiration_date;

        if($expiration_date != 'lifetime'){
            if(date('Y-m-d') > $expiration_date){
                $notification = trans('translate.Your plan is expired, please renew or re-order');
                $notification = array('messege'=>$notification,'alert-type'=>'error');
                return redirect()->route('pricing-plan')->with($notification);
            }
        }

        $max_listing = $active_plan->max_listing;

        $total_listing = Listing::where('agent_id', $user->id)->count();

        if($total_listing >= $max_listing){
            $notification = trans('translate.Your listing limitation has exceeded');
            $notification = array('messege'=>$notification,'alert-type'=>'error');
            return redirect()->route('user.select-listing-purpose')->with($notification);
        }

        if($request->category == 'classified'){

            $sub_categories = SubCategory::with('translate')->where('category_id', 1)->where('status', 'enable')->get();
            $cities = City::with('translate')->get();
            $aminities = Feature::with('translate')->where('category_id', 1)->get();

            return view('listing::frontend.create_classified', compact('sub_categories', 'cities', 'aminities', 'countries'));

        }elseif($request->category == 'job-post'){

            $sub_categories = SubCategory::with('translate')->where('category_id', 3)->where('status', 'enable')->get();
            $cities = City::with('translate')->get();
            $aminities = Feature::with('translate')->where('category_id', 3)->get();

            return view('listing::frontend.create_jobpost', compact('sub_categories', 'cities', 'aminities', 'countries'));

        }elseif($request->category == 'real-estate'){

            $sub_categories = SubCategory::with('translate')->where('category_id', 2)->where('status', 'enable')->get();
            $cities = City::with('translate')->get();
            $aminities = Feature::with('translate')->where('category_id', 2)->get();

            return view('listing::frontend.create_real_estate', compact('sub_categories', 'cities', 'aminities', 'countries'));

        }else{
            abort(404);
        };

    }

    /**
     * Store a newly created resource in storage.
     * @param Request $request
     * @return Renderable
     */
    public function store(ListingRequest $request)
    {

        $user = Auth::guard('web')->user();

        $listing = new Listing();

        if ($request->hasFile('thumb_image')) {
            $image_path = uploadFile($request->file('thumb_image'), 'uploads/custom-images');
            $listing->thumb_image = $image_path;
        }

        $listing->agent_id = $user->id;
        $listing->category_id = $request->category_id;
        $listing->sub_category_id = $request->sub_category_id;
        $listing->child_category_id = $request->child_category_id ? $request->child_category_id : 0;
        $listing->city_id = $request->city_id;
        $listing->country_id = $request->country_id;
        $listing->slug = $request->slug;
        $listing->features = json_encode($request->features);
        $listing->regular_price = $request->regular_price;
        $listing->video_id = $request->video_id;
        $listing->google_map = $request->google_map;
        $listing->save();

        $active_plan = SubscriptionHistory::where('user_id', $user->id)->latest()->first();

        if($active_plan->expiration_date == 'lifetime'){
            $listing->expired_date = null;
            $listing->save();
        }else{
            $listing->expired_date = $active_plan->expiration_date;
            $listing->save();
        }

        $languages = Language::all();
        foreach($languages as $language){

            $listing_translate = new ListingTranslation();
            $listing_translate->lang_code = $language->lang_code;
            $listing_translate->listing_id = $listing->id;
            $listing_translate->title = $request->title;
            $listing_translate->description = $request->description;
            $listing_translate->address = $request->address;
            $listing_translate->seo_title = $request->seo_title ? $request->seo_title : $request->title;
            $listing_translate->seo_description = $request->seo_description ? $request->seo_description : $request->title;
            $listing_translate->save();

        }


        $notification= trans('translate.Created successfully, please awaiting for admin approval');
        $notification=array('messege'=>$notification,'alert-type'=>'success');
        return redirect()->route('user.listing.edit', ['listing' => $listing->id, 'lang_code' => admin_lang()] )->with($notification);
    }

    /**
     * Show the form for editing the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function edit(Request $request, $id)
    {

        $countries = Country::latest()->get();

        $user = Auth::guard('web')->user();

        $listing = Listing::where('agent_id', $user->id)->where('id', $id)->firstOrFail();

        $listing_translate = ListingTranslation::where(['listing_id' => $id, 'lang_code' => $request->lang_code])->first();


        $child_categories = ChildCategory::where(['sub_category_id' => $listing->sub_category_id, 'status' => 'enable'])->latest()->get();


        if($listing->category_id == 1){

            $sub_categories = SubCategory::with('translate')->where('category_id', 1)->where('status', 'enable')->get();
            $cities = City::with('translate')->where('country_id', $listing->country_id)->get();
            $aminities = Feature::with('translate')->where('category_id', 1)->get();

            $existing_aminities = array();
            if($listing->features != 'null'){
                $existing_aminities = json_decode($listing->features);
            }

            return view('listing::frontend.edit_classified', compact('sub_categories', 'cities', 'aminities', 'existing_aminities', 'listing_translate', 'listing', 'countries', 'child_categories'));

        }elseif($listing->category_id == 2){

            $sub_categories = SubCategory::with('translate')->where('category_id', 2)->where('status', 'enable')->get();
            $cities = City::with('translate')->where('country_id', $listing->country_id)->get();
            $aminities = Feature::with('translate')->where('category_id', 2)->get();

            $existing_aminities = array();
            if($listing->features != 'null'){
                $existing_aminities = json_decode($listing->features);
            }

            return view('listing::frontend.edit_real_estate', compact('sub_categories', 'cities', 'aminities', 'existing_aminities', 'listing_translate', 'listing', 'countries', 'child_categories'));

        }elseif($listing->category_id == 3){
            $sub_categories = SubCategory::with('translate')->where('category_id', 3)->where('status', 'enable')->get();
            $cities = City::with('translate')->where('country_id', $listing->country_id)->get();
            $aminities = Feature::with('translate')->where('category_id', 3)->get();

            $existing_aminities = array();
            if($listing->features != 'null'){
                $existing_aminities = json_decode($listing->features);
            }

            return view('listing::frontend.edit_jobpost', compact('sub_categories', 'cities', 'aminities', 'existing_aminities', 'listing_translate', 'listing', 'countries', 'child_categories'));
        }else{
            abort(404);
        };
    }

    /**
     * Update the specified resource in storage.
     * @param Request $request
     * @param int $id
     * @return Renderable
     */
    public function update(ListingRequest $request, $id)
    {
        $listing = Listing::findOrFail($id);

        if($request->lang_code == admin_lang()){

            if ($request->hasFile('thumb_image')) {
                $image_path = uploadFile($request->file('thumb_image'), 'uploads/custom-images', $listing->thumb_image);
                $listing->thumb_image = $image_path;
                $listing->save();
            }

            $listing->sub_category_id = $request->sub_category_id;
            $listing->child_category_id = $request->child_category_id ? $request->child_category_id : 0;
            $listing->city_id = $request->city_id;
            $listing->country_id = $request->country_id;
            $listing->slug = $request->slug;
            $listing->video_id = $request->video_id;
            $listing->features = json_encode($request->features);
            $listing->regular_price = $request->regular_price;
            $listing->video_id = $request->video_id;
            $listing->google_map = $request->google_map;
            $listing->save();

        }

        $listing_translate = ListingTranslation::findOrFail($request->translate_id);
        $listing_translate->title = $request->title;
        $listing_translate->description = $request->description;
        $listing_translate->video_description = $request->video_description;
        $listing_translate->address = $request->address;
        $listing_translate->seo_title = $request->seo_title ? $request->seo_title : $request->title;
        $listing_translate->seo_description = $request->seo_description ? $request->seo_description : $request->title;
        $listing_translate->save();

        $notification= trans('translate.Updated Successfully');
        $notification=array('messege'=>$notification,'alert-type'=>'success');
        return redirect()->back()->with($notification);
    }

    /**
     * Remove the specified resource from storage.
     * @param int $id
     * @return Renderable
     */
    public function destroy($id)
    {
        $listing = Listing::findOrFail($id);

        deleteFile($listing->thumb_image);

        ListingTranslation::where('listing_id',$id)->delete();
        Review::where('listing_id',$id)->delete();
        ListingReport::where('listing_id',$id)->delete();
        JobRequest::where('listing_id',$id)->delete();

        $galleries = ListingGallery::where('listing_id', $id)->get();
        foreach($galleries as $gallery){

            deleteFile($gallery->image);

            $gallery->delete();
        }

        $listing->delete();

        $notification=  trans('translate.Delete Successfully');
        $notification=array('messege'=>$notification,'alert-type'=>'success');
        return redirect()->back()->with($notification);
    }

    public function listing_gallery($id){
        $listing = Listing::findOrFail($id);

        $galleries = ListingGallery::where('listing_id', $id)->get();

        return view('listing::frontend.gallery', compact('listing', 'galleries'));
    }

    public function upload_listing_gallery(Request $request, $id){

        $listing = Listing::findOrFail($id);

        foreach ($request->file as $index => $image) {
            $gallery_image = new ListingGallery();


            if ($image) {
                $image_path = uploadFile($image, 'uploads/custom-images');
                $gallery_image->image = $image_path;
            }

            $gallery_image->listing_id = $id;
            $gallery_image->save();
        }

        if ($gallery_image) {
            return response()->json([
                'message' => trans('translate.Images uploaded successfully'),
                'url' => route('user.listing-gallery', $id),
            ]);
        } else {
             return response()->json([
                'message' => trans('translate.Images uploaded Failed'),
                'url' => route('user.listing-gallery', $id),
            ]);
        }

    }

    public function delete_listing_gallery($id){
        $gallery = ListingGallery::findOrFail($id);
        deleteFile($gallery->image);

        $gallery->delete();

        $notification=  trans('translate.Delete Successfully');
        $notification=array('messege'=>$notification,'alert-type'=>'success');
        return redirect()->back()->with($notification);

    }
}
