<?php

namespace Modules\Listing\Entities;

use App\Models\Booking;
use App\Models\User;
use App\Models\JobRequest;
use Illuminate\Database\Eloquent\Model;
use Modules\Category\Entities\Category;
use Modules\Category\Entities\SubCategory;
use Modules\Category\Entities\ChildCategory;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Listing extends Model
{
    use HasFactory;

    protected $fillable = [];

    protected $appends = ['title', 'description', 'video_description', 'address', 'seo_title', 'seo_description', 'total_job_application'];

    protected $hidden = ['front_translate'];

    protected static function newFactory()
    {
        return \Modules\Listing\Database\factories\ListingFactory::new();
    }

    public function category(){
        return $this->belongsTo(Category::class, 'category_id');
    }

    public function sub_category(){
        return $this->belongsTo(SubCategory::class, 'sub_category_id');
    }

    public function child_category(){
        return $this->belongsTo(ChildCategory::class, 'child_category_id');
    }

    public function agent(){
        return $this->belongsTo(User::class, 'agent_id')->select('id', 'name', 'email', 'image', 'username');
    }

    public function job_applications(){
        return $this->hasMany(JobRequest::class);
    }

    public function getTotalJobApplicationAttribute(){
        return $this->job_applications()->count();
    }

    public function translate(){
        return $this->belongsTo(ListingTranslation::class, 'id', 'listing_id')->where('lang_code', admin_lang());
    }

    public function front_translate(){
        return $this->belongsTo(ListingTranslation::class, 'id', 'listing_id')->where('lang_code', front_lang());
    }

    public function getTitleAttribute()
    {
        if($this->front_translate){
            return $this->front_translate->title;          
        }else{
            return $this->translate->title;

        }
    }

    public function getDescriptionAttribute()
    {
        if($this->front_translate){
            return $this->front_translate->description;          
        }else{
            return $this->translate->description;

        }
    }

    public function getVideoDescriptionAttribute()
    {
        if($this->front_translate){
            return $this->front_translate->video_description;          
        }else{
            return $this->translate->video_description;

        }
    }

    public function getAddressAttribute()
    {
        if($this->front_translate){
            return $this->front_translate->address;          
        }else{
            return $this->translate->address;

        }
    }

    public function getSeoTitleAttribute()
    {
        if($this->front_translate){
            return $this->front_translate->seo_title;          
        }else{
            return $this->translate->seo_title;

        }
    }

    public function getSeoDescriptionAttribute()
    {
        if($this->front_translate){
            return $this->front_translate->seo_description;          
        }else{
            return $this->translate->seo_description;

        }
    }

    public function checkJobStatus($id){
        $approval_check = JobRequest::where('listing_id', $id)->where('status', 'approved')->count();

        if($approval_check > 0){
            return "approved";
        }else{
            return "pending";
        }
    }

    public function isOwnedByUser($user = null)
    {
        if (!$user) {
            $user = auth()->guard('web')->user();
        }
        return $user && $this->agent_id === $user->id;
    }

    public function bookings()
    {
        return $this->hasMany(Booking::class);
    }

}
