@extends('layout')
@section('title')
    <title>{{ $seo_setting->seo_title }}</title>
    <meta name="title" content="{{ $seo_setting->seo_title }}">
    <meta name="description" content="{!! strip_tags(clean($seo_setting->seo_description)) !!}">
@endsection

@section('body-content')
    <main>
        <!-- banner part start  -->
        <section class="banner common-class">
            <div class="container banner-bg">
                <div class="row align-items-center">
                    <div class="col-xl-7 col-lg-8">
                        <h1 class="banner-taitel">
                            {{ $homepage->home1_intro_short_title }}
                        </h1>

                        <p class="banner-dec">{{ $homepage->home1_intro_title }}</p>

                        <div class="sarch-box">
                            <div class="sarch-box-left">
                                <form class="sarch-box-form-item" action="{{ route('listings') }}" id="intro_search_form">

                                    <div class="sarch-box-form-inner">
                                        <div class="icon">
                                            <span>
                                                <svg width="20" height="20" viewBox="0 0 20 20" fill="none"
                                                    xmlns="http://www.w3.org/2000/svg">
                                                    <path
                                                        d="M19.7552 18.5774L14.781 13.6033C16.1365 11.9454 16.803 9.83002 16.6425 7.69457C16.4821 5.55913 15.507 3.56705 13.919 2.13037C12.331 0.693699 10.2515 -0.0776494 8.1107 -0.0241229C5.96991 0.0294036 3.93158 0.90371 2.41734 2.41795C0.903099 3.93219 0.0287933 5.97052 -0.0247333 8.11131C-0.0782598 10.2521 0.693089 12.3316 2.12976 13.9196C3.56644 15.5076 5.55852 16.4827 7.69396 16.6431C9.82941 16.8036 11.9448 16.1371 13.6027 14.7816L18.5768 19.7558C18.734 19.9076 18.9445 19.9916 19.163 19.9897C19.3815 19.9878 19.5905 19.9001 19.745 19.7456C19.8995 19.5911 19.9872 19.3821 19.9891 19.1636C19.991 18.9451 19.907 18.7346 19.7552 18.5774ZM8.33266 14.9999C7.01412 14.9999 5.72519 14.6089 4.62886 13.8764C3.53253 13.1439 2.67805 12.1027 2.17347 10.8845C1.66888 9.66632 1.53686 8.32588 1.79409 7.03267C2.05133 5.73947 2.68627 4.55158 3.61862 3.61923C4.55097 2.68688 5.73885 2.05194 7.03206 1.7947C8.32527 1.53747 9.66571 1.66949 10.8839 2.17408C12.1021 2.67866 13.1433 3.53314 13.8758 4.62947C14.6083 5.7258 14.9993 7.01473 14.9993 8.33327C14.9973 10.1008 14.2943 11.7953 13.0445 13.0451C11.7947 14.2949 10.1002 14.998 8.33266 14.9999Z"
                                                        fill="#14212B" />
                                                </svg>

                                            </span>
                                        </div>

                                        <input type="email" class="form-control" id="search" name="search"
                                            placeholder="{{ __('translate.Search here') }}">
                                    </div>
                                    <div class="sarch-box-form-inner">
                                        <div class="icon">
                                            <span>
                                                <svg width="19" height="21" viewBox="0 0 19 21" fill="none"
                                                    xmlns="http://www.w3.org/2000/svg">
                                                    <path fill-rule="evenodd" clip-rule="evenodd"
                                                        d="M9.22693 7.32679C8.15022 7.32679 7.26112 8.21319 7.26112 9.32679C7.26112 10.4404 8.15022 11.3268 9.22693 11.3268C10.3036 11.3268 11.1927 10.4404 11.1927 9.32679C11.1927 8.21319 10.3036 7.32679 9.22693 7.32679ZM5.72266 9.32679C5.72266 7.38159 7.28259 5.78833 9.22693 5.78833C11.1713 5.78833 12.7312 7.38159 12.7312 9.32679C12.7312 11.272 11.1713 12.8653 9.22693 12.8653C7.28259 12.8653 5.72266 11.272 5.72266 9.32679Z"
                                                        fill="#14212B" />
                                                    <path fill-rule="evenodd" clip-rule="evenodd"
                                                        d="M9.22436 1.78846C5.11763 1.78846 1.78846 5.11763 1.78846 9.22436C1.78846 11.2362 2.94903 13.6299 4.5586 15.5591C5.35353 16.5119 6.22926 17.3157 7.07021 17.8749C7.92722 18.4449 8.67305 18.7115 9.22436 18.7115C9.77567 18.7115 10.5215 18.4449 11.3785 17.8749C12.2195 17.3157 13.0952 16.5119 13.8901 15.5591C15.4997 13.6299 16.6603 11.2362 16.6603 9.22436C16.6603 5.11763 13.3311 1.78846 9.22436 1.78846ZM0.25 9.22436C0.25 4.26796 4.26796 0.25 9.22436 0.25C14.1808 0.25 18.1987 4.26796 18.1987 9.22436C18.1987 11.744 16.7952 14.4786 15.0714 16.5447C14.1997 17.5896 13.2164 18.5002 12.2305 19.156C11.2605 19.801 10.2115 20.25 9.22436 20.25C8.2372 20.25 7.18817 19.801 6.21825 19.156C5.23228 18.5002 4.24903 17.5896 3.37729 16.5447C1.65354 14.4786 0.25 11.744 0.25 9.22436Z"
                                                        fill="#14212B" />
                                                </svg>

                                            </span>
                                        </div>

                                        <select class="form-select select2" name="country">
                                            <option selected value="">
                                                {{ __('translate.Country') }}
                                            </option>
                                            @foreach ($countries as $country)
                                                <option value="{{ $country->id }}">{{ $country->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <div class="sarch-box-form-inner">
                                        <div class="icon">
                                            <span>
                                                <svg width="20" height="20" viewBox="0 0 20 20" fill="none"
                                                    xmlns="http://www.w3.org/2000/svg">
                                                    <g clip-path="url(#clip0_2977_180283)">
                                                        <path
                                                            d="M5.83333 5.00004H19.1667C19.3877 5.00004 19.5996 4.91224 19.7559 4.75596C19.9122 4.59968 20 4.38772 20 4.16671C20 3.94569 19.9122 3.73373 19.7559 3.57745C19.5996 3.42117 19.3877 3.33337 19.1667 3.33337H5.83333C5.61232 3.33337 5.40036 3.42117 5.24408 3.57745C5.0878 3.73373 5 3.94569 5 4.16671C5 4.38772 5.0878 4.59968 5.24408 4.75596C5.40036 4.91224 5.61232 5.00004 5.83333 5.00004Z"
                                                            fill="#14212B" />
                                                        <path
                                                            d="M19.1667 9.16663H5.83333C5.61232 9.16663 5.40036 9.25442 5.24408 9.4107C5.0878 9.56698 5 9.77895 5 9.99996C5 10.221 5.0878 10.4329 5.24408 10.5892C5.40036 10.7455 5.61232 10.8333 5.83333 10.8333H19.1667C19.3877 10.8333 19.5996 10.7455 19.7559 10.5892C19.9122 10.4329 20 10.221 20 9.99996C20 9.77895 19.9122 9.56698 19.7559 9.4107C19.5996 9.25442 19.3877 9.16663 19.1667 9.16663Z"
                                                            fill="#14212B" />
                                                        <path
                                                            d="M19.1667 15H5.83333C5.61232 15 5.40036 15.0878 5.24408 15.2441C5.0878 15.4004 5 15.6123 5 15.8333C5 16.0543 5.0878 16.2663 5.24408 16.4226C5.40036 16.5789 5.61232 16.6667 5.83333 16.6667H19.1667C19.3877 16.6667 19.5996 16.5789 19.7559 16.4226C19.9122 16.2663 20 16.0543 20 15.8333C20 15.6123 19.9122 15.4004 19.7559 15.2441C19.5996 15.0878 19.3877 15 19.1667 15Z"
                                                            fill="#14212B" />
                                                        <path
                                                            d="M1.66667 5.83333C2.58714 5.83333 3.33333 5.08714 3.33333 4.16667C3.33333 3.24619 2.58714 2.5 1.66667 2.5C0.746192 2.5 0 3.24619 0 4.16667C0 5.08714 0.746192 5.83333 1.66667 5.83333Z"
                                                            fill="#14212B" />
                                                        <path
                                                            d="M1.66667 11.6667C2.58714 11.6667 3.33333 10.9205 3.33333 10C3.33333 9.07957 2.58714 8.33337 1.66667 8.33337C0.746192 8.33337 0 9.07957 0 10C0 10.9205 0.746192 11.6667 1.66667 11.6667Z"
                                                            fill="#14212B" />
                                                        <path
                                                            d="M1.66667 17.5C2.58714 17.5 3.33333 16.7538 3.33333 15.8333C3.33333 14.9128 2.58714 14.1666 1.66667 14.1666C0.746192 14.1666 0 14.9128 0 15.8333C0 16.7538 0.746192 17.5 1.66667 17.5Z"
                                                            fill="#14212B" />
                                                    </g>

                                                </svg>

                                            </span>
                                        </div>
                                        <select class="form-select select2" name="sub_category_id">

                                            <option selected value="">
                                                {{ __('translate.Category') }}
                                            </option>
                                            @foreach ($sub_categories as $sub_category)
                                                <option value="{{ $sub_category->id }}">{{ $sub_category->name }}</option>
                                            @endforeach

                                        </select>
                                    </div>

                                    <input type="hidden" name="category" value="classified">
                                </form>
                            </div>

                            <a href="javascript:;" class="main-btn" id="intro_form_submit">
                                <span>
                                    <svg width="17" height="17" viewBox="0 0 17 17" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <path
                                            d="M14.125 12.0307L15.5663 13.4719C16.1446 14.0503 16.1446 14.9879 15.5663 15.5663C14.9879 16.1446 14.0503 16.1446 13.4719 15.5663L12.0307 14.125M1 7.375C1 3.85418 3.85418 1 7.37499 1C10.8958 1 13.75 3.85418 13.75 7.375C13.75 10.8958 10.8958 13.75 7.37499 13.75C3.85418 13.75 1 10.8958 1 7.375Z"
                                            stroke-width="1.2" stroke-linecap="round" />
                                    </svg>
                                </span>

                                <div class="btn_m">
                                    <div class="btn_c">
                                        <div class="btn_t1"> {{ __('translate.Search') }}</div>
                                        <div class="btn_t2"> {{ __('translate.Search') }}</div>
                                    </div>
                                </div>
                            </a>
                        </div>
                    </div>

                    <div class="col-xl-5 col-lg-4">
                        <div class="banner-thumb">
                            <img src="{{ asset($homepage->home1_intro_image) }}" alt="thumb">
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- banner part end  -->

        <!-- listing part start  -->
        <section class="listing common-class">
            <div class="container">
                <div class="row align-items-end">
                    <div class="col-lg-6 col-sm-8">
                        <h2 class="taitel">{{ __('translate.Browse all Categories') }}</h2>
                    </div>

                    <div class="col-lg-6 col-sm-4">
                        <div class="listing-arrow">
                            <div class="listing-arrow-next">
                                <span>
                                    <svg width="20" height="14" viewBox="0 0 20 14" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <path d="M7 1L1 7M1 7L7 13M1 7L19 7" stroke-width="1.5" stroke-linecap="round"
                                            stroke-linejoin="round" />
                                    </svg>
                                </span>
                            </div>
                            <div class="listing-arrow-prev">
                                <span>
                                    <svg width="20" height="14" viewBox="0 0 20 14" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <path d="M13.0002 13L19.0002 7M19.0002 7L13.0002 0.999999M19.0002 7L1.00024 7"
                                            stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                                    </svg>
                                </span>
                            </div>

                        </div>
                    </div>
                </div>

                <div class="row listing-slick">
                    @foreach ($sub_categories as $sub_category)
                        <div class="col-lg-2">
                            <div class="listing-item">
                                <div class="listing-images">
                                    <div class="listing-thumb">
                                        <img src="{{ asset($sub_category->icon) }}" alt="img">
                                    </div>
                                </div>

                                <div class="listing-txt">
                                    <h4><a
                                            href="{{ route('listings', ['sub_category_id' => $sub_category->id, 'category' => 'classified']) }}">{{ $sub_category->name }}</a>
                                    </h4>
                                    <h5>
                                        <span>
                                            <svg width="11" height="12" viewBox="0 0 11 12" fill="none"
                                                xmlns="http://www.w3.org/2000/svg">
                                                <path
                                                    d="M10.9992 3.33675C10.9992 3.93866 11.001 4.54013 10.9984 5.14203C10.9971 5.49792 10.8734 5.80727 10.6216 6.06061C10.253 6.43158 9.88231 6.79996 9.51201 7.16963C8.1817 8.49838 6.8514 9.82713 5.52152 11.1563C5.40297 11.2748 5.27925 11.3851 5.11717 11.4407C4.78523 11.5544 4.47658 11.507 4.21276 11.2774C3.99593 11.0882 3.79548 10.8797 3.59158 10.6763C2.52854 9.61472 1.46636 8.55181 0.405044 7.48889C0.330468 7.41435 0.257184 7.33723 0.192523 7.25408C-0.0816435 6.89991 -0.0622449 6.4096 0.245976 6.08302C0.471862 5.84346 0.708524 5.61382 0.941737 5.38072C2.27248 4.04982 3.60365 2.71934 4.93439 1.38886C5.11415 1.2092 5.29089 1.02609 5.47453 0.849866C5.70904 0.624529 5.99527 0.504752 6.31815 0.503029C7.545 0.497858 8.77142 0.500874 9.99827 0.500874C10.275 0.500874 10.5255 0.573258 10.7251 0.776621C10.8854 0.939914 10.982 1.13509 10.9885 1.36517C10.9971 1.69994 10.9975 2.03471 10.9992 2.36949C11.001 2.69177 10.9992 3.01404 10.9992 3.33632V3.33675ZM9.16327 3.25748C9.1706 2.76243 8.77271 2.35268 8.28603 2.33545C7.76571 2.31692 7.3355 2.7271 7.33075 3.24671C7.32644 3.73788 7.72562 4.14978 8.21059 4.16916C8.72616 4.18984 9.17318 3.76718 9.16327 3.25748Z" />
                                            </svg>
                                        </span>
                                        {{ $sub_category->total_listing }}
                                    </h5>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </section>
        <!-- listing part end  -->


        <!-- Features part start  -->
        <section class="features common-class">
            <div class="container">
                <div class="row">
                    <div class="col-lg-9">
                        <div class="row align-items-end">
                            <div class="col-lg-6 col-sm-6">
                                <h2 class="taitel">{{ __('translate.Featured Listing') }}</h2>
                            </div>
                            <div class="col-lg-6 col-sm-6">
                                <a href="{{ route('listings', ['category' => 'classified', 'featured' => 'enable']) }}"
                                    class="features-view-btn">{{ __('translate.View More') }}
                                    <span>
                                        <svg width="14" height="10" viewBox="0 0 14 10" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path d="M9 9L13 5M13 5L9 1M13 5L1 5" stroke-width="1.5"
                                                stroke-linecap="round" stroke-linejoin="round" />
                                        </svg>
                                    </span>
                                </a>
                            </div>
                        </div>


                        <div class="row mt-20px g-3">
                            @foreach ($featured_listings as $index => $featured_listing)
                                <div class="  col-xxl-4 col-lg-6 col-sm-6" data-aos="fade-up">
                                    <div class="features-single-box ">
                                        <div class="features-thumb">
                                            <img src="{{ getImageOrPlaceholder($featured_listing->thumb_image, '315x230') }}"
                                                alt="img">
                                        </div>

                                        <div class="features-single-box-over">
                                            <div class="text">
                                                @if ($featured_listing->is_urgent == 'enable')
                                                    <p>{{ __('translate.Urgent') }}</p>
                                                @endif

                                                @if ($featured_listing->is_featured == 'enable')
                                                    <h6>{{ __('translate.Featured') }}</h6>
                                                @endif
                                            </div>

                                            <div class="icon">
                                                @guest('web')
                                                    <a href="javascript:;" class="before_auth_wishlist">
                                                        <span>
                                                            <svg width="24" height="21" viewBox="0 0 20 18"
                                                                fill="none" xmlns="http://www.w3.org/2000/svg">
                                                                <path
                                                                    d="M10.765 1.70229L10 2.52422L9.23495 1.70229C7.12233 -0.567428 3.69709 -0.56743 1.58447 1.70229C-0.528155 3.972 -0.528156 7.65194 1.58447 9.92165L8.4699 17.3191C9.31495 18.227 10.685 18.227 11.5301 17.3191L18.4155 9.92165C20.5282 7.65194 20.5282 3.972 18.4155 1.70229C16.3029 -0.567429 12.8777 -0.567429 10.765 1.70229Z" />
                                                            </svg>
                                                        </span>
                                                    </a>
                                                @else
                                                    <a href="{{ route('user.add-to-wishlist', $featured_listing->id) }}">
                                                        <span>
                                                            <svg width="24" height="21" viewBox="0 0 20 18"
                                                                fill="none" xmlns="http://www.w3.org/2000/svg">
                                                                <path
                                                                    d="M10.765 1.70229L10 2.52422L9.23495 1.70229C7.12233 -0.567428 3.69709 -0.56743 1.58447 1.70229C-0.528155 3.972 -0.528156 7.65194 1.58447 9.92165L8.4699 17.3191C9.31495 18.227 10.685 18.227 11.5301 17.3191L18.4155 9.92165C20.5282 7.65194 20.5282 3.972 18.4155 1.70229C16.3029 -0.567429 12.8777 -0.567429 10.765 1.70229Z" />
                                                            </svg>
                                                        </span>
                                                    </a>
                                                @endguest

                                            </div>
                                        </div>


                                        <div class="features-single-box-inner">
                                            <div class="features-single-box-inner-txt">
                                                <p>

                                                    <span>
                                                        <svg width="11" height="12" viewBox="0 0 11 12"
                                                            fill="none" xmlns="http://www.w3.org/2000/svg">
                                                            <path
                                                                d="M10.9992 3.43661C10.9992 4.03851 11.001 4.63998 10.9984 5.24188C10.9971 5.59777 10.8734 5.90712 10.6216 6.16046C10.253 6.53143 9.88231 6.89981 9.51201 7.26948C8.1817 8.59823 6.8514 9.92699 5.52152 11.2562C5.40297 11.3747 5.27925 11.485 5.11717 11.5405C4.78523 11.6543 4.47658 11.6069 4.21276 11.3772C3.99593 11.1881 3.79548 10.9796 3.59158 10.7762C2.52854 9.71458 1.46636 8.65166 0.405044 7.58874C0.330468 7.51421 0.257184 7.43708 0.192523 7.35393C-0.0816435 6.99977 -0.0622449 6.50946 0.245976 6.18287C0.471862 5.94331 0.708524 5.71367 0.941737 5.48058C2.27248 4.14967 3.60365 2.81919 4.93439 1.48872C5.11415 1.30905 5.29089 1.12594 5.47453 0.949719C5.70904 0.724383 5.99527 0.604606 6.31815 0.602882C7.545 0.597712 8.77142 0.600728 9.99827 0.600728C10.275 0.600728 10.5255 0.673111 10.7251 0.876474C10.8854 1.03977 10.982 1.23494 10.9885 1.46502C10.9971 1.79979 10.9975 2.13457 10.9992 2.46934C11.001 2.79162 10.9992 3.1139 10.9992 3.43618V3.43661ZM9.16327 3.35733C9.1706 2.86228 8.77271 2.45254 8.28603 2.4353C7.76571 2.41678 7.3355 2.82695 7.33075 3.34656C7.32644 3.83773 7.72562 4.24963 8.21059 4.26902C8.72616 4.2897 9.17318 3.86703 9.16327 3.35733Z" />
                                                        </svg>
                                                    </span>
                                                    {{ $featured_listing?->sub_category?->name }}
                                                </p>

                                                <span>
                                                    {{ currency($featured_listing->regular_price) }}
                                                </span>
                                            </div>


                                            <a href="{{ route('listing', $featured_listing->slug) }}">
                                                <h3>{{ html_decode($featured_listing->title) }}</h3>
                                            </a>


                                            <div class="features-single-box-contact">
                                                <div class="location">
                                                    <p><a href="javascript:;">
                                                            <span>
                                                                <svg width="12" height="14" viewBox="0 0 11 13"
                                                                    fill="none" xmlns="http://www.w3.org/2000/svg">
                                                                    <path fill-rule="evenodd" clip-rule="evenodd"
                                                                        d="M5.5 13C7.5625 13 11 8.96876 11 5.77778C11 2.5868 8.53757 0 5.5 0C2.46243 0 0 2.5868 0 5.77778C0 8.96876 3.4375 13 5.5 13ZM5.5 7.7999C6.51252 7.7999 7.33333 6.92686 7.33333 5.8499C7.33333 4.77295 6.51252 3.8999 5.5 3.8999C4.48748 3.8999 3.66667 4.77295 3.66667 5.8499C3.66667 6.92686 4.48748 7.7999 5.5 7.7999Z" />
                                                                </svg>
                                                            </span>
                                                            {{ html_decode($featured_listing->address) }}
                                                        </a>
                                                    </p>
                                                </div>

                                                <div class="contact">
                                                    <p>
                                                        <a
                                                            href="{{ route('agent', $featured_listing?->agent?->username) }}">
                                                            <span>
                                                                <svg width="13" height="16" viewBox="0 0 13 16"
                                                                    fill="none" xmlns="http://www.w3.org/2000/svg">
                                                                    <path fill-rule="evenodd" clip-rule="evenodd"
                                                                        d="M6.22222 7.11111C8.1859 7.11111 9.77778 5.51923 9.77778 3.55556C9.77778 1.59188 8.1859 0 6.22222 0C4.25854 0 2.66667 1.59188 2.66667 3.55556C2.66667 5.51923 4.25854 7.11111 6.22222 7.11111ZM6.22222 16C9.65866 16 12.4444 14.4081 12.4444 12.4444C12.4444 10.4808 9.65866 8.88889 6.22222 8.88889C2.78578 8.88889 0 10.4808 0 12.4444C0 14.4081 2.78578 16 6.22222 16Z" />
                                                                </svg>
                                                            </span>
                                                            {{ $featured_listing?->agent?->name }}
                                                        </a>
                                                    </p>
                                                    <p>
                                                        <a href="javascript:;">
                                                            <span>
                                                                <svg width="15" height="17" viewBox="0 0 15 17"
                                                                    fill="none" xmlns="http://www.w3.org/2000/svg">
                                                                    <path fill-rule="evenodd" clip-rule="evenodd"
                                                                        d="M4.64157 0.605422C4.64157 0.271056 4.37051 0 4.03614 0C3.70178 0 3.43072 0.271057 3.43072 0.605422V1.85647C1.54458 2.12521 0.0823859 3.70969 0.00336393 5.65071H14.5268C14.4477 3.70969 12.9855 2.12521 11.0994 1.85647V0.605422C11.0994 0.271057 10.8283 0 10.494 0C10.1596 0 9.88855 0.271057 9.88855 0.605422V1.81627H4.64157L4.64157 0.605422ZM1.54674e-05 6.86155H14.5301V12.75C14.5301 14.9591 12.7393 16.75 10.5301 16.75H4C1.79086 16.75 0 14.9591 0 12.75V6.86155H1.54674e-05ZM7.26508 11.9066C7.7109 11.9066 8.0723 11.5452 8.0723 11.0994C8.0723 10.6536 7.7109 10.2922 7.26508 10.2922C6.81926 10.2922 6.45785 10.6536 6.45785 11.0994C6.45785 11.5452 6.81926 11.9066 7.26508 11.9066ZM11.3012 11.0994C11.3012 11.5452 10.9398 11.9066 10.494 11.9066C10.0482 11.9066 9.68676 11.5452 9.68676 11.0994C9.68676 10.6536 10.0482 10.2922 10.494 10.2922C10.9398 10.2922 11.3012 10.6536 11.3012 11.0994ZM4.03616 11.9066C4.48198 11.9066 4.84339 11.5452 4.84339 11.0994C4.84339 10.6536 4.48198 10.2922 4.03616 10.2922C3.59034 10.2922 3.22893 10.6536 3.22893 11.0994C3.22893 11.5452 3.59034 11.9066 4.03616 11.9066Z" />
                                                                </svg>
                                                            </span>
                                                            {{ $featured_listing->created_at->diffForHumans() }}
                                                        </a>
                                                    </p>
                                                </div>
                                            </div>

                                        </div>

                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>

                    <div class="col-lg-3">
                        <div class="features-ads">
                            @if ($home1_featured1_ads->status == 'enable')
                                <div class="features-ads-one">
                                    <a target="_blank" href="{{ $home1_featured1_ads->link }}">
                                        <img src="{{ asset($home1_featured1_ads->image) }}" alt="img">
                                    </a>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>

                @if ($home1_featured3_ads->status == 'enable')
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="ads-banner">
                                <a target="_blank" href="{{ $home1_featured3_ads->link }}">
                                    <img src="{{ asset($home1_featured3_ads->image) }}" alt="img">
                                </a>
                            </div>
                        </div>
                    </div>
                @endif
            </div>
        </section>
        <!-- Features part end  -->



        <!-- Locations part start  -->
        <section class="locations common-class">
            <div class="container">
                <div class="row align-items-end">
                    <div class="col-lg-6 col-sm-6">
                        <h2 class="taitel">{{ __('translate.Browse By Cities') }}</h2>
                    </div>
                    <div class="col-lg-6  col-sm-6">
                        <a href="{{ route('listings', ['category' => 'classified']) }}"
                            class="features-view-btn">{{ __('translate.View More') }}
                            <span>
                                <svg width="14" height="10" viewBox="0 0 14 10" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path d="M9 9L13 5M13 5L9 1M13 5L1 5" stroke-width="1.5" stroke-linecap="round"
                                        stroke-linejoin="round" />
                                </svg>
                            </span>
                        </a>
                    </div>
                </div>

                <div class="row g-3 mt-20px">
                    @foreach ($cities->take(6) as $city)
                        <div class=" col-xxl-2 col-lg-4 col-sm-6 " data-aos="fade-right" data-aos-delay="50">
                            <div class="locations-item">
                                <div class="locations-item-thumb">
                                    <img src="{{ getImageOrPlaceholder($city->image, '195x210') }}" alt="img">
                                </div>

                                <div class="locations-item-text">
                                    <a
                                        href="{{ route('listings', ['location' => $city->id, 'country' => $city->country_id, 'category' => 'classified']) }}">
                                        <h3>{{ $city->name }}</h3>
                                    </a>

                                    <h5>{{ $city->total_classified_listing }}+ {{ __('translate.Listing') }}</h5>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </section>

        <!-- Locations part end  -->

        <!-- _explore-new part start  -->
        <section class="explore-new common-class"
            style=" background-image: url({{ asset($homepage->home2_explore_image) }}) ;">
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-lg-7">
                        <span class="explore-txt">{{ $homepage->home2_explore_title }}</span>

                        <h2 class="explore-taitel">
                            {{ $homepage->home2_explore_des }}
                        </h2>

                        <a class="main-btn " href="{{ route('contact-us') }}">
                            <div class="btn_m">
                                <div class="btn_c">
                                    <div class="btn_t1"> {{ __('translate.Contact Us') }}</div>
                                    <div class="btn_t2"> {{ __('translate.Contact Us') }}</div>
                                </div>
                            </div>
                        </a>
                    </div>
                </div>
            </div>
        </section>
        <!-- _explore-new part end  -->


        <!-- new-Listing part start  -->
        <section class="new-listing   ">
            <div class="container">
                <div class="row mb-20px align-items-end">
                    <div class="col-lg-6 col-sm-6">
                        <h2 class="taitel">{{ __('translate.New Listing') }}</h2>
                    </div>

                    <div class="col-lg-6 col-sm-6">
                        <a href="{{ route('listings', ['category' => 'classified']) }}"
                            class="features-view-btn">{{ __('translate.View More') }}
                            <span>
                                <svg width="14" height="10" viewBox="0 0 14 10" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path d="M9 9L13 5M13 5L9 1M13 5L1 5" stroke-width="1.5" stroke-linecap="round"
                                        stroke-linejoin="round"></path>
                                </svg>
                            </span>
                        </a>
                    </div>
                </div>

                <div class="row  g-3">

                    @foreach ($latest_listings as $latest_listing)
                        <div class=" col-xl-4 col-lg-6 col-sm-6" data-aos="fade-up" data-aos-delay="50">
                            <div class="new-listing-item">
                                <div class="new-listing-thumb">
                                    <img src="{{ getImageOrPlaceholder($latest_listing->thumb_image, '155x135') }}"
                                        alt="img">
                                    <div class="new-listing-item-overlay">
                                        @if ($latest_listing->is_urgent == 'enable')
                                            <h6 class="txt">{{ __('translate.Urgent') }}</h6>
                                        @endif
                                        <div class="icon">
                                            @guest('web')
                                                <a href="javascript:;" class="before_auth_wishlist">
                                                    <span>
                                                        <svg width="24" height="21" viewBox="0 0 16 14"
                                                            fill="none" xmlns="http://www.w3.org/2000/svg">
                                                            <path
                                                                d="M8.71459 1.324L8.11105 1.96329L7.50752 1.324C5.84089 -0.441333 3.13876 -0.441334 1.47214 1.324C-0.194488 3.08933 -0.194488 5.95151 1.47214 7.71684L6.90398 13.4704C7.57063 14.1765 8.65148 14.1765 9.31813 13.4704L14.75 7.71684C16.4166 5.95151 16.4166 3.08934 14.75 1.324C13.0833 -0.441333 10.3812 -0.441334 8.71459 1.324Z" />
                                                        </svg>
                                                    </span>
                                                </a>
                                            @else
                                                <a href="{{ route('user.add-to-wishlist', $latest_listing->id) }}">
                                                    <span>
                                                        <svg width="24" height="21" viewBox="0 0 16 14"
                                                            fill="none" xmlns="http://www.w3.org/2000/svg">
                                                            <path
                                                                d="M8.71459 1.324L8.11105 1.96329L7.50752 1.324C5.84089 -0.441333 3.13876 -0.441334 1.47214 1.324C-0.194488 3.08933 -0.194488 5.95151 1.47214 7.71684L6.90398 13.4704C7.57063 14.1765 8.65148 14.1765 9.31813 13.4704L14.75 7.71684C16.4166 5.95151 16.4166 3.08934 14.75 1.324C13.0833 -0.441333 10.3812 -0.441334 8.71459 1.324Z" />
                                                        </svg>
                                                    </span>
                                                </a>
                                            @endguest
                                        </div>
                                    </div>
                                </div>

                                <div class="new-listing-inner">
                                    <div class="new-listing-inner-txt">
                                        <p>
                                            <a
                                                href="{{ route('listings', ['sub_category_id' => $latest_listing->sub_category_id, 'category' => 'classified']) }}">
                                                <span>
                                                    <svg width="11" height="12" viewBox="0 0 11 12"
                                                        fill="none" xmlns="http://www.w3.org/2000/svg">
                                                        <path
                                                            d="M10.9992 3.43667C10.9992 4.03857 11.001 4.64004 10.9984 5.24195C10.9971 5.59783 10.8734 5.90718 10.6216 6.16053C10.253 6.53149 9.88231 6.89987 9.51201 7.26954C8.1817 8.5983 6.8514 9.92705 5.52152 11.2562C5.40297 11.3747 5.27925 11.485 5.11717 11.5406C4.78523 11.6543 4.47658 11.6069 4.21276 11.3773C3.99593 11.1882 3.79548 10.9796 3.59158 10.7763C2.52854 9.71464 1.46636 8.65172 0.405044 7.58881C0.330468 7.51427 0.257184 7.43714 0.192523 7.35399C-0.0816435 6.99983 -0.0622449 6.50952 0.245976 6.18293C0.471862 5.94338 0.708524 5.71373 0.941737 5.48064C2.27248 4.14973 3.60365 2.81925 4.93439 1.48878C5.11415 1.30911 5.29089 1.126 5.47453 0.949781C5.70904 0.724444 5.99527 0.604667 6.31815 0.602943C7.545 0.597773 8.77142 0.600789 9.99827 0.600789C10.275 0.600789 10.5255 0.673172 10.7251 0.876535C10.8854 1.03983 10.982 1.23501 10.9885 1.46508C10.9971 1.79985 10.9975 2.13463 10.9992 2.4694C11.001 2.79168 10.9992 3.11396 10.9992 3.43624V3.43667ZM9.16327 3.35739C9.1706 2.86234 8.77271 2.4526 8.28603 2.43536C7.76571 2.41684 7.3355 2.82701 7.33075 3.34662C7.32644 3.83779 7.72562 4.24969 8.21059 4.26908C8.72616 4.28976 9.17318 3.86709 9.16327 3.35739Z" />
                                                    </svg>
                                                </span>
                                                {{ $latest_listing?->sub_category?->name }}
                                            </a>
                                        </p>
                                    </div>

                                    <a href="{{ route('listing', $latest_listing->slug) }}">
                                        <h4>{{ html_decode($latest_listing->title) }}</h4>
                                    </a>

                                    <div class="contact-box">

                                        <span>{{ currency($latest_listing->regular_price) }}</span>
                                        <a href="javascript:;">
                                            <span>
                                                <svg width="15" height="17" viewBox="0 0 15 17" fill="none"
                                                    xmlns="http://www.w3.org/2000/svg">
                                                    <path fill-rule="evenodd" clip-rule="evenodd"
                                                        d="M4.87643 0.730422C4.87643 0.396056 4.60537 0.125 4.27101 0.125C3.93664 0.125 3.66559 0.396057 3.66559 0.730422V1.98147C1.77944 2.25021 0.317249 3.83469 0.238227 5.77571H14.7616C14.6826 3.83469 13.2204 2.25021 11.3343 1.98147V0.730422C11.3343 0.396057 11.0632 0.125 10.7288 0.125C10.3945 0.125 10.1234 0.396057 10.1234 0.730422V1.94127H4.87643L4.87643 0.730422ZM0.234879 6.98655H14.765V12.875C14.765 15.0841 12.9741 16.875 10.765 16.875H4.23486C2.02572 16.875 0.234863 15.0841 0.234863 12.875V6.98655H0.234879ZM7.49994 12.0316C7.94576 12.0316 8.30717 11.6702 8.30717 11.2244C8.30717 10.7786 7.94576 10.4172 7.49994 10.4172C7.05412 10.4172 6.69271 10.7786 6.69271 11.2244C6.69271 11.6702 7.05412 12.0316 7.49994 12.0316ZM11.5361 11.2244C11.5361 11.6702 11.1747 12.0316 10.7289 12.0316C10.283 12.0316 9.92163 11.6702 9.92163 11.2244C9.92163 10.7786 10.283 10.4172 10.7289 10.4172C11.1747 10.4172 11.5361 10.7786 11.5361 11.2244ZM4.27102 12.0316C4.71684 12.0316 5.07825 11.6702 5.07825 11.2244C5.07825 10.7786 4.71684 10.4172 4.27102 10.4172C3.8252 10.4172 3.46379 10.7786 3.46379 11.2244C3.46379 11.6702 3.8252 12.0316 4.27102 12.0316Z" />
                                                </svg>
                                            </span>
                                            {{ $latest_listing->created_at->diffForHumans() }}
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </section>
        <!-- new-Listing part end  -->
    </main>
@endsection
