@extends('layout')
@section('title')
    <title>{{ $seo_setting->seo_title }}</title>
    <meta name="title" content="{{ $seo_setting->seo_title }}">
    <meta name="description" content="{!! strip_tags(clean($seo_setting->seo_description)) !!}">
@endsection

@section('body-content')
    <main>
        <!-- Hero/Slider Section Start -->
        <section class="ecommerce_banner">
            <div class="ecommerce_container p-0">
                <div class="row ">
                    <div class="col-lg-12">
                        <div class="ecommerce_banner_slider_main">
                            <div class="ecommerce_banner_slider">
                                @foreach ($sliders as $slider)
                                    <!-- slider 1  -->
                                    <div class="ecommerce_banner_slider_item"
                                        style="background-image: url({{ $slider->image }});">

                                        <div class="container">
                                            <div class="row">
                                                <div class="col-lg-7">
                                                    <div class="ecommerce_banner_slider_text_main">
                                                        <div class="ecommerce_banner_slider_text">
                                                            <h4>{{ __($slider->translate->small_text) }}</h4>
                                                            <h1>
                                                                {{ __($slider->translate->title) }}
                                                                <span>
                                                                    {{ __('translate.New Collection') }}
                                                                </span>
                                                            </h1>

                                                            <a class="main-btn main-btn-black "
                                                                href="{{ $slider->url ?? '#' }}">
                                                                <div class="btn_m">
                                                                    <div class="btn_c">
                                                                        <div class="btn_t1">
                                                                            {{ __('translate.Shop Now') }}

                                                                        </div>
                                                                        <div class="btn_t2">
                                                                            {{ __('translate.Shop Now') }}

                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </a>

                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-lg-5">
                                                    <div class="ecommerce_banner_thumb_main">
                                                        <div class="ecommerce_banner_thumb">

                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                @endforeach

                            </div>

                        </div>
                    </div>
                </div>


                <div class="row">
                    <div class="col-lg-12">
                        <div class="ecommerce_arrow_main">
                            <span class="ecommerce_arrow_left">
                                <svg width="16" height="13" viewBox="0 0 16 13" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M6.3335 11.334L1.3335 6.33398M1.3335 6.33398L6.3335 1.33398M1.3335 6.33398L14.6668 6.33399"
                                        stroke="currentColor" stroke-width="1.5" stroke-linecap="round"
                                        stroke-linejoin="round" />
                                </svg>
                            </span>
                            <span class="ecommerce_arrow_right">
                                <svg width="16" height="13" viewBox="0 0 16 13" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M9.6665 11.334L14.6665 6.33398M14.6665 6.33398L9.6665 1.33398M14.6665 6.33398L1.33317 6.33399"
                                        stroke="currentColor" stroke-width="1.5" stroke-linecap="round"
                                        stroke-linejoin="round" />
                                </svg>

                            </span>
                        </div>
                    </div>
                </div>




            </div>
        </section>
        <!-- Hero/Slider Section Start -->


        <!-- Hero Section End -->

        <!-- fashion part start  -->
        <section class="fashion">
            <div class="ecommerce_container p-0">
                <div class="row">
                    @foreach ($banners as $banner)
                        @if ($banner->position == 'left')
                            <!-- Left Banner -->
                            <div class="col-lg-7 left" data-aos="fade-up" data-aos-delay="200">
                                <div class="fashion_main">
                                    <div class="fashion_main_df">
                                        <div class="fashion_main_text">
                                            <h4>{{ $banner->translate->sub_title ?? '' }}</h4>
                                            <h2>{{ $banner->translate->title ?? '' }}</h2>
                                            <p>
                                                {{ $banner->translate->description ?? '' }}
                                            </p>
                                            <a href="{{ url($banner->button_url) }}" class="main-btn main-btn-black">
                                                <div class="btn_m">
                                                    <div class="btn_c">
                                                        <div class="btn_t1">
                                                            {{ $banner->translate->button_text ?? 'Shop Now' }}
                                                        </div>
                                                        <div class="btn_t2">
                                                            {{ $banner->translate->button_text ?? 'Shop Now' }}
                                                        </div>
                                                    </div>
                                                </div>
                                            </a>
                                        </div>
                                        <div class="fashion_main_thumb">
                                            <img src="{{ asset($banner->image) }}" alt="thumb">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @elseif($banner->position == 'right')
                            <!-- Right Banner -->
                            <div class="col-lg-5 mt-md-4 mt-lg-0 right" data-aos="fade-up" data-aos-delay="400">
                                <div class="fashion_main two">
                                    <div class="fashion_main_df">
                                        <div class="fashion_main_text">
                                            <h4>{{ $banner->translate->sub_title ?? 'Default Subtitle' }}</h4>
                                            <h2>{{ $banner->translate->title ?? 'Default Title' }}</h2>
                                            <a href="{{ url($banner->button_url) }}" class="main-btn main-btn-black ">
                                                <div class="btn_m">
                                                    <div class="btn_c">
                                                        <div class="btn_t1">
                                                            {{ $banner->translate->button_text ?? 'Shop Now' }}
                                                        </div>
                                                        <div class="btn_t2">
                                                            {{ $banner->translate->button_text ?? 'Shop Now' }}
                                                        </div>
                                                    </div>
                                                </div>
                                            </a>
                                        </div>
                                        <div class="fashion_main_thumb">
                                            <img src="{{ asset($banner->image) }}" alt="thumb">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endif
                    @endforeach
                </div>
            </div>

        </section>
        <!-- fashion part end  -->

        <!-- category part start  -->
        @include('frontend.theme_four.categories')
        <!-- category part end  -->

        <!-- trending product part start  -->
        @include('frontend.theme_four.trending_products')
        <!-- trending  product part end  -->

        <!-- Latest Products Start -->
        @include('frontend.theme_four.latest_products')
        <!-- Latest Products End -->

        <!-- sale ads part start -->
        <div class="fashion-sale">
            <div class="container">
                <div class="row">
                    <div class="fashion-sale-thumb" data-aos="fade-up" data-aos-delay="200">
                        <img src="{{ asset($homepage->home4_bg_image) }}" alt="thumb">
                        <div class="fashion-sale-btn">
                            <a href="{{ $homepage->home4_explore_image }}" class="main-btn">
                                <div class="btn_m">
                                    <div class="btn_c">
                                        <div class="btn_t1">
                                            {{ __('translate.Shop Now') }}

                                        </div>
                                        <div class="btn_t2">
                                            {{ __('translate.Shop Now') }}

                                        </div>
                                    </div>
                                </div>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- sale ads part end -->
    </main>
@endsection
@push('style_section')
    <style>
        .ecommerce_banner_thumb img {
            max-width: 100%;
            height: auto;
        }
    </style>
@endpush
