<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (Schema::hasTable('wishlists') && !Schema::hasColumn('wishlists', 'product_id')) {
            Schema::table('wishlists', function (Blueprint $table) {
                $table->integer('product_id')->nullable()->after('listing_id');
                $table->integer('listing_id')->nullable()->change();
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        if (Schema::hasTable('wishlists') && Schema::hasColumn('wishlists', 'product_id')) {
            Schema::table('wishlists', function (Blueprint $table) {
                $table->dropColumn('product_id');
            });
        }
    }
};
