<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{

    public function up(): void
    {
        Schema::create('support_tickets', function (Blueprint $table) {
            $table->id();
            $table->integer('user_id');
            $table->text('subject');
            $table->string('ticket_id');
            $table->string('priority')->nullable();
            $table->text('message')->nullable();
            $table->string('status')->default('pending')->comment('pending, in_progress, closed');
            $table->timestamps();
        });
    }


    public function down(): void
    {
        Schema::dropIfExists('support_tickets');
    }
};
