@extends('admin.master_layout')
@section('title')
    <title>{{ isset($banner) ? __('translate.Edit Banner') : __('translate.Banner Information') }}</title>
@endsection

@section('body-header')
    <h3 class="crancy-header__title m-0">{{ isset($banner) ? __('translate.Edit Banner') : __('translate.Add New Banner') }}</h3>
    <p class="crancy-header__text">{{ __('translate.Manage Banner') }} >> {{ isset($banner) ? __('translate.Edit Banner') : __('translate.Add New Banner') }}</p>
@endsection

@section('body-content')

    <form action="{{ route('admin.banner.store', isset($banner) ? $banner->id : null) }}" method="POST" enctype="multipart/form-data">
        @csrf

        <input type="hidden" name="lang_code" value="{{ $listing_translate->lang_code ?? '' }}">
        <input type="hidden" name="translate_id" value="{{ $listing_translate->id ?? '' }}">

        <!-- crancy Dashboard -->
        <section class="crancy-adashboard crancy-show">
            <div class="container container__bscreen">
                <div class="row">
                    <div class="col-12">
                        <div class="crancy-body">
                            <!-- Dashboard Inner -->
                            <div class="crancy-dsinner">
                                <div class="row">
                                    <div class="col-12 mg-top-30">
                                        <!-- Product Card -->
                                        <div class="crancy-product-card">
                                            <div class="create_new_btn_inline_box">
                                                <h4 class="crancy-product-card__title">{{ __('translate.Basic Information') }}</h4>
                                            </div>

                                            <div class="row">

                                                <div class="col-12 mg-top-form-20">
                                                    <div class="row">
                                                        <div class="col-md-3">
                                                            <div class="crancy__item-form--group w-100 h-100">
                                                                <label
                                                                    class="crancy__item-label">{{ __('translate.Banner Image') }}
                                                                    * </label>
                                                                <div
                                                                    class="crancy-product-card__upload crancy-product-card__upload--border">
                                                                    <input type="file" class="btn-check"
                                                                           name="image" id="input-img1"
                                                                           autocomplete="off"
                                                                           onchange="previewImage(event)">
                                                                    <label class="crancy-image-video-upload__label"
                                                                           for="input-img1">
                                                                        <img id="view_img"
                                                                             src="{{ isset($banner) && $banner->image ? asset($banner->image) : asset($setting->placeholder_image) }}">
                                                                        <h4 class="crancy-image-video-upload__title">{{ __('translate.Click here to') }}
                                                                            <span
                                                                                class="crancy-primary-color">{{ __('translate.Choose File') }}</span> {{ __('translate.and upload') }}
                                                                        </h4>
                                                                    </label>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-9">
                                                            <div class="crancy__item-form--group mg-top-form-20">
                                                                <label class="crancy__item-label">{{ __('translate.Small Title') }}
                                                                    * </label>
                                                                <input class="crancy__item-input" type="text"
                                                                       name="sub_title" id="title"
                                                                       value="{{ old('sub_title', $banner->translate->sub_title ?? '') }}">
                                                            </div>


                                                            <div class="crancy__item-form--group mg-top-form-20">
                                                                <label class="crancy__item-label">{{ __('translate.Title') }}
                                                                    * </label>
                                                                <input class="crancy__item-input" type="text"
                                                                       name="title" id="title"
                                                                       value="{{ old('title', $banner->translate->title ?? '') }}">
                                                            </div>


                                                            <div class="crancy__item-form--group mg-top-form-20">
                                                                <label class="crancy__item-label">{{ __('translate.Description') }} *</label>
                                                                <input class="crancy__item-input" type="text"
                                                                       name="description" id="description"
                                                                       value="{{ old('description', $banner->translate->description ?? '') }}">
                                                            </div>

                                                            <div class="crancy__item-form--group mg-top-form-20">
                                                                <label class="crancy__item-label">{{ __('translate.Button Text') }}</label>
                                                                <input class="crancy__item-input" type="text"
                                                                       name="button_text" id="button_text"
                                                                       value="{{ old('button_text', @$banner->translate->button_text ?? '') }}">
                                                            </div>


                                                            <div class="crancy__item-form--group mg-top-form-20">
                                                                <label class="crancy__item-label">{{ __('translate.Button URL') }}</label>
                                                                <input class="crancy__item-input" type="text"
                                                                       name="button_url" id="url"
                                                                       value="{{ old('button_url', $banner->button_url ?? '') }}">
                                                            </div>
                                                            <div class="crancy__item-form--group mg-top-form-20">
                                                                <label class="crancy__item-label">{{ __('translate.Select Position') }}</label>
                                                                <select name="position" id="position">
                                                                    <option value="left" {{ isset($banner) && $banner->position == 'left' ? 'selected' : '' }}>{{ __('translate.Left') }}</option>
                                                                    <option value="right" {{ isset($banner) && $banner->position == 'right' ? 'selected' : '' }}>{{ __('translate.Right') }}</option>
                                                                </select>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <button class="crancy-btn mg-top-25" type="submit">
                                            {{ isset($banner) ? __('translate.Update Data') : __('translate.Save Data') }}
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </form>
@endsection


@push('style_section')
    <style>
        .offer-price{
            width: auto !important;
        }
    </style>
@endpush

@push('js_section')
    <script>
        function previewImage(event) {
            var reader = new FileReader();
            reader.onload = function () {
                var output = document.getElementById('view_img');
                output.src = reader.result;
            }
            reader.readAsDataURL(event.target.files[0]);
        };
    </script>
@endpush

