<?php

namespace Modules\Page\Http\Controllers;

use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\Page\Entities\AboutUs;
use Modules\Page\Entities\AboutUsTranslation;
use Modules\Page\Http\Requests\AboutRequest;
use Image, File, Str;

class AboutUsController extends Controller
{

    public function __construct()
    {
        $this->middleware('auth:admin');
    }

    public function index(Request $request)
    {
        $about_us = AboutUs::first();
        $translate = AboutUsTranslation::where('lang_code', $request->lang_code)->first();

        return view('page::about_us', compact('about_us','translate'));
    }


    public function update(AboutRequest $request)
    {
        $about_us = AboutUs::first();
        if($request->lang_code == admin_lang()){
            $about_us->experience_year = $request->experience_year;
            $about_us->save();
        }

        if($request->about_image){
            $old_image = $about_us->about_image;
            $image_name = 'about-us'.date('-Y-m-d-h-i-s-').rand(999,9999).'.webp';
            $image_name ='uploads/website-images/'.$image_name;
            Image::make($request->about_image)
                ->encode('webp', 80)
                ->save(public_path().'/'.$image_name);
            $about_us->about_image = $image_name;
            $about_us->save();

            if($old_image){
                if(File::exists(public_path().'/'.$old_image))unlink(public_path().'/'.$old_image);
            }
        }

        if($request->ceo_image){
            $old_image = $about_us->ceo_image;
            $image_name = 'ceo-image'.date('-Y-m-d-h-i-s-').rand(999,9999).'.webp';
            $image_name ='uploads/website-images/'.$image_name;
            Image::make($request->ceo_image)
                ->encode('webp', 80)
                ->save(public_path().'/'.$image_name);
            $about_us->ceo_image = $image_name;
            $about_us->save();

            if($old_image){
                if(File::exists(public_path().'/'.$old_image))unlink(public_path().'/'.$old_image);
            }
        }

        if($request->signature_image){
            $old_image = $about_us->signature_image;
            $image_name = 'reveiw-icon'.date('-Y-m-d-h-i-s-').rand(999,9999).'.webp';
            $image_name ='uploads/website-images/'.$image_name;
            Image::make($request->signature_image)
                ->encode('webp', 80)
                ->save(public_path().'/'.$image_name);
            $about_us->signature_image = $image_name;
            $about_us->save();

            if($old_image){
                if(File::exists(public_path().'/'.$old_image))unlink(public_path().'/'.$old_image);
            }
        }

        $translate = AboutUsTranslation::where('lang_code', $request->lang_code)->first();
        $translate->header = $request->header;
        $translate->title = $request->title;
        $translate->description = $request->description;
        $translate->ceo_name = $request->ceo_name;
        $translate->ceo_designation = $request->ceo_designation;
        $translate->save();

        $notification= trans('translate.Updated Successfully');
        $notification=array('messege'=>$notification,'alert-type'=>'success');
        return redirect()->back()->with($notification);

    }

    public function assign_language($lang_code){
        $about_translates = AboutUsTranslation::where('lang_code', admin_lang())->get();
        foreach($about_translates as $about_translate){
            $translate = new AboutUsTranslation();
            $translate->about_us_id = $about_translate->about_us_id;
            $translate->lang_code = $lang_code;
            $translate->header = $about_translate->header;
            $translate->title = $about_translate->title;
            $translate->description = $about_translate->description;
            $translate->ceo_name = $about_translate->ceo_name;
            $translate->ceo_designation = $about_translate->ceo_designation;
            $translate->save();
        }
    }

}
