@extends('layout')
@section('title')
    <title>{{ __('translate.Listing Gallery') }}</title>
@endsection
@section('body-content')

<main>
    <!-- banner-part-start  -->

    <div class="inner-bg common-class"
    style="    background-image:  url({{ asset($breadcrumb) }});">
        <div class="container">
            <div class="row">
                <div class="col-lg-3">

                    <div class="inner-bg-txt">
                        <h1>{{ __('translate.Listing Gallery') }}</h1>

                        <ul>
                            <li><a href={{ route('home') }}">{{ __('translate.Home') }}</a></li>
                            <li><span>
                                    <svg width="6" height="12" viewBox="0 0 6 12" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <path
                                            d="M0.633816 2.7705e-08C0.446997 0.0532405 0.28353 0.143084 0.158011 0.319443C-0.0492418 0.618921 -0.0550799 1.0515 0.155092 1.35098C0.195958 1.40755 0.239744 1.46411 0.286449 1.51735C1.56499 2.97481 2.84645 4.4356 4.125 5.89306C4.15419 5.92633 4.18922 5.95295 4.24176 6.03281C4.20673 6.0561 4.16295 6.06941 4.13375 6.10269C2.84062 7.57346 1.5504 9.04755 0.257258 10.5183C0.0295721 10.7779 -0.0579994 11.0773 0.0412483 11.4367C0.187201 11.9591 0.776848 12.1721 1.16216 11.8427C1.20595 11.8061 1.24682 11.7628 1.28768 11.7196C2.7764 10.0225 4.26511 8.32881 5.75091 6.63177C6.02238 6.32231 6.07492 5.92966 5.89394 5.57361C5.85015 5.4871 5.78594 5.41056 5.72464 5.34069C4.27971 3.69356 2.83478 2.04976 1.39277 0.399304C1.23222 0.216289 1.06875 0.0532405 0.838149 3.66367e-08C0.771011 3.3702e-08 0.703873 3.07673e-08 0.633816 2.7705e-08Z" />
                                    </svg>

                                </span></li>
                            <li><a href="javascript:;" class="active">{{ __('translate.Listing Gallery') }}</a></li>
                        </ul>
                    </div>

                </div>
            </div>
        </div>
    </div>
    <!-- banner-part-end -->

    <!-- dashboard-part-start -->
    <section class="dashboard footer-top-pad">
        <div class="container">
            <div class="row">
                @include('profile.sidebar')


                <div class="col-lg-9">
                    <div class="row gy-5">
                        <!-- Manage Listing -->
                        <div class="col-lg-12">
                            <div class="car-images">
                                <h3 class="car-images-taitel">{{ __('translate.Listing') }} : {{ html_decode($listing->translate->title) }}</h3>
                                <div class="car-images-inner car-images-inner-car">

                                    <form id="dropzoneForm" method="post" action="{{ route('user.upload-gallery', $listing->id) }}"  enctype="multipart/form-data"  class="dropzone">
                                        @csrf

                                    </form>
                                    <div class="text-center car-images-manage-car-item-btn">
                                        <button id="submit-all" type="submit" class="main-btn">{{ __('translate.Upload Images') }}</button>
                                    </div>

                                </div>
                            </div>
                        </div>


                        <!-- Gallery Images  -->
                        @if ($galleries->count() > 0)
                            <div class="col-lg-12">
                                <div class="car-images">
                                    <h3 class="car-images-taitel">{{ __('translate.Gallery Images') }}</h3>
                                    <div class="car-images-inner">
                                        <div class="gallery-img-item">

                                            @foreach ($galleries as $gallery)
                                                <div class="gallery-img-item-thumb">
                                                    <img src="{{ asset($gallery->image) }}" alt="img">
                                                    <button class="car-delet-btn" onclick="deleteGallery({{ $gallery->id }})">
                                                        <svg width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                            <rect x="0.601562" width="31.3984" height="32" rx="15.6992" fill="#FF603D"/>
                                                            <path d="M18.734 13.375C18.512 13.375 18.332 13.5584 18.332 13.7846V21.5266C18.332 21.7527 18.512 21.9362 18.734 21.9362C18.956 21.9362 19.1359 21.7527 19.1359 21.5266V13.7846C19.1359 13.5584 18.956 13.375 18.734 13.375Z" fill="white"/>
                                                            <path d="M13.9957 13.375C13.7737 13.375 13.5938 13.5584 13.5938 13.7846V21.5266C13.5938 21.7527 13.7737 21.9362 13.9957 21.9362C14.2177 21.9362 14.3976 21.7527 14.3976 21.5266V13.7846C14.3976 13.5584 14.2177 13.375 13.9957 13.375Z" fill="white"/>
                                                            <path d="M10.5361 12.2463V22.3387C10.5361 22.9352 10.7507 23.4954 11.1256 23.8974C11.4988 24.3004 12.0182 24.5292 12.5617 24.5302H20.1663C20.71 24.5292 21.2294 24.3004 21.6024 23.8974C21.9773 23.4954 22.1919 22.9352 22.1919 22.3387V12.2463C22.9372 12.0447 23.4202 11.3109 23.3205 10.5315C23.2206 9.75226 22.5692 9.16934 21.798 9.16918H19.7402V8.65714C19.7425 8.22655 19.5755 7.81309 19.2764 7.50891C18.9773 7.20489 18.571 7.0356 18.1485 7.03912H14.5795C14.157 7.0356 13.7507 7.20489 13.4516 7.50891C13.1525 7.81309 12.9855 8.22655 12.9878 8.65714V9.16918H10.93C10.1588 9.16934 9.50739 9.75226 9.40753 10.5315C9.30784 11.3109 9.79078 12.0447 10.5361 12.2463ZM20.1663 23.7109H12.5617C11.8745 23.7109 11.3399 23.1093 11.3399 22.3387V12.2823H21.3881V22.3387C21.3881 23.1093 20.8535 23.7109 20.1663 23.7109ZM13.7917 8.65714C13.789 8.44385 13.8713 8.23856 14.0198 8.08799C14.1682 7.93742 14.3701 7.85469 14.5795 7.85837H18.1485C18.3579 7.85469 18.5598 7.93742 18.7082 8.08799C18.8567 8.2384 18.939 8.44385 18.9363 8.65714V9.16918H13.7917V8.65714ZM10.93 9.98843H21.798C22.1976 9.98843 22.5215 10.3185 22.5215 10.7258C22.5215 11.133 22.1976 11.4631 21.798 11.4631H10.93C10.5304 11.4631 10.2065 11.133 10.2065 10.7258C10.2065 10.3185 10.5304 9.98843 10.93 9.98843Z" fill="white"/>
                                                            <path d="M16.3668 13.377C16.1448 13.377 15.9648 13.5603 15.9648 13.7866V21.5285C15.9648 21.7546 16.1448 21.9382 16.3668 21.9382C16.5888 21.9382 16.7687 21.7546 16.7687 21.5285V13.7866C16.7687 13.5603 16.5888 13.377 16.3668 13.377Z" fill="white"/>
                                                            </svg>

                                                    </button>
                                                </div>

                                                <form action="{{ route('user.delete-gallery', $gallery->id) }}" id="remove_gallery_{{ $gallery->id }}" class="d-none" method="POST">
                                                    @csrf
                                                    @method('DELETE')

                                                </form>
                                            @endforeach

                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endif
                    </div>
                </div>


            </div>
        </div>
        </div>
    </section>

    <!-- dashboard-part-end -->

    @include('profile.logout')

</main>

@endsection

@push('style_section')

    <link rel="stylesheet" href="{{ asset('global/dropzone/dropzone.min.css') }}">
    <style>
        .dropzone {
            background: white;
            border-radius: 5px;
            border: 2px dashed rgb(0, 135, 247);
            border-image: none;
            max-width: 805px;
            margin-left: auto;
            margin-right: auto;
        }
    </style>
@endpush

@push('js_section')

<script src="{{ asset('global/sweetalert/sweetalert2@11.js') }}"></script>

<script src="{{ asset('global/dropzone/dropzone.min.js') }}"></script>

<script>
    "use strict";
    function deleteGallery(id){
        Swal.fire({
            title: "{{ __('translate.Are you realy want to delete this item ?') }}",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: "{{__('Yes, Delete It')}}",
            cancelButtonText: "{{__('Cancel')}}",
        }).then((result) => {
            if (result.isConfirmed) {
                $("#remove_gallery_"+id).submit();
            }

        })
    }
</script>

<script>
        Dropzone.options.dropzoneForm = {
            autoProcessQueue: false,
            uploadMultiple: true,
            parallelUploads: 10,
            thumbnailHeight: 200,
            thumbnailWidth: 200,
            maxFilesize: 3,
            filesizeBase: 1000,
            addRemoveLinks: true,
            renameFile: function(file) {
                var dt = new Date();
                var time = dt.getTime();
                return time + file.name;
            },
            acceptedFiles: ".jpeg,.jpg,.png,.webp",
            init: function() {
                myDropzone = this;
                $('#submit-all').on('click', function(e) {
                    e.preventDefault();
                    myDropzone.processQueue();
                });

                this.on("complete", function() {
                    if (this.getQueuedFiles().length == 0 && this.getUploadingFiles().length == 0) {
                        var _this = this;
                        _this.removeAllFiles();
                    }
                });
            },
            success: function(file, response) {
                window.location.href = response.url;
                toastr.success(response.message);
            },
        };

</script>


@endpush
