@extends('admin.master_layout')
@section('title')
    <title>{{ __('translate.Booking List') }}</title>
@endsection

@section('body-header')
    <h3 class="crancy-header__title m-0">{{ __('translate.All Bookings') }}</h3>
    <p class="crancy-header__text">{{ __('translate.Manage Listings') }} >> {{ __('translate.Booking List') }}</p>
@endsection

@section('body-content')
    <!-- crancy Dashboard -->
    <section class="crancy-adashboard crancy-show">
        <div class="container container__bscreen">
            <div class="row">
                <div class="col-12">
                    <div class="crancy-body">
                        <div class="crancy-dsinner">

                            <div class="crancy-table crancy-table--v3 mg-top-30">

                                <div class="crancy-customer-filter">
                                    <div class="crancy-customer-filter__single crancy-customer-filter__single--csearch d-flex items-center justify-between create_new_btn_box">
                                        <div class="crancy-header__form crancy-header__form--customer create_new_btn_inline_box">
                                            <h4 class="crancy-product-card__title">{{ __('translate.Booking List') }}</h4>
                                        </div>
                                    </div>
                                </div>

                                <!-- crancy Table -->
                                <div id="crancy-table__main_wrapper" class=" dt-bootstrap5 no-footer">

                                    <table class="crancy-table__main crancy-table__main-v3  no-footer" id="dataTable">
                                        <!-- crancy Table Head -->
                                        <thead class="crancy-table__head">
                                        <tr>

                                            <th class="crancy-table__column-2 crancy-table__h2 sorting" >
                                                {{ __('translate.Serial') }}
                                            </th>


                                            <th class="crancy-table__column-2 crancy-table__h2 sorting" >
                                                {{ __('translate.Agent') }}
                                            </th>


                                            <th class="crancy-table__column-2 crancy-table__h2 sorting" >
                                                {{ __('translate.Listing') }}
                                            </th>

                                            <th class="crancy-table__column-2 crancy-table__h2 sorting" >
                                                {{ __('translate.Start Date') }}
                                            </th>

                                            <th class="crancy-table__column-2 crancy-table__h2 sorting" >
                                                {{ __('translate.End Date') }}
                                            </th>
                                            <th class="crancy-table__column-2 crancy-table__h2 sorting" >
                                                {{ __('translate.Status') }}
                                            </th>

                                            <th class="crancy-table__column-3 crancy-table__h3 sorting">
                                                {{ __('translate.Action') }}
                                            </th>

                                        </tr>
                                        </thead>

                                        <!-- crancy Table Body -->
                                        <tbody class="crancy-table__body">
                                        @foreach ($bookings as $index => $booking)
                                            <tr class="odd">

                                                <td class="crancy-table__column-2 crancy-table__data-2">
                                                    <h4 class="crancy-table__product-title">{{ ++$index }}</h4>
                                                </td>

                                                <td class="crancy-table__column-2 crancy-table__data-2">
                                                    <h4 class="crancy-table__product-title"><a href="{{ route('admin.user-show', $booking->user_id) }}">{{ html_decode(@$booking?->user?->name) }}</a></h4>
                                                </td>

                                                <td class="crancy-table__column-2 crancy-table__data-2">
                                                    <h4 class="crancy-table__product-title"><a target="_blank" href="{{ route('listing', $booking->listing->slug) }}">{{ html_decode($booking->listing->translate->title) }}</a></h4>
                                                </td>

                                                <td class="crancy-table__column-2 crancy-table__data-2">
                                                    <h4 class="crancy-table__product-title">
                                                        {{ $booking->start_date }}
                                                    </h4>
                                                </td>

                                                <td class="crancy-table__column-2 crancy-table__data-2">
                                                    <h4 class="crancy-table__product-title">
                                                        {{ $booking->end_date }}
                                                    </h4>
                                                </td>


                                                <td class="crancy-table__column-2 crancy-table__data-2">
                                                    @php echo $booking->statusBadge @endphp
                                                </td>


                                                <td class="crancy-table__column-2 crancy-table__data-2">
                                                    <div class="dropdown">
                                                        <button class="crancy-btn dropdown-toggle" type="button" id="dropdownMenuButton1" data-bs-toggle="dropdown" aria-expanded="false">
                                                            {{ __('translate.Action') }}
                                                        </button>
                                                        <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton1">

                                                           @if($booking->status == \App\Constants\Status::DISABLE)
                                                                <li>
                                                                    <a onclick="statusConfrimation({{ $booking->id }})" href="javascript:;" data-bs-toggle="modal" data-bs-target="#statusModal" class="dropdown-item"><i class="fas fa-eye"></i> {{ __('translate.Enable') }}</a>
                                                                </li>
                                                            @else
                                                                <li>
                                                                    <a onclick="statusConfrimation({{ $booking->id }})" href="javascript:;" data-bs-toggle="modal" data-bs-target="#statusModal" class="dropdown-item"><i class="fas fa-eye-slash"></i> {{ __('translate.Disable') }}</a>
                                                                </li>
                                                           @endif

                                                            <li>
                                                                <a onclick="itemDeleteConfrimation({{ $booking->id }})" href="javascript:;" data-bs-toggle="modal" data-bs-target="#exampleModal" class="dropdown-item"><i class="fas fa-trash"></i> {{ __('translate.Delete') }}</a>
                                                            </li>

                                                        </ul>
                                                    </div>
                                                </td>
                                            </tr>
                                        @endforeach

                                        </tbody>
                                        <!-- End crancy Table Body -->
                                    </table>
                                </div>
                                <!-- End crancy Table -->
                            </div>

                        </div>
                    </div>
                </div>

            </div>
        </div>
    </section>
    <!-- End crancy Dashboard -->


    <!-- Delete Confirmation Modal -->
    <div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">{{ __('translate.Delete Confirmation') }}</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p>{{ __('translate.Are you really want to delete this booking?') }}</p>
                </div>
                <div class="modal-footer">
                    <form action="" id="item_delect_confirmation" class="delet_modal_form" method="POST">
                        @csrf
                        @method('DELETE')
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('translate.Close') }}</button>
                        <button type="submit" class="btn btn-primary">{{ __('translate.Yes, Delete') }}</button>

                    </form>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="statusModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">{{ __('translate.Status Update') }}</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p>{{ __('translate.Are you sure want to update this booking?') }}</p>
                </div>
                <div class="modal-footer">
                    <form action="" id="status_confirmation" class="delet_modal_form" method="POST">
                        @csrf
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('translate.Close') }}</button>
                        <button type="submit" class="btn btn-primary">{{ __('translate.Yes, Update') }}</button>

                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('js_section')
    <script>
        "use strict"
        function itemDeleteConfrimation(id){
            $("#item_delect_confirmation").attr("action",'{{ url("admin/listing/booking/delete") }}' + "/" + id);
        }
        function statusConfrimation(id){
            $("#status_confirmation").attr("action",'{{ url("admin/listing/booking/status") }}' + "/" + id);
        }
    </script>
@endpush
