<?php

namespace Modules\Category\Entities;

use Modules\Listing\Entities\Listing;
use Illuminate\Database\Eloquent\Model;
use Modules\Category\Entities\SubCategory;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Modules\Category\Entities\ChildCategoryTranslation;

class ChildCategory extends Model
{
    use HasFactory;

    protected $fillable = [];

    protected $appends = ['name'];

    protected $hidden = ['front_translate', 'total_listing'];


    public function translate(){
        return $this->belongsTo(ChildCategoryTranslation::class, 'id', 'child_category_id')->where('lang_code', admin_lang());
    }

    public function sub_category(){
        return $this->belongsTo(SubCategory::class);
    }


    public function front_translate(){
        return $this->belongsTo(ChildCategoryTranslation::class, 'id', 'child_category_id')->where('lang_code', front_lang());
    }

    public function getNameAttribute()
    {
        return $this->front_translate->name;
    }

    public function listings(){
        return $this->hasMany(Listing::class, 'child_category_id')->where(function ($query) {
            $query->where('expired_date', null)
                ->orWhere('expired_date', '>=', date('Y-m-d'));
        })->where(['status' => 'enable', 'approved_by_admin' => 'approved']);
    }

    public function getTotalListingAttribute()
    {
        return $this->listings->count();
    }


}
