@extends('layout')
@section('title')
    <title>{{ __('translate.My Booking List') }}</title>
@endsection
@section('body-content')

    <main>

        <div class="inner-bg common-class"
             style="    background-image:  url({{ asset($breadcrumb) }});">
            <div class="container">
                <div class="row">
                    <div class="col-lg-3">

                        <div class="inner-bg-txt">
                            <h1>{{ __('translate.My Booking List') }}</h1>

                            <ul>
                                <li><a href="{{ route('home') }}">{{ __('translate.Home') }}</a></li>
                                <li><span>
                                    <svg width="6" height="12" viewBox="0 0 6 12" fill="none"
                                         xmlns="http://www.w3.org/2000/svg">
                                        <path
                                            d="M0.633816 2.7705e-08C0.446997 0.0532405 0.28353 0.143084 0.158011 0.319443C-0.0492418 0.618921 -0.0550799 1.0515 0.155092 1.35098C0.195958 1.40755 0.239744 1.46411 0.286449 1.51735C1.56499 2.97481 2.84645 4.4356 4.125 5.89306C4.15419 5.92633 4.18922 5.95295 4.24176 6.03281C4.20673 6.0561 4.16295 6.06941 4.13375 6.10269C2.84062 7.57346 1.5504 9.04755 0.257258 10.5183C0.0295721 10.7779 -0.0579994 11.0773 0.0412483 11.4367C0.187201 11.9591 0.776848 12.1721 1.16216 11.8427C1.20595 11.8061 1.24682 11.7628 1.28768 11.7196C2.7764 10.0225 4.26511 8.32881 5.75091 6.63177C6.02238 6.32231 6.07492 5.92966 5.89394 5.57361C5.85015 5.4871 5.78594 5.41056 5.72464 5.34069C4.27971 3.69356 2.83478 2.04976 1.39277 0.399304C1.23222 0.216289 1.06875 0.0532405 0.838149 3.66367e-08C0.771011 3.3702e-08 0.703873 3.07673e-08 0.633816 2.7705e-08Z" />
                                    </svg>

                                </span></li>
                                <li><a href="javascript:;" class="active">{{ __('translate.My Booking List') }}</a></li>
                            </ul>
                        </div>

                    </div>
                </div>
            </div>
        </div>
        <!-- banner-part-end -->

        <!-- dashboard-part-start -->
        <section class="dashboard footer-top-pad">
            <div class="container">
                <div class="row">
                    @include('profile.sidebar')
                    <div class=" col-xxl-9 col-xl-8 col-lg-8">
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="dashbord-tabel dashboard-my-job-tabel my_job_post">
                                    <table class="table">
                                        <thead>
                                        <tr>
                                            <th>{{ __('translate.Title') }}</th>
                                            <th>{{ __('translate.Start Date') }}</th>
                                            <th>{{ __('translate.End Date') }}</th>
                                            <th>{{ __('translate.Status') }}</th>
                                        </tr>
                                        </thead>
                                        <tbody>

                                        @forelse ($bookings as $index => $booking)
                                            <tr>
                                                <td>
                                                    <div class="taitel-name-item">
                                                        <div class="taitel-name-thumb-main">
                                                            <div class="taitel-name-thumb">
                                                                <img src="{{ asset($booking->listing->thumb_image) }}"
                                                                     alt="thumb">
                                                            </div>
                                                        </div>
                                                        <a href="{{ route('listing', $booking->listing->slug) }}">{{ html_decode($booking->listing->translate->title) }}</a>
                                                    </div>
                                                </td>

                                                <td>
                                                    {{ $booking->start_date }}
                                                </td>

                                                <td>
                                                    {{ $booking->end_date }}
                                                </td>

                                                <td>
                                                    @php echo $booking->statusBadge @endphp
                                                </td>

                                            </tr>
                                        @empty
                                            <tr class="not_found">
                                                <td colspan="5">{{ __('translate.Data not found') }}</td>
                                            </tr>
                                        @endforelse

                                        </tbody>
                                    </table>
                                </div>
                            </div>


                            @if ($bookings->hasPages())
                                <div class="col-lg-12">
                                    {{ $bookings->links('pagination-box') }}
                                </div>
                            @endif

                        </div>
                    </div>


                </div>
            </div>
            </div>
        </section>

        <!-- dashboard-part-end -->

        @include('profile.logout')

    </main>

@endsection
