@extends('admin.master_layout')
@section('title')
    <title>{{ __('translate.Support Ticket') }}</title>
@endsection

@section('body-header')
    <h3 class="crancy-header__title m-0">{{ __('translate.Support Ticket') }}</h3>
    <p class="crancy-header__text">{{ __('translate.Manage Support') }} >> {{ __('translate.Support Ticket') }}</p>
@endsection

@section('body-content')
    <section class="crancy-adashboard crancy-show">
        <div class="container container__bscreen">
            <div class="row">
                <div class="col-12">
                    <div class="crancy-body">
                        <div class="crancy-dsinner">
                            <div class="crancy-table crancy-table--v3 mg-top-30">
                                <div class="crancy-customer-filter">
                                    <div
                                        class="crancy-customer-filter__single crancy-customer-filter__single--csearch d-flex items-center justify-between create_new_btn_box">
                                        <div
                                            class="crancy-header__form crancy-header__form--customer create_new_btn_inline_box">
                                            <h4 class="crancy-product-card__title">{{ __('translate.Support Ticket') }}</h4>
                                        </div>
                                    </div>
                                </div>
                                <div class="section-body">
                                    <div class="row">
                                        <div class="col-md-8">
                                            <div class="card">
                                                <div class="card-body ticket-message">
                                                    <div class="list-group">
                                                        @foreach ($ticket_messages as $message)
                                                            @if ($message->admin_id == 0)
                                                                <div
                                                                    class="list-group-item list-group-item-action flex-column align-items-start author_message mb-2">
                                                                    <div class="d-flex w-100 justify-content-between">
                                                                        <h6 class="mb-1"> {{ $ticket->user->name }}
                                                                            <small>({{__('translate.Author')}})</small>
                                                                        </h6>
                                                                        <small>{{ $message->created_at->diffForHumans() }}</small>
                                                                    </div>
                                                                    <p class="mb-1">{!! html_decode(clean(nl2br($message->message))) !!}</p>

                                                                </div>
                                                            @else
                                                                <div
                                                                    class="list-group-item list-group-item-action flex-column align-items-start mb-2">
                                                                    <div class="d-flex w-100 justify-content-between">
                                                                        <h6 class="mb-1">{{ $message->admin ? $message->admin->name : '' }}
                                                                            <small>({{__('translate.Administrator')}})</small>
                                                                        </h6>
                                                                        <small>{{ $message->created_at->diffForHumans() }} </small>
                                                                    </div>
                                                                    <p class="mb-1">{!! html_decode(clean(nl2br($message->message))) !!}</p>

                                                                </div>

                                                            @endif
                                                        @endforeach
                                                    </div>

                                                    <div class="message-box mt-4">
                                                        <form
                                                            action="{{ route('admin.send-support-message', $ticket->id) }}"
                                                            method="POST"
                                                            enctype="multipart/form-data">
                                                            @csrf
                                                            <div class="form-group">
                                                            <textarea required name="message" placeholder="{{__('Type here')}}.."
                                                            class="form-control text-area-5" id="" cols="30" rows="10"></textarea>
                                                            </div>
                                                            <input type="hidden" value="{{ $ticket->id }}"
                                                                   name="ticket_id">
                                                            <input type="hidden" value="{{ $ticket->user_id }}"
                                                                   name="user_id">


                                                            <button class="btn btn-primary mt-3"
                                                                    type="submit">{{__('Submit')}}</button>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="card">
                                                <div class="card-body">
                                                    <h6>{{__('Ticket Information')}}</h6>
                                                    <hr>
                                                    <p>{{__('Subject')}}: {{ html_decode($ticket->subject) }}</p>
                                                    <p>{{__('Ticket Id')}}: {{ $ticket->ticket_id }}</p>
                                                    <p>{{__('Created')}}
                                                        : {{ $ticket->created_at->format('h:m A, d-M-Y') }}</p>
                                                    <p>{{__('Status')}}:
                                                        @if($ticket->status == 'pending')
                                                            <span class="badge bg-danger">{{__('Pending')}}</span>
                                                        @elseif ($ticket->status == 'in_progress')
                                                            <span
                                                                class="badge bg-success">{{__('In Progress')}}</span>
                                                        @elseif ($ticket->status == 'closed')
                                                            <span class="badge bg-danger">{{__('Closed')}}</span>
                                                        @endif
                                                    </p>

                                                    <h6 class="mt-3">{{__('User Information')}}</h6>
                                                    <hr>

                                                    <p>
                                                        {{__('Name')}}: <a
                                                            href="#">{{ $ticket?->user?->name }}</a>
                                                    </p>
                                                    <p>{{__('User Type')}} : {{__('Client')}}</p>
                                                    <p>{{__('Email')}} : {{ $ticket->user->email  }}</p>
                                                    <p>{{__('Phone')}} : {{ $ticket->user->Phone  }}</p>

                                                    <a href="javascript:" data-toggle="modal"
                                                       data-target="#deleteModal" class="crancy-btn btn btn-danger"
                                                       onclick="deleteData({{ $ticket->id }})">
                                                        <i class="fa fa-trash" aria-hidden="true"></i>
                                                        {{__('Delete')}}</a>

                                                    @if ($ticket->status != 'closed')
                                                        <a onclick="itemDeleteConfirmation({{ $ticket->id }})" href="javascript:" data-bs-toggle="modal" data-bs-target="#closeTicket" class="crancy-btn delete_danger_btn"><i class="fas fa-eye-slash"></i> {{ __('translate.Close') }}</a>
                                                    @endif
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <div class="modal fade" id="closeTicket" tabindex="-1" aria-labelledby="closeTicketLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="closeTicketLabel">{{ __('translate.Close Confirmation') }}</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p>{{ __('translate.Are you sure to closed this support?') }}</p>
                </div>
                <div class="modal-footer">
                    <form action="{{ route('admin.ticket-closed', $ticket->id) }}" id="item_delect_confirmation" class="delet_modal_form" method="POST">
                        @csrf
                        @method('PUT')
                        <button type="button" class="btn btn-primary"
                                data-bs-dismiss="modal">{{ __('translate.Close') }}</button>
                        <button type="submit" class="btn btn-danger">{{ __('translate.Yes, Close') }}</button>

                    </form>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" tabindex="-1" role="dialog" id="deleteModal" aria-labelledby="deleteModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">{{__('translate.Item Delete Confirmation')}}</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p>{{__('translate.Are You sure delete this item ?')}}</p>
                </div>
                <div class="modal-footer">
                    <form id="deleteForm" action="" method="POST" class="delet_modal_form">
                        @csrf
                        @method("DELETE")
                        <button type="button" class="btn btn-danger close" data-bs-dismiss="modal" aria-label="Close">{{__('translate.Close')}}</button>
                        <button type="submit" class="btn btn-primary">{{__('translate.Yes, Delete')}}</button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <script>
        function deleteData(id) {
            $("#deleteForm").attr("action",'{{ url("admin/support-tickets/") }}'+"/"+id);
            $("#deleteModal").modal("show");
        }
    </script>

@endsection
