<?php

namespace Modules\SupportTicket\Http\Controllers;

use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Auth;
use Modules\SupportTicket\Entities\SupportTicket;
use Modules\SupportTicket\Entities\TicketMessage;
use Modules\SupportTicket\Http\Requests\SupportTicketRequest;
use Modules\SupportTicket\Http\Requests\TicketMessageRequest;

class SupportTicketController extends Controller
{

    public function index()
    {
        $user = Auth::guard('web')->user();
        $supportTickets = SupportTicket::where('user_id', $user->id)->latest()->paginate(10);

        return view('supportticket::user.index', compact('supportTickets'));
    }


    public function create()
    {
        return view('supportticket::user.create');
    }

    public function store(SupportTicketRequest $request)
    {
        $user = Auth::guard('web')->user();

        $ticket = new SupportTicket();
        $ticket->user_id = $user->id;
        $ticket->ticket_id = randomNumber();
        $ticket->subject = $request->subject;
        $ticket->priority = $request->priority;
        $ticket->save();

        $ticket_message = new TicketMessage();
        $ticket_message->user_id = $user->id;
        $ticket_message->support_ticket_id = $ticket->id;
        $ticket_message->message = $request->message;
        $ticket_message->message_from = 'user';
        $ticket_message->seen_by_user = 'yes';
        $ticket_message->save();

        $notification = trans('translate.Your ticket has been submitted successfully');
        $notification = array('messege'=> $notification, 'alert-type'=>'success');

        return redirect()->route('user.support-tickets.index')->with($notification);
    }


    public function show($id)
    {
        $user = Auth::guard('web')->user();

        $ticket = SupportTicket::where(['user_id' => $user->id, 'id' => $id])->first();

        if(!$ticket){
            $notification = trans('translate.Ticket not found');
            $notification = array('messege'=> $notification, 'alert-type'=>'error');
            return redirect()->route('user.support-tickets.index')->with($notification);
        }

        $ticket_messages = TicketMessage::where('support_ticket_id', $ticket->id)->get();
        return view('supportticket::user.show', compact('ticket', 'ticket_messages'));
    }

    public function edit($id)
    {
        return view('supportticket::edit');
    }

    public function send_support_message(TicketMessageRequest $request, $id){

        $user = Auth::guard('web')->user();

        $ticket_message = new TicketMessage();
        $ticket_message->user_id = $user->id;
        $ticket_message->support_ticket_id = $id;
        $ticket_message->message = $request->message;
        $ticket_message->message_from = 'user';
        $ticket_message->seen_by_user = 'yes';
        $ticket_message->save();

        $notification = trans('translate.Message Send Successfully');
        $notification = array('messege'=> $notification, 'alert-type'=>'success');
        return redirect()->back()->with($notification);
    }

}
