<?php

namespace Modules\Listing\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class ListingRequest extends FormRequest
{
    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        if ($this->isMethod('post')) {
            $rules = [
                'agent_id'=>'required',
                'category_id'=>'required',
                'sub_category_id'=>'required',
                'city_id'=>'required',
                'country_id'=>'required',
                'title'=>'required',
                'slug'=>'required|unique:listings',
                'description'=>'required',
                'regular_price'=>'required|numeric',
                'address'=>'required',
                'google_map'=>'required',
                'thumb_image'=>'required',
            ];
        }

        if ($this->isMethod('put')) {
            if($this->request->get('lang_code') == admin_lang()){
                $rules = [
                    'agent_id'=>'required',
                    'sub_category_id'=>'required',
                    'city_id'=>'required',
                    'country_id'=>'required',
                    'title'=>'required',
                    'slug'=>'required|unique:listings,slug,'.$this->listing.',id',
                    'description'=>'required',
                    'regular_price'=>'required|numeric',
                    'address'=>'required',
                    'google_map'=>'required',
                    'thumb_image'=>'sometimes|required',
                ];
            }else{
                $rules = [
                    'title'=>'required',
                    'description'=>'required',
                    'address'=>'required',
                ];
            }
        }

        return $rules;
    }

    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    public function messages(): array
    {
        return [
            'agent_id.required' => trans('translate.Agent is required'),
            'category_id.required' => trans('translate.Category is required'),
            'sub_category_id.required' => trans('translate.Sub category is required'),
            'city_id.required' => trans('translate.City is required'),
            'country_id.required' => trans('translate.Country is required'),
            'title.required' => trans('translate.Title is required'),
            'slug.required' => trans('translate.Slug is required'),
            'slug.unique' => trans('translate.Slug already exist'),
            'description.required' => trans('translate.Description is required'),
            'regular_price.required' => trans('translate.Regular price is required'),
            'regular_price.numeric' => trans('translate.Regular price should be numeric'),
            'address.required' => trans('translate.Address is required'),
            'google_map.required' => trans('translate.Google map is required'),
            'thumb_image.required' => trans('translate.Image is required'),
        ];
    }
}
