<?php

namespace Modules\Category\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

use Modules\Category\Entities\SubCategoryTranslation;
use Modules\Category\Entities\Category;
use Modules\Listing\Entities\Listing;

class SubCategory extends Model
{
    use HasFactory;

    protected $fillable = [];

    protected $appends = ['name'];

    protected $hidden = ['front_translate', 'total_listing'];

    protected static function newFactory()
    {
        return \Modules\Category\Database\factories\SubCategoryFactory::new();
    }

    public function translate(){
        return $this->belongsTo(SubCategoryTranslation::class, 'id', 'sub_category_id')->where('lang_code', admin_lang());
    }

    public function category(){
        return $this->belongsTo(Category::class);
    }


    public function front_translate(){
        return $this->belongsTo(SubCategoryTranslation::class, 'id', 'sub_category_id')->where('lang_code', front_lang());
    }

    public function getNameAttribute()
    {
        return $this->front_translate->name;
    }

    public function listings(){
        return $this->hasMany(Listing::class, 'sub_category_id')->where(function ($query) {
            $query->where('expired_date', null)
                ->orWhere('expired_date', '>=', date('Y-m-d'));
        })->where(['status' => 'enable', 'approved_by_admin' => 'approved']);
    }

    public function getTotalListingAttribute()
    {
        return $this->listings->count();
    }


}
