@extends('layout')
@section('title')
    <title>{{ html_decode($listing->seo_title) }}</title>
    <meta name="title" content="{{ html_decode($listing->seo_title) }}">
    <meta name="description" content="{{ html_decode($listing->seo_description) }}">
@endsection

@section('body-content')
<main>


    <!-- inner-bg  part start  -->

    <div class="inner-bg common-class"
    style="    background-image:  url({{ asset($breadcrumb) }});">
    <div class="container">
        <div class="row">
            <div class="  col-xxl-3  col-xl-5 col-lg-5">

                <div class="inner-bg-txt">
                    <h1>{{ __('translate.Listing Details') }}</h1>

                    <ul>
                        <li><a href="{{ route('home') }}">{{ __('translate.Home') }}</a></li>
                        <li><span>
                                <svg width="6" height="12" viewBox="0 0 6 12" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M0.633816 2.7705e-08C0.446997 0.0532405 0.28353 0.143084 0.158011 0.319443C-0.0492418 0.618921 -0.0550799 1.0515 0.155092 1.35098C0.195958 1.40755 0.239744 1.46411 0.286449 1.51735C1.56499 2.97481 2.84645 4.4356 4.125 5.89306C4.15419 5.92633 4.18922 5.95295 4.24176 6.03281C4.20673 6.0561 4.16295 6.06941 4.13375 6.10269C2.84062 7.57346 1.5504 9.04755 0.257258 10.5183C0.0295721 10.7779 -0.0579994 11.0773 0.0412483 11.4367C0.187201 11.9591 0.776848 12.1721 1.16216 11.8427C1.20595 11.8061 1.24682 11.7628 1.28768 11.7196C2.7764 10.0225 4.26511 8.32881 5.75091 6.63177C6.02238 6.32231 6.07492 5.92966 5.89394 5.57361C5.85015 5.4871 5.78594 5.41056 5.72464 5.34069C4.27971 3.69356 2.83478 2.04976 1.39277 0.399304C1.23222 0.216289 1.06875 0.0532405 0.838149 3.66367e-08C0.771011 3.3702e-08 0.703873 3.07673e-08 0.633816 2.7705e-08Z" />
                                </svg>

                            </span></li>
                        <li><a href="javascript:;" class="active">{{ __('translate.Listing Details') }}</a></li>
                    </ul>
                </div>

            </div>
        </div>
    </div>
</div>

    <!-- inner-bg  part end  -->



    <!-- Motorcycle part start  -->
    <section class="motorcycle common-class">
        <div class="container">
            <div class="row g-3">
                <div class="col-lg-8">
                    @if ($listing_top_ads->status == 'enable')
                        <div class="motorcycle-ads">
                            <a href="{{ $listing_top_ads->link }}" target="_blank"><img src="{{ asset($listing_top_ads->image) }}" alt="img"></a>
                        </div>
                    @endif



                    <div class="row">

                        <div class="col-lg-12">

                            <div class="motorcycle-slick-main">

                                <div class="motorcycle-slick-btm-thumb-over">
                                    <div class="vedio-ani"></div>
                                    <a class="my-video-links" data-autoplay="true" data-vbtype="video"
                                        href="https://www.youtube.com/watch?v=YBLXLNRwgQI">

                                        <span class="icon">
                                            <svg width="16" height="20" viewBox="0 0 26 30" fill="none"
                                                xmlns="http://www.w3.org/2000/svg">
                                                <path
                                                    d="M24.0139 11.111L5.41584 0.482154C4.88422 0.171026 4.27879 0.00467176 3.66111 0C2.69012 0 1.75891 0.381551 1.07231 1.06072C0.385723 1.73988 0 2.66103 0 3.62151V26.4327C0.000123489 27.0701 0.172854 27.6958 0.500231 28.2448C0.827609 28.7938 1.29768 29.246 1.86157 29.5545C2.42546 29.8629 3.06258 30.0163 3.70669 29.9986C4.35079 29.981 4.97837 29.793 5.52416 29.4542L24.1438 17.8183C24.7228 17.4599 25.198 16.9592 25.5232 16.3651C25.8483 15.771 26.0124 15.1037 25.9993 14.4282C25.9862 13.7527 25.7964 13.0921 25.4485 12.5108C25.1005 11.9294 24.6063 11.4472 24.0139 11.111Z">
                                                </path>

                                            </svg>

                                        </span>


                                    </a>

                                </div>



                                <div class="motorcycle-slick-top">
                                    @foreach ($galleries as $gallery)
                                    <div class="motorcycle-slick-top-thumb">
                                        <div class="motorcycle-slick-top-thumb-over">
                                            @if ($listing->is_featured == 'enable')

                                            <a href="javascript::">{{ __('translate.Featured') }}</a>
                                            @endif
                                        </div>
                                        <img src="{{ asset($gallery->image) }}" alt="thumb">
                                    </div>
                                    @endforeach
                                </div>
                            </div>

                            <div class="motorcycle-slick-btm">
                                @foreach ($galleries as $gallery)
                                    <div class="motorcycle-slick-btm-thumb">
                                        <img src="{{ asset($gallery->image) }}" alt="img">
                                    </div>
                                @endforeach

                            </div>
                        </div>
                    </div>


                    <div class="row">
                        <div class="col-lg-8">
                            <ul class="product-name">
                                <li>
                                    <span>
                                        <svg width="11" height="12" viewBox="0 0 11 12" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path
                                                d="M10.9992 3.43661C10.9992 4.03851 11.001 4.63998 10.9984 5.24188C10.9971 5.59777 10.8734 5.90712 10.6216 6.16046C10.253 6.53143 9.88231 6.89981 9.51201 7.26948C8.1817 8.59823 6.8514 9.92699 5.52152 11.2562C5.40297 11.3747 5.27925 11.485 5.11717 11.5405C4.78523 11.6543 4.47658 11.6069 4.21276 11.3772C3.99593 11.1881 3.79548 10.9796 3.59158 10.7762C2.52854 9.71458 1.46636 8.65166 0.405044 7.58874C0.330468 7.51421 0.257184 7.43708 0.192523 7.35393C-0.0816435 6.99977 -0.0622449 6.50946 0.245976 6.18287C0.471862 5.94331 0.708524 5.71367 0.941737 5.48058C2.27248 4.14967 3.60365 2.81919 4.93439 1.48872C5.11415 1.30905 5.29089 1.12594 5.47453 0.949719C5.70904 0.724383 5.99527 0.604606 6.31815 0.602882C7.545 0.597712 8.77142 0.600728 9.99827 0.600728C10.275 0.600728 10.5255 0.673111 10.7251 0.876474C10.8854 1.03977 10.982 1.23494 10.9885 1.46502C10.9971 1.79979 10.9975 2.13457 10.9992 2.46934C11.001 2.79162 10.9992 3.1139 10.9992 3.43618V3.43661ZM9.16327 3.35733C9.1706 2.86228 8.77271 2.45254 8.28603 2.4353C7.76571 2.41678 7.3355 2.82695 7.33075 3.34656C7.32644 3.83773 7.72562 4.24963 8.21059 4.26902C8.72616 4.2897 9.17318 3.86703 9.16327 3.35733Z" />
                                        </svg>
                                    </span>

                                    {{ $listing?->sub_category?->name }}
                                </li>

                                <li>
                                    <span class="circle"></span>
                                </li>
                                <li>
                                    {{ __('translate.Views') }} : {{ $listing->total_view }}
                                </li>
                            </ul>

                            <h2 class="product-name-taitel">{{ html_decode($listing->title) }}</h2>

                            <div class="product-name-btn-main">
                                @guest('web')
                                    <a href="javascript:;" class="product-name-btn before_auth_wishlist">
                                        <span>
                                            <svg width="24" height="21" viewBox="0 0 22 20" fill="none"
                                                xmlns="http://www.w3.org/2000/svg">
                                                <path
                                                    d="M11.765 2.70229L11 3.52422L10.235 2.70229C8.12233 0.432572 4.69709 0.43257 2.58447 2.70229C0.471845 4.972 0.471844 8.65194 2.58447 10.9217L9.4699 18.3191C10.315 19.227 11.685 19.227 12.5301 18.3191L19.4155 10.9217C21.5282 8.65194 21.5282 4.972 19.4155 2.70229C17.3029 0.432571 13.8777 0.432571 11.765 2.70229Z"
                                                    stroke-linejoin="round" />
                                            </svg>
                                        </span>
                                        {{ __('translate.Wishlist') }}
                                    </a>
                                @else
                                    <a href="{{ route('user.add-to-wishlist', $listing->id) }}" class="product-name-btn">
                                        <span>
                                            <svg width="24" height="21" viewBox="0 0 22 20" fill="none"
                                                xmlns="http://www.w3.org/2000/svg">
                                                <path
                                                    d="M11.765 2.70229L11 3.52422L10.235 2.70229C8.12233 0.432572 4.69709 0.43257 2.58447 2.70229C0.471845 4.972 0.471844 8.65194 2.58447 10.9217L9.4699 18.3191C10.315 19.227 11.685 19.227 12.5301 18.3191L19.4155 10.9217C21.5282 8.65194 21.5282 4.972 19.4155 2.70229C17.3029 0.432571 13.8777 0.432571 11.765 2.70229Z"
                                                    stroke-linejoin="round" />
                                            </svg>
                                        </span>
                                        {{ __('translate.Wishlist') }}
                                    </a>
                                @endguest

                                <a href="#" class="product-name-btn" data-bs-toggle="modal"
                                    data-bs-target="#exampleModal">
                                    <span>
                                        <svg class="svg-two" width="15" height="18" viewBox="0 0 15 18" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path
                                                d="M14.9414 0.189723C14.9057 0.131754 14.8555 0.083868 14.7958 0.050649C14.736 0.0174301 14.6687 -9.41999e-06 14.6002 6.462e-08H3.65809C3.60552 -2.97044e-05 3.55346 0.0102262 3.50488 0.0301815C3.4563 0.0501368 3.41216 0.0794 3.37499 0.116298C3.33781 0.153196 3.30833 0.197005 3.28822 0.24522C3.26812 0.293435 3.25778 0.345111 3.25781 0.397293V7.56137C3.25778 7.61355 3.26812 7.66523 3.28822 7.71344C3.30833 7.76166 3.33781 7.80546 3.37499 7.84236C3.41216 7.87926 3.4563 7.90852 3.50488 7.92848C3.55346 7.94843 3.60552 7.95869 3.65809 7.95866H14.6002C14.6687 7.95866 14.736 7.94122 14.7958 7.908C14.8555 7.87478 14.9057 7.82689 14.9415 7.76892C14.9772 7.71095 14.9974 7.64484 15.0001 7.57691C15.0028 7.50898 14.9878 7.44151 14.9567 7.38095L13.2086 3.97913L14.9567 0.577703C14.9878 0.517141 15.0028 0.449667 15.0001 0.381736C14.9974 0.313806 14.9772 0.247693 14.9414 0.189723ZM12.4025 3.79873C12.3738 3.8546 12.3589 3.91643 12.3589 3.97914C12.3589 4.04186 12.3738 4.10369 12.4025 4.15956L13.9466 7.16408H4.05838V0.794586H13.9466L12.4025 3.79873Z" />
                                            <path
                                                d="M4.0634 15.6973H2.63231V0.397293C2.63231 0.291924 2.59014 0.190871 2.51507 0.116364C2.44 0.0418575 2.33819 0 2.23203 0C2.12586 0 2.02405 0.0418575 1.94898 0.116364C1.87392 0.190871 1.83174 0.291924 1.83174 0.397293V15.6973H0.400282C0.347708 15.6973 0.295643 15.7076 0.247065 15.7275C0.198487 15.7475 0.154349 15.7767 0.117173 15.8136C0.0799975 15.8505 0.0505141 15.8943 0.0304086 15.9426C0.0103032 15.9908 -2.99279e-05 16.0424 6.51062e-08 16.0946V17.6027C-2.99279e-05 17.6549 0.0103032 17.7066 0.0304086 17.7548C0.0505141 17.803 0.0799975 17.8468 0.117173 17.8837C0.154349 17.9206 0.198487 17.9499 0.247065 17.9698C0.295643 17.9898 0.347708 18 0.400282 18H4.0634C4.11597 18 4.16804 17.9898 4.21661 17.9698C4.26519 17.9499 4.30933 17.9206 4.34651 17.8837C4.38368 17.8468 4.41316 17.803 4.43327 17.7548C4.45338 17.7066 4.46371 17.6549 4.46368 17.6027V16.0946C4.46371 16.0424 4.45338 15.9908 4.43327 15.9426C4.41316 15.8943 4.38368 15.8505 4.34651 15.8136C4.30933 15.7767 4.26519 15.7475 4.21661 15.7275C4.16804 15.7076 4.11597 15.6973 4.0634 15.6973ZM3.66311 17.2054H0.800565V16.4919H3.66311V17.2054Z" />
                                            <path
                                                d="M4.8954 2.5596C4.94797 2.55963 5.00004 2.54938 5.04862 2.52942C5.09719 2.50947 5.14133 2.4802 5.17851 2.44331C5.21569 2.40641 5.24517 2.3626 5.26527 2.31438C5.28538 2.26617 5.29571 2.21449 5.29568 2.16231V1.90469H8.0918C8.19796 1.90469 8.29977 1.86284 8.37484 1.78833C8.44991 1.71382 8.49208 1.61277 8.49208 1.5074C8.49208 1.40203 8.44991 1.30098 8.37484 1.22647C8.29977 1.15197 8.19796 1.11011 8.0918 1.11011H4.8954C4.84283 1.11008 4.79076 1.12033 4.74218 1.14029C4.6936 1.16024 4.64946 1.18951 4.61229 1.2264C4.57511 1.2633 4.54563 1.30711 4.52553 1.35533C4.50542 1.40354 4.49509 1.45522 4.49512 1.5074V2.16231C4.49509 2.21449 4.50542 2.26617 4.52553 2.31438C4.54563 2.3626 4.57511 2.40641 4.61229 2.44331C4.64946 2.4802 4.6936 2.50947 4.74218 2.52942C4.79076 2.54938 4.84283 2.55963 4.8954 2.5596Z" />
                                            <path
                                                d="M4.8954 4.37639C4.94797 4.37642 5.00004 4.36616 5.04862 4.34621C5.09719 4.32625 5.14133 4.29699 5.17851 4.26009C5.21569 4.22319 5.24517 4.17939 5.26527 4.13117C5.28538 4.08295 5.29571 4.03128 5.29568 3.9791V3.28694C5.29568 3.18157 5.25351 3.08052 5.17844 3.00601C5.10337 2.93151 5.00156 2.88965 4.8954 2.88965C4.78924 2.88965 4.68742 2.93151 4.61236 3.00601C4.53729 3.08052 4.49512 3.18157 4.49512 3.28694V3.9791C4.49509 4.03128 4.50542 4.08295 4.52553 4.13117C4.54563 4.17939 4.57511 4.22319 4.61229 4.26009C4.64946 4.29699 4.6936 4.32625 4.74218 4.34621C4.79076 4.36616 4.84283 4.37642 4.8954 4.37639Z" />
                                        </svg>
                                    </span>
                                    {{ __('translate.Report') }}
                                </a>
                            </div>
                        </div>


                        <div class="col-lg-4">
                            <div class="right-btn">
                                <a href="javascript:;" class="price-btn">{{ currency($listing->regular_price) }}</a>
                            </div>
                        </div>
                    </div>


                    <div class="row">


                        <!-- Description Overview  -->
                        <div class="col-lg-12">
                            <div class="accordion" id="accordionPanelsStayOpenExample">
                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="panelsStayOpen-headingOne">
                                        <button class="accordion-button" type="button" data-bs-toggle="collapse"
                                            data-bs-target="#panelsStayOpen-collapseOne" aria-expanded="true"
                                            aria-controls="panelsStayOpen-collapseOne">
                                            {{ __('translate.Description Overview') }}
                                        </button>
                                    </h2>
                                    <div id="panelsStayOpen-collapseOne" class="accordion-collapse collapse show"
                                        aria-labelledby="panelsStayOpen-headingOne">
                                        <div class="accordion-body">
                                           {!! clean(html_decode($listing->description)) !!}
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>


                        <!-- Features Overview  -->

                        @if ($listing_features->count() > 0)
                            <div class="col-lg-12">

                                <div class="accordion" id="accordionPanelsStayOpenExample2">
                                    <div class="accordion-item">
                                        <h2 class="accordion-header" id="panelsStayOpen-headingtwo">
                                            <button class="accordion-button" type="button" data-bs-toggle="collapse"
                                                data-bs-target="#panelsStayOpen-collapsetwo" aria-expanded="true"
                                                aria-controls="panelsStayOpen-collapsetwo">
                                                {{ __('translate.Features & Aminities') }}
                                            </button>
                                        </h2>
                                        <div id="panelsStayOpen-collapsetwo" class="accordion-collapse collapse show"
                                            aria-labelledby="panelsStayOpen-headingtwo">
                                            <div class="accordion-body">

                                                <div class="features-main">
                                                    <ul>
                                                        @foreach ($listing_features as $index => $listing_feature)
                                                            <li> <span></span>{{ $listing_feature->name }}</li>
                                                        @endforeach
                                                    </ul>

                                                </div>

                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endif


                        <!-- Locations -->
                        <div class="col-lg-12">

                            <div class="accordion" id="accordionPanelsStayOpenExample3">
                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="panelsStayOpen-headingthree">
                                        <button class="accordion-button" type="button" data-bs-toggle="collapse"
                                            data-bs-target="#panelsStayOpen-collapsethree" aria-expanded="true"
                                            aria-controls="panelsStayOpen-collapsethree">
                                            {{ __('translate.Locations') }}
                                        </button>
                                    </h2>
                                    <div id="panelsStayOpen-collapsethree" class="accordion-collapse collapse show"
                                        aria-labelledby="panelsStayOpen-headingthree">
                                        <div class="accordion-body">

                                            <ul class="locations-item">
                                                <li>
                                                    <a href="javascript:;">
                                                        <span>
                                                            <svg width="18" height="22" viewBox="0 0 18 22"
                                                                fill="none" xmlns="http://www.w3.org/2000/svg">
                                                                <path
                                                                    d="M2.55 20.25C2.13579 20.25 1.8 20.5858 1.8 21C1.8 21.4142 2.13579 21.75 2.55 21.75V20.25ZM14.95 21.75C15.3642 21.75 15.7 21.4142 15.7 21C15.7 20.5858 15.3642 20.25 14.95 20.25V21.75ZM15.75 8.5C15.75 10.1981 14.6274 12.4022 13.0703 14.2376C12.3055 15.139 11.4701 15.9098 10.6819 16.4488C9.87165 17.0029 9.2019 17.25 8.75 17.25V18.75C9.65435 18.75 10.6315 18.3005 11.5286 17.687C12.4479 17.0584 13.3804 16.1906 14.2141 15.208C15.8538 13.2752 17.25 10.7292 17.25 8.5H15.75ZM8.75 17.25C8.31285 17.25 7.64989 16.992 6.83557 16.4004C6.0463 15.8269 5.20886 15.0085 4.44153 14.0574C2.8796 12.1213 1.75 9.81691 1.75 8.11111H0.25C0.25 10.3327 1.63915 12.9727 3.27409 14.9992C4.1052 16.0294 5.03573 16.9468 5.95389 17.6139C6.84698 18.2628 7.8309 18.75 8.75 18.75V17.25ZM1.75 8.11111C1.75 4.5023 5.07541 1.75 8.75 1.75V0.25C4.43487 0.25 0.25 3.4977 0.25 8.11111H1.75ZM8.75 1.75C12.3966 1.75 15.75 4.47727 15.75 8.5H17.25C17.25 3.52273 13.0931 0.25 8.75 0.25V1.75ZM11.1 8C11.1 9.21965 10.0712 10.25 8.75 10.25V11.75C10.8529 11.75 12.6 10.0941 12.6 8H11.1ZM8.75 10.25C7.42876 10.25 6.4 9.21965 6.4 8H4.9C4.9 10.0941 6.64707 11.75 8.75 11.75V10.25ZM6.4 8C6.4 6.78035 7.42876 5.75 8.75 5.75V4.25C6.64707 4.25 4.9 5.90594 4.9 8H6.4ZM8.75 5.75C10.0712 5.75 11.1 6.78035 11.1 8H12.6C12.6 5.90594 10.8529 4.25 8.75 4.25V5.75ZM2.55 21.75H14.95V20.25H2.55V21.75Z" />
                                                            </svg>
                                                        </span>
                                                        {{ html_decode($listing->address) }}
                                                    </a>

                                                    <iframe src="{{ html_decode($listing->google_map) }}" width="600" height="450" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>

                                                </li>

                                            </ul>

                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>



                        @if ($reviews->count() > 0)
                            <!-- Reviews -->
                            <div class="col-lg-12">
                                <div class="accordion" id="accordionPanelsStayOpenExample4">
                                    <div class="accordion-item">
                                        <h2 class="accordion-header" id="panelsStayOpen-headingfour">
                                            <button class="accordion-button" type="button" data-bs-toggle="collapse"
                                                data-bs-target="#panelsStayOpen-collapsefour" aria-expanded="true"
                                                aria-controls="panelsStayOpen-collapsefour">
                                                {{ __('translate.Reviews') }}
                                            </button>
                                        </h2>
                                        <div id="panelsStayOpen-collapsefour" class="accordion-collapse collapse show"
                                            aria-labelledby="panelsStayOpen-headingfour">
                                            <div class="accordion-body">

                                                <div class="review-item">
                                                    @foreach ($reviews as $review)
                                                        <div class="reviews">
                                                            <div class="reviews-item">
                                                                <ul class="icon">
                                                                    @for ($i = 1; $i <= 5; $i++)
                                                                        @if ($review->rating < $i)
                                                                        <li><i class="fa-regular fa-star"></i></li>
                                                                        @else
                                                                        <li><i class="fa-solid fa-star"></i></li>
                                                                        @endif
                                                                    @endfor
                                                                </ul>

                                                                <div class="text">
                                                                    <h6>{{ $review->created_at->format('M d Y') }}</h6>
                                                                </div>
                                                            </div>

                                                            <p>{{ html_decode($review->comment) }}</p>

                                                            <div class="reviews-inner">
                                                                <div class="reviews-inner-item">
                                                                    <div class="reviews-inner-img">
                                                                        <img src="{{ asset($review?->user?->image) }}"
                                                                            alt="img">
                                                                    </div>

                                                                    <div class="reviews-inner-text">
                                                                        <h3>{{ html_decode($review?->user?->name) }}</h3>
                                                                        <p>{{ html_decode($review?->user?->designation) }}</p>
                                                                    </div>
                                                                </div>

                                                            </div>


                                                        </div>

                                                    @endforeach
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endif

                        <!-- Write Your Review -->
                        <div class="col-lg-12">

                            <div class="accordion" id="accordionPanelsStayOpenExample5">
                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="panelsStayOpen-headingfive">
                                        <button class="accordion-button" type="button" data-bs-toggle="collapse"
                                            data-bs-target="#panelsStayOpen-collapsefive" aria-expanded="true"
                                            aria-controls="panelsStayOpen-collapsefive">
                                            {{ __('translate.Write Your Review') }}
                                        </button>
                                    </h2>
                                    <div id="panelsStayOpen-collapsefive" class="accordion-collapse collapse show"
                                        aria-labelledby="panelsStayOpen-headingfive">
                                        <div class="accordion-body">

                                            <div class="write-your-review-item">
                                                <div class="write-your-review-stars">
                                                    <ul>
                                                        <li><i onclick="listingReview(1)" data-rating="1" class="listing_rat fa-solid fa-star"></i></li>
                                                        <li><i onclick="listingReview(2)" data-rating="2" class="listing_rat fa-solid fa-star"></i></li>
                                                        <li><i onclick="listingReview(3)" data-rating="3" class="listing_rat fa-solid fa-star"></i></li>
                                                        <li><i onclick="listingReview(4)" data-rating="4" class="listing_rat fa-solid fa-star"></i></li>
                                                        <li><i onclick="listingReview(5)" data-rating="5" class="listing_rat fa-solid fa-star"></i></li>
                                                    </ul>
                                                    <span id="rating_visible">(5.0)</span>
                                                </div>

                                                <form method="POST" action="{{ route('user.store-review') }}" id="review_form">

                                                    @csrf

                                                    <input type="hidden" name="agent_id" value="{{ $listing->agent_id }}">
                                                    <input type="hidden" name="listing_id" value="{{ $listing->id }}">
                                                    <input type="hidden" id="listing_rating" name="rating" value="5">

                                                    <div class="form-item two">
                                                        <div class="form-inner">
                                                            <label class="form-label">{{ __('translate.Review') }} <span>*</span> </label>
                                                            <textarea class="form-control"
                                                                 rows="5"
                                                                placeholder="{{ __('translate.Type your review') }}" name="comment">{{ old('comment') }}</textarea>
                                                        </div>

                                                    </div>

                                                    @if($google_recaptcha->status==1)
                                                        <div class="form-item two">
                                                            <div class="form-inner">
                                                                <div class="g-recaptcha" data-sitekey="{{ $google_recaptcha->site_key }}"></div>
                                                            </div>
                                                        </div>
                                                    @endif

                                                    @guest('web')
                                                        <a class="main-btn before_auth_wishlist" href="javascript:;">
                                                            <div class="btn_m">
                                                                <div class="btn_c">
                                                                    <div class="btn_t1">{{ __('translate.Submit Review') }}</div>
                                                                    <div class="btn_t2">{{ __('translate.Submit Review') }}</div>
                                                                </div>
                                                            </div>
                                                        </a>
                                                    @else
                                                        <a class="main-btn " href="javascript:;" id="review_form_btn">
                                                            <div class="btn_m">
                                                                <div class="btn_c">
                                                                    <div class="btn_t1">{{ __('translate.Submit Review') }}</div>
                                                                    <div class="btn_t2">{{ __('translate.Submit Review') }}</div>
                                                                </div>
                                                            </div>
                                                        </a>
                                                    @endguest


                                                </form>

                                            </div>


                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>

                </div>

                <div class="col-lg-4 listing-pl">
                    <div class="motorcycle-side-ber">
                        <div class="motorcycle-side-ber-profile">
                            <div class="motorcycle-side-ber-profile-thumb">
                                @if ($agent->image)
                                <img src="{{ asset($agent->image) }}" alt="thumb">
                                @else
                                <img src="{{ asset($setting->default_avatar) }}" alt="thumb">

                                @endif

                            </div>

                            <div class="motorcycle-side-ber-profile-txt">
                                <h2 class="profile-taitel"> <a href="{{ route('agent', html_decode($agent->username)) }}">{{ html_decode($agent->name) }}</a> </h2>

                                <ul>
                                    <li>{{ __('translate.Member Since') }} {{ $agent->created_at->format('Y') }} </li>
                                    <li>{{ __('translate.Total Listing') }} : <span>{{ $agent->total_listing }}</span> </li>
                                </ul>
                            </div>
                        </div>


                        @if ($setting->agent_contact_info == 'enable')

                        <ul class="motorcycle-side-ber-contuct">
                            <li>
                                <a href="tel:{{ html_decode($agent->phone) }}">
                                    <span>
                                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path
                                                d="M24 21.3333V19.1388C24 18.0483 23.3361 17.0678 22.3237 16.6628L19.6115 15.5779C18.3238 15.0629 16.8563 15.6208 16.236 16.8613L16 17.3333C16 17.3333 12.6667 16.6667 10 14C7.33333 11.3333 6.66667 8 6.66667 8L7.13869 7.76399C8.37917 7.14375 8.93714 5.67618 8.42206 4.38848L7.33718 1.67629C6.93221 0.66387 5.95166 0 4.86125 0H2.66667C1.19391 0 0 1.19391 0 2.66667C0 14.4487 9.55126 24 21.3333 24C22.8061 24 24 22.8061 24 21.3333Z" />
                                        </svg>
                                    </span>
                                    {{ html_decode($agent->phone) }}
                                </a>
                            </li>

                            <li>
                                <a target="_blank" href="https://wa.me/{{ html_decode($agent->whatsapp_phone) }}">
                                    <span>
                                        <svg width="22" height="22" viewBox="0 0 22 22" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path fill-rule="evenodd" clip-rule="evenodd"
                                                d="M22 11C22 17.0751 17.0751 22 11 22C9.31964 22 7.72728 21.6232 6.3028 20.9495L1.37449 21.7709C0.699508 21.8834 0.113469 21.3 0.222984 20.6245L1.02918 15.6519C0.368851 14.239 0 12.6626 0 11C0 4.92487 4.92487 0 11 0C17.0751 0 22 4.92487 22 11ZM15.3996 13.9425V14.4223C15.3996 14.9623 14.9618 15.4001 14.4218 15.4001C10.1017 15.4001 6.59958 11.898 6.59958 7.57788C6.59958 7.03786 7.03735 6.6001 7.57736 6.6001H8.05718C8.6532 6.6001 9.18917 6.96297 9.41053 7.51636L9.6158 8.02954C9.84529 8.60325 9.5967 9.2571 9.04402 9.53343C9.04402 9.53343 9.28847 10.7557 10.2662 11.7334C11.244 12.7112 12.4662 12.9557 12.4662 12.9557C12.7426 12.403 13.3964 12.1544 13.9701 12.3839L14.4833 12.5891C15.0367 12.8105 15.3996 13.3465 15.3996 13.9425Z" />
                                        </svg>
                                    </span>
                                    {{ html_decode($agent->whatsapp_phone) }}
                                </a>
                            </li>

                            <li>
                                <a href="mailto:{{ html_decode($agent->email) }}">
                                    <span>
                                        <svg width="25" height="22" viewBox="0 0 25 22" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path fill-rule="evenodd" clip-rule="evenodd"
                                                d="M4 0C1.79086 0 0 1.79086 0 4V4.54162L10.4573 12.1469C11.5092 12.912 12.9344 12.912 13.9863 12.1469L24.4444 4.54099V4C24.4444 1.79086 22.6536 0 20.4444 0H4ZM24.4444 7.01399L15.1626 13.7644C13.4094 15.0395 11.0342 15.0395 9.28093 13.7644L0 7.01462V18C0 20.2091 1.79086 22 4 22H20.4444C22.6536 22 24.4444 20.2091 24.4444 18V7.01399Z" />
                                        </svg>
                                    </span>
                                    {{ html_decode($agent->email) }}
                                </a>
                            </li>

                        </ul>

                        @endif



                        <div class="safety-tips-item">
                            <h2>{{ __('translate.Safety Tips') }}</h2>

                            <div class="safety-tips">
                                {!! clean($setting->safetytips) !!}
                            </div>

                        </div>

                        <div class="motorcycle-contact">
                            <h2 class="motorcycle-contact-taitel ">{{ __('translate.Contact Us') }}</h2>
                            <form class="motorcycle-form" action="{{ route('store-agent-contact-message', $listing->agent_id) }}" method="POST">
                                @csrf

                                <input type="text" class="form-control"
                                    placeholder="{{ __('translate.Your Name') }}" name="name" value="{{ old('name') }}">

                                <input type="email" class="form-control"
                                    placeholder="{{ __('translate.Your Email') }}" name="email" value="{{ old('email') }}">

                                <input type="text" class="form-control"
                                    placeholder="{{ __('translate.Your Phone') }}" name="phone" value="{{ old('phone') }}">

                                <input type="text" class="form-control"
                                    placeholder="{{ __('translate.Your Subject') }}" name="subject" value="{{ old('subject') }}">

                                <textarea class="form-control two" rows="5" placeholder="{{ __('translate.Type Message') }}" name="message">{{ old('message') }}</textarea>

                                @if($google_recaptcha->status==1)
                                    <div class="g-recaptcha" data-sitekey="{{ $google_recaptcha->site_key }}"></div>
                                @endif

                                <div class="motorcycle-form-btn">
                                    <button type="submit" class="send-bnt"> {{ __('translate.Send Message') }}</button>

                                    @if ($listing->category_id == 3)
                                        <button type="button" class="send-bnt apply-now-btn" data-bs-toggle="modal"
                                            data-bs-target="#exampleModal2">
                                            {{ __('translate.Apply Now') }}
                                        </button>
                                    @endif

                                </div>
                            </form>
                        </div>
                    </div>



                    @if ($listing_sidebar_ads->status == 'enable')
                    <div class="motorcycle-side-ber-ads">
                        <a href="{{ $listing_sidebar_ads->link }}" target="_blank"><img src="{{ asset($listing_sidebar_ads->image) }}" alt="img"></a>
                    </div>
                    @endif


                </div>
            </div>
        </div>
    </section>


    <!--report Modal -->
    <div class="modal fade report-modal " id="exampleModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="exampleModalLabel">
                        {{ __('translate.Report to Admin') }}
                    </h4>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form class="report-modal-form" action="{{ route('store-report') }}" method="POST">
                        @csrf
                        <input type="hidden" name="listing_id" value="{{ $listing->id }}">
                        <input type="hidden" name="agent_id" value="{{ $listing->agent_id }}">

                        <div class="report-modal-form-item">
                            <div class="report-modal-form-inner">
                                <label for="report_name" class="form-label">{{ __('translate.Name') }}
                                    <span>*</span></label>
                                <input type="text" class="form-control" id="report_name"
                                    placeholder="{{ __('translate.Type Name') }}" name="name" value="{{ old('name') }}">
                            </div>
                            <div class="report-modal-form-inner">
                                <label for="report_mail" class="form-label">{{ __('translate.Email') }}
                                    <span>*</span></label>
                                <input type="email" class="form-control" id="report_mail"
                                    placeholder="{{ __('translate.Type Email') }}" name="email" value="{{ old('email') }}">
                            </div>
                            <div class="report-modal-form-inner two">
                                <label for="report_reasone" class="form-label">{{ __('translate.Reason') }}
                                    <span>*</span></label>
                                <textarea class="form-control" rows="5" placeholder="{{ __('translate.Describe your reason') }}" id="report_reasone" name="message">{{ old('message') }}</textarea>
                            </div>

                            @if($google_recaptcha->status==1)
                                <div class="report-modal-form-inner two">
                                    <div class="g-recaptcha" data-sitekey="{{ $google_recaptcha->site_key }}"></div>
                                </div>
                            @endif

                            <div class="report-modal-form-inner">
                                <button type="submit" class="report-modal-btn"> {{ __('translate.Submit Report') }}</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>


    <!-- Apply Modal -->
    <div class="modal apply-modal stripe-modal  fade" id="exampleModal2" tabindex="-1"
        aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">
                        {{ __('translate.Apply for New Job') }}
                    </h5>
                </div>
                <div class="modal-body">
                    <form method="POST" action="{{ route('store-job-request', $listing->id) }}" id="job_application_form">
                        @csrf

                        <input type="hidden" name="listing_id" value="{{ $listing->id }}">
                        <input type="hidden" name="agent_id" value="{{ $listing->agent_id }}">

                        <div class="apply-modal-form">
                            <div class="alert alert-danger" role="alert">
                                {{ __('translate.Your profile information will be added with application') }}
                            </div>
                            <textarea class="form-control" id="job_description" rows="3"
                                placeholder="{{ __('translate.Type your message') }}" name="description">{{ old('description') }}</textarea>
                        </div>

                        @if($google_recaptcha->status==1)
                            <div class="apply-modal-form mt-4">
                                <div class="g-recaptcha" data-sitekey="{{ $google_recaptcha->site_key }}"></div>
                            </div>
                        @endif

                    </form>
                </div>

                <div class="modal-footer">
                    <a class="main-btn " href="javascript:;" data-bs-dismiss="modal">
                        <div class="btn_m">
                            <div class="btn_c">
                                <div class="btn_t1">{{ __('translate.Close') }}</div>
                                <div class="btn_t2">{{ __('translate.Close') }}</div>
                            </div>
                        </div>
                    </a>

                    @guest('web')
                        <a class="main-btn  two before_auth_wishlist" href="javascript:;">
                            <div class="btn_m">
                                <div class="btn_c">
                                    <div class="btn_t1">{{ __('translate.Apply') }}</div>
                                    <div class="btn_t2">{{ __('translate.Apply') }}</div>
                                </div>
                            </div>
                        </a>
                    @else
                        <a class="main-btn  two" href="javascript:;" id="job_application_form_btn">
                            <div class="btn_m">
                                <div class="btn_c">
                                    <div class="btn_t1">{{ __('translate.Apply') }}</div>
                                    <div class="btn_t2">{{ __('translate.Apply') }}</div>
                                </div>
                            </div>
                        </a>
                    @endguest
                </div>

            </div>
        </div>
    </div>
    <!--Motorcycle part end  -->



    <!-- Related Ads Listings start  -->
    @if($related_listings->count() > 0)
    <section class="related-ads footer-top-pad">
        <div class="container">
            <div class="row">
                <div class="col-lg-6 col-sm-8 ">
                    <h2 class="related-ads-taitel">{{ __('translate.Related Listings') }}</h2>
                </div>

                <div class="col-lg-6  col-sm-4 ">
                    <div class="related-ads-arrow">
                        <div class="arrow-left">
                            <span>
                                <svg width="8" height="14" viewBox="0 0 8 14" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M6.62974 13.6666C6.83732 13.6075 7.01895 13.5076 7.15842 13.3117C7.3887 12.9789 7.39518 12.4983 7.16166 12.1655C7.11625 12.1027 7.0676 12.0398 7.01571 11.9807C5.5951 10.3613 4.17126 8.73818 2.75065 7.11879C2.71822 7.08181 2.6793 7.05223 2.62092 6.9635C2.65984 6.93762 2.70849 6.92283 2.74092 6.88586C4.17774 5.25167 5.61132 3.61379 7.04814 1.9796C7.30113 1.69121 7.39843 1.35846 7.28815 0.959158C7.12598 0.378689 6.47082 0.142065 6.04269 0.508094C5.99404 0.548763 5.94864 0.596826 5.90323 0.644891C4.2491 2.53049 2.59497 4.41239 0.944088 6.29799C0.642452 6.64184 0.584072 7.07812 0.785161 7.47372C0.833812 7.56985 0.905166 7.65489 0.973277 7.73253C2.57875 9.56267 4.18423 11.3891 5.78646 13.223C5.96485 13.4263 6.14648 13.6075 6.40271 13.6666C6.47731 13.6666 6.5519 13.6666 6.62974 13.6666Z" />
                                </svg>
                            </span>
                        </div>


                        <div class="arrow-right">
                            <span>
                                <svg width="8" height="14" viewBox="0 0 8 14" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M1.37026 0.333374C1.16268 0.39253 0.981049 0.492356 0.841583 0.688311C0.611303 1.02106 0.604816 1.50171 0.83834 1.83446C0.883747 1.89731 0.932398 1.96017 0.984292 2.01932C2.4049 3.63872 3.82874 5.26182 5.24935 6.88121C5.28178 6.91819 5.3207 6.94776 5.37908 7.0365C5.34016 7.06238 5.29151 7.07717 5.25908 7.11414C3.82226 8.74833 2.38868 10.3862 0.951858 12.0204C0.698874 12.3088 0.601572 12.6415 0.711847 13.0408C0.874016 13.6213 1.52918 13.8579 1.95731 13.4919C2.00596 13.4512 2.05137 13.4032 2.09677 13.3551C3.7509 11.4695 5.40503 9.5876 7.05591 7.702C7.35755 7.35816 7.41593 6.92188 7.21484 6.52628C7.16619 6.43015 7.09483 6.34511 7.02672 6.26747C5.42125 4.43733 3.81577 2.61088 2.21354 0.777045C2.03515 0.573696 1.85352 0.39253 1.59729 0.333374C1.52269 0.333374 1.4481 0.333374 1.37026 0.333374Z" />
                                </svg>
                            </span>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row related-ads-slick {{ $listing->category_id == 3 ? 'job-listing common-class' : '' }}">
                @foreach ($related_listings as $related_listing)
                    @if ($listing->category_id == 3)
                        <div class="col-xxl-3 ">
                            <div class="job-listing-item">
                                <div class="job-listing-item-inner">
                                    <div class="job-listing-img">
                                        <img src="{{ asset($related_listing->thumb_image) }}" alt="img">
                                    </div>

                                    <div class="job-listing-img-btn">
                                        @guest('web')
                                            <a href="javascript:;" class="before_auth_wishlist">
                                                <span>
                                                    <svg width="24" height="21" viewBox="0 0 20 18" fill="none"
                                                        xmlns="http://www.w3.org/2000/svg">
                                                        <path
                                                            d="M10.765 1.70229L10 2.52422L9.23495 1.70229C7.12233 -0.567428 3.69709 -0.56743 1.58447 1.70229C-0.528155 3.972 -0.528156 7.65194 1.58447 9.92165L8.4699 17.3191C9.31495 18.227 10.685 18.227 11.5301 17.3191L18.4155 9.92165C20.5282 7.65194 20.5282 3.972 18.4155 1.70229C16.3029 -0.567429 12.8777 -0.567429 10.765 1.70229Z" />
                                                    </svg>
                                                </span>
                                            </a>
                                        @else
                                            <a href="{{ route('user.add-to-wishlist', $related_listing->id) }}">
                                                <span>
                                                    <svg width="24" height="21" viewBox="0 0 20 18" fill="none"
                                                        xmlns="http://www.w3.org/2000/svg">
                                                        <path
                                                            d="M10.765 1.70229L10 2.52422L9.23495 1.70229C7.12233 -0.567428 3.69709 -0.56743 1.58447 1.70229C-0.528155 3.972 -0.528156 7.65194 1.58447 9.92165L8.4699 17.3191C9.31495 18.227 10.685 18.227 11.5301 17.3191L18.4155 9.92165C20.5282 7.65194 20.5282 3.972 18.4155 1.70229C16.3029 -0.567429 12.8777 -0.567429 10.765 1.70229Z" />
                                                    </svg>
                                                </span>
                                            </a>
                                        @endguest

                                        @if ($related_listing->is_urgent == 'enable')
                                            <span class="txt">{{ __('translate.Urgent') }}</span>
                                        @endif
                                    </div>
                                </div>

                                <div class="job-listing-content">
                                    <p>{{ currency($related_listing->regular_price) }}/{{ __('translate.m') }}</p>

                                    <a href="{{ route('listing', $related_listing->slug) }}">
                                        <h3 class="job-listing-content-link">{{ html_decode($related_listing->title) }}</h3>
                                    </a>
                                </div>

                                <div class="job-listing-content-btn">
                                    <a href="javascript:;">
                                        <span>
                                            <svg width="10" height="11" viewBox="0 0 10 11" fill="none"
                                                xmlns="http://www.w3.org/2000/svg">
                                                <path fill-rule="evenodd" clip-rule="evenodd"
                                                    d="M2.97888 0.513554C2.97888 0.298962 2.80492 0.125 2.59032 0.125C2.37573 0.125 2.20177 0.298962 2.20177 0.513554V1.7167C1.35167 2.14527 0.675371 2.86822 0.306805 3.75163H9.0185C8.64993 2.86823 7.97365 2.14529 7.12357 1.71672V0.513554C7.12357 0.298962 6.94961 0.125 6.73501 0.125C6.52042 0.125 6.34646 0.298962 6.34646 0.513554V1.4222C6.02048 1.33638 5.67823 1.29067 5.3253 1.29067H4C3.64709 1.29067 3.30485 1.33638 2.97888 1.42219V0.513554ZM0 5.29067C0 5.03013 0.0249108 4.7754 0.0724807 4.52874H9.25282C9.30039 4.7754 9.3253 5.03013 9.3253 5.29068V6.87501C9.3253 9.08415 7.53444 10.875 5.3253 10.875H4C1.79086 10.875 0 9.08415 0 6.87501V5.29067ZM4.66263 7.76653C4.94876 7.76653 5.18071 7.53458 5.18071 7.24846C5.18071 6.96234 4.94876 6.73039 4.66263 6.73039C4.37651 6.73039 4.14456 6.96234 4.14456 7.24846C4.14456 7.53458 4.37651 7.76653 4.66263 7.76653ZM7.25274 7.24846C7.25274 7.53458 7.02079 7.76653 6.73467 7.76653C6.44854 7.76653 6.21659 7.53458 6.21659 7.24846C6.21659 6.96234 6.44854 6.73039 6.73467 6.73039C7.02079 6.73039 7.25274 6.96234 7.25274 7.24846ZM2.59029 7.76653C2.87641 7.76653 3.10836 7.53458 3.10836 7.24846C3.10836 6.96234 2.87641 6.73039 2.59029 6.73039C2.30417 6.73039 2.07222 6.96234 2.07222 7.24846C2.07222 7.53458 2.30417 7.76653 2.59029 7.76653Z" />
                                            </svg>
                                        </span>

                                        {{ $related_listing->created_at->diffForHumans() }}
                                    </a>


                                    <a href="javascript:;">
                                        <span>
                                            <svg width="10" height="11" viewBox="0 0 10 11" fill="none"
                                                xmlns="http://www.w3.org/2000/svg">
                                                <path fill-rule="evenodd" clip-rule="evenodd"
                                                    d="M4.81644 11C6.56164 11 9.47029 7.58895 9.47029 4.88889C9.47029 2.18883 7.38669 0 4.81644 0C2.2462 0 0.162598 2.18883 0.162598 4.88889C0.162598 7.58895 3.07125 11 4.81644 11ZM4.81631 6.59992C5.67306 6.59992 6.36759 5.86119 6.36759 4.94992C6.36759 4.03865 5.67306 3.29992 4.81631 3.29992C3.95956 3.29992 3.26502 4.03865 3.26502 4.94992C3.26502 5.86119 3.95956 6.59992 4.81631 6.59992Z" />
                                            </svg>
                                        </span>

                                        {{ html_decode($related_listing->address) }}
                                    </a>
                                </div>

                                <div class="job-listing-btn">
                                    <a class="main-btn " href="{{ route('listing', ['slug' => $related_listing->slug,'is_apply' => 'yes']) }}">
                                        <div class="btn_m">
                                            <div class="btn_c">
                                                <div class="btn_t1">{{ __('translate.Apply Now') }}</div>
                                                <div class="btn_t2">{{ __('translate.Apply Now') }}</div>
                                            </div>
                                        </div>
                                    </a>
                                    <a class="main-btn two " href="{{ route('listing', $related_listing->slug) }}">
                                        <div class="btn_m">
                                            <div class="btn_c">
                                                <div class="btn_t1">{{ __('translate.Detail Now') }}</div>
                                                <div class="btn_t2">{{ __('translate.Detail Now') }}</div>
                                            </div>
                                        </div>
                                    </a>


                                </div>
                            </div>
                        </div>
                    @else
                        <div class="col-xxl-3">
                            <div class="features-single-box ">
                                <div class="features-thumb">
                                    <img src="{{ asset($related_listing->thumb_image) }}" alt="img">
                                </div>

                                <div class="features-single-box-over">
                                    <div class="text">
                                        @if ($related_listing->is_urgent == 'enable')
                                        <p>{{ __('translate.Urgent') }}</p>
                                        @endif

                                        @if ($related_listing->is_featured == 'enable')
                                        <h6>{{ __('translate.Featured') }}</h6>
                                        @endif
                                    </div>

                                    <div class="icon">
                                        @guest('web')
                                            <a href="javascript:;" class="before_auth_wishlist">
                                                <span>
                                                    <svg width="24" height="21" viewBox="0 0 20 18" fill="none"
                                                        xmlns="http://www.w3.org/2000/svg">
                                                        <path
                                                            d="M10.765 1.70229L10 2.52422L9.23495 1.70229C7.12233 -0.567428 3.69709 -0.56743 1.58447 1.70229C-0.528155 3.972 -0.528156 7.65194 1.58447 9.92165L8.4699 17.3191C9.31495 18.227 10.685 18.227 11.5301 17.3191L18.4155 9.92165C20.5282 7.65194 20.5282 3.972 18.4155 1.70229C16.3029 -0.567429 12.8777 -0.567429 10.765 1.70229Z" />
                                                    </svg>
                                                </span>
                                            </a>
                                        @else
                                        <a href="{{ route('user.add-to-wishlist', $related_listing->id) }}">
                                                <span>
                                                    <svg width="24" height="21" viewBox="0 0 20 18" fill="none"
                                                        xmlns="http://www.w3.org/2000/svg">
                                                        <path
                                                            d="M10.765 1.70229L10 2.52422L9.23495 1.70229C7.12233 -0.567428 3.69709 -0.56743 1.58447 1.70229C-0.528155 3.972 -0.528156 7.65194 1.58447 9.92165L8.4699 17.3191C9.31495 18.227 10.685 18.227 11.5301 17.3191L18.4155 9.92165C20.5282 7.65194 20.5282 3.972 18.4155 1.70229C16.3029 -0.567429 12.8777 -0.567429 10.765 1.70229Z" />
                                                    </svg>
                                                </span>
                                            </a>
                                        @endguest

                                    </div>
                                </div>


                                <div class="features-single-box-inner">
                                    <div class="features-single-box-inner-txt">
                                        <p>

                                            <span>
                                                <svg width="11" height="12" viewBox="0 0 11 12" fill="none"
                                                    xmlns="http://www.w3.org/2000/svg">
                                                    <path
                                                        d="M10.9992 3.43661C10.9992 4.03851 11.001 4.63998 10.9984 5.24188C10.9971 5.59777 10.8734 5.90712 10.6216 6.16046C10.253 6.53143 9.88231 6.89981 9.51201 7.26948C8.1817 8.59823 6.8514 9.92699 5.52152 11.2562C5.40297 11.3747 5.27925 11.485 5.11717 11.5405C4.78523 11.6543 4.47658 11.6069 4.21276 11.3772C3.99593 11.1881 3.79548 10.9796 3.59158 10.7762C2.52854 9.71458 1.46636 8.65166 0.405044 7.58874C0.330468 7.51421 0.257184 7.43708 0.192523 7.35393C-0.0816435 6.99977 -0.0622449 6.50946 0.245976 6.18287C0.471862 5.94331 0.708524 5.71367 0.941737 5.48058C2.27248 4.14967 3.60365 2.81919 4.93439 1.48872C5.11415 1.30905 5.29089 1.12594 5.47453 0.949719C5.70904 0.724383 5.99527 0.604606 6.31815 0.602882C7.545 0.597712 8.77142 0.600728 9.99827 0.600728C10.275 0.600728 10.5255 0.673111 10.7251 0.876474C10.8854 1.03977 10.982 1.23494 10.9885 1.46502C10.9971 1.79979 10.9975 2.13457 10.9992 2.46934C11.001 2.79162 10.9992 3.1139 10.9992 3.43618V3.43661ZM9.16327 3.35733C9.1706 2.86228 8.77271 2.45254 8.28603 2.4353C7.76571 2.41678 7.3355 2.82695 7.33075 3.34656C7.32644 3.83773 7.72562 4.24963 8.21059 4.26902C8.72616 4.2897 9.17318 3.86703 9.16327 3.35733Z" />
                                                </svg>
                                            </span>
                                            {{ $related_listing?->sub_category?->name }}
                                        </p>

                                        <span>
                                            {{ currency($related_listing->regular_price) }}
                                        </span>
                                    </div>


                                    <a href="{{ route('listing', $related_listing->slug) }}">
                                        <h3>{{ html_decode($related_listing->title) }}</h3>
                                    </a>


                                    <div class="features-single-box-contact">
                                        <div class="location">
                                            <p><a href="javascript:;">
                                                    <span>
                                                        <svg width="11" height="13" viewBox="0 0 11 13" fill="none"
                                                            xmlns="http://www.w3.org/2000/svg">
                                                            <path fill-rule="evenodd" clip-rule="evenodd"
                                                                d="M5.5 13C7.5625 13 11 8.96876 11 5.77778C11 2.5868 8.53757 0 5.5 0C2.46243 0 0 2.5868 0 5.77778C0 8.96876 3.4375 13 5.5 13ZM5.5 7.7999C6.51252 7.7999 7.33333 6.92686 7.33333 5.8499C7.33333 4.77295 6.51252 3.8999 5.5 3.8999C4.48748 3.8999 3.66667 4.77295 3.66667 5.8499C3.66667 6.92686 4.48748 7.7999 5.5 7.7999Z" />
                                                        </svg>
                                                    </span>
                                                    {{ html_decode($related_listing->address) }}
                                                </a>
                                            </p>
                                        </div>

                                        <div class="contact">
                                            <p>
                                                <a href="{{ route('agent', $related_listing?->agent?->username) }}">
                                                    <span>
                                                        <svg width="13" height="16" viewBox="0 0 13 16" fill="none"
                                                            xmlns="http://www.w3.org/2000/svg">
                                                            <path fill-rule="evenodd" clip-rule="evenodd"
                                                                d="M6.22222 7.11111C8.1859 7.11111 9.77778 5.51923 9.77778 3.55556C9.77778 1.59188 8.1859 0 6.22222 0C4.25854 0 2.66667 1.59188 2.66667 3.55556C2.66667 5.51923 4.25854 7.11111 6.22222 7.11111ZM6.22222 16C9.65866 16 12.4444 14.4081 12.4444 12.4444C12.4444 10.4808 9.65866 8.88889 6.22222 8.88889C2.78578 8.88889 0 10.4808 0 12.4444C0 14.4081 2.78578 16 6.22222 16Z" />
                                                        </svg>
                                                    </span>
                                                    {{ $related_listing?->agent?->name }}
                                                </a>
                                            </p>
                                            <p>
                                                <a href="javascript:;">
                                                    <span>
                                                        <svg width="15" height="17" viewBox="0 0 15 17" fill="none"
                                                            xmlns="http://www.w3.org/2000/svg">
                                                            <path fill-rule="evenodd" clip-rule="evenodd"
                                                                d="M4.64157 0.605422C4.64157 0.271056 4.37051 0 4.03614 0C3.70178 0 3.43072 0.271057 3.43072 0.605422V1.85647C1.54458 2.12521 0.0823859 3.70969 0.00336393 5.65071H14.5268C14.4477 3.70969 12.9855 2.12521 11.0994 1.85647V0.605422C11.0994 0.271057 10.8283 0 10.494 0C10.1596 0 9.88855 0.271057 9.88855 0.605422V1.81627H4.64157L4.64157 0.605422ZM1.54674e-05 6.86155H14.5301V12.75C14.5301 14.9591 12.7393 16.75 10.5301 16.75H4C1.79086 16.75 0 14.9591 0 12.75V6.86155H1.54674e-05ZM7.26508 11.9066C7.7109 11.9066 8.0723 11.5452 8.0723 11.0994C8.0723 10.6536 7.7109 10.2922 7.26508 10.2922C6.81926 10.2922 6.45785 10.6536 6.45785 11.0994C6.45785 11.5452 6.81926 11.9066 7.26508 11.9066ZM11.3012 11.0994C11.3012 11.5452 10.9398 11.9066 10.494 11.9066C10.0482 11.9066 9.68676 11.5452 9.68676 11.0994C9.68676 10.6536 10.0482 10.2922 10.494 10.2922C10.9398 10.2922 11.3012 10.6536 11.3012 11.0994ZM4.03616 11.9066C4.48198 11.9066 4.84339 11.5452 4.84339 11.0994C4.84339 10.6536 4.48198 10.2922 4.03616 10.2922C3.59034 10.2922 3.22893 10.6536 3.22893 11.0994C3.22893 11.5452 3.59034 11.9066 4.03616 11.9066Z" />
                                                        </svg>
                                                    </span>
                                                    {{ $related_listing->created_at->diffForHumans() }}
                                                </a>
                                            </p>
                                        </div>
                                    </div>

                                </div>

                            </div>
                        </div>
                    @endif
                @endforeach
            </div>
        </div>
    </section>
    @endif
    <!-- Related Ads Listings end -->





</main>

@endsection


@push('js_section')

    <script src="https://www.google.com/recaptcha/api.js" async defer></script>


    <script>
        (function($) {
            "use strict"
            $(document).ready(function () {
                $('#review_form_btn').on("click", function(){
                    $("#review_form").submit();
                });

                $('#job_application_form_btn').on("click", function(){
                    $("#job_application_form").submit();
                });


            });
        })(jQuery);

        function listingReview(rating){
            $(".listing_rat").each(function(){
                var listing_rat = $(this).data('rating')
                if(listing_rat > rating){
                    $(this).removeClass('fa-solid fa-star').addClass('fa-regular fa-star');
                }else{
                    $(this).removeClass('fa-regular fa-star').addClass('fa-solid fa-star');
                }
            })

            $("#listing_rating").val(rating);
            $("#rating_visible").html(`(${rating}.0)`);
        }

        function checkApply(){

            var urlParams = new URLSearchParams(window.location.search);
            var isApply = urlParams.get('is_apply');
            if (isApply !== null) {
                $(".apply-now-btn").click();
            }


        }

        checkApply();
    </script>




@endpush

