@extends('layout')
@section('title')
    <title>{{ $seo_setting->seo_title }}</title>
    <meta name="title" content="{{ $seo_setting->seo_title }}">
    <meta name="description" content="{!! strip_tags(clean($seo_setting->seo_description)) !!}">
@endsection

@section('body-content')

<main>


    <!-- banner part start  -->

    <div class=" banner-three common-class">
        <div class="banner-img" style="background-image: url({{ asset($homepage->home3_intro_bg) }});"></div>

        <div class="container">
            <div class="row">
                <div class="col-lg-8">
                    <span class="banner-three-dec">{{ $homepage->home3_intro_short_title }}</span>

                    <h1 class="banner-three-taitel">{{ $homepage->home3_intro_title }}</h1>

                    <p class="banner-three-des">{{ $homepage->home3_intro_des }}</p>

                    <form class="banner-sarch-bar" action="{{ route('listings') }}" id="intro_search_form">
                        <input type="hidden" name="category" value="realestate">
                        <div class="banner-sarch-bar-item">
                            <div class="banner-sarch-bar-item-inner">
                                <div class="f-select">
                                    <select class="form-select select2" name="country">
                                        <option selected value="">
                                            {{ __('translate.Country') }}
                                        </option>
                                        @foreach ($countries as $country)
                                            <option value="{{ $country->id }}">{{ $country->name }}</option>
                                        @endforeach
                                    </select>
                                </div>


                            </div>
                            <div class="banner-sarch-bar-item-inner">
                                <div class="f-select">
                                    <select class="form-select select2" name="sub_category_id">

                                        <option selected value="">
                                            {{ __('translate.Category') }}
                                        </option>
                                        @foreach ($realestate_sub_categories as $sub_category)
                                            <option value="{{ $sub_category->id }}">{{ $sub_category->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="banner-sarch-bar-item-inner">
                                <div class="f-select">
                                    <select class="form-select select2" name="price_filter">
                                        <option selected="">{{ __('translate.Price') }}</option>
                                        <option value="low_to_high">{{ __('translate.Low Price') }}</option>
                                        <option value="high_to_low">{{ __('translate.High Price') }}</option>
                                    </select>
                                </div>


                            </div>
                            <div class="banner-sarch-bar-item-inner ">
                                <a class="main-btn " href="javascript:;" id="intro_form_submit">
                                    <div class="btn_m">
                                        <div class="btn_c">
                                            <div class="btn_t1">{{ __('translate.Find Job') }}</div>
                                            <div class="btn_t2">{{ __('translate.Find Job') }}</div>
                                        </div>
                                    </div>
                                </a>
                            </div>
                        </div>

                    </form>

                </div>

                <div class="col-lg-12">
                    <div class="banner-three-thumb">
                        <img src="{{ asset($homepage->home3_intro_image) }}" alt="img">
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- banner part end  -->






    <!-- Properties part start  -->
    <section class="properties common-class">
        <div class="container">
            <div class="row align-items-end">
                <div class="col-lg-4 ">
                    <h2 class="taitel">{{ __('translate.Browse all Properties') }}</h2>
                </div>

                <div class="col-lg-8">
                    <ul class="shaf-filter course-filter ">
                        <li class="active" data-group="all">{{ __('translate.All') }}</li>
                        @foreach ($realestate_sub_categories as $realestate_sub_category)
                        <li data-group="realestatecat_{{ $realestate_sub_category->id }}">{{ $realestate_sub_category->name }}</li>
                        @endforeach
                    </ul>
                </div>
            </div>

            <!-- Filter Content -->
            <div class="row g-3 mt-20px shafull-container">

                @foreach ($realestate_latest_listings as $latest_listing)
                    <div class=" col-xl-4 col-lg-4 col-sm-6  col-md-6 shaf-item  " data-groups='[  "realestatecat_{{
                    $latest_listing->sub_category_id }}" ]'>
                        <div class="properties-item">
                            <div class="properties-item-img">

                                <img src="{{ asset($latest_listing->thumb_image) }}" alt="img">
                            </div>

                            <div class="properties-inner">
                                <div class="properties-inner-top">
                                    <p>
                                        <span>
                                            <svg width="11" height="12" viewBox="0 0 11 12" fill="none"
                                                xmlns="http://www.w3.org/2000/svg">
                                                <path
                                                    d="M10.9992 3.43685C10.9992 4.03875 11.001 4.64023 10.9984 5.24213C10.9971 5.59801 10.8734 5.90737 10.6216 6.16071C10.253 6.53167 9.88231 6.90005 9.51201 7.26973C8.1817 8.59848 6.8514 9.92723 5.52152 11.2564C5.40297 11.3749 5.27925 11.4852 5.11717 11.5408C4.78523 11.6545 4.47658 11.6071 4.21276 11.3775C3.99593 11.1883 3.79548 10.9798 3.59158 10.7764C2.52854 9.71482 1.46636 8.65191 0.405044 7.58899C0.330468 7.51445 0.257184 7.43733 0.192523 7.35417C-0.0816435 7.00001 -0.0622449 6.5097 0.245976 6.18311C0.471862 5.94356 0.708524 5.71391 0.941737 5.48082C2.27248 4.14991 3.60365 2.81944 4.93439 1.48896C5.11415 1.3093 5.29089 1.12618 5.47453 0.949964C5.70904 0.724627 5.99527 0.60485 6.31815 0.603126C7.545 0.597956 8.77142 0.600972 9.99827 0.600972C10.275 0.600972 10.5255 0.673356 10.7251 0.876718C10.8854 1.04001 10.982 1.23519 10.9885 1.46526C10.9971 1.80004 10.9975 2.13481 10.9992 2.46958C11.001 2.79186 10.9992 3.11414 10.9992 3.43642V3.43685ZM9.16327 3.35757C9.1706 2.86252 8.77271 2.45278 8.28603 2.43555C7.76571 2.41702 7.3355 2.82719 7.33075 3.3468C7.32644 3.83798 7.72562 4.24987 8.21059 4.26926C8.72616 4.28994 9.17318 3.86727 9.16327 3.35757Z" />
                                            </svg>
                                        </span>

                                        {{ $latest_listing?->sub_category?->name }}
                                    </p>
                                </div>

                                <a href="{{ route('listing', $latest_listing->slug) }}">
                                    <h3 class="properties-link">{{ html_decode($latest_listing->title) }}</h3>
                                </a>

                                <h5 class="amount">
                                    {{ currency($latest_listing->regular_price) }}
                                </h5>
                            </div>
                        </div>
                    </div>
                @endforeach

            </div>

            @if ($home3_ads->status == 'enable')
                <div class="row">
                    <div class="col-lg-12">
                        <div class="properties-ads">
                            <a target="_blank" href="{{ $home3_ads->link }}"> <img src="{{ asset($home3_ads->image) }}" alt="img"></a>
                        </div>
                    </div>
                </div>
            @endif

        </div>
    </section>
    <!-- Properties part end  -->



    <!--  Perfect City part start  -->


    <section class=" perfect-city  common-class">
        <div class="container">


            <div class="row align-items-end">
                <div class="col-lg-6">
                    <h2 class="taitel">{{ __('translate.Find the Perfect City') }}</h2>
                </div>
                <div class="col-lg-6">
                    <a href="{{ route('listings', ['category' => 'realestate']) }}" class="features-view-btn">{{ __('translate.View More') }}
                        <span>
                            <svg width="14" height="10" viewBox="0 0 14 10" fill="none"
                                xmlns="http://www.w3.org/2000/svg">
                                <path d="M9 9L13 5M13 5L9 1M13 5L1 5" stroke-width="1.5" stroke-linecap="round"
                                    stroke-linejoin="round" />
                            </svg>
                        </span>
                    </a>
                </div>
            </div>


            <div class="row g-3 row-cols-5 mt-20px">
                @if (isset($cities[0]))
                    <div class="col">
                        <div class="perfect-city-item">
                            <div class="perfect-city-thumb">
                                <img src="{{ asset($cities[0]->image) }}" alt="img">

                                <div class="perfect-city-thumb-over">
                                    <h4>{{ $cities[0]->total_realestate_listing }}+ {{ __('translate.Listing') }}</h4>
                                    <a href="{{ route('listings', ['location' => $cities[0]->id, 'country' => $cities[0]->country_id , 'category' => 'realestate']) }}">{{ $cities[0]->name }}</a>
                                </div>
                            </div>
                        </div>
                    </div>
                @endif

                @if (isset($cities[1]) && isset($cities[2]))
                    <div class="col">
                        <div class="perfect-city-item">

                            @if ($cities[1])
                                <div class="perfect-city-thumb two">
                                    <img src="{{ asset($cities[1]->image) }}" alt="img">

                                    <div class="perfect-city-thumb-over">
                                        <h4>{{ $cities[1]->total_realestate_listing }}+ {{ __('translate.Listing') }}</h4>
                                        <a href="{{ route('listings', ['location' => $cities[1]->id, 'country' => $cities[1]->country_id , 'category' => 'realestate']) }}">{{ $cities[1]->name }}</a>
                                    </div>
                                </div>
                            @endif

                            @if ($cities[2])
                                <div class="perfect-city-thumb three mt-30px">
                                    <img src="{{ asset($cities[2]->image) }}" alt="img">

                                    <div class="perfect-city-thumb-over">
                                        <h4>{{ $cities[2]->total_realestate_listing }}+ {{ __('translate.Listing') }}</h4>
                                        <a href="{{ route('listings', ['location' => $cities[2]->id, 'country' => $cities[2]->country_id , 'category' => 'realestate']) }}">{{ $cities[2]->name }}</a>
                                    </div>
                                </div>
                            @endif

                        </div>
                    </div>
                @endif

                @if (isset($cities[3]))
                    <div class="col">
                        <div class="perfect-city-item">
                            <div class="perfect-city-thumb">
                                <img src="{{ asset($cities[3]->image) }}" alt="img">
                                <div class="perfect-city-thumb-over">
                                    <h4>{{ $cities[3]->total_realestate_listing }}+ {{ __('translate.Listing') }}</h4>
                                    <a href="{{ route('listings', ['location' => $cities[3]->id, 'country' => $cities[3]->country_id , 'category' => 'realestate']) }}">{{ $cities[3]->name }}</a>
                                </div>
                            </div>
                        </div>
                    </div>
                @endif

                @if (isset($cities[4]) && isset($cities[5]))
                    <div class="col">
                        <div class="perfect-city-item">

                            @if (isset($cities[4]))
                                <div class="perfect-city-thumb three">
                                    <img src="{{ asset($cities[4]->image) }}" alt="img">

                                    <div class="perfect-city-thumb-over">
                                        <h4>{{ $cities[4]->total_realestate_listing }}+ {{ __('translate.Listing') }}</h4>
                                        <a href="{{ route('listings', ['location' => $cities[4]->id, 'country' => $cities[4]->country_id , 'category' => 'realestate']) }}">{{ $cities[4]->name }}</a>
                                    </div>
                                </div>
                            @endif

                            @if (isset($cities[5]))
                                <div class="perfect-city-thumb two mt-30px">
                                    <img src="{{ asset($cities[5]->image) }}" alt="img">

                                    <div class="perfect-city-thumb-over">
                                        <h4>{{ $cities[5]->total_realestate_listing }}+ {{ __('translate.Listing') }}</h4>
                                        <a href="{{ route('listings', ['location' => $cities[5]->id, 'country' => $cities[5]->country_id , 'category' => 'realestate']) }}">{{ $cities[5]->name }}</a>
                                    </div>
                                </div>
                            @endif

                        </div>
                    </div>
                @endif

                @if (isset($cities[6]) && isset($cities[7]))
                    <div class="col">
                        <div class="perfect-city-item">

                            @if (isset($cities[6]))
                                <div class="perfect-city-thumb two ">
                                    <img src="{{ asset($cities[6]->image) }}" alt="img">

                                    <div class="perfect-city-thumb-over">
                                        <h4>{{ $cities[6]->total_realestate_listing }}+ {{ __('translate.Listing') }}</h4>
                                        <a href="{{ route('listings', ['location' => $cities[6]->id, 'country' => $cities[6]->country_id , 'category' => 'realestate']) }}">{{ $cities[6]->name }}</a>
                                    </div>
                                </div>
                            @endif

                            @if (isset($cities[7]))
                                <div class="perfect-city-thumb three mt-30px">
                                    <img src="{{ asset($cities[7]->image) }}" alt="img">

                                    <div class="perfect-city-thumb-over">
                                        <h4>{{ $cities[7]->total_realestate_listing }}+ {{ __('translate.Listing') }}</h4>
                                        <a href="{{ route('listings', ['location' => $cities[7]->id, 'country' => $cities[7]->country_id , 'category' => 'realestate']) }}">{{ $cities[7]->name }}</a>
                                    </div>
                                </div>
                            @endif

                        </div>
                    </div>
                @endif


            </div>

        </div>
    </section>

    <!--  Perfect City part end  -->



    <!-- Featured-Properties part start  -->


    <section class="featured-properties common-class">
        <div class="container">

            <div class="row">
                <div class="col-lg-6">
                    <h2 class="taitel">{{ __('translate.Featured Properties') }}</h2>
                </div>

                <div class="col-lg-6">
                     <div class="featured-properties-arrow">
                        <div class="left-arrow">
                            <span>
                                <svg width="8" height="14" viewBox="0 0 8 14" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M6.62926 13.6666C6.83683 13.6075 7.01846 13.5076 7.15793 13.3117C7.38821 12.9789 7.3947 12.4983 7.16117 12.1655C7.11576 12.1027 7.06711 12.0398 7.01522 11.9807C5.59462 10.3613 4.17077 8.73818 2.75017 7.11879C2.71773 7.08181 2.67881 7.05223 2.62043 6.9635C2.65935 6.93762 2.708 6.92283 2.74044 6.88586C4.17726 5.25167 5.61083 3.61379 7.04765 1.9796C7.30064 1.69121 7.39794 1.35846 7.28767 0.959158C7.1255 0.378689 6.47033 0.142065 6.04221 0.508094C5.99355 0.548763 5.94815 0.596826 5.90274 0.644891C4.24861 2.53049 2.59448 4.41239 0.943599 6.29799C0.641964 6.64184 0.583583 7.07812 0.784673 7.47372C0.833324 7.56985 0.904678 7.65489 0.972789 7.73253C2.57827 9.56267 4.18374 11.3891 5.78598 13.223C5.96436 13.4263 6.14599 13.6075 6.40222 13.6666C6.47682 13.6666 6.55142 13.6666 6.62926 13.6666Z" />
                                </svg>
                            </span>
                        </div>
                        <div class="right-arrow">
                            <span>
                                <svg width="8" height="14" viewBox="0 0 8 14" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M6.62926 13.6666C6.83683 13.6075 7.01846 13.5076 7.15793 13.3117C7.38821 12.9789 7.3947 12.4983 7.16117 12.1655C7.11576 12.1027 7.06711 12.0398 7.01522 11.9807C5.59462 10.3613 4.17077 8.73818 2.75017 7.11879C2.71773 7.08181 2.67881 7.05223 2.62043 6.9635C2.65935 6.93762 2.708 6.92283 2.74044 6.88586C4.17726 5.25167 5.61083 3.61379 7.04765 1.9796C7.30064 1.69121 7.39794 1.35846 7.28767 0.959158C7.1255 0.378689 6.47033 0.142065 6.04221 0.508094C5.99355 0.548763 5.94815 0.596826 5.90274 0.644891C4.24861 2.53049 2.59448 4.41239 0.943599 6.29799C0.641964 6.64184 0.583583 7.07812 0.784673 7.47372C0.833324 7.56985 0.904678 7.65489 0.972789 7.73253C2.57827 9.56267 4.18374 11.3891 5.78598 13.223C5.96436 13.4263 6.14599 13.6075 6.40222 13.6666C6.47682 13.6666 6.55142 13.6666 6.62926 13.6666Z" />
                                </svg>
                            </span>
                        </div>
                    </div>

                </div>
            </div>

            <div class="row">
            <div class="col-lg-12">
                    <div class="row featured-properties-slick ">
                        @foreach ($realestate_featured_listings as $featured_listing)
                            <div class="col-lg-4">
                                <div class="featured-properties-item">
                                    <div class="featured-properties-thumb">
                                        <img src="{{ asset($featured_listing->thumb_image) }}" alt="img">
                                        <div class="featured-properties-thumb-over">
                                            @if ($featured_listing->is_urgent == 'enable')
                                                <h6 class="thumb-over-txt">{{ __('translate.Urgent') }}</h6>
                                            @endif

                                            @if ($featured_listing->is_featured == 'enable')
                                                <h6 class="thumb-over-txt two">{{ __('translate.Featured') }}</h6>
                                            @endif

                                        </div>
                                        <div class="icon">
                                            @guest('web')
                                                <a href="javascript:;" class="before_auth_wishlist">
                                                    <span>
                                                        <svg width="24" height="21" viewBox="0 0 20 18" fill="none"
                                                            xmlns="http://www.w3.org/2000/svg">
                                                            <path
                                                                d="M10.765 1.70229L10 2.52422L9.23495 1.70229C7.12233 -0.567428 3.69709 -0.56743 1.58447 1.70229C-0.528155 3.972 -0.528156 7.65194 1.58447 9.92165L8.4699 17.3191C9.31495 18.227 10.685 18.227 11.5301 17.3191L18.4155 9.92165C20.5282 7.65194 20.5282 3.972 18.4155 1.70229C16.3029 -0.567429 12.8777 -0.567429 10.765 1.70229Z">
                                                            </path>
                                                        </svg>
                                                    </span>
                                                </a>
                                            @else
                                                <a href="{{ route('user.add-to-wishlist', $featured_listing->id) }}">
                                                    <span>
                                                        <svg width="24" height="21" viewBox="0 0 20 18" fill="none"
                                                            xmlns="http://www.w3.org/2000/svg">
                                                            <path
                                                                d="M10.765 1.70229L10 2.52422L9.23495 1.70229C7.12233 -0.567428 3.69709 -0.56743 1.58447 1.70229C-0.528155 3.972 -0.528156 7.65194 1.58447 9.92165L8.4699 17.3191C9.31495 18.227 10.685 18.227 11.5301 17.3191L18.4155 9.92165C20.5282 7.65194 20.5282 3.972 18.4155 1.70229C16.3029 -0.567429 12.8777 -0.567429 10.765 1.70229Z">
                                                            </path>
                                                        </svg>
                                                    </span>
                                                </a>
                                            @endguest
                                        </div>
                                    </div>

                                    <div class="featured-properties-inner">
                                        <div class="featured-properties-inner-txt">
                                            <p>
                                                <span>
                                                    <svg width="11" height="12" viewBox="0 0 11 12" fill="none"
                                                        xmlns="http://www.w3.org/2000/svg">
                                                        <path
                                                            d="M10.9992 3.43673C10.9992 4.03863 11.001 4.6401 10.9984 5.24201C10.9971 5.59789 10.8734 5.90724 10.6216 6.16059C10.253 6.53155 9.88231 6.89993 9.51201 7.2696C8.1817 8.59836 6.8514 9.92711 5.52152 11.2563C5.40297 11.3748 5.27925 11.4851 5.11717 11.5407C4.78523 11.6544 4.47658 11.607 4.21276 11.3774C3.99593 11.1882 3.79548 10.9797 3.59158 10.7763C2.52854 9.7147 1.46636 8.65178 0.405044 7.58887C0.330468 7.51433 0.257184 7.43721 0.192523 7.35405C-0.0816435 6.99989 -0.0622449 6.50958 0.245976 6.18299C0.471862 5.94344 0.708524 5.71379 0.941737 5.4807C2.27248 4.14979 3.60365 2.81932 4.93439 1.48884C5.11415 1.30917 5.29089 1.12606 5.47453 0.949842C5.70904 0.724505 5.99527 0.604728 6.31815 0.603004C7.545 0.597834 8.77142 0.60085 9.99827 0.60085C10.275 0.60085 10.5255 0.673233 10.7251 0.876596C10.8854 1.03989 10.982 1.23507 10.9885 1.46514C10.9971 1.79992 10.9975 2.13469 10.9992 2.46946C11.001 2.79174 10.9992 3.11402 10.9992 3.4363V3.43673ZM9.16327 3.35745C9.1706 2.8624 8.77271 2.45266 8.28603 2.43543C7.76571 2.4169 7.3355 2.82707 7.33075 3.34668C7.32644 3.83785 7.72562 4.24975 8.21059 4.26914C8.72616 4.28982 9.17318 3.86715 9.16327 3.35745Z" />
                                                    </svg>
                                                </span>
                                                {{ $featured_listing?->sub_category?->name }}
                                            </p>

                                            <h6>{{ currency($featured_listing->regular_price) }} <span>/{{ __('translate.m') }}</span></h6>
                                        </div>

                                        <a href="{{ route('listing', $featured_listing->slug) }}">
                                            <h3 class="featured-properties-link">{{ html_decode($featured_listing->title) }}</h3>
                                        </a>

                                        <div class="featured-properties-contact-box">
                                            <a href="javascript:;">
                                                <span>
                                                    <svg width="11" height="13" viewBox="0 0 11 13" fill="none"
                                                        xmlns="http://www.w3.org/2000/svg">
                                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                                            d="M5.5 13C7.5625 13 11 8.96876 11 5.77778C11 2.5868 8.53757 0 5.5 0C2.46243 0 0 2.5868 0 5.77778C0 8.96876 3.4375 13 5.5 13ZM5.5 7.7999C6.51252 7.7999 7.33333 6.92686 7.33333 5.8499C7.33333 4.77295 6.51252 3.8999 5.5 3.8999C4.48748 3.8999 3.66667 4.77295 3.66667 5.8499C3.66667 6.92686 4.48748 7.7999 5.5 7.7999Z" />
                                                    </svg>
                                                </span>

                                                {{ html_decode($featured_listing->address) }}
                                            </a>
                                            <div class="featured-properties-contact-box two">
                                                <a href="{{ route('agent', $featured_listing?->agent?->username) }}">
                                                    <span>
                                                        <svg width="12" height="16" viewBox="0 0 12 16" fill="none"
                                                            xmlns="http://www.w3.org/2000/svg">
                                                            <path fill-rule="evenodd" clip-rule="evenodd"
                                                                d="M6.00001 7.11111C7.89356 7.11111 9.42858 5.51923 9.42858 3.55556C9.42858 1.59188 7.89356 0 6.00001 0C4.10647 0 2.57144 1.59188 2.57144 3.55556C2.57144 5.51923 4.10647 7.11111 6.00001 7.11111ZM6 16C9.31371 16 12 14.4081 12 12.4444C12 10.4808 9.31371 8.88889 6 8.88889C2.68629 8.88889 0 10.4808 0 12.4444C0 14.4081 2.68629 16 6 16Z" />
                                                        </svg>
                                                    </span>
                                                    {{ $featured_listing?->agent?->name }}
                                                </a>
                                                <a href="javascript:;">
                                                    <span>
                                                        <svg width="15" height="17" viewBox="0 0 15 17" fill="none"
                                                            xmlns="http://www.w3.org/2000/svg">
                                                            <path fill-rule="evenodd" clip-rule="evenodd"
                                                                d="M4.64157 0.605422C4.64157 0.271056 4.37051 0 4.03614 0C3.70178 0 3.43072 0.271057 3.43072 0.605422V1.85647C1.54458 2.12521 0.0823859 3.70969 0.00336393 5.65071H14.5268C14.4477 3.70969 12.9855 2.12521 11.0994 1.85647V0.605422C11.0994 0.271057 10.8283 0 10.494 0C10.1596 0 9.88855 0.271057 9.88855 0.605422V1.81627H4.64157L4.64157 0.605422ZM1.54674e-05 6.86155H14.5301V12.75C14.5301 14.9591 12.7393 16.75 10.5301 16.75H4C1.79086 16.75 0 14.9591 0 12.75V6.86155H1.54674e-05ZM7.26508 11.9066C7.7109 11.9066 8.0723 11.5452 8.0723 11.0994C8.0723 10.6536 7.7109 10.2922 7.26508 10.2922C6.81926 10.2922 6.45785 10.6536 6.45785 11.0994C6.45785 11.5452 6.81926 11.9066 7.26508 11.9066ZM11.3012 11.0994C11.3012 11.5452 10.9398 11.9066 10.494 11.9066C10.0482 11.9066 9.68676 11.5452 9.68676 11.0994C9.68676 10.6536 10.0482 10.2922 10.494 10.2922C10.9398 10.2922 11.3012 10.6536 11.3012 11.0994ZM4.03616 11.9066C4.48198 11.9066 4.84339 11.5452 4.84339 11.0994C4.84339 10.6536 4.48198 10.2922 4.03616 10.2922C3.59034 10.2922 3.22893 10.6536 3.22893 11.0994C3.22893 11.5452 3.59034 11.9066 4.03616 11.9066Z" />
                                                        </svg>
                                                    </span>
                                                    {{ $featured_listing->created_at->diffForHumans() }}
                                                </a>
                                            </div>
                                        </div>

                                    </div>
                                </div>
                            </div>
                        @endforeach

                    </div>
                </div>
            </div>

        </div>
    </section>

    <!-- Featured-Properties part end  -->



    <!-- about-us part start  -->

    <section class="about-us  ">
        <div class="container">

            <div class="row align-items-center  ">
                <div class="col-lg-6 p-0 about-us-thumb-bg ">
                    <div class="about-us-thumb">
                        <img src="{{ asset($homepage->testimonial_image) }}" alt="thumb">
                    </div>
                </div>
                <div class="col-lg-6 about-slick-btm-slick-bg ">
                    <h2 class="taitel">{{ __('translate.What People are Talking About Us') }}</h2>



                    <div class="about-slick-btm-slick">
                        @foreach ($testimonials as $testimonial)
                            <div class="about-slick-btm-item">


                                    <div class="right">
                                        <span>
                                        <svg width="60" height="60" viewBox="0 0 60 60" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M55.9702 11.994C53.2589 8.94822 49.9682 7.40381 46.1898 7.40381C42.7939 7.40381 39.9151 8.61307 37.6326 10.9978C35.3647 13.3674 34.2147 16.3105 34.2147 19.7458C34.2147 22.9921 35.3763 25.8849 37.6672 28.3439C39.688 30.5133 42.2336 31.8932 45.2472 32.4556C44.7202 36.4511 41.1881 40.0676 34.7278 43.2188L33.5645 43.7863L38.3341 52.5918L39.4108 52.046C53.0727 45.1209 59.9997 35.334 59.9997 22.957C59.9997 18.687 58.6441 14.9986 55.9702 11.994ZM39.3601 49.2764L36.9704 44.8652C44.1567 41.0997 47.7976 36.5731 47.7976 31.3976V30.2895L46.6966 30.1648C43.7312 29.8292 41.3715 28.6804 39.4828 26.6527C37.6077 24.6397 36.6961 22.3806 36.6961 19.7458C36.6961 16.9323 37.5889 14.6322 39.4252 12.7133C41.2467 10.8101 43.4595 9.8849 46.1899 9.8849C49.2725 9.8849 51.8654 11.1144 54.1167 13.6436C56.4058 16.2156 57.5186 19.262 57.5186 22.9569C57.5186 28.6296 55.9213 33.7509 52.7711 38.1786C49.7653 42.4033 45.257 46.133 39.3601 49.2764Z" fill="white"/>
                                        <path d="M22.3404 11.9887C19.599 8.94659 16.2947 7.40405 12.519 7.40405C9.11988 7.40405 6.25406 8.61554 4.0016 11.0048C1.76848 13.3734 0.636094 16.3143 0.636094 19.746C0.636094 22.9922 1.79766 25.885 4.08832 28.3442C6.10488 30.5089 8.61996 31.8875 11.5775 32.4524C11.0569 36.451 7.55414 40.0693 1.14562 43.221L0 43.7842L4.65094 52.596L5.73832 52.0474C19.4621 45.1226 26.4207 35.3352 26.4207 22.9572C26.4206 18.6838 25.0477 14.9935 22.3404 11.9887ZM5.70223 49.2725L3.3777 44.8681C10.5118 41.1011 14.1267 36.5734 14.1267 31.3977V30.2921L13.0282 30.1653C10.1236 29.8301 7.79297 28.6812 5.90367 26.6528C4.02855 24.64 3.11719 22.3807 3.11719 19.746C3.11719 16.9289 3.99703 14.6263 5.80676 12.7069C7.5968 10.8082 9.79254 9.88515 12.519 9.88515C15.6047 9.88515 18.2146 11.1164 20.497 13.6496C22.8135 16.2202 23.9395 19.2648 23.9395 22.9572C23.9395 28.6289 22.3352 33.7496 19.1708 38.1768C16.152 42.4002 11.6243 46.1294 5.70223 49.2725Z" fill="white"/>
                                        </svg>

                                        </span>

                                        <span class="star-svg">
                                            <svg width="95" height="16" viewBox="0 0 95 16" fill="none"
                                                xmlns="http://www.w3.org/2000/svg">
                                                <path
                                                    d="M55.863 5.78722C55.8112 5.62592 55.6753 5.5107 55.5102 5.48436L50.5915 4.77331L48.3781 0.246895C48.3037 0.0954657 48.1516 0 47.9866 0C47.8215 0 47.6695 0.0954657 47.595 0.250187L45.4107 4.78977L40.492 5.53375C40.327 5.56008 40.1911 5.6753 40.1393 5.8366C40.0875 5.99791 40.1329 6.17567 40.2526 6.29089L43.8219 9.80997L42.9967 14.794C42.9676 14.9619 43.0355 15.1297 43.1714 15.2285C43.2459 15.2845 43.3365 15.3141 43.4271 15.3141C43.4983 15.3141 43.5662 15.2976 43.631 15.2614L48.0222 12.8945L52.4264 15.2351C52.4911 15.268 52.559 15.2845 52.627 15.2845C52.8664 15.2845 53.0638 15.0836 53.0638 14.84C53.0638 14.8038 53.0606 14.7709 53.0509 14.738L52.1998 9.78364L55.7465 6.2448C55.8727 6.12629 55.9147 5.94853 55.863 5.78722Z" />
                                                <path
                                                    d="M74.9191 5.78722C74.8673 5.62592 74.7314 5.5107 74.5664 5.48436L69.6477 4.77331L67.4343 0.246895C67.3599 0.0954657 67.2078 0 67.0427 0C66.8777 0 66.7256 0.0954657 66.6512 0.250187L64.4669 4.78977L59.5482 5.53375C59.3832 5.56008 59.2473 5.6753 59.1955 5.8366C59.1437 5.99791 59.189 6.17567 59.3087 6.29089L62.878 9.80997L62.0529 14.794C62.0237 14.9619 62.0917 15.1297 62.2276 15.2285C62.302 15.2845 62.3926 15.3141 62.4832 15.3141C62.5544 15.3141 62.6224 15.2976 62.6871 15.2614L67.0783 12.8945L71.4825 15.2351C71.5472 15.268 71.6152 15.2845 71.6831 15.2845C71.9226 15.2845 72.12 15.0836 72.12 14.84C72.12 14.8038 72.1168 14.7709 72.1071 14.738L71.256 9.78364L74.8026 6.2448C74.9288 6.12629 74.9709 5.94853 74.9191 5.78722Z" />
                                                <path
                                                    d="M94.9782 5.78722C94.9264 5.62592 94.7905 5.5107 94.6255 5.48436L89.7068 4.77331L87.4934 0.246895C87.4189 0.0954657 87.2669 0 87.1018 0C86.9368 0 86.7847 0.0954657 86.7103 0.250187L84.526 4.78977L79.6073 5.53375C79.4422 5.56008 79.3063 5.6753 79.2546 5.8366C79.2028 5.99791 79.2481 6.17567 79.3678 6.29089L82.9371 9.80997L82.1119 14.794C82.0828 14.9619 82.1508 15.1297 82.2867 15.2285C82.3611 15.2845 82.4517 15.3141 82.5423 15.3141C82.6135 15.3141 82.6815 15.2976 82.7462 15.2614L87.1374 12.8945L91.5416 15.2351C91.6063 15.268 91.6743 15.2845 91.7422 15.2845C91.9817 15.2845 92.1791 15.0836 92.1791 14.84C92.1791 14.8038 92.1758 14.7709 92.1661 14.738L91.3151 9.78364L94.8617 6.2448C94.9879 6.12629 95.03 5.94853 94.9782 5.78722Z" />
                                                <path
                                                    d="M35.8039 5.78722C35.7521 5.62592 35.6162 5.5107 35.4512 5.48436L30.5325 4.77331L28.3191 0.246895C28.2446 0.0954657 28.0925 0 27.9275 0C27.7625 0 27.6104 0.0954657 27.5359 0.250187L25.3517 4.78977L20.433 5.53375C20.2679 5.56008 20.132 5.6753 20.0802 5.8366C20.0285 5.99791 20.0738 6.17567 20.1935 6.29089L23.7628 9.80997L22.9376 14.794C22.9085 14.9619 22.9764 15.1297 23.1124 15.2285C23.1868 15.2845 23.2774 15.3141 23.368 15.3141C23.4392 15.3141 23.5071 15.2976 23.5719 15.2614L27.9631 12.8945L32.3673 15.2351C32.432 15.268 32.4999 15.2845 32.5679 15.2845C32.8074 15.2845 33.0048 15.0836 33.0048 14.84C33.0048 14.8038 33.0015 14.7709 32.9918 14.738L32.1408 9.78364L35.6874 6.2448C35.8136 6.12629 35.8557 5.94853 35.8039 5.78722Z" />
                                                <path
                                                    d="M15.7448 5.78722C15.693 5.62592 15.5571 5.5107 15.3921 5.48436L10.4734 4.77331L8.25997 0.246895C8.18555 0.0954657 8.03345 0 7.86842 0C7.70339 0 7.55129 0.0954657 7.47687 0.250187L5.29258 4.78977L0.373883 5.53375C0.208848 5.56008 0.0729369 5.6753 0.0211612 5.8366C-0.0306145 5.99791 0.0146893 6.17567 0.134421 6.29089L3.70371 9.80997L2.87853 14.794C2.84941 14.9619 2.91737 15.1297 3.05328 15.2285C3.12771 15.2845 3.21831 15.3141 3.30892 15.3141C3.38011 15.3141 3.44807 15.2976 3.51279 15.2614L7.90402 12.8945L12.3082 15.2351C12.3729 15.268 12.4409 15.2845 12.5088 15.2845C12.7483 15.2845 12.9457 15.0836 12.9457 14.84C12.9457 14.8038 12.9424 14.7709 12.9327 14.738L12.0817 9.78364L15.6283 6.2448C15.7545 6.12629 15.7966 5.94853 15.7448 5.78722Z" />
                                            </svg>
                                        </span>
                                    </div>

                                <p class="about-slick-dec">{{ $testimonial->comment }}</p>

                                <div class="about-slick-btm-inner">
                                    <div class="left">
                                    <div class="left-df">
                                     <div class="about-slick-top-thumb">
                                        <img src="{{ asset($testimonial->image) }}" alt="img">
                                     </div>
                                    </div>

                                    <div class="left-df-m">
                                    <h6>{{ $testimonial->name }}</h6>
                                        <h4>{{ $testimonial->designation }}</h4>
                                    </div>

                                    </div>

                                </div>
                            </div>
                        @endforeach

                    </div>



                </div>
            </div>




        </div>
    </section>


    <!-- about-us part end  -->

    <!-- more-Properties  part start  -->

    <section class=" more-properties  footer-top-pad">
        <div class="container">
            <div class="row more-properties-bg align-items-center" data-aos="fade-up">
                <div class="col-lg-7">
                    <h2 class="more-properties-txt">{{ $homepage->home3_explore_title }}</h2>

                    <a href="{{ route('contact-us') }}" class="main-btn">
                        <div class="btn_m">
                            <div class="btn_c">
                                <div class="btn_t1"> {{ __('translate.Contact Us') }}</div>
                                <div class="btn_t2"> {{ __('translate.Contact Us') }}</div>
                            </div>
                        </div>
                    </a>
                </div>

                <div class="col-lg-5">
                    <div class="more-properties-thumb">
                        <img src="{{ asset($homepage->home3_explore_image) }}" alt="img">
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- more-Properties  part end  -->

</main>

@endsection
