<?php

namespace Modules\Listing\Http\Controllers;

use App\Models\User;
use App\Models\Review;
use App\Models\JobRequest;
use Auth, Image, File, Str;
use Illuminate\Http\Request;
use App\Models\ListingReport;
use Modules\City\Entities\City;


use Intervention\Image\Gd\Driver;
use Illuminate\Routing\Controller;
use Intervention\Image\ImageManager;
use Modules\Country\Entities\Country;
use Modules\Feature\Entities\Feature;
use Modules\Listing\Entities\Listing;
use Modules\Language\Entities\Language;
use Modules\Category\Entities\SubCategory;

use Illuminate\Contracts\Support\Renderable;

use Modules\Category\Entities\ChildCategory;
use Modules\Listing\Entities\ListingGallery;
use Modules\Listing\Entities\ListingTranslation;
use Modules\Listing\Http\Requests\ListingRequest;
use Modules\Subscription\Entities\SubscriptionHistory;

class ListingController extends Controller
{
    /**
     * Display a listing of the resource.
     * @return Renderable
     */
    public function index()
    {
        $listings = Listing::with('translate','agent','category')->latest()->get();

        return view('listing::index', compact('listings'));
    }

    public function awaiting_listings()
    {
        $listings = Listing::with('translate','agent')->where('approved_by_admin', 'pending')->latest()->get();

        return view('listing::awaiting_listing', compact('listings'));
    }

    public function featured_listings()
    {
        $listings = Listing::with('translate','agent')->where('is_featured', 'enable')->latest()->get();

        return view('listing::featured_listing', compact('listings'));
    }


    /**
     * Show the form for creating a new resource.
     * @return Renderable
     */
    public function create(Request $request)
    {

        $countries = Country::latest()->get();

        if($request->category == 'classified'){

            $sub_categories = SubCategory::with('translate')->where('category_id', 1)->where('status', 'enable')->get();
            $cities = City::with('translate')->get();
            $aminities = Feature::with('translate')->where('category_id', 1)->get();
            $agents = User::where(['status' => 'enable' , 'is_banned' => 'no', 'is_dealer' => 1])->where('email_verified_at', '!=', null)->orderBy('id','desc')->get();


            return view('listing::create_classified_listing', compact('sub_categories', 'cities', 'aminities', 'agents', 'countries'));

        }elseif($request->category == 'job-post'){
            $sub_categories = SubCategory::with('translate')->where('category_id', 3)->where('status', 'enable')->get();
            $cities = City::with('translate')->get();
            $aminities = Feature::with('translate')->where('category_id', 3)->get();
            $agents = User::all();

            return view('listing::create_jobpost_listing', compact('sub_categories', 'cities', 'aminities', 'agents', 'countries'));

        }elseif($request->category == 'real-estate'){

            $sub_categories = SubCategory::with('translate')->where('category_id', 2)->where('status', 'enable')->get();
            $cities = City::with('translate')->get();
            $aminities = Feature::with('translate')->where('category_id', 2)->get();
            $agents = User::all();

            return view('listing::create_realestate_listing', compact('sub_categories', 'cities', 'aminities', 'agents', 'countries'));
        }else{
            abort(404);
        };


    }

    public function select_listings_purpose()
    {
        return view('listing::select_purpose');
    }



    /**
     * Store a newly created resource in storage.
     * @param Request $request
     * @return Renderable
     */
    public function store(ListingRequest $request)
    {

        $user = User::findOrFail($request->agent_id);

        $active_plan = SubscriptionHistory::where('user_id', $user->id)->latest()->first();

        if(!$active_plan){
            $notification=  trans('translate.Agent did not enrolled any plan yet.');
            $notification=array('messege'=>$notification,'alert-type'=>'error');
            return redirect()->back()->with($notification);
        }

        $expiration_date = $active_plan->expiration_date;

        if($expiration_date != 'lifetime'){
            if(date('Y-m-d') > $expiration_date){
                $notification = trans('translate.Agent plan is expired, please renew or re-order');
                $notification = array('messege'=>$notification,'alert-type'=>'error');
                return redirect()->back()->with($notification);
            }
        }

        $max_listing = $active_plan->max_listing;

        $total_listing = Listing::where('agent_id', $user->id)->count();

        if($total_listing >= $max_listing){
            $notification = trans('translate.Agent listing limitation has exceeded');
            $notification = array('messege'=>$notification,'alert-type'=>'error');
            return redirect()->back()->with($notification);
        }

        $listing = new Listing();


        if($request->thumb_image) {

            $image_name = 'listing'.date('-Y-m-d-h-i-s-').rand(999,9999).'.webp';
            $image_name = 'uploads/custom-images/'.$image_name;
            $manager = new ImageManager(['driver' => 'gd']);
            $image = $manager->make($request->thumb_image);

            $author_name = '©'. $user->name;

            $author_name = explode(' ', trim($author_name))[0];

            $image->text($author_name, $image->width() / 2, $image->height() - 50, function($font) {
                $font->file(public_path('fonts/static/Quicksand-Bold.ttf'));
                $font->size(40);
                $font->color([255, 255, 255, 0.5]);
                $font->align('center');
                $font->valign('bottom');
            });

            $image->encode('webp', 80)->save(public_path().'/'.$image_name);

            $listing->thumb_image = $image_name;

        }


        $listing->agent_id = $request->agent_id;
        $listing->category_id = $request->category_id;
        $listing->sub_category_id = $request->sub_category_id;
        $listing->child_category_id = $request->child_category_id ? $request->child_category_id : 0;
        $listing->city_id = $request->city_id;
        $listing->country_id = $request->country_id;
        $listing->slug = $request->slug;
        $listing->features = json_encode($request->features);
        $listing->regular_price = $request->regular_price;
        $listing->offer_price = $request->offer_price;
        $listing->video_id = $request->video_id;
        $listing->google_map = $request->google_map;
        $listing->approved_by_admin = 'approved';
        $listing->status = 'enable';

        if($active_plan->expiration_date == 'lifetime'){
            $listing->expired_date = null;
            $listing->save();
        }else{
            $listing->expired_date = $active_plan->expiration_date;
            $listing->save();
        }
        $listing->save();

        $languages = Language::all();
        foreach($languages as $language){
            $listing_translate = new ListingTranslation();
            $listing_translate->lang_code = $language->lang_code;
            $listing_translate->listing_id = $listing->id;
            $listing_translate->title = $request->title;
            $listing_translate->description = $request->description;
            $listing_translate->address = $request->address;
            $listing_translate->seo_title = $request->seo_title ? $request->seo_title : $request->title;
            $listing_translate->seo_description = $request->seo_description ? $request->seo_description : $request->title;
            $listing_translate->save();
        }


        $notification= trans('translate.Created Successfully');
        $notification=array('messege'=>$notification,'alert-type'=>'success');
        return redirect()->route('admin.listings.edit', ['listing' => $listing->id, 'lang_code' => admin_lang()] )->with($notification);
    }


    /**
     * Show the form for editing the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function edit(Request $request, $id)
    {

        $countries = Country::latest()->get();

        $listing = Listing::findOrFail($id);
        $listing_translate = ListingTranslation::where(['listing_id' => $id, 'lang_code' => $request->lang_code])->first();

        $child_categories = ChildCategory::where(['sub_category_id' => $listing->sub_category_id, 'status' => 'enable'])->latest()->get();

        if($listing->category_id == 1){

            $sub_categories = SubCategory::with('translate')->where('category_id', 1)->where('status', 'enable')->get();
            $cities = City::with('translate')->where('country_id', $listing->country_id)->get();
            $aminities = Feature::with('translate')->where('category_id', 1)->get();
            $agents = User::where(['status' => 'enable' , 'is_banned' => 'no', 'is_dealer' => 1])->where('email_verified_at', '!=', null)->orderBy('id','desc')->get();

            $existing_aminities = array();
            if($listing->features != 'null'){
                $existing_aminities = json_decode($listing->features);
            }

            return view('listing::edit_classified_listing', compact('sub_categories', 'cities', 'aminities', 'agents', 'listing', 'existing_aminities', 'listing_translate', 'countries', 'child_categories'));

        }elseif($listing->category_id == 2){

            $sub_categories = SubCategory::with('translate')->where('category_id', 2)->where('status', 'enable')->get();
            $cities = City::with('translate')->where('country_id', $listing->country_id)->get();
            $aminities = Feature::with('translate')->where('category_id', 2)->get();
            $agents = User::all();

            $existing_aminities = array();
            if($listing->features != 'null'){
                $existing_aminities = json_decode($listing->features);
            }

            return view('listing::edit_realestate_listing', compact('sub_categories', 'cities', 'aminities', 'agents', 'listing', 'listing_translate', 'existing_aminities', 'countries', 'child_categories'));

        }elseif($listing->category_id == 3){

            $sub_categories = SubCategory::with('translate')->where('category_id', 3)->where('status', 'enable')->get();
            $cities = City::with('translate')->where('country_id', $listing->country_id)->get();
            $aminities = Feature::with('translate')->where('category_id', 3)->get();
            $agents = User::all();

            $existing_aminities = array();
            if($listing->features != 'null'){
                $existing_aminities = json_decode($listing->features);
            }

            return view('listing::edit_jobpost_listing', compact('sub_categories', 'cities', 'aminities', 'agents', 'listing', 'listing_translate', 'existing_aminities', 'countries', 'child_categories'));

        }else{
            abort(404);
        };
    }

    /**
     * Update the specified resource in storage.
     * @param Request $request
     * @param int $id
     * @return Renderable
     */
    public function update(ListingRequest $request, $id)
    {

        $listing = Listing::findOrFail($id);

        if($request->lang_code == admin_lang()){

            $user = User::findOrFail($request->agent_id);


            $active_plan = SubscriptionHistory::where('user_id', $user->id)->latest()->first();

            if(!$active_plan){
                $notification=  trans('translate.Agent did not enrolled any plan yet.');
                $notification=array('messege'=>$notification,'alert-type'=>'error');
                return redirect()->back()->with($notification);
            }

            $expiration_date = $active_plan->expiration_date;

            if($expiration_date != 'lifetime'){
                if(date('Y-m-d') > $expiration_date){
                    $notification = trans('translate.Agent plan is expired, please renew or re-order');
                    $notification = array('messege'=>$notification,'alert-type'=>'error');
                    return redirect()->back()->with($notification);
                }
            }

            $max_listing = $active_plan->max_listing;

            $total_listing = Listing::where('agent_id', $user->id)->count();

            if($total_listing >= $max_listing){
                $notification = trans('translate.Agent listing limitation has exceeded');
                $notification = array('messege'=>$notification,'alert-type'=>'error');
                return redirect()->back()->with($notification);
            }

            if($request->thumb_image) {

                $old_image = $listing->thumb_image;
                $image_name = 'listing'.date('-Y-m-d-h-i-s-').rand(999,9999).'.webp';
                $image_name = 'uploads/custom-images/'.$image_name;
                $manager = new ImageManager(['driver' => 'gd']);
                $image = $manager->make($request->thumb_image);

                $author_name = '©'. $user->name;

                $author_name = explode(' ', trim($author_name))[0];

                $image->text($author_name, $image->width() / 2, $image->height() - 50, function($font) {
                    $font->file(public_path('fonts/static/Quicksand-Bold.ttf'));
                    $font->size(40);
                    $font->color([255, 255, 255, 0.5]);
                    $font->align('center');
                    $font->valign('bottom');
                });

                $image->encode('webp', 80)->save(public_path().'/'.$image_name);

                $listing->thumb_image = $image_name;
                $listing->save();

                if($old_image && File::exists(public_path().'/'.$old_image)) {
                    unlink(public_path().'/'.$old_image);
                }
            }

            $listing->agent_id = $request->agent_id;
            $listing->sub_category_id = $request->sub_category_id;
            $listing->child_category_id = $request->child_category_id ? $request->child_category_id : 0;
            $listing->city_id = $request->city_id;
            $listing->country_id = $request->country_id;
            $listing->slug = $request->slug;
            $listing->video_id = $request->video_id;
            $listing->features = json_encode($request->features);
            $listing->regular_price = $request->regular_price;
            $listing->video_id = $request->video_id;
            $listing->google_map = $request->google_map;
            $listing->save();

        }

        $listing_translate = ListingTranslation::findOrFail($request->translate_id);
        $listing_translate->title = $request->title;
        $listing_translate->description = $request->description;
        $listing_translate->video_description = $request->video_description;
        $listing_translate->address = $request->address;
        $listing_translate->seo_title = $request->seo_title ? $request->seo_title : $request->title;
        $listing_translate->seo_description = $request->seo_description ? $request->seo_description : $request->title;
        $listing_translate->save();

        $notification= trans('translate.Updated Successfully');
        $notification=array('messege'=>$notification,'alert-type'=>'success');
        return redirect()->back()->with($notification);
    }

    /**
     * Remove the specified resource from storage.
     * @param int $id
     * @return Renderable
     */
    public function destroy($id)
    {
        $listing = Listing::findOrFail($id);
        $old_image = $listing->thumb_image;

        if($old_image){
            if(File::exists(public_path().'/'.$old_image))unlink(public_path().'/'.$old_image);
        }

        ListingTranslation::where('listing_id',$id)->delete();
        Review::where('listing_id',$id)->delete();
        ListingReport::where('listing_id',$id)->delete();
        JobRequest::where('listing_id',$id)->delete();

        $galleries = ListingGallery::where('listing_id', $id)->get();
        foreach($galleries as $gallery){
            $old_image = $gallery->image;

            if($old_image){
                if(File::exists(public_path().'/'.$old_image))unlink(public_path().'/'.$old_image);
            }

            $gallery->delete();
        }

        $listing->delete();

        $notification=  trans('translate.Delete Successfully');
        $notification=array('messege'=>$notification,'alert-type'=>'success');
        return redirect()->route('admin.listings.index')->with($notification);
    }

    public function listing_gallery($id){
        $listing = Listing::findOrFail($id);

        $galleries = ListingGallery::where('listing_id', $id)->get();

        return view('listing::gallery', compact('listing', 'galleries'));
    }

    public function upload_listing_gallery(Request $request, $id){

        $listing = Listing::findOrFail($id);



        foreach ($request->file as $index => $image) {
            $gallery_image = new ListingGallery();

            if($image) {

                $image_name = 'listing'.date('-Y-m-d-h-i-s-').rand(999,9999).'.webp';
                $image_name = 'uploads/custom-images/'.$image_name;
                $manager = new ImageManager(['driver' => 'gd']);
                $image = $manager->make($image);

                $user = User::findOrFail($listing->agent_id);

                $author_name = '©'. $user->name;

                $author_name = explode(' ', trim($author_name))[0];

                $image->text($author_name, $image->width() / 2, $image->height() - 50, function($font) {
                    $font->file(public_path('fonts/static/Quicksand-Bold.ttf'));
                    $font->size(40);
                    $font->color([255, 255, 255, 0.5]);
                    $font->align('center');
                    $font->valign('bottom');
                });

                $image->encode('webp', 80)->save(public_path().'/'.$image_name);

                $gallery_image->image = $image_name;

            }

            $gallery_image->listing_id = $id;
            $gallery_image->save();
        }

        if ($gallery_image) {
            return response()->json([
                'message' => trans('translate.Images uploaded successfully'),
                'url' => route('admin.listings-gallery', $id),
            ]);
        } else {
             return response()->json([
                'message' => trans('translate.Images uploaded Failed'),
                'url' => route('admin.listings-gallery', $id),
            ]);
        }

    }

    public function delete_listing_gallery($id){
        $gallery = ListingGallery::findOrFail($id);
        $old_image = $gallery->image;

        if($old_image){
            if(File::exists(public_path().'/'.$old_image))unlink(public_path().'/'.$old_image);
        }

        $gallery->delete();

        $notification=  trans('translate.Delete Successfully');
        $notification=array('messege'=>$notification,'alert-type'=>'success');
        return redirect()->back()->with($notification);

    }

    public function assign_language($lang_code){
        $listing_translates = ListingTranslation::where('lang_code', admin_lang())->get();
        foreach($listing_translates as $listing_translate){
            $translate = new ListingTranslation();
            $translate->listing_id = $listing_translate->listing_id;
            $translate->lang_code = $lang_code;
            $translate->title = $listing_translate->title;
            $translate->description = $listing_translate->description;
            $translate->address = $listing_translate->address;
            $translate->seo_title = $listing_translate->seo_title;
            $translate->seo_description = $listing_translate->seo_description;
            $translate->save();
        }
    }

    public function listings_approval($id){

        $listing = Listing::findOrFail($id);
        $listing->approved_by_admin = 'approved';
        $listing->status = 'enable';
        $listing->save();

        $notification=  trans('translate.Apporval Successfully');
        $notification=array('messege'=>$notification,'alert-type'=>'success');
        return redirect()->back()->with($notification);
    }

    public function listings_featured($id){

        $listing = Listing::findOrFail($id);

        $user = User::findOrFail($listing->agent_id);

        $active_plan = SubscriptionHistory::where('user_id', $user->id)->latest()->first();

        if(!$active_plan){
            $notification=  trans('translate.Agent did not enrolled any plan yet.');
            $notification=array('messege'=>$notification,'alert-type'=>'error');
            return redirect()->back()->with($notification);
        }

        $max_featured = $active_plan->featured_listing;

        $featured_listing = Listing::where('agent_id', $user->id)->where('is_featured', 'enable')->count();

        if($featured_listing >= $max_featured){
            $notification = trans('translate.Your featured limitation has exceeded');
            $notification = array('messege'=>$notification,'alert-type'=>'error');
            return redirect()->back()->with($notification);
        }

        $listing = Listing::findOrFail($id);
        $listing->is_featured = 'enable';
        $listing->save();

        $notification=  trans('translate.Featured Successfully');
        $notification=array('messege'=>$notification,'alert-type'=>'success');
        return redirect()->back()->with($notification);
    }

    public function listings_featured_removed($id){

        $listing = Listing::findOrFail($id);
        $listing->is_featured = 'disable';
        $listing->save();

        $notification=  trans('translate.Featured removed Successfully');
        $notification=array('messege'=>$notification,'alert-type'=>'success');
        return redirect()->back()->with($notification);
    }



    public function review_list(){

        $reviews = Review::with('user','listing')->latest()->get();

        return view('listing::reviews', ['reviews' => $reviews]);
    }

    public function review_detail($id){

        $review = Review::with('user','listing')->findOrFail($id);

        return view('listing::review_show', ['review' => $review]);
    }

    public function review_delete($id){

        $review = Review::findOrFail($id);
        $review->delete();


        $notification=  trans('translate.Deleted Successfully');
        $notification=array('messege'=>$notification,'alert-type'=>'success');
        return redirect()->route('admin.review-list')->with($notification);

    }

    public function review_approval($id){

        $review = Review::findOrFail($id);
        $review->status = 'enable';
        $review->save();

        $notification=  trans('translate.Review approval successfully');
        $notification=array('messege'=>$notification,'alert-type'=>'success');
        return redirect()->back()->with($notification);
    }

    public function report_list(){

        $reports = ListingReport::with('agent','listing')->latest()->get();

        return view('listing::reports', ['reports' => $reports]);
    }

    public function report_detail($id){

        $report = ListingReport::with('agent','listing')->findOrFail($id);

        return view('listing::report_show', ['report' => $report]);
    }

    public function report_delete($id){

        $report = ListingReport::findOrFail($id);
        $report->delete();


        $notification=  trans('translate.Deleted Successfully');
        $notification=array('messege'=>$notification,'alert-type'=>'success');
        return redirect()->route('admin.report-list')->with($notification);

    }

    public function job_posts(){

        $listings = Listing::with('agent')->where(['category_id' => 3])->latest()->get();

        return view('listing::job_posts', ['listings' => $listings]);

    }

    public function job_post_applicants($id){

        $job_post = Listing::findOrFail($id);

        $job_requests = JobRequest::with('user')->where('listing_id', $id)->latest()->get();

        return view('listing::job_applicants', ['job_requests' => $job_requests]);

    }

    public function job_application_approval($id){

        $job_request = JobRequest::findOrFail($id);

        $approval_check = JobRequest::where('listing_id', $job_request->listing_id)->where('status', 'approved')->count();

        if($approval_check == 0){
            $job_request = JobRequest::findOrFail($id);
            $job_request->status = 'approved';
            $job_request->save();

            JobRequest::where('listing_id', $job_request->listing_id)->where('id', '!=', $id)->update(['status' => 'rejected']);

            $notification = trans('translate.Job assigned successfully');
            $notification = array('messege'=>$notification,'alert-type'=>'success');
            return redirect()->back()->with($notification);

        }else{
            $notification = trans('translate.Job already has assigned, so you can not assign again');
            $notification = array('messege'=>$notification,'alert-type'=>'error');
            return redirect()->back()->with($notification);
        }

    }

    public function job_application_delete($id){

        $job_request = JobRequest::findOrFail($id);
        $job_request->delete();

        $notification = trans('translate.Deleted successfully');
        $notification = array('messege'=>$notification,'alert-type'=>'success');
        return redirect()->back()->with($notification);

    }

}
