@extends('layout')
@section('title')
    <title>{{ __('translate.Job Applications') }}</title>
@endsection
@section('body-content')

<main>
    <!-- banner-part-start  -->

    <div class="inner-bg common-class"
    style="    background-image:  url({{ custom_asset($breadcrumb, '1905x408') }});">
        <div class="container">
            <div class="row">
                <div class="col-lg-3">

                    <div class="inner-bg-txt">
                        <h1>{{ __('translate.Job Applications') }}</h1>

                        <ul>
                            <li><a href="{{ route('home') }}">{{ __('translate.Home') }}</a></li>
                            <li><span>
                                    <svg width="6" height="12" viewBox="0 0 6 12" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <path
                                            d="M0.633816 2.7705e-08C0.446997 0.0532405 0.28353 0.143084 0.158011 0.319443C-0.0492418 0.618921 -0.0550799 1.0515 0.155092 1.35098C0.195958 1.40755 0.239744 1.46411 0.286449 1.51735C1.56499 2.97481 2.84645 4.4356 4.125 5.89306C4.15419 5.92633 4.18922 5.95295 4.24176 6.03281C4.20673 6.0561 4.16295 6.06941 4.13375 6.10269C2.84062 7.57346 1.5504 9.04755 0.257258 10.5183C0.0295721 10.7779 -0.0579994 11.0773 0.0412483 11.4367C0.187201 11.9591 0.776848 12.1721 1.16216 11.8427C1.20595 11.8061 1.24682 11.7628 1.28768 11.7196C2.7764 10.0225 4.26511 8.32881 5.75091 6.63177C6.02238 6.32231 6.07492 5.92966 5.89394 5.57361C5.85015 5.4871 5.78594 5.41056 5.72464 5.34069C4.27971 3.69356 2.83478 2.04976 1.39277 0.399304C1.23222 0.216289 1.06875 0.0532405 0.838149 3.66367e-08C0.771011 3.3702e-08 0.703873 3.07673e-08 0.633816 2.7705e-08Z" />
                                    </svg>

                                </span></li>
                            <li><a href="javascript:;" class="active">{{ __('translate.Job Applications') }}</a></li>
                        </ul>
                    </div>

                </div>
            </div>
        </div>
    </div>
    <!-- banner-part-end -->

    <!-- dashboard-part-start -->
    <section class="dashboard footer-top-pad">
        <div class="container">
            <div class="row">
                @include('profile.sidebar')

                <div class=" col-xxl-9 col-xl-8 col-lg-8">
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="dashbord-tabel dashboard-my-job-tabel two ">
                                    <table class="table">
                                        <thead>
                                            <tr>
                                                <th>{{ __('translate.Serial') }}</th>
                                                <th>{{ __('translate.Name') }}</th>
                                                <th>{{ __('translate.Phone') }}</th>
                                                <th>{{ __('translate.Email') }}</th>
                                                <th>{{ __('translate.Status') }}</th>
                                                <th>{{ __('translate.Actions') }}</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @forelse ($job_requests as $index => $job_request)
                                                <tr>
                                                    <td>
                                                        {{ ++$index }}
                                                    </td>

                                                    <td>
                                                        <div class="taitel-name-item">
                                                            <div class="taitel-name-thumb-main">
                                                                <img src="{{ custom_asset($job_request?->user?->image, '30x30') }}"
                                                                    alt="thumb">
                                                            </div>
                                                            <p> {{ html_decode($job_request?->user?->name) }}</p>
                                                        </div>
                                                    </td>

                                                    <td>
                                                        {{ html_decode($job_request?->user?->phone) }}
                                                    </td>
                                                    <td>
                                                        {{ html_decode($job_request?->user?->email) }}
                                                    </td>

                                                    <td>

                                                        @if ($job_request->status == 'approved')
                                                            <button type="button" class="active-btn">{{ __('translate.Hired') }}</button>
                                                        @elseif ($job_request->status == 'pending')
                                                            <button type="button" class="active-btn close-btn">{{ __('translate.Pending') }}</button>
                                                        @else
                                                            <button type="button" class="active-btn close-btn">{{ __('translate.Rejected') }}</button>
                                                        @endif
                                                    </td>

                                                    <td>

                                                        <div class="action-btn">
                                                            <a href="javascript:;" class="view-btn" data-bs-toggle="modal"
                                                                data-bs-target="#viewRequestDetail{{ $job_request->id }}">
                                                                <i class="fa-solid fa-eye"></i>
                                                            </a>

                                                            @if ($job_request->status == 'pending')
                                                                <a href="javascript:;" class="view-btn check-btn" onclick="applicationApproval({{ $job_request->id }})">
                                                                    <i class="fa-solid fa-check"></i>
                                                                </a>
                                                            @endif

                                                            <form action="{{ route('user.job-application-approval', $job_request->id) }}" class="d-none" method="post" id="approval_application_{{ $job_request->id }}">
                                                                @csrf
                                                                @method('PUT')

                                                            </form>

                                                        </div>

                                                    </td>
                                                </tr>
                                            @empty
                                                <tr class="not_found">
                                                    <td colspan="6">{{ __('translate.Job Applications Not Found') }}</td>
                                                </tr>
                                            @endforelse

                                        </tbody>
                                    </table>
                                </div>
                            </div>

                            @if ($job_requests->hasPages())
                                <div class="col-lg-12">
                                    {{ $job_requests->links('pagination_box') }}
                                </div>
                            @endif

                        </div>
                    </div>


            </div>
        </div>
        </div>
    </section>


    @foreach ($job_requests as $index => $job_request)
        <!-- Candidate Details Modal -->
        <div class="modal candidate-modal fade" id="viewRequestDetail{{ $job_request->id }}" tabindex="-1" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLabel">{{ __('translate.Application Details') }}</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="candidate-modal-tabel">
                            <table>
                                <tbody>
                                    <tr>
                                        <td>{{ __('translate.Name') }}:</td>
                                        <td>{{ html_decode($job_request?->user?->name) }}</td>
                                    </tr>
                                    <tr>
                                        <td> {{ __('translate.Phone') }}:</td>
                                        <td>{{ html_decode($job_request?->user?->phone) }}</td>
                                    </tr>
                                    <tr>
                                        <td> {{ __('translate.Email') }}:</td>
                                        <td>{{ html_decode($job_request?->user?->email) }}</td>
                                    </tr>

                                    <tr>
                                        <td> {{ __('translate.Address') }}:</td>
                                        <td>{{ html_decode($job_request?->user?->address) }}</td>
                                    </tr>

                                    <tr>
                                        <td>{{ __('translate.Apply Date') }}:</td>
                                        <td>{{ $job_request->created_at->format('Y-m-d') }}</td>
                                    </tr>
                                    <tr>
                                        <td> {{ __('translate.Message') }}:</td>
                                        <td>{!! clean(nl2br(html_decode($job_request->description))) !!}</td>
                                    </tr>

                                    @if ($job_request?->user?->resume)
                                        <tr>
                                            <td> </td>
                                            <td>

                                                <a href="{{ route('download-resume', $job_request?->user?->resume) }}" class="cv-button">
                                                    <span>
                                                        <i class="fa-solid fa-file-pdf"></i>
                                                    </span>
                                                    {{ __('translate.CV Download') }}
                                                </a>

                                            </td>
                                        </tr>
                                    @endif

                                </tbody>
                            </table>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    @endforeach

    <!-- dashboard-part-end -->

    @include('profile.logout')

</main>

@endsection

@push('js_section')
<script src="{{ asset('global/sweetalert/sweetalert2@11.js') }}"></script>

<script>
    "use strict";
        function applicationApproval(id){
            Swal.fire({
                title: "{{ __('translate.Want to approve this application ?') }}",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: "{{__('Yes, Approved It')}}",
                cancelButtonText: "{{__('Cancel')}}",
            }).then((result) => {
                if (result.isConfirmed) {
                    $("#approval_application_"+id).submit();
                }

            })
        }
    </script>

@endpush
