<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use Modules\Language\Entities\Language;
use Modules\Currency\app\Models\MultiCurrency;
use Session, Config;

class LangSession
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        // for language

        $is_default = Language::where('is_default', 'Yes')->first();

        if(!$is_default && !Session::get('front_lang')){
            $default_lang = Language::where('id', 1)->first();
            Session::put('front_lang', $default_lang->lang_code);
            Session::put('lang_dir', $default_lang->lang_direction);
            Session::put('front_lang_name', $default_lang->lang_name);

            app()->setLocale($default_lang->lang_code);
        }else{
           
            $is_exist = Language::where('lang_code', Session::get('front_lang'))->first();

            if($is_exist){

                Session::put('front_lang', $is_exist->lang_code);
                Session::put('lang_dir', $is_exist->lang_direction);
                Session::put('front_lang_name', $is_exist->lang_name);
                app()->setLocale($is_exist->lang_code);

            }else{
                Session::put('front_lang', $is_default->lang_code);
                Session::put('lang_dir', $is_default->lang_direction);
                Session::put('front_lang_name', $is_default->lang_name);
                app()->setLocale($is_default->lang_code);
            }
        }

        // for currency

        $default_currency = MultiCurrency::where('is_default', 'Yes')->first();

        if(!$default_currency && !Session::get('currency_code')){

            $currency = MultiCurrency::where('id', 1)->first();

            Session::put('currency_name', $currency->currency_name);
            Session::put('currency_code', $currency->currency_code);
            Session::put('currency_icon', $currency->currency_icon);
            Session::put('currency_rate', $currency->currency_rate);
            Session::put('currency_position', $currency->currency_position);

        }else{

            $session_currency = MultiCurrency::where('currency_code', Session::get('currency_code'))->first();
            if($session_currency){

                Session::put('currency_name', $session_currency->currency_name);
                Session::put('currency_code', $session_currency->currency_code);
                Session::put('currency_icon', $session_currency->currency_icon);
                Session::put('currency_rate', $session_currency->currency_rate);
                Session::put('currency_position', $session_currency->currency_position);
            }else{
                Session::put('currency_name', $default_currency->currency_name);
                Session::put('currency_code', $default_currency->currency_code);
                Session::put('currency_icon', $default_currency->currency_icon);
                Session::put('currency_rate', $default_currency->currency_rate);
                Session::put('currency_position', $default_currency->currency_position);
            }
        }
        return $next($request);
    }
}
