<?php

namespace Modules\SupportTicket\Http\Controllers\Admin;

use Illuminate\Routing\Controller;
use Modules\SupportTicket\Entities\SupportTicket;
use Modules\SupportTicket\Entities\TicketMessage;
use Modules\SupportTicket\Http\Requests\TicketMessageRequest;
use Illuminate\Support\Facades\Auth;

class SupportTicketController extends Controller
{

    public function index()
    {
        $support_tickets = SupportTicket::orderBy('id', 'desc')->paginate(10);

        return view('supportticket::admin.index', [
            'support_tickets' => $support_tickets
        ]);
    }


    public function show($id)
    {
        $ticket = SupportTicket::where(['ticket_id' => $id])->firstOrFail();
        $ticket_messages = TicketMessage::where('support_ticket_id', $ticket->id)->get();

        return view('supportticket::admin.show', [
            'ticket' => $ticket,
            'ticket_messages' => $ticket_messages,
        ]);
    }


    public function send_support_message(TicketMessageRequest $request, $id){

        $admin = Auth::guard('admin')->user();

        $ticket_message = new TicketMessage();
        $ticket_message->user_id = $request->user_id;
        $ticket_message->admin_id = $admin->id;
        $ticket_message->support_ticket_id = $id;
        $ticket_message->message = $request->message;
        $ticket_message->message_from = 'admin';
        $ticket_message->seen_by_admin = 'yes';
        $ticket_message->save();


        $firstSmsExist = TicketMessage::where('message_from', 'admin')->where('support_ticket_id',$id)->count();


        if($firstSmsExist != 0){
            $ticket = SupportTicket::where(['id' => $id])->first();
            $ticket->status = 'in_progress';
            $ticket->save();

            TicketMessage::where('support_ticket_id',$id)->update(['seen_by_admin' => 'yes']);
        }

        $notification = trans('Message Send Successfully');
        $notification=array('messege'=>$notification,'alert-type'=>'success');
        return redirect()->back()->with($notification);

    }


    public function ticket_closed($id){
        $ticket = SupportTicket::findOrFail($id);
        $ticket->status = 'closed';
        $ticket->save();
        $notification= trans('Closed Successfully');
        $notification=array('messege'=>$notification, 'alert-type'=>'success');
        return redirect()->route('admin.support-tickets.index')->with($notification);
    }



    public function destroy($id)
    {
        SupportTicket::where('id', $id)->delete();
        TicketMessage::where('support_ticket_id', $id)->delete();

        $notification= trans('translate.Delete Successfully');
        $notification=array('messege'=>$notification,'alert-type'=>'success');
        return redirect()->route('admin.support-tickets.index')->with($notification);
    }
}
