<?php

namespace Modules\Country\Entities;

use Modules\Listing\Entities\Listing;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Country extends Model
{
    use HasFactory;

    protected $fillable = [];


    protected $appends = ['total_listing'];


    public function listings($type = null){
        if($type == null){
            return $this->hasMany(Listing::class, 'country_id')->where(function ($query) {
                $query->where('expired_date', null)
                    ->orWhere('expired_date', '>=', date('Y-m-d'));
            })->where(['status' => 'enable', 'approved_by_admin' => 'approved']);
        }else{
            return $this->hasMany(Listing::class, 'country_id')->where(function ($query) {
                $query->where('expired_date', null)
                    ->orWhere('expired_date', '>=', date('Y-m-d'));
            })->where(['status' => 'enable', 'approved_by_admin' => 'approved', 'category_id' => $type]);
        }

    }


    public function getTotalListingAttribute()
    {
        return $this->listings()->count();
    }


}
