@extends('layout')
@section('title')
    <title>{{ $agent->name }}</title>
@endsection

@section('body-content')

<main>

    <!-- inner-bg  part start  -->

    <section class="profile-banner common-class">
        <div class="container">
            <div class="row profile-banner-bg" style="background-image: url({{ asset($setting->default_cover_image) }});">
                <div class="col-lg-6">

                    <div class="profile-banner-item">
                        <div class="profile-banner-thumb">
                            @if ($agent->image)
                                <img src="{{ asset($agent->image) }}" alt="thumb">
                            @else
                                <img src="{{ asset($setting->default_avatar) }}" alt="thumb">
                            @endif
                        </div>

                        <div class="profile-banner-txt">
                            <h2 class="profile-banner-taitel">{{ html_decode($agent->name) }}
                                @php
                                    $kyc = Modules\Kyc\Entities\KycInformation::where('user_id',$agent->id)->where('status',1)->first();
                                @endphp
                                @if($kyc)
                                    <span  class="varified-badge">
                                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor"><path d="M10.007 2.10377C8.60544 1.65006 7.08181 2.28116 6.41156 3.59306L5.60578 5.17023C5.51004 5.35763 5.35763 5.51004 5.17023 5.60578L3.59306 6.41156C2.28116 7.08181 1.65006 8.60544 2.10377 10.007L2.64923 11.692C2.71404 11.8922 2.71404 12.1078 2.64923 12.308L2.10377 13.993C1.65006 15.3946 2.28116 16.9182 3.59306 17.5885L5.17023 18.3942C5.35763 18.49 5.51004 18.6424 5.60578 18.8298L6.41156 20.407C7.08181 21.7189 8.60544 22.35 10.007 21.8963L11.692 21.3508C11.8922 21.286 12.1078 21.286 12.308 21.3508L13.993 21.8963C15.3946 22.35 16.9182 21.7189 17.5885 20.407L18.3942 18.8298C18.49 18.6424 18.6424 18.49 18.8298 18.3942L20.407 17.5885C21.7189 16.9182 22.35 15.3946 21.8963 13.993L21.3508 12.308C21.286 12.1078 21.286 11.8922 21.3508 11.692L21.8963 10.007C22.35 8.60544 21.7189 7.08181 20.407 6.41156L18.8298 5.60578C18.6424 5.51004 18.49 5.35763 18.3942 5.17023L17.5885 3.59306C16.9182 2.28116 15.3946 1.65006 13.993 2.10377L12.308 2.64923C12.1078 2.71403 11.8922 2.71404 11.692 2.64923L10.007 2.10377ZM6.75977 11.7573L8.17399 10.343L11.0024 13.1715L16.6593 7.51465L18.0735 8.92886L11.0024 15.9999L6.75977 11.7573Z">

                                        </path>
                                        </svg>
                                    </span>
                                @endif
                            </h2>

                            <ul class="profile-banner-contact">
                                <li>
                                    <a href="javascript:;">
                                        <span>
                                            <svg width="11" height="13" viewBox="0 0 11 13" fill="none"
                                                xmlns="http://www.w3.org/2000/svg">
                                                <path fill-rule="evenodd" clip-rule="evenodd"
                                                    d="M5.5 13C7.5625 13 11 8.96876 11 5.77778C11 2.5868 8.53757 0 5.5 0C2.46243 0 0 2.5868 0 5.77778C0 8.96876 3.4375 13 5.5 13ZM5.49935 7.7999C6.51187 7.7999 7.33268 6.92686 7.33268 5.8499C7.33268 4.77295 6.51187 3.8999 5.49935 3.8999C4.48683 3.8999 3.66602 4.77295 3.66602 5.8499C3.66602 6.92686 4.48683 7.7999 5.49935 7.7999Z" />
                                            </svg>
                                        </span>
                                        {{ html_decode($agent->address) }}
                                    </a>
                                </li>
                                <li>
                                    <a href="javascript:;">
                                        <span>
                                            <svg width="16" height="15" viewBox="0 0 16 15" fill="none"
                                                xmlns="http://www.w3.org/2000/svg">
                                                <path
                                                    d="M16 5.95909C15.8855 6.07153 15.7709 6.21207 15.6564 6.32451C14.4537 7.36454 13.2511 8.37646 12.0484 9.38838C11.9339 9.47271 11.9053 9.55704 11.9625 9.69758C12.3348 11.2717 12.707 12.8739 13.0793 14.448C13.1365 14.6448 13.1079 14.8134 12.9361 14.9258C12.7643 15.0383 12.5925 15.0102 12.4207 14.9258C10.989 14.0826 9.58587 13.2393 8.15415 12.396C8.03961 12.3117 7.9537 12.3117 7.83917 12.396C6.43607 13.2393 5.00435 14.0826 3.60126 14.8977C3.48672 14.9821 3.34355 15.0102 3.20038 14.9821C2.9713 14.9258 2.85676 14.701 2.91403 14.448C3.14311 13.5204 3.34355 12.5928 3.57262 11.6652C3.74443 10.9906 3.8876 10.316 4.05941 9.64136C4.08805 9.52893 4.05941 9.47271 3.97351 9.38838C2.74222 8.34835 1.53957 7.30832 0.308291 6.26829C0.251022 6.21207 0.193753 6.18396 0.165118 6.12775C0.0219457 6.01531 -0.0353233 5.87477 0.0219457 5.678C0.0792147 5.50935 0.222387 5.42502 0.394194 5.39691C0.651905 5.36881 0.909615 5.3407 1.19596 5.3407C2.36998 5.22826 3.54399 5.14393 4.74664 5.0315C4.97572 5.00339 5.20479 4.97528 5.43387 4.97528C5.54841 4.97528 5.60567 4.91906 5.63431 4.83474C6.2929 3.31685 6.92286 1.82708 7.58146 0.309198C7.66736 0.140545 7.75326 0.0281089 7.9537 0C8.18278 0.0562179 8.32595 0.140545 8.41186 0.365416C8.75547 1.15247 9.09908 1.96762 9.4427 2.75467C9.75768 3.4574 10.044 4.18823 10.359 4.89095C10.3876 4.97528 10.4449 5.0315 10.5594 5.0315C11.4757 5.11583 12.3921 5.17204 13.337 5.25637C14.0815 5.31259 14.8546 5.39691 15.5991 5.45313C15.7996 5.48124 15.9141 5.59368 16 5.76233C16 5.81855 16 5.90288 16 5.95909Z" />
                                            </svg>
                                        </span>
                                        {{ $total_agent_rating }} {{ __('translate.Reviews') }}
                                    </a>
                                </li>
                                @if ($setting->agent_contact_info == 'enable')
                                <li class="active">
                                    <a href="tel:{{ html_decode($agent->phone) }}">
                                        <span>
                                            <svg width="14" height="14" viewBox="0 0 14 14" fill="none"
                                                xmlns="http://www.w3.org/2000/svg">
                                                <path
                                                    d="M14 12.4444V11.1643C14 10.5282 13.6127 9.95621 13.0222 9.71998L11.4401 9.08713C10.6889 8.78667 9.83281 9.11215 9.47101 9.83576L9.33333 10.1111C9.33333 10.1111 7.38889 9.72222 5.83333 8.16667C4.27778 6.61111 3.88889 4.66667 3.88889 4.66667L4.16424 4.52899C4.88785 4.16719 5.21333 3.31111 4.91287 2.55994L4.28002 0.977837C4.04379 0.387258 3.4718 0 2.83573 0H1.55556C0.696446 0 0 0.696446 0 1.55556C0 8.42843 5.57157 14 12.4444 14C13.3036 14 14 13.3036 14 12.4444Z"
                                                    fill="#FD4917" />
                                            </svg>
                                        </span>
                                        {{ html_decode($agent->phone) }}
                                    </a>
                                </li>
                                @endif
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- inner-bg  part end  -->



    <!-- profile-details part start  -->
    <section class="profile-details footer-top-pad">
        <div class="container">
            <div class="row">
                <div class=" col-xl-3  col-lg-4">

                    <!-- dealers-details-side-bar  -->
                    <div class="profile-details-side-bar">

                        <!-- Description  -->
                        <div class="profile-details-taitel">
                            <h3>{{ __('translate.About Us') }}</h3>
                            <p>{{ html_decode($agent->about_me) }}</p>
                        </div>

                        @if ($setting->agent_contact_info == 'enable')
                        <!-- Address  -->
                        <div class="profile-details-taitel two">
                            <h3>{{ __('translate.Contact Info') }}</h3>

                            <ul class="address">
                                <li>
                                    <a href="tel:{{ html_decode($agent->phone) }}">
                                        <span>
                                            <svg width="20" height="20" viewBox="0 0 20 20" fill="none"
                                                xmlns="http://www.w3.org/2000/svg">
                                                <path
                                                    d="M13 14L12.8529 14.7354C13.1846 14.8018 13.5196 14.6379 13.6708 14.3354L13 14ZM6 7L5.66459 6.32918C5.36208 6.48043 5.19824 6.81544 5.26456 7.14709L6 7ZM6.35402 6.82299L6.68943 7.49381L6.68943 7.49381L6.35402 6.82299ZM7.31654 4.29136L8.0129 4.01281L7.31654 4.29136ZM6.50289 2.25722L5.80653 2.53576L6.50289 2.25722ZM17.7428 13.4971L17.4642 14.1935L17.7428 13.4971ZM15.7086 12.6835L15.9872 11.9871H15.9872L15.7086 12.6835ZM13.177 13.646L13.8478 13.9814V13.9814L13.177 13.646ZM14.25 9C14.25 9.41421 14.5858 9.75 15 9.75C15.4142 9.75 15.75 9.41421 15.75 9H14.25ZM14.6955 7.46927L15.3884 7.18225L14.6955 7.46927ZM12.5307 5.30448L12.8177 4.61157L12.5307 5.30448ZM11 4.25C10.5858 4.25 10.25 4.58579 10.25 5C10.25 5.41421 10.5858 5.75 11 5.75V4.25ZM18.25 9C18.25 9.41421 18.5858 9.75 19 9.75C19.4142 9.75 19.75 9.41421 19.75 9H18.25ZM18.391 5.93853L19.0839 5.65152L18.391 5.93853ZM14.0615 1.60896L14.3485 0.916054V0.916054L14.0615 1.60896ZM11 0.25C10.5858 0.25 10.25 0.585786 10.25 1C10.25 1.41421 10.5858 1.75 11 1.75V0.25ZM18.25 15.3541V17H19.75V15.3541H18.25ZM3 1.75H4.64593V0.25H3V1.75ZM13 14C13.1471 13.2646 13.1473 13.2646 13.1475 13.2646C13.1476 13.2647 13.1477 13.2647 13.1479 13.2647C13.1481 13.2648 13.1483 13.2648 13.1484 13.2648C13.1487 13.2649 13.1488 13.2649 13.1488 13.2649C13.1488 13.2649 13.1482 13.2648 13.147 13.2645C13.1447 13.264 13.14 13.2631 13.1331 13.2615C13.1193 13.2585 13.0967 13.2533 13.0659 13.2459C13.0044 13.2309 12.9104 13.2066 12.7898 13.1711C12.5482 13.1 12.2016 12.9847 11.7954 12.8106C10.9796 12.461 9.94391 11.8833 9.03033 10.9697L7.96967 12.0303C9.05609 13.1167 10.2704 13.789 11.2046 14.1894C11.6734 14.3903 12.0768 14.525 12.3665 14.6101C12.5115 14.6528 12.6285 14.6832 12.7114 14.7034C12.7529 14.7135 12.7859 14.721 12.8097 14.7263C12.8217 14.7289 12.8313 14.7309 12.8385 14.7325C12.8421 14.7332 12.8451 14.7339 12.8475 14.7343C12.8487 14.7346 12.8498 14.7348 12.8507 14.735C12.8511 14.7351 12.8515 14.7352 12.8519 14.7352C12.8521 14.7353 12.8523 14.7353 12.8524 14.7353C12.8527 14.7354 12.8529 14.7354 13 14ZM9.03033 10.9697C8.11675 10.0561 7.53901 9.02042 7.18936 8.20456C7.01527 7.79836 6.89996 7.45184 6.8289 7.21025C6.79342 7.08962 6.76912 6.99565 6.75414 6.93406C6.74666 6.90329 6.74151 6.88065 6.73847 6.86687C6.73695 6.85999 6.73595 6.85532 6.73546 6.85296C6.73521 6.85178 6.73509 6.85118 6.73508 6.85117C6.73508 6.85116 6.73511 6.8513 6.73517 6.85159C6.7352 6.85174 6.73524 6.85192 6.73528 6.85214C6.7353 6.85225 6.73534 6.85244 6.73535 6.8525C6.73539 6.8527 6.73544 6.85291 6 7C5.26456 7.14709 5.26461 7.14732 5.26466 7.14756C5.26468 7.14765 5.26473 7.1479 5.26477 7.14809C5.26484 7.14846 5.26492 7.14887 5.26501 7.14932C5.2652 7.15022 5.26541 7.15127 5.26566 7.15247C5.26615 7.15488 5.26677 7.15789 5.26753 7.1615C5.26905 7.16873 5.27111 7.17834 5.27374 7.19026C5.279 7.21408 5.28655 7.2471 5.29664 7.28859C5.31682 7.37154 5.34721 7.48851 5.38985 7.6335C5.47504 7.92316 5.60973 8.32664 5.81064 8.79544C6.21099 9.72958 6.88325 10.9439 7.96967 12.0303L9.03033 10.9697ZM6.33541 7.67082L6.68943 7.49381L6.01861 6.15217L5.66459 6.32918L6.33541 7.67082ZM8.0129 4.01281L7.19925 1.97868L5.80653 2.53576L6.62018 4.5699L8.0129 4.01281ZM18.0213 12.8008L15.9872 11.9871L15.4301 13.3798L17.4642 14.1935L18.0213 12.8008ZM12.5062 13.3106L12.3292 13.6646L13.6708 14.3354L13.8478 13.9814L12.5062 13.3106ZM15.9872 11.9871C14.6592 11.4559 13.1458 12.0313 12.5062 13.3106L13.8478 13.9814C14.1386 13.3999 14.8265 13.1384 15.4301 13.3798L15.9872 11.9871ZM6.68943 7.49381C7.96868 6.85419 8.54408 5.34076 8.0129 4.01281L6.62018 4.5699C6.86163 5.17351 6.60008 5.86143 6.01861 6.15217L6.68943 7.49381ZM4.64593 1.75C5.15706 1.75 5.6167 2.06119 5.80653 2.53576L7.19925 1.97868C6.78162 0.934616 5.77042 0.25 4.64593 0.25V1.75ZM19.75 15.3541C19.75 14.2296 19.0654 13.2184 18.0213 12.8008L17.4642 14.1935C17.9388 14.3833 18.25 14.8429 18.25 15.3541H19.75ZM17 18.25C8.57766 18.25 1.75 11.4223 1.75 3H0.25C0.25 12.2508 7.74923 19.75 17 19.75V18.25ZM17 19.75C18.5188 19.75 19.75 18.5188 19.75 17H18.25C18.25 17.6904 17.6904 18.25 17 18.25V19.75ZM1.75 3C1.75 2.30964 2.30964 1.75 3 1.75V0.25C1.48122 0.25 0.25 1.48122 0.25 3H1.75ZM15.75 9C15.75 8.37622 15.6271 7.75855 15.3884 7.18225L14.0026 7.75628C14.1659 8.15059 14.25 8.5732 14.25 9H15.75ZM15.3884 7.18225C15.1497 6.60596 14.7998 6.08232 14.3588 5.64124L13.2981 6.7019C13.5999 7.00369 13.8393 7.36197 14.0026 7.75628L15.3884 7.18225ZM14.3588 5.64124C13.9177 5.20016 13.394 4.85028 12.8177 4.61157L12.2437 5.99739C12.638 6.16072 12.9963 6.40011 13.2981 6.7019L14.3588 5.64124ZM12.8177 4.61157C12.2415 4.37286 11.6238 4.25 11 4.25V5.75C11.4268 5.75 11.8494 5.83406 12.2437 5.99739L12.8177 4.61157ZM19.75 9C19.75 7.85093 19.5237 6.71312 19.0839 5.65152L17.6981 6.22554C18.0625 7.10516 18.25 8.04792 18.25 9H19.75ZM19.0839 5.65152C18.6442 4.58992 17.9997 3.62533 17.1872 2.81282L16.1265 3.87348C16.7997 4.5467 17.3338 5.34593 17.6981 6.22554L19.0839 5.65152ZM17.1872 2.81282C16.3747 2.0003 15.4101 1.35578 14.3485 0.916054L13.7745 2.30187C14.6541 2.66622 15.4533 3.20025 16.1265 3.87348L17.1872 2.81282ZM14.3485 0.916054C13.2869 0.476325 12.1491 0.25 11 0.25V1.75C11.9521 1.75 12.8948 1.93753 13.7745 2.30187L14.3485 0.916054Z">
                                                </path>
                                            </svg>
                                        </span>

                                        {{ html_decode($agent->phone) }}
                                    </a>
                                </li>
                                <li>
                                    <a href="https://wa.me/{{ html_decode($agent->whatsapp_phone) }}">
                                        <span>
                                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path fill-rule="evenodd" clip-rule="evenodd" d="M12 2.75C6.89136 2.75 2.75 6.89137 2.75 12C2.75 13.3995 3.06028 14.7244 3.61508 15.9115C3.67885 16.0479 3.70006 16.2004 3.67596 16.3491L2.96332 20.7445C2.93594 20.9134 3.08245 21.0592 3.2512 21.0311L7.60652 20.3052C7.75734 20.2801 7.91224 20.3017 8.05047 20.367C9.24731 20.9331 10.5856 21.25 12 21.25C17.1086 21.25 21.25 17.1086 21.25 12C21.25 6.89137 17.1086 2.75 12 2.75ZM1.25 12C1.25 6.06294 6.06294 1.25 12 1.25C17.9371 1.25 22.75 6.06294 22.75 12C22.75 17.9371 17.9371 22.75 12 22.75C10.4438 22.75 8.96315 22.4189 7.62607 21.8227L3.49779 22.5107C2.31657 22.7076 1.291 21.6865 1.48265 20.5044L2.15903 16.3326C1.57433 15.0064 1.25 13.5401 1.25 12Z" />
                                        <path d="M16 15.1111V14.6749C16 14.1331 15.6701 13.6458 15.167 13.4446L14.7005 13.258C14.1789 13.0494 13.5845 13.2753 13.3333 13.7778C13.3333 13.7778 12.2222 13.5556 11.3333 12.6667C10.4444 11.7778 10.2222 10.6667 10.2222 10.6667C10.7247 10.4155 10.9506 9.82105 10.742 9.29949L10.5554 8.83296C10.3542 8.32988 9.86693 8 9.32509 8H8.88889C8.39797 8 8 8.39797 8 8.88889C8 12.8162 11.1838 16 15.1111 16C15.602 16 16 15.602 16 15.1111Z" />
                                        </svg>
                                        </span>

                                        {{ html_decode($agent->whatsapp_phone) }}
                                    </a>
                                </li>
                                <li>
                                    <a href="mailto:{{ html_decode($agent->email) }}">
                                        <span>
                                            <svg class=" svg-two " width="24" height="24" viewBox="0 0 24 24"
                                                fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <path
                                                    d="M2 12V7C2 4.79086 3.79086 3 6 3H18C20.2091 3 22 4.79086 22 7V17C22 19.2091 20.2091 21 18 21H8M6 8L9.7812 10.5208C11.1248 11.4165 12.8752 11.4165 14.2188 10.5208L18 8M2 15H8M2 18H8"
                                                    stroke-width="1.5" stroke-linecap="round"></path>
                                            </svg>
                                        </span>

                                        {{ html_decode($agent->email) }}
                                    </a>
                                </li>
                                <li>
                                    <a href="javascript:;">
                                        <span>
                                            <svg width="18" height="22" viewBox="0 0 18 22" fill="none"
                                                xmlns="http://www.w3.org/2000/svg">
                                                <path
                                                    d="M3 20.25C2.58579 20.25 2.25 20.5858 2.25 21C2.25 21.4142 2.58579 21.75 3 21.75V20.25ZM15 21.75C15.4142 21.75 15.75 21.4142 15.75 21C15.75 20.5858 15.4142 20.25 15 20.25V21.75ZM15.75 8.5C15.75 10.2065 14.6599 12.4136 13.1547 14.2468C12.4148 15.1481 11.6072 15.9179 10.8465 16.4554C10.0624 17.0094 9.42269 17.25 9 17.25V18.75C9.88982 18.75 10.8438 18.294 11.7121 17.6804C12.6038 17.0504 13.5071 16.1815 14.314 15.1987C15.9026 13.2638 17.25 10.7209 17.25 8.5H15.75ZM9 17.25C8.59247 17.25 7.95947 16.9993 7.171 16.4074C6.409 15.8353 5.59932 15.0178 4.85679 14.0668C3.34675 12.1327 2.25 9.82498 2.25 8.11111H0.75C0.75 10.3246 2.09075 12.9614 3.67446 14.9899C4.4788 16.0201 5.38006 16.9385 6.27041 17.6069C7.13428 18.2555 8.09503 18.75 9 18.75V17.25ZM2.25 8.11111C2.25 4.48059 5.47857 1.75 9 1.75V0.25C4.78944 0.25 0.75 3.51941 0.75 8.11111H2.25ZM9 1.75C12.4938 1.75 15.75 4.45503 15.75 8.5H17.25C17.25 3.54497 13.2382 0.25 9 0.25V1.75ZM11.25 8C11.25 9.24264 10.2426 10.25 9 10.25V11.75C11.0711 11.75 12.75 10.0711 12.75 8H11.25ZM9 10.25C7.75736 10.25 6.75 9.24264 6.75 8H5.25C5.25 10.0711 6.92893 11.75 9 11.75V10.25ZM6.75 8C6.75 6.75736 7.75736 5.75 9 5.75V4.25C6.92893 4.25 5.25 5.92893 5.25 8H6.75ZM9 5.75C10.2426 5.75 11.25 6.75736 11.25 8H12.75C12.75 5.92893 11.0711 4.25 9 4.25V5.75ZM3 21.75H15V20.25H3V21.75Z">
                                                </path>
                                            </svg>
                                        </span>

                                        {{ html_decode($agent->address) }}
                                    </a>
                                </li>
                            </ul>

                        </div>
                        @endif



                        <!-- Working Hours  -->
                        <div class="profile-details-taitel two">
                            <h3>{{ __('translate.Working Hours') }}</h3>

                            <ul class="working-hours">
                                <li><span>{{ __('translate.Sunday') }}</span>{{ html_decode($agent->sunday) }}</li>
                                <li><span>{{ __('translate.Monday') }}</span>{{ html_decode($agent->monday) }}</li>
                                <li><span>{{ __('translate.Tuesday') }}</span>{{ html_decode($agent->tuesday) }}</li>
                                <li><span>{{ __('translate.Wednesday') }}</span>{{ html_decode($agent->wednesday) }}</li>
                                <li><span>{{ __('translate.Thursday') }}</span>{{ html_decode($agent->thursday) }}</li>
                                <li><span>{{ __('translate.Friday') }}</span>{{ html_decode($agent->friday) }}</li>
                                <li><span>{{ __('translate.Saturday') }}</span>{{ html_decode($agent->saturday) }}</li>
                            </ul>

                        </div>


                        <!-- Location Map  -->
                        <div class="profile-details-taitel two">
                            <h3>{{ __('translate.Location Map') }}</h3>

                            <div class="map">

                                <iframe src="{{ html_decode($agent->google_map) }}"  allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>

                            </div>

                        </div>


                        <!-- Follow my Social   -->
                        <div class="profile-details-taitel two">
                            <h3>{{ __('translate.Follow my Social') }} </h3>

                            <ul class="social-link">
                                <li>
                                    <a href="{{ html_decode($agent->instagram) }}" target="_blank">
                                        <span>
                                            <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <g clip-path="url(#clip0_2944_144932)">
                                                <mask id="mask0_2944_144932" style="mask-type:luminance" maskUnits="userSpaceOnUse" x="0" y="0" width="20" height="20">
                                                <path d="M0 20H20V0H0V20Z" fill="white"/>
                                                </mask>
                                                <g mask="url(#mask0_2944_144932)">
                                                <path fill-rule="evenodd" clip-rule="evenodd" d="M0 2.92969C0 1.31167 1.31167 0 2.92969 0H17.0703C18.6883 0 20 1.31167 20 2.92969V17.0703C20 18.6883 18.6883 20 17.0703 20H2.92969C1.31167 20 0 18.6883 0 17.0703V2.92969ZM2.92969 1.17187C1.95888 1.17187 1.17187 1.95888 1.17187 2.92969V17.0703C1.17187 18.0411 1.95888 18.8281 2.92969 18.8281H17.0703C18.0411 18.8281 18.8281 18.0411 18.8281 17.0703V2.92969C18.8281 1.95888 18.0411 1.17187 17.0703 1.17187H2.92969Z" />
                                                <path fill-rule="evenodd" clip-rule="evenodd" d="M15.2734 16.4453C15.2734 15.798 15.7981 15.2734 16.4453 15.2734C17.0925 15.2734 17.6172 15.798 17.6172 16.4453C17.6172 17.0925 17.0925 17.6172 16.4453 17.6172C15.7981 17.6172 15.2734 17.0925 15.2734 16.4453Z" />
                                                <path fill-rule="evenodd" clip-rule="evenodd" d="M4.72656 10C4.72656 7.08757 7.08757 4.72656 10 4.72656C12.9124 4.72656 15.2734 7.08757 15.2734 10C15.2734 12.9124 12.9124 15.2734 10 15.2734C7.08757 15.2734 4.72656 12.9124 4.72656 10ZM10 5.89844C7.73478 5.89844 5.89844 7.73478 5.89844 10C5.89844 12.2652 7.73478 14.1016 10 14.1016C12.2652 14.1016 14.1016 12.2652 14.1016 10C14.1016 7.73478 12.2652 5.89844 10 5.89844Z" />
                                                </g>
                                                </svg>
                                        </span>
                                    </a>
                                </li>
                                <li>
                                    <a href="{{ html_decode($agent->facebook) }}" target="_blank">
                                        <span>
                                            <svg width="20" height="20" viewBox="0 0 13 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <g clip-path="url(#clip0_423_120014)">
                                                    <path d="M7.74461 13.009H5.79193C5.46577 13.009 5.20045 12.7437 5.20045 12.4175V8.01311H4.06121C3.73505 8.01311 3.46973 7.7477 3.46973 7.42163V5.53435C3.46973 5.20818 3.73505 4.94286 4.06121 4.94286H5.20045V3.99778C5.20045 3.06069 5.4947 2.26343 6.05129 1.69232C6.6104 1.11861 7.39175 0.81543 8.31088 0.81543L9.8001 0.817848C10.1257 0.818407 10.3906 1.08373 10.3906 1.40933V3.16163C10.3906 3.48779 10.1253 3.75311 9.79926 3.75311L8.79659 3.75348C8.4908 3.75348 8.41294 3.81479 8.39628 3.83358C8.36884 3.86475 8.33619 3.95285 8.33619 4.19612V4.94277H9.72391C9.82838 4.94277 9.9296 4.96854 10.0166 5.0171C10.2042 5.12195 10.3209 5.32019 10.3209 5.53444L10.3201 7.42173C10.3201 7.7477 10.0548 8.01302 9.72865 8.01302H8.33619V12.4175C8.33619 12.7437 8.07078 13.009 7.74461 13.009ZM5.91528 12.2941H7.62126V7.69309C7.62126 7.47531 7.79848 7.29818 8.01617 7.29818H9.60529L9.60595 5.6577H8.01607C7.79838 5.6577 7.62126 5.48058 7.62126 5.26279V4.19612C7.62126 3.91684 7.64963 3.59924 7.86044 3.36053C8.11515 3.07195 8.51657 3.03865 8.7964 3.03865L9.67572 3.03827V1.5325L8.31033 1.53027C6.8332 1.53027 5.91528 2.47582 5.91528 3.99778V5.26279C5.91528 5.48048 5.73816 5.6577 5.52047 5.6577H4.18456V7.29818H5.52047C5.73816 7.29818 5.91528 7.47531 5.91528 7.69309V12.2941Z">
                                                    </path>
                                                </g>

                                            </svg>
                                        </span>
                                    </a>
                                </li>

                                <li>
                                    <a href="{{ html_decode($agent->linkedin) }}" target="_blank">
                                        <span>
                                            <svg width="20" height="20" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <g clip-path="url(#clip0_423_120018)">
                                                    <path d="M2.61293 1.06934C2.16584 1.06934 1.75938 1.23192 1.45454 1.53676C1.12939 1.86192 0.966797 2.26835 0.966797 2.69513C0.966797 3.14222 1.1497 3.54867 1.45454 3.85351C1.75938 4.15835 2.18615 4.34126 2.59261 4.32094C2.59261 4.32094 2.61293 4.32094 2.63326 4.32094C3.03972 4.32094 3.42584 4.15835 3.73068 3.85351C4.03552 3.54867 4.21843 3.14222 4.21843 2.69513C4.23874 2.26835 4.05584 1.86189 3.751 1.55705C3.44616 1.2319 3.0397 1.06934 2.61293 1.06934ZM3.44616 3.56901C3.2226 3.79257 2.91776 3.93482 2.59261 3.91451C2.28777 3.91451 1.96262 3.79257 1.73906 3.56901C1.49519 3.34546 1.37326 3.0203 1.37326 2.69515C1.37326 2.37 1.49519 2.06516 1.73906 1.82129C1.96262 1.59773 2.26746 1.4758 2.61293 1.4758C2.91776 1.4758 3.2226 1.59773 3.44616 1.82129C3.69003 2.06516 3.81197 2.37 3.81197 2.69515C3.81197 3.0203 3.69003 3.34546 3.44616 3.56901Z">
                                                    </path>
                                                    <path d="M3.40541 4.72754H1.75928C1.43413 4.72754 1.16992 4.99172 1.16992 5.33722V12.4501C1.16992 12.7753 1.45445 13.0598 1.7796 13.0598H3.40541C3.73057 13.0598 4.01509 12.7753 4.01509 12.4704V5.33722C4.01509 5.01204 3.73057 4.72754 3.40541 4.72754ZM3.60863 12.4704C3.60863 12.5721 3.50701 12.6533 3.40541 12.6533H1.7796C1.67798 12.6533 1.57638 12.5517 1.57638 12.4501V5.33722C1.57638 5.2356 1.65766 5.134 1.75928 5.134H3.40541C3.50703 5.134 3.60863 5.23562 3.60863 5.33722V12.4704Z">
                                                    </path>
                                                    <path d="M10.3149 4.52441H9.88816C9.09558 4.52441 8.34365 4.86991 7.85591 5.41862V5.13409C7.85591 4.93087 7.65269 4.72763 7.44945 4.72763H5.4172C5.2343 4.72763 5.01074 4.89022 5.01074 5.11375V12.6941C5.01074 12.9176 5.2343 13.0599 5.4172 13.0599H7.65269C7.8356 13.0599 8.05915 12.9176 8.05915 12.6941V8.30439C8.05915 7.63375 8.5469 7.10535 9.17689 7.10535C9.50204 7.10535 9.80688 7.22729 10.0304 7.45084C10.2337 7.63375 10.315 7.91827 10.315 8.28408V12.6534C10.315 12.8567 10.5182 13.0599 10.7214 13.0599H12.7537C12.9569 13.0599 13.1601 12.8567 13.1601 12.6534V7.41021C13.1601 5.78442 11.9204 4.52441 10.3149 4.52441ZM12.7536 12.6331L12.7333 12.6534H10.7417L10.7214 8.2841C10.7214 7.79636 10.5995 7.43055 10.3353 7.16637C10.0304 6.86153 9.62398 6.69894 9.1972 6.69894C8.34365 6.71925 7.67301 7.41024 7.67301 8.30441V12.6534H5.43752V5.13409H7.44945L7.46977 5.15441V6.43473L8.01848 5.88602L8.03879 5.8657C8.44525 5.29668 9.15652 4.93087 9.90848 4.93087H10.3352C11.6969 4.93087 12.7536 6.02829 12.7536 7.41024V12.6331Z">
                                                    </path>
                                                </g>
                                            </svg>
                                        </span>
                                    </a>
                                </li>
                                <li>
                                    <a href="{{ html_decode($agent->twitter) }}" target="_blank">
                                        <span>
                                            <svg width="20" height="20" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <g clip-path="url(#clip0_423_120005)">
                                                    <path d="M1.20739 10.9229C2.33631 11.6393 3.65016 12.0178 5.00669 12.0178C6.99323 12.0178 8.81362 11.2547 10.1331 9.86918C11.3956 8.54313 12.0901 6.76135 12.0556 4.95315C12.5342 4.54365 13.0971 3.76174 13.0971 2.99964C13.0971 2.7075 12.7801 2.52206 12.523 2.67092C12.0734 2.93512 11.6634 3.00421 11.2417 2.88584C10.3805 2.04651 9.09865 1.86971 8.0185 2.45195C7.07452 2.96001 6.54969 3.88977 6.59693 4.9059C5.00212 4.71131 3.52873 3.91162 2.50143 2.66889C2.33275 2.46617 2.01267 2.49005 1.87854 2.7197C1.38368 3.56715 1.38877 4.54924 1.8191 5.34233C1.61435 5.3784 1.48784 5.55063 1.48784 5.73709C1.48784 6.53425 1.84653 7.26688 2.4242 7.76681C2.31649 7.87046 2.28093 8.0244 2.32665 8.16158C2.58068 8.92469 3.15581 9.52116 3.87473 9.8199C3.09281 10.1933 2.22809 10.3178 1.45837 10.2233C1.06005 10.1694 0.863426 10.7049 1.20739 10.9229ZM5.11085 9.95047C5.39587 9.7315 5.24447 9.27525 4.88679 9.26763C4.25679 9.25442 3.68318 8.944 3.32602 8.45575C3.49825 8.44457 3.67658 8.41815 3.84627 8.37242C4.23291 8.26776 4.21462 7.70991 3.82189 7.63116C3.10907 7.48788 2.54969 6.96864 2.33986 6.30003C2.5314 6.34728 2.7265 6.3737 2.92109 6.37725C3.30671 6.37929 3.45252 5.88494 3.13803 5.67816C2.42928 5.21125 2.12698 4.38666 2.32716 3.61135C3.56481 4.86525 5.24396 5.62075 7.02015 5.7061C7.27469 5.72185 7.46572 5.48255 7.40984 5.24021C7.16851 4.1941 7.75278 3.46096 8.38024 3.1231C9.0011 2.78778 9.99792 2.68312 10.762 3.48484C10.9892 3.72414 11.7553 3.73329 12.145 3.64234C11.9702 3.97157 11.7015 4.28403 11.45 4.45982C11.3428 4.53501 11.2813 4.66 11.2879 4.79057C11.3697 6.45956 10.7478 8.1189 9.58181 9.34283C8.40717 10.5759 6.78289 11.2552 5.0072 11.2552C4.30099 11.2552 3.6085 11.1404 2.95411 10.9188C3.73653 10.7674 4.47983 10.4362 5.11085 9.95047Z">
                                                    </path>
                                                </g>
                                            </svg>
                                        </span>
                                    </a>
                                </li>
                            </ul>

                        </div>
                    </div>


                    <!-- Contact Beach  -->

                    <div class="contact-beach-box">
                        <div class="contact-beach-box-taitel">
                            <h3>{{ __('translate.Contact Us') }}</h3>
                        </div>

                        <form class="contact-beach-box-main" action="{{ route('store-agent-contact-message', $agent->id) }}" method="POST">
                            @csrf

                            <div class="contact-beach-box-item">
                                <input type="text" class="form-control"
                                    placeholder="{{ __('translate.Your Name') }}" name="name" value="{{ old('name') }}">
                            </div>
                            <div class="contact-beach-box-item">
                                <input type="email" class="form-control"
                                    placeholder="{{ __('translate.Your Email') }}" name="email" value="{{ old('email') }}">
                            </div>
                            <div class="contact-beach-box-item">
                                <input type="text" class="form-control"
                                    placeholder="{{ __('translate.Your Phone') }}" name="phone" value="{{ old('phone') }}">
                            </div>
                            <div class="contact-beach-box-item">
                                <input type="text" class="form-control"
                                    placeholder="{{ __('translate.Your Subject') }}" name="subject" value="{{ old('subject') }}">
                            </div>

                            <div class="contact-beach-box-item two">
                                    <textarea class="form-control" rows="5" placeholder="{{ __('translate.Type Message') }}" name="message">{{ old('message') }}</textarea>
                            </div>

                            @if($google_recaptcha->status==1)
                                <div class="contact-beach-box-item two">
                                    <div class="g-recaptcha" data-sitekey="{{ $google_recaptcha->site_key }}"></div>
                                </div>
                            @endif

                            <a class="main-btn send " href="javascript:;" id="send_agent_message">
                                <div class="btn_m">
                                    <div class="btn_c">
                                        <div class="btn_t1">{{ __('translate.Send Message') }}</div>
                                        <div class="btn_t2">{{ __('translate.Send Message') }}</div>
                                    </div>
                                </div>
                            </a>



                        </form>
                    </div>


                </div>


                <div class=" col-xl-9 col-lg-8">
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="classified-listings-bar" >
                                <div class="left">
                                    <ul class="shaf-filter course-filter ">
                                        <li class="active" data-group="Classified" class="" id="Classified_item_filter">{{ __('translate.Classified') }}</li>
                                        <li data-group="Real-Estate" class="">{{ __('translate.Real Estate') }}</li>
                                        <li data-group="JobPost" class="">{{ __('translate.Job Post') }}</li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row  mt-20px g-3 shafull-container ">

                        @foreach ($listings as $index => $listing)
                            @if ($listing->category_id == 1)
                            <div class="  col-xxl-4 col-lg-6 col-sm-6 shaf-item" data-groups='["Classified"]'>
                            @elseif ($listing->category_id == 2)
                            <div class="  col-xxl-4 col-lg-6 col-sm-6 shaf-item" data-groups='["Real-Estate"]'>
                            @elseif ($listing->category_id == 3)
                            <div class="  col-xxl-4 col-lg-6 col-sm-6 shaf-item job-listing common-class" data-groups='["JobPost" ]'>
                            @endif
                                @if ($listing->category_id == 3)
                                    <div class="job-listing-item">
                                        <div class="job-listing-item-inner">
                                            <div class="job-listing-img">
                                                <img src="{{ asset($listing->thumb_image) }}" alt="img">
                                            </div>

                                            <div class="job-listing-img-btn">
                                                @guest('web')
                                                    <a href="javascript:;" class="before_auth_wishlist">
                                                        <span>
                                                            <svg width="24" height="21" viewBox="0 0 20 18" fill="none"
                                                                xmlns="http://www.w3.org/2000/svg">
                                                                <path
                                                                    d="M10.765 1.70229L10 2.52422L9.23495 1.70229C7.12233 -0.567428 3.69709 -0.56743 1.58447 1.70229C-0.528155 3.972 -0.528156 7.65194 1.58447 9.92165L8.4699 17.3191C9.31495 18.227 10.685 18.227 11.5301 17.3191L18.4155 9.92165C20.5282 7.65194 20.5282 3.972 18.4155 1.70229C16.3029 -0.567429 12.8777 -0.567429 10.765 1.70229Z" />
                                                            </svg>
                                                        </span>
                                                    </a>
                                                @else
                                                    <a href="{{ route('user.add-to-wishlist', $listing->id) }}">
                                                        <span>
                                                            <svg width="24" height="21" viewBox="0 0 20 18" fill="none"
                                                                xmlns="http://www.w3.org/2000/svg">
                                                                <path
                                                                    d="M10.765 1.70229L10 2.52422L9.23495 1.70229C7.12233 -0.567428 3.69709 -0.56743 1.58447 1.70229C-0.528155 3.972 -0.528156 7.65194 1.58447 9.92165L8.4699 17.3191C9.31495 18.227 10.685 18.227 11.5301 17.3191L18.4155 9.92165C20.5282 7.65194 20.5282 3.972 18.4155 1.70229C16.3029 -0.567429 12.8777 -0.567429 10.765 1.70229Z" />
                                                            </svg>
                                                        </span>
                                                    </a>
                                                @endguest

                                                @if ($listing->is_urgent == 'enable')
                                                    <span class="txt">{{ __('translate.Urgent') }}</span>
                                                @endif
                                            </div>
                                        </div>

                                        <div class="job-listing-content">
                                            <p>{{ currency($listing->regular_price) }}/{{ __('translate.m') }}</p>

                                            <a href="{{ route('listing', $listing->slug) }}">
                                                <h3 class="job-listing-content-link">{{ html_decode($listing->title) }}</h3>
                                            </a>
                                        </div>

                                        <div class="job-listing-content-btn">
                                            <a href="javascript:;">
                                                <span>
                                                    <svg width="12" height="14" viewBox="0 0 10 11" fill="none"
                                                        xmlns="http://www.w3.org/2000/svg">
                                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                                            d="M2.97888 0.513554C2.97888 0.298962 2.80492 0.125 2.59032 0.125C2.37573 0.125 2.20177 0.298962 2.20177 0.513554V1.7167C1.35167 2.14527 0.675371 2.86822 0.306805 3.75163H9.0185C8.64993 2.86823 7.97365 2.14529 7.12357 1.71672V0.513554C7.12357 0.298962 6.94961 0.125 6.73501 0.125C6.52042 0.125 6.34646 0.298962 6.34646 0.513554V1.4222C6.02048 1.33638 5.67823 1.29067 5.3253 1.29067H4C3.64709 1.29067 3.30485 1.33638 2.97888 1.42219V0.513554ZM0 5.29067C0 5.03013 0.0249108 4.7754 0.0724807 4.52874H9.25282C9.30039 4.7754 9.3253 5.03013 9.3253 5.29068V6.87501C9.3253 9.08415 7.53444 10.875 5.3253 10.875H4C1.79086 10.875 0 9.08415 0 6.87501V5.29067ZM4.66263 7.76653C4.94876 7.76653 5.18071 7.53458 5.18071 7.24846C5.18071 6.96234 4.94876 6.73039 4.66263 6.73039C4.37651 6.73039 4.14456 6.96234 4.14456 7.24846C4.14456 7.53458 4.37651 7.76653 4.66263 7.76653ZM7.25274 7.24846C7.25274 7.53458 7.02079 7.76653 6.73467 7.76653C6.44854 7.76653 6.21659 7.53458 6.21659 7.24846C6.21659 6.96234 6.44854 6.73039 6.73467 6.73039C7.02079 6.73039 7.25274 6.96234 7.25274 7.24846ZM2.59029 7.76653C2.87641 7.76653 3.10836 7.53458 3.10836 7.24846C3.10836 6.96234 2.87641 6.73039 2.59029 6.73039C2.30417 6.73039 2.07222 6.96234 2.07222 7.24846C2.07222 7.53458 2.30417 7.76653 2.59029 7.76653Z" />
                                                    </svg>
                                                </span>

                                                {{ $listing->created_at->diffForHumans() }}
                                            </a>


                                            <a href="javascript:;">
                                                <span>
                                                    <svg width="12" height="14" viewBox="0 0 10 11" fill="none"
                                                        xmlns="http://www.w3.org/2000/svg">
                                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                                            d="M4.81644 11C6.56164 11 9.47029 7.58895 9.47029 4.88889C9.47029 2.18883 7.38669 0 4.81644 0C2.2462 0 0.162598 2.18883 0.162598 4.88889C0.162598 7.58895 3.07125 11 4.81644 11ZM4.81631 6.59992C5.67306 6.59992 6.36759 5.86119 6.36759 4.94992C6.36759 4.03865 5.67306 3.29992 4.81631 3.29992C3.95956 3.29992 3.26502 4.03865 3.26502 4.94992C3.26502 5.86119 3.95956 6.59992 4.81631 6.59992Z" />
                                                    </svg>
                                                </span>

                                                {{ html_decode($listing->address) }}
                                            </a>
                                        </div>

                                        <div class="job-listing-btn">
                                            <a class="main-btn " href="{{ route('listing', ['slug' => $listing->slug,'is_apply' => 'yes']) }}">
                                                <div class="btn_m">
                                                    <div class="btn_c">
                                                        <div class="btn_t1">{{ __('translate.Apply Now') }}</div>
                                                        <div class="btn_t2">{{ __('translate.Apply Now') }}</div>
                                                    </div>
                                                </div>
                                            </a>
                                            <a class="main-btn two " href="{{ route('listing', $listing->slug) }}">
                                                <div class="btn_m">
                                                    <div class="btn_c">
                                                        <div class="btn_t1">{{ __('translate.Detail Now') }}</div>
                                                        <div class="btn_t2">{{ __('translate.Detail Now') }}</div>
                                                    </div>
                                                </div>
                                            </a>


                                        </div>
                                    </div>
                                @else


                                <div class="features-single-box ">
                                    <div class="features-thumb">
                                        <img src="{{ asset($listing->thumb_image) }}" alt="img">
                                    </div>

                                    <div class="features-single-box-over">
                                        <div class="text">
                                            @if ($listing->is_urgent == 'enable')
                                            <p>{{ __('translate.Urgent') }}</p>
                                            @endif

                                            @if ($listing->is_featured == 'enable')
                                            <h6>{{ __('translate.Featured') }}</h6>
                                            @endif
                                        </div>

                                        <div class="icon">
                                            @guest('web')
                                                <a href="javascript:;" class="before_auth_wishlist">
                                                    <span>
                                                        <svg width="24" height="21" viewBox="0 0 20 18" fill="none"
                                                            xmlns="http://www.w3.org/2000/svg">
                                                            <path
                                                                d="M10.765 1.70229L10 2.52422L9.23495 1.70229C7.12233 -0.567428 3.69709 -0.56743 1.58447 1.70229C-0.528155 3.972 -0.528156 7.65194 1.58447 9.92165L8.4699 17.3191C9.31495 18.227 10.685 18.227 11.5301 17.3191L18.4155 9.92165C20.5282 7.65194 20.5282 3.972 18.4155 1.70229C16.3029 -0.567429 12.8777 -0.567429 10.765 1.70229Z" />
                                                        </svg>
                                                    </span>
                                                </a>
                                            @else
                                                <a href="{{ route('user.add-to-wishlist', $listing->id) }}">
                                                    <span>
                                                        <svg width="24" height="21" viewBox="0 0 20 18" fill="none"
                                                            xmlns="http://www.w3.org/2000/svg">
                                                            <path
                                                                d="M10.765 1.70229L10 2.52422L9.23495 1.70229C7.12233 -0.567428 3.69709 -0.56743 1.58447 1.70229C-0.528155 3.972 -0.528156 7.65194 1.58447 9.92165L8.4699 17.3191C9.31495 18.227 10.685 18.227 11.5301 17.3191L18.4155 9.92165C20.5282 7.65194 20.5282 3.972 18.4155 1.70229C16.3029 -0.567429 12.8777 -0.567429 10.765 1.70229Z" />
                                                        </svg>
                                                    </span>
                                                </a>
                                            @endguest

                                        </div>
                                    </div>


                                    <div class="features-single-box-inner">
                                        <div class="features-single-box-inner-txt">
                                            <p>

                                                <span>
                                                    <svg width="11" height="12" viewBox="0 0 11 12" fill="none"
                                                        xmlns="http://www.w3.org/2000/svg">
                                                        <path
                                                            d="M10.9992 3.43661C10.9992 4.03851 11.001 4.63998 10.9984 5.24188C10.9971 5.59777 10.8734 5.90712 10.6216 6.16046C10.253 6.53143 9.88231 6.89981 9.51201 7.26948C8.1817 8.59823 6.8514 9.92699 5.52152 11.2562C5.40297 11.3747 5.27925 11.485 5.11717 11.5405C4.78523 11.6543 4.47658 11.6069 4.21276 11.3772C3.99593 11.1881 3.79548 10.9796 3.59158 10.7762C2.52854 9.71458 1.46636 8.65166 0.405044 7.58874C0.330468 7.51421 0.257184 7.43708 0.192523 7.35393C-0.0816435 6.99977 -0.0622449 6.50946 0.245976 6.18287C0.471862 5.94331 0.708524 5.71367 0.941737 5.48058C2.27248 4.14967 3.60365 2.81919 4.93439 1.48872C5.11415 1.30905 5.29089 1.12594 5.47453 0.949719C5.70904 0.724383 5.99527 0.604606 6.31815 0.602882C7.545 0.597712 8.77142 0.600728 9.99827 0.600728C10.275 0.600728 10.5255 0.673111 10.7251 0.876474C10.8854 1.03977 10.982 1.23494 10.9885 1.46502C10.9971 1.79979 10.9975 2.13457 10.9992 2.46934C11.001 2.79162 10.9992 3.1139 10.9992 3.43618V3.43661ZM9.16327 3.35733C9.1706 2.86228 8.77271 2.45254 8.28603 2.4353C7.76571 2.41678 7.3355 2.82695 7.33075 3.34656C7.32644 3.83773 7.72562 4.24963 8.21059 4.26902C8.72616 4.2897 9.17318 3.86703 9.16327 3.35733Z" />
                                                    </svg>
                                                </span>
                                                {{ $listing?->sub_category?->name }}
                                            </p>

                                            <span>
                                                {{ currency($listing->regular_price) }}
                                            </span>
                                        </div>


                                        <a href="{{ route('listing', $listing->slug) }}">
                                            <h3>{{ html_decode($listing->title) }}</h3>
                                        </a>


                                        <div class="features-single-box-contact">
                                            <div class="location">
                                                <p><a href="javascript:;">
                                                        <span>
                                                            <svg width="11" height="13" viewBox="0 0 11 13" fill="none"
                                                                xmlns="http://www.w3.org/2000/svg">
                                                                <path fill-rule="evenodd" clip-rule="evenodd"
                                                                    d="M5.5 13C7.5625 13 11 8.96876 11 5.77778C11 2.5868 8.53757 0 5.5 0C2.46243 0 0 2.5868 0 5.77778C0 8.96876 3.4375 13 5.5 13ZM5.5 7.7999C6.51252 7.7999 7.33333 6.92686 7.33333 5.8499C7.33333 4.77295 6.51252 3.8999 5.5 3.8999C4.48748 3.8999 3.66667 4.77295 3.66667 5.8499C3.66667 6.92686 4.48748 7.7999 5.5 7.7999Z" />
                                                            </svg>
                                                        </span>
                                                        {{ html_decode($listing->address) }}
                                                    </a>
                                                </p>
                                            </div>

                                            <div class="contact">
                                                <p>
                                                    <a href="{{ route('agent', $listing?->agent?->username) }}">
                                                        <span>
                                                            <svg width="13" height="16" viewBox="0 0 13 16" fill="none"
                                                                xmlns="http://www.w3.org/2000/svg">
                                                                <path fill-rule="evenodd" clip-rule="evenodd"
                                                                    d="M6.22222 7.11111C8.1859 7.11111 9.77778 5.51923 9.77778 3.55556C9.77778 1.59188 8.1859 0 6.22222 0C4.25854 0 2.66667 1.59188 2.66667 3.55556C2.66667 5.51923 4.25854 7.11111 6.22222 7.11111ZM6.22222 16C9.65866 16 12.4444 14.4081 12.4444 12.4444C12.4444 10.4808 9.65866 8.88889 6.22222 8.88889C2.78578 8.88889 0 10.4808 0 12.4444C0 14.4081 2.78578 16 6.22222 16Z" />
                                                            </svg>
                                                        </span>
                                                        {{ $listing?->agent?->name }}
                                                    </a>
                                                </p>
                                                <p>
                                                    <a href="javascript:;">
                                                        <span>
                                                            <svg width="15" height="17" viewBox="0 0 15 17" fill="none"
                                                                xmlns="http://www.w3.org/2000/svg">
                                                                <path fill-rule="evenodd" clip-rule="evenodd"
                                                                    d="M4.64157 0.605422C4.64157 0.271056 4.37051 0 4.03614 0C3.70178 0 3.43072 0.271057 3.43072 0.605422V1.85647C1.54458 2.12521 0.0823859 3.70969 0.00336393 5.65071H14.5268C14.4477 3.70969 12.9855 2.12521 11.0994 1.85647V0.605422C11.0994 0.271057 10.8283 0 10.494 0C10.1596 0 9.88855 0.271057 9.88855 0.605422V1.81627H4.64157L4.64157 0.605422ZM1.54674e-05 6.86155H14.5301V12.75C14.5301 14.9591 12.7393 16.75 10.5301 16.75H4C1.79086 16.75 0 14.9591 0 12.75V6.86155H1.54674e-05ZM7.26508 11.9066C7.7109 11.9066 8.0723 11.5452 8.0723 11.0994C8.0723 10.6536 7.7109 10.2922 7.26508 10.2922C6.81926 10.2922 6.45785 10.6536 6.45785 11.0994C6.45785 11.5452 6.81926 11.9066 7.26508 11.9066ZM11.3012 11.0994C11.3012 11.5452 10.9398 11.9066 10.494 11.9066C10.0482 11.9066 9.68676 11.5452 9.68676 11.0994C9.68676 10.6536 10.0482 10.2922 10.494 10.2922C10.9398 10.2922 11.3012 10.6536 11.3012 11.0994ZM4.03616 11.9066C4.48198 11.9066 4.84339 11.5452 4.84339 11.0994C4.84339 10.6536 4.48198 10.2922 4.03616 10.2922C3.59034 10.2922 3.22893 10.6536 3.22893 11.0994C3.22893 11.5452 3.59034 11.9066 4.03616 11.9066Z" />
                                                            </svg>
                                                        </span>
                                                        {{ $listing->created_at->diffForHumans() }}
                                                    </a>
                                                </p>
                                            </div>
                                        </div>

                                    </div>

                                </div>
                                @endif
                            </div>
                        @endforeach

                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--profile-details part end  -->


</main>

@endsection


@push('js_section')

<script src="https://www.google.com/recaptcha/api.js" async defer></script>

<script>

    (function($) {
        "use strict"
        $(document).ready(function () {

            $('#send_agent_message').on("click", function(){
                $(".contact-beach-box-main").submit();
            });

        });
    })(jQuery);


</script>

@endpush
