@extends('layout')
@section('title')
    <title>{{ __('translate.Subscription Plan') }}</title>
@endsection

@section('body-content')
<main>
    <!-- banner-part-start  -->

    <div class="inner-bg common-class"
    style="    background-image:  url({{  custom_asset($breadcrumb, '1905x408') }});">
        <div class="container">
            <div class="row">
                <div class="  col-xxl-3  col-xl-5 col-lg-5">

                    <div class="inner-bg-txt">
                        <h1>{{ __('translate.Subscription Plan') }}</h1>

                        <ul>
                            <li><a href="{{ route('home') }}">{{ __('translate.Home') }}</a></li>
                            <li><span>
                                    <svg width="6" height="12" viewBox="0 0 6 12" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <path
                                            d="M0.633816 2.7705e-08C0.446997 0.0532405 0.28353 0.143084 0.158011 0.319443C-0.0492418 0.618921 -0.0550799 1.0515 0.155092 1.35098C0.195958 1.40755 0.239744 1.46411 0.286449 1.51735C1.56499 2.97481 2.84645 4.4356 4.125 5.89306C4.15419 5.92633 4.18922 5.95295 4.24176 6.03281C4.20673 6.0561 4.16295 6.06941 4.13375 6.10269C2.84062 7.57346 1.5504 9.04755 0.257258 10.5183C0.0295721 10.7779 -0.0579994 11.0773 0.0412483 11.4367C0.187201 11.9591 0.776848 12.1721 1.16216 11.8427C1.20595 11.8061 1.24682 11.7628 1.28768 11.7196C2.7764 10.0225 4.26511 8.32881 5.75091 6.63177C6.02238 6.32231 6.07492 5.92966 5.89394 5.57361C5.85015 5.4871 5.78594 5.41056 5.72464 5.34069C4.27971 3.69356 2.83478 2.04976 1.39277 0.399304C1.23222 0.216289 1.06875 0.0532405 0.838149 3.66367e-08C0.771011 3.3702e-08 0.703873 3.07673e-08 0.633816 2.7705e-08Z" />
                                    </svg>

                                </span></li>
                            <li><a href="javascript:;" class="active">{{ __('translate.Subscription Plan') }}</a></li>
                        </ul>
                    </div>

                </div>
            </div>
        </div>
    </div>
    <!-- banner-part-end -->

    <!-- dashboard-part-start -->

    <!-- membership part start  -->
    <section class="membership footer-top-pad">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="membership-taitel">
                        <span class="membership-sub-taitel">{{ __('translate.Our Plan') }}</span>
                        <h2 class="taitel">{{ __('translate.Subscription Plan') }}</h2>

                    </div>
                </div>
            </div>
            <div class="row justify-content-center">
                @foreach ($subscription_plans as $index => $subscription_plan)
                <div class="col-lg-3 padding-0">
                    <div class="pricing-box {{ $index == 1 ? 'pricing-box-two' : '' }}">
                        <h3 class="pricing-box-taitel">{{ $subscription_plan->plan_name }}</h3>

                        <div class="pricing-box-price">
                            <h2>
                                @if (Session::get('currency_position') == 'before_price')
                                <sup>{{ Session::get('currency_icon') }}</sup>  {{ currency_without_icon($subscription_plan->plan_price) }}
                                @elseif (Session::get('currency_position') == 'before_price_with_space')
                                <sup>{{ Session::get('currency_icon') }}</sup>  {{ currency_without_icon($subscription_plan->plan_price) }}
                                @elseif (Session::get('currency_position') == 'after_price')
                                {{ currency_without_icon($subscription_plan->plan_price) }}<sup>{{ Session::get('currency_icon') }}</sup>
                                @elseif (Session::get('currency_position') == 'after_price_with_space')
                                {{ currency_without_icon($subscription_plan->plan_price) }}<sup> {{ Session::get('currency_icon') }}</sup>
                                @endif
                                <span>
                                    @if ($subscription_plan->expiration_date == 'monthly')
                                        /{{ __('translate.Monthly') }}
                                    @elseif ($subscription_plan->expiration_date == 'yearly')
                                        /{{ __('translate.Yearly') }}
                                    @elseif ($subscription_plan->expiration_date == 'lifetime')
                                        /{{ __('translate.Lifetime') }}
                                    @endif
                                </span></h2>
                        </div>

                        <ul class="pricing-list">
                            <li>
                                <span>
                                    <svg width="15" height="15" viewBox="0 0 15 15" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <circle cx="7.5" cy="7.5" r="7.5" fill="#1DBF73" />
                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                            d="M5.84549 10.8315C5.64265 10.6063 5.64265 10.238 5.84549 10.0128L11.111 4.16888C11.3139 3.94371 11.6458 3.94371 11.8487 4.16888C12.0516 4.39404 12.0508 4.76323 11.8487 4.98754L6.58313 10.8315C6.38102 11.0558 6.04837 11.0566 5.84549 10.8315Z"
                                            fill="white" />
                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                            d="M6.57547 10.8228C6.37263 11.0479 6.04071 11.0479 5.83783 10.8228L3.15213 7.84205C2.94929 7.61689 2.94929 7.24851 3.15213 7.02339C3.35501 6.79822 3.68805 6.79946 3.88977 7.02339L6.57547 10.0041C6.77723 10.228 6.77835 10.5976 6.57547 10.8228Z"
                                            fill="white" />
                                    </svg>
                                </span>
                                {{ __('translate.Duration') }} :
                                @if ($subscription_plan->expiration_date == 'monthly')
                                {{ __('translate.Monthly') }}
                                @elseif ($subscription_plan->expiration_date == 'yearly')
                                {{ __('translate.Yearly') }}
                                @elseif ($subscription_plan->expiration_date == 'lifetime')
                                {{ __('translate.Lifetime') }}
                                @endif
                            </li>
                            <li>
                                <span>
                                    <svg width="15" height="15" viewBox="0 0 15 15" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <circle cx="7.5" cy="7.5" r="7.5" fill="#1DBF73" />
                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                            d="M5.84549 10.8315C5.64265 10.6063 5.64265 10.238 5.84549 10.0128L11.111 4.16888C11.3139 3.94371 11.6458 3.94371 11.8487 4.16888C12.0516 4.39404 12.0508 4.76323 11.8487 4.98754L6.58313 10.8315C6.38102 11.0558 6.04837 11.0566 5.84549 10.8315Z"
                                            fill="white" />
                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                            d="M6.57547 10.8228C6.37263 11.0479 6.04071 11.0479 5.83783 10.8228L3.15213 7.84205C2.94929 7.61689 2.94929 7.24851 3.15213 7.02339C3.35501 6.79822 3.68805 6.79946 3.88977 7.02339L6.57547 10.0041C6.77723 10.228 6.77835 10.5976 6.57547 10.8228Z"
                                            fill="white" />
                                    </svg>
                                </span>
                                {{ __('translate.Maximum Listings') }} : {{ $subscription_plan->max_listing }}
                            </li>
                            @if ($subscription_plan->featured_listing == 0)
                                <li>
                                    <span>
                                        <svg width="15" height="15" viewBox="0 0 15 15" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <circle cx="7.5" cy="7.5" r="7.5" fill="#FD4917" />
                                            <path
                                                d="M8.1413 7.50005L10.867 4.77425C11.0443 4.59695 11.0443 4.31028 10.867 4.13298C10.6897 3.95567 10.403 3.95567 10.2257 4.13298L7.49996 6.85878L4.7743 4.13298C4.59692 3.95567 4.31033 3.95567 4.13304 4.13298C3.95565 4.31028 3.95565 4.59695 4.13304 4.77425L6.8587 7.50005L4.13304 10.2259C3.95565 10.4032 3.95565 10.6898 4.13304 10.8671C4.22139 10.9556 4.33757 11 4.45367 11C4.56976 11 4.68586 10.9556 4.7743 10.8671L7.49996 8.14133L10.2257 10.8671C10.3141 10.9556 10.4302 11 10.5463 11C10.6624 11 10.7785 10.9556 10.867 10.8671C11.0443 10.6898 11.0443 10.4032 10.867 10.2259L8.1413 7.50005Z"
                                                fill="white" />
                                        </svg>
                                    </span>
                                    {{ __('translate.Featured Listing') }} : {{ __('translate.Not Available') }}
                                </li>
                            @else
                                <li>
                                    <span>
                                        <svg width="15" height="15" viewBox="0 0 15 15" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <circle cx="7.5" cy="7.5" r="7.5" fill="#1DBF73" />
                                            <path fill-rule="evenodd" clip-rule="evenodd"
                                                d="M5.84549 10.8315C5.64265 10.6063 5.64265 10.238 5.84549 10.0128L11.111 4.16888C11.3139 3.94371 11.6458 3.94371 11.8487 4.16888C12.0516 4.39404 12.0508 4.76323 11.8487 4.98754L6.58313 10.8315C6.38102 11.0558 6.04837 11.0566 5.84549 10.8315Z"
                                                fill="white" />
                                            <path fill-rule="evenodd" clip-rule="evenodd"
                                                d="M6.57547 10.8228C6.37263 11.0479 6.04071 11.0479 5.83783 10.8228L3.15213 7.84205C2.94929 7.61689 2.94929 7.24851 3.15213 7.02339C3.35501 6.79822 3.68805 6.79946 3.88977 7.02339L6.57547 10.0041C6.77723 10.228 6.77835 10.5976 6.57547 10.8228Z"
                                                fill="white" />
                                        </svg>
                                    </span>
                                    {{ __('translate.Featured Listing') }} : {{ __('translate.Available') }}
                                </li>
                            @endif

                            <li>
                                <span>
                                    <svg width="15" height="15" viewBox="0 0 15 15" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <circle cx="7.5" cy="7.5" r="7.5" fill="#1DBF73" />
                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                            d="M5.84549 10.8315C5.64265 10.6063 5.64265 10.238 5.84549 10.0128L11.111 4.16888C11.3139 3.94371 11.6458 3.94371 11.8487 4.16888C12.0516 4.39404 12.0508 4.76323 11.8487 4.98754L6.58313 10.8315C6.38102 11.0558 6.04837 11.0566 5.84549 10.8315Z"
                                            fill="white" />
                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                            d="M6.57547 10.8228C6.37263 11.0479 6.04071 11.0479 5.83783 10.8228L3.15213 7.84205C2.94929 7.61689 2.94929 7.24851 3.15213 7.02339C3.35501 6.79822 3.68805 6.79946 3.88977 7.02339L6.57547 10.0041C6.77723 10.228 6.77835 10.5976 6.57547 10.8228Z"
                                            fill="white" />
                                    </svg>
                                </span>
                                {{ __('translate.Number of Featured') }} : {{ $subscription_plan->featured_listing }}
                            </li>


                            <li>
                                <span>
                                    <svg width="15" height="15" viewBox="0 0 15 15" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <circle cx="7.5" cy="7.5" r="7.5" fill="#1DBF73" />
                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                            d="M5.84549 10.8315C5.64265 10.6063 5.64265 10.238 5.84549 10.0128L11.111 4.16888C11.3139 3.94371 11.6458 3.94371 11.8487 4.16888C12.0516 4.39404 12.0508 4.76323 11.8487 4.98754L6.58313 10.8315C6.38102 11.0558 6.04837 11.0566 5.84549 10.8315Z"
                                            fill="white" />
                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                            d="M6.57547 10.8228C6.37263 11.0479 6.04071 11.0479 5.83783 10.8228L3.15213 7.84205C2.94929 7.61689 2.94929 7.24851 3.15213 7.02339C3.35501 6.79822 3.68805 6.79946 3.88977 7.02339L6.57547 10.0041C6.77723 10.228 6.77835 10.5976 6.57547 10.8228Z"
                                            fill="white" />
                                    </svg>
                                </span>
                                {{ __('translate.Listing Image') }} : {{ __('translate.Unlimited') }}
                            </li>
                            <li>
                                <span>
                                    <svg width="15" height="15" viewBox="0 0 15 15" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <circle cx="7.5" cy="7.5" r="7.5" fill="#1DBF73" />
                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                            d="M5.84549 10.8315C5.64265 10.6063 5.64265 10.238 5.84549 10.0128L11.111 4.16888C11.3139 3.94371 11.6458 3.94371 11.8487 4.16888C12.0516 4.39404 12.0508 4.76323 11.8487 4.98754L6.58313 10.8315C6.38102 11.0558 6.04837 11.0566 5.84549 10.8315Z"
                                            fill="white" />
                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                            d="M6.57547 10.8228C6.37263 11.0479 6.04071 11.0479 5.83783 10.8228L3.15213 7.84205C2.94929 7.61689 2.94929 7.24851 3.15213 7.02339C3.35501 6.79822 3.68805 6.79946 3.88977 7.02339L6.57547 10.0041C6.77723 10.228 6.77835 10.5976 6.57547 10.8228Z"
                                            fill="white" />
                                    </svg>
                                </span>
                                {{ __('translate.24/7 Hours Help') }}
                            </li>

                        </ul>


                        <a class="main-btn " href="{{ route('pricing-plan-enroll', $subscription_plan->id) }}">
                            <div class="btn_m">
                                <div class="btn_c">
                                    <div class="btn_t1">{{ __('translate.Enroll Now') }}</div>
                                    <div class="btn_t2">{{ __('translate.Enroll Now') }}</div>
                                </div>
                            </div>
                        </a>


                    </div>
                </div>
                @endforeach

            </div>
        </div>
    </section>
    <!-- membership part end  -->

</main>
@endsection
