@extends('layout')
@section('title')
    <title>{{ __('translate.Payment') }}</title>
@endsection

@section('body-content')
<main>
    <!-- banner-part-start  -->

    <div class="inner-bg common-class"
    style="    background-image:  url({{  custom_asset($breadcrumb, '1905x408') }});">
        <div class="container">
            <div class="row">
                <div class="  col-xxl-3  col-xl-5 col-lg-5">

                    <div class="inner-bg-txt">
                        <h1>{{ __('translate.Payment') }}</h1>

                        <ul>
                            <li><a href="{{ route('home') }}">{{ __('translate.Home') }}</a></li>
                            <li><span>
                                    <svg width="6" height="12" viewBox="0 0 6 12" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <path
                                            d="M0.633816 2.7705e-08C0.446997 0.0532405 0.28353 0.143084 0.158011 0.319443C-0.0492418 0.618921 -0.0550799 1.0515 0.155092 1.35098C0.195958 1.40755 0.239744 1.46411 0.286449 1.51735C1.56499 2.97481 2.84645 4.4356 4.125 5.89306C4.15419 5.92633 4.18922 5.95295 4.24176 6.03281C4.20673 6.0561 4.16295 6.06941 4.13375 6.10269C2.84062 7.57346 1.5504 9.04755 0.257258 10.5183C0.0295721 10.7779 -0.0579994 11.0773 0.0412483 11.4367C0.187201 11.9591 0.776848 12.1721 1.16216 11.8427C1.20595 11.8061 1.24682 11.7628 1.28768 11.7196C2.7764 10.0225 4.26511 8.32881 5.75091 6.63177C6.02238 6.32231 6.07492 5.92966 5.89394 5.57361C5.85015 5.4871 5.78594 5.41056 5.72464 5.34069C4.27971 3.69356 2.83478 2.04976 1.39277 0.399304C1.23222 0.216289 1.06875 0.0532405 0.838149 3.66367e-08C0.771011 3.3702e-08 0.703873 3.07673e-08 0.633816 2.7705e-08Z" />
                                    </svg>

                                </span></li>
                            <li><a href="javascript:;" class="active">{{ __('translate.Payment') }}</a></li>
                        </ul>
                    </div>

                </div>
            </div>
        </div>
    </div>
    <!-- banner-part-end -->



    <section class="membership-two footer-top-pad">
        <div class="container">
            <div class="row justify-content-center ">
                <div class="col-lg-7 membership-two-bg ">
                    <div class="row">
                        <div class="col-lg-6 ">
                            <div class="pricing-box pricing-box-two">
                                <h3 class="pricing-box-taitel">{{ $subscription_plan->plan_name }}</h3>

                                <div class="pricing-box-price">
                                    <h2>
                                        @if (Session::get('currency_position') == 'before_price')
                                        <sup>{{ Session::get('currency_icon') }}</sup>  {{ currency_without_icon($subscription_plan->plan_price) }}
                                        @elseif (Session::get('currency_position') == 'before_price_with_space')
                                        <sup>{{ Session::get('currency_icon') }}</sup>  {{ currency_without_icon($subscription_plan->plan_price) }}
                                        @elseif (Session::get('currency_position') == 'after_price')
                                        {{ currency_without_icon($subscription_plan->plan_price) }}<sup>{{ Session::get('currency_icon') }}</sup>
                                        @elseif (Session::get('currency_position') == 'after_price_with_space')
                                        {{ currency_without_icon($subscription_plan->plan_price) }}<sup> {{ Session::get('currency_icon') }}</sup>
                                        @endif
                                        <span>
                                            @if ($subscription_plan->expiration_date == 'monthly')
                                                /{{ __('translate.Monthly') }}
                                            @elseif ($subscription_plan->expiration_date == 'yearly')
                                                /{{ __('translate.Yearly') }}
                                            @elseif ($subscription_plan->expiration_date == 'lifetime')
                                                /{{ __('translate.Lifetime') }}
                                            @endif
                                        </span></h2>
                                </div>

                                <ul class="pricing-list">
                                    <li>
                                        <span>
                                            <svg width="15" height="15" viewBox="0 0 15 15" fill="none"
                                                xmlns="http://www.w3.org/2000/svg">
                                                <circle cx="7.5" cy="7.5" r="7.5" fill="#1DBF73" />
                                                <path fill-rule="evenodd" clip-rule="evenodd"
                                                    d="M5.84549 10.8315C5.64265 10.6063 5.64265 10.238 5.84549 10.0128L11.111 4.16888C11.3139 3.94371 11.6458 3.94371 11.8487 4.16888C12.0516 4.39404 12.0508 4.76323 11.8487 4.98754L6.58313 10.8315C6.38102 11.0558 6.04837 11.0566 5.84549 10.8315Z"
                                                    fill="white" />
                                                <path fill-rule="evenodd" clip-rule="evenodd"
                                                    d="M6.57547 10.8228C6.37263 11.0479 6.04071 11.0479 5.83783 10.8228L3.15213 7.84205C2.94929 7.61689 2.94929 7.24851 3.15213 7.02339C3.35501 6.79822 3.68805 6.79946 3.88977 7.02339L6.57547 10.0041C6.77723 10.228 6.77835 10.5976 6.57547 10.8228Z"
                                                    fill="white" />
                                            </svg>
                                        </span>
                                        {{ __('translate.Duration') }} :
                                        @if ($subscription_plan->expiration_date == 'monthly')
                                        {{ __('translate.Monthly') }}
                                        @elseif ($subscription_plan->expiration_date == 'yearly')
                                        {{ __('translate.Yearly') }}
                                        @elseif ($subscription_plan->expiration_date == 'lifetime')
                                        {{ __('translate.Lifetime') }}
                                        @endif
                                    </li>
                                    <li>
                                        <span>
                                            <svg width="15" height="15" viewBox="0 0 15 15" fill="none"
                                                xmlns="http://www.w3.org/2000/svg">
                                                <circle cx="7.5" cy="7.5" r="7.5" fill="#1DBF73" />
                                                <path fill-rule="evenodd" clip-rule="evenodd"
                                                    d="M5.84549 10.8315C5.64265 10.6063 5.64265 10.238 5.84549 10.0128L11.111 4.16888C11.3139 3.94371 11.6458 3.94371 11.8487 4.16888C12.0516 4.39404 12.0508 4.76323 11.8487 4.98754L6.58313 10.8315C6.38102 11.0558 6.04837 11.0566 5.84549 10.8315Z"
                                                    fill="white" />
                                                <path fill-rule="evenodd" clip-rule="evenodd"
                                                    d="M6.57547 10.8228C6.37263 11.0479 6.04071 11.0479 5.83783 10.8228L3.15213 7.84205C2.94929 7.61689 2.94929 7.24851 3.15213 7.02339C3.35501 6.79822 3.68805 6.79946 3.88977 7.02339L6.57547 10.0041C6.77723 10.228 6.77835 10.5976 6.57547 10.8228Z"
                                                    fill="white" />
                                            </svg>
                                        </span>
                                        {{ __('translate.Maximum Listings') }} : {{ $subscription_plan->max_listing }}
                                    </li>
                                    @if ($subscription_plan->featured_listing == 0)
                                        <li>
                                            <span>
                                                <svg width="15" height="15" viewBox="0 0 15 15" fill="none"
                                                    xmlns="http://www.w3.org/2000/svg">
                                                    <circle cx="7.5" cy="7.5" r="7.5" fill="#FD4917" />
                                                    <path
                                                        d="M8.1413 7.50005L10.867 4.77425C11.0443 4.59695 11.0443 4.31028 10.867 4.13298C10.6897 3.95567 10.403 3.95567 10.2257 4.13298L7.49996 6.85878L4.7743 4.13298C4.59692 3.95567 4.31033 3.95567 4.13304 4.13298C3.95565 4.31028 3.95565 4.59695 4.13304 4.77425L6.8587 7.50005L4.13304 10.2259C3.95565 10.4032 3.95565 10.6898 4.13304 10.8671C4.22139 10.9556 4.33757 11 4.45367 11C4.56976 11 4.68586 10.9556 4.7743 10.8671L7.49996 8.14133L10.2257 10.8671C10.3141 10.9556 10.4302 11 10.5463 11C10.6624 11 10.7785 10.9556 10.867 10.8671C11.0443 10.6898 11.0443 10.4032 10.867 10.2259L8.1413 7.50005Z"
                                                        fill="white" />
                                                </svg>
                                            </span>
                                            {{ __('translate.Featured Listing') }} : {{ __('translate.Not Available') }}
                                        </li>
                                    @else
                                        <li>
                                            <span>
                                                <svg width="15" height="15" viewBox="0 0 15 15" fill="none"
                                                    xmlns="http://www.w3.org/2000/svg">
                                                    <circle cx="7.5" cy="7.5" r="7.5" fill="#1DBF73" />
                                                    <path fill-rule="evenodd" clip-rule="evenodd"
                                                        d="M5.84549 10.8315C5.64265 10.6063 5.64265 10.238 5.84549 10.0128L11.111 4.16888C11.3139 3.94371 11.6458 3.94371 11.8487 4.16888C12.0516 4.39404 12.0508 4.76323 11.8487 4.98754L6.58313 10.8315C6.38102 11.0558 6.04837 11.0566 5.84549 10.8315Z"
                                                        fill="white" />
                                                    <path fill-rule="evenodd" clip-rule="evenodd"
                                                        d="M6.57547 10.8228C6.37263 11.0479 6.04071 11.0479 5.83783 10.8228L3.15213 7.84205C2.94929 7.61689 2.94929 7.24851 3.15213 7.02339C3.35501 6.79822 3.68805 6.79946 3.88977 7.02339L6.57547 10.0041C6.77723 10.228 6.77835 10.5976 6.57547 10.8228Z"
                                                        fill="white" />
                                                </svg>
                                            </span>
                                            {{ __('translate.Featured Listing') }} : {{ __('translate.Available') }}
                                        </li>
                                    @endif

                                    <li>
                                        <span>
                                            <svg width="15" height="15" viewBox="0 0 15 15" fill="none"
                                                xmlns="http://www.w3.org/2000/svg">
                                                <circle cx="7.5" cy="7.5" r="7.5" fill="#1DBF73" />
                                                <path fill-rule="evenodd" clip-rule="evenodd"
                                                    d="M5.84549 10.8315C5.64265 10.6063 5.64265 10.238 5.84549 10.0128L11.111 4.16888C11.3139 3.94371 11.6458 3.94371 11.8487 4.16888C12.0516 4.39404 12.0508 4.76323 11.8487 4.98754L6.58313 10.8315C6.38102 11.0558 6.04837 11.0566 5.84549 10.8315Z"
                                                    fill="white" />
                                                <path fill-rule="evenodd" clip-rule="evenodd"
                                                    d="M6.57547 10.8228C6.37263 11.0479 6.04071 11.0479 5.83783 10.8228L3.15213 7.84205C2.94929 7.61689 2.94929 7.24851 3.15213 7.02339C3.35501 6.79822 3.68805 6.79946 3.88977 7.02339L6.57547 10.0041C6.77723 10.228 6.77835 10.5976 6.57547 10.8228Z"
                                                    fill="white" />
                                            </svg>
                                        </span>
                                        {{ __('translate.Number of Featured') }} : {{ $subscription_plan->featured_listing }}
                                    </li>


                                    <li>
                                        <span>
                                            <svg width="15" height="15" viewBox="0 0 15 15" fill="none"
                                                xmlns="http://www.w3.org/2000/svg">
                                                <circle cx="7.5" cy="7.5" r="7.5" fill="#1DBF73" />
                                                <path fill-rule="evenodd" clip-rule="evenodd"
                                                    d="M5.84549 10.8315C5.64265 10.6063 5.64265 10.238 5.84549 10.0128L11.111 4.16888C11.3139 3.94371 11.6458 3.94371 11.8487 4.16888C12.0516 4.39404 12.0508 4.76323 11.8487 4.98754L6.58313 10.8315C6.38102 11.0558 6.04837 11.0566 5.84549 10.8315Z"
                                                    fill="white" />
                                                <path fill-rule="evenodd" clip-rule="evenodd"
                                                    d="M6.57547 10.8228C6.37263 11.0479 6.04071 11.0479 5.83783 10.8228L3.15213 7.84205C2.94929 7.61689 2.94929 7.24851 3.15213 7.02339C3.35501 6.79822 3.68805 6.79946 3.88977 7.02339L6.57547 10.0041C6.77723 10.228 6.77835 10.5976 6.57547 10.8228Z"
                                                    fill="white" />
                                            </svg>
                                        </span>
                                        {{ __('translate.Listing Image') }} : {{ __('translate.Unlimited') }}
                                    </li>
                                    <li>
                                        <span>
                                            <svg width="15" height="15" viewBox="0 0 15 15" fill="none"
                                                xmlns="http://www.w3.org/2000/svg">
                                                <circle cx="7.5" cy="7.5" r="7.5" fill="#1DBF73" />
                                                <path fill-rule="evenodd" clip-rule="evenodd"
                                                    d="M5.84549 10.8315C5.64265 10.6063 5.64265 10.238 5.84549 10.0128L11.111 4.16888C11.3139 3.94371 11.6458 3.94371 11.8487 4.16888C12.0516 4.39404 12.0508 4.76323 11.8487 4.98754L6.58313 10.8315C6.38102 11.0558 6.04837 11.0566 5.84549 10.8315Z"
                                                    fill="white" />
                                                <path fill-rule="evenodd" clip-rule="evenodd"
                                                    d="M6.57547 10.8228C6.37263 11.0479 6.04071 11.0479 5.83783 10.8228L3.15213 7.84205C2.94929 7.61689 2.94929 7.24851 3.15213 7.02339C3.35501 6.79822 3.68805 6.79946 3.88977 7.02339L6.57547 10.0041C6.77723 10.228 6.77835 10.5976 6.57547 10.8228Z"
                                                    fill="white" />
                                            </svg>
                                        </span>
                                        {{ __('translate.24/7 Hours Help') }}
                                    </li>

                                </ul>

                            </div>

                        </div>

                        <div class="col-lg-6 ">
                            <div class="payment-box">

                                @if ($stripe->status == 1)
                                    <a href="javascript:;" class="stripe-modal-btn">

                                    </a>
                                    <div class="payment-box-item" data-bs-toggle="modal" data-bs-target="#stripeModal">
                                        <input type="submit" class="form-control" id="exampleFormControlInput1">
                                        <div class="input-img">
                                            <img src="{{  custom_asset($stripe->image, '100x25') }}" alt="img">
                                        </div>
                                    </div>
                                @endif

                                @if ($paypal->status == 1)
                                <div class="payment-box-item" id="paypal_btn">
                                    <input type="submit" class="form-control" id="exampleFormControlInput11">

                                    <div class="input-img">
                                        <img src="{{  custom_asset($paypal->image, '100x25') }}" alt="img">
                                    </div>

                                </div>
                                @endif

                                @if ($razorpay->status == 1)
                                <div class="payment-box-item" id="razorpay_btn">
                                    <input type="submit" class="form-control" id="exampleFormControlInput12">

                                    <div class="input-img">
                                        <img src="{{  custom_asset($razorpay->image, '100x25') }}" alt="img">
                                    </div>

                                </div>


                                <form action="{{ route('pay-via-razorpay', $subscription_plan->id) }}" method="POST" class="d-none">
                                    @csrf
                                    @php
                                        $payable_amount = $subscription_plan->plan_price * $razorpay->currency->currency_rate;
                                        $payable_amount = round($payable_amount, 2);
                                    @endphp
                                    <script src="https://checkout.razorpay.com/v1/checkout.js"
                                            data-key="{{ $razorpay->key }}"
                                            data-currency="{{ $razorpay->currency->currency_code }}"
                                            data-amount= "{{ $payable_amount * 100 }}"
                                            data-buttontext="{{ __('translate.Pay') }} {{ $payable_amount }} {{ $razorpay->currency->currency_code }}"
                                            data-name="{{ $razorpay->name }}"
                                            data-description="{{ $razorpay->description }}"
                                            data-image="{{  custom_asset($razorpay->image) }}"
                                            data-prefill.name=""
                                            data-prefill.email=""
                                            data-theme.color="{{ $razorpay->color }}">
                                    </script>
                                </form>

                                @endif


                                @if ($flutterwave->status == 1)
                                <div class="payment-box-item" id="flutterwavePayment">
                                    <input type="submit" class="form-control" id="exampleFormControlInput13">

                                    <div class="input-img">
                                        <img src="{{  custom_asset($flutterwave->logo, '100x25') }}" alt="img">
                                    </div>

                                </div>
                                @endif

                                @if ($paystack->paystack_status == 1)
                                <div class="payment-box-item" id="paystackPayment">
                                    <input type="submit" class="form-control" id="exampleFormControlInput14">

                                    <div class="input-img">
                                        <img src="{{  custom_asset($paystack->paystack_image, '100x25') }}" alt="img">
                                    </div>
                                </div>
                                @endif

                                @if ($mollie->mollie_status == 1)

                                <div class="payment-box-item" id="mollie_payment_btn">
                                    <input type="submit" class="form-control" id="exampleFormControlInput16">

                                    <div class="input-img">
                                        <img src="{{  custom_asset($mollie->mollie_image, '100x25') }}" alt="img">
                                    </div>

                                </div>
                                @endif

                                @if ($instamojo->status == 1)
                                <div class="payment-box-item" id="instamojo_payment_btn">
                                    <input type="submit" class="form-control" id="exampleFormControlInput17">

                                    <div class="input-img">
                                        <img src="{{  custom_asset($instamojo->image, '100x25') }}" alt="img">
                                    </div>

                                </div>
                                @endif


                                @if ($bank->status == 1)
                                <div class="payment-box-item" data-bs-toggle="modal"
                                    data-bs-target="#bankModal">
                                    <input type="submit" class="form-control" id="exampleFormControlInput15">
                                    <div class="input-img">
                                        <img src="{{  custom_asset($bank->image, '100x25') }}" alt="img">
                                    </div>
                                </div>
                                @endif



                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- dashboard-part-end -->


    <!-- stripe-modal  -->
    <div class="modal stripe-modal fade" id="stripeModal" tabindex="-1" aria-labelledby="exampleModalLabel"
    aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">{{ __('translate.Pay via Stripe') }}</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="payment-modal-item">
                        <h4>{{ __('translate.Amount') }}<span>{{ currency($subscription_plan->plan_price) }}</span></h4>
                    </div>
                    <form class="stripe-modal-form require-validation " role="form" action="{{ route('pay-via-stripe', $subscription_plan->id) }}" method="POST" data-cc-on-file="false" data-stripe-publishable-key="{{ $stripe->stripe_key }}" id="payment-form">
                        @csrf

                        <div class="stripe-modal-form-item">
                            <div class="stripe-modal-form-inner">
                                <input type="text" class="card-number form-control" name="card_number" placeholder="{{ __('translate.Card Number') }}">
                            </div>
                        </div>
                        <div class="stripe-modal-form-item">
                            <div class="stripe-modal-form-inner">
                                <input type="text" class="card-expiry-month form-control" name="month" placeholder="{{ __('translate.Expired Month') }}">
                            </div>
                            <div class="stripe-modal-form-inner">
                                <input type="text" class="card-expiry-year form-control" name="year" placeholder="{{ __('translate.Expired Year') }}">
                            </div>
                        </div>
                        <div class="stripe-modal-form-item">
                            <div class="stripe-modal-form-inner">
                                <input type="text" class="card-cvc form-control" name="cvc" placeholder="{{ __('translate.CVC') }}">
                            </div>
                        </div>

                        <div class="stripe-modal-form-item stripe_error d-none">
                            <div class="stripe-modal-form-inner">
                                <div class='alert-danger alert '>{{ __('translate.Please provide your valid card information') }}</div>
                            </div>
                        </div>

                        <div class="stripe-modal-form-item">
                            <div class="stripe-modal-form-inner">
                                <a class="main-btn " href="javascript:;" id="stripe_form_btn">
                                    <div class="btn_m">
                                        <div class="btn_c">
                                            <div class="btn_t1">{{ __('translate.Payment Now') }}</div>
                                            <div class="btn_t2">{{ __('translate.Payment Now') }}</div>
                                        </div>
                                    </div>
                                </a>
                            </div>
                        </div>
                    </form>
                </div>
            </div>

        </div>
    </div>

    <!-- banck Modal -->
    <div class="modal banck-modal stripe-modal fade" id="bankModal" tabindex="-1"
    aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">{{ __('translate.Bank Payment') }}</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="payment-modal-item">
                        <h4>{{ __('translate.Amount') }}<span>{{ currency($subscription_plan->plan_price) }}</span></h4>
                    </div>
                    <div class="bank-payment-modal-txt">
                        {!! clean(nl2br($bank->account_info)) !!}
                    </div>
                    <form class="payment-modal-from" action="{{ route('pay-via-bank', $subscription_plan->id) }}" method="POST" id="bank_payment_form">
                        @csrf
                        <div class="bank-payment-form-item">
                            <div class="bank-payment-form-inner">
                                <textarea class="form-control" id="exampleFormControlTextarea1" rows="3"
                                placeholder="{{ __('translate.Transaction information') }}" name="tnx_info"></textarea>
                            </div>
                        </div>
                        <div class="bank-payment-form-item">
                            <div class="bank-payment-form-inner">
                                <a class="main-btn " href="javascript:;" id="bank_payment_btn">
                                    <div class="btn_m">
                                        <div class="btn_c">
                                            <div class="btn_t1">{{ __('translate.Payment Now') }}</div>
                                            <div class="btn_t2">{{ __('translate.Payment Now') }}</div>
                                        </div>
                                    </div>
                                </a>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

</main>
@endsection


@push('js_section')
    <script type="text/javascript" src="https://js.stripe.com/v2/"></script>
    <script>
        "use strict";
        $(function() {

            $("#stripe_form_btn").on("click", function(){
                $("#payment-form").submit();
            })

            var $form = $(".require-validation");
            $('form.require-validation').on('submit', function(e) {
                var $form         = $(".require-validation"),
                inputSelector = ['input[type=email]', 'input[type=password]',
                                    'input[type=text]', 'input[type=file]',
                                    'textarea'].join(', '),
                $inputs       = $form.find('.required').find(inputSelector),
                $errorMessage = $form.find('div.stripe_error'),
                valid         = true;
                $errorMessage.addClass('d-none');

                $('.has-error').removeClass('has-error');
                $inputs.each(function(i, el) {
                    var $input = $(el);
                    if ($input.val() === '') {
                        $input.parent().addClass('has-error');
                        $errorMessage.removeClass('d-none');
                        e.preventDefault();
                    }
                });

                if (!$form.data('cc-on-file')) {
                e.preventDefault();
                Stripe.setPublishableKey($form.data('stripe-publishable-key'));
                Stripe.createToken({
                    number: $('.card-number').val(),
                    cvc: $('.card-cvc').val(),
                    exp_month: $('.card-expiry-month').val(),
                    exp_year: $('.card-expiry-year').val()
                }, stripeResponseHandler);
                }

            });

            function stripeResponseHandler(status, response) {
                if (response.error) {
                    $('.stripe_error')
                        .removeClass('d-none')
                        .find('.alert')
                        .text(response.error.message);
                } else {
                    var token = response['id'];
                    $form.find('input[type=text]').empty();
                    $form.append("<input type='hidden' name='stripeToken' value='" + token + "'/>");
                    $form.get(0).submit();
                }
            }

            $("#razorpay_btn").on("click", function(){
                $(".razorpay-payment-button").click();
            })

            $("#paypal_btn").on("click", function(){
                window.location.href = "{{ route('pay-via-paypal', $subscription_plan->id) }}";
            })

            $("#mollie_payment_btn").on("click", function(){
                window.location.href = "{{ route('pay-via-mollie',$subscription_plan->id) }}";
            })

            $("#instamojo_payment_btn").on("click", function(){
                window.location.href = "{{ route('pay-via-instamojo',$subscription_plan->id) }}";
            })

            $("#bank_payment_btn").on("click", function(){
                $("#bank_payment_form").submit();
            })



        });
    </script>

    {{-- start flutterwave payment --}}
    @if ($flutterwave->status == 1)
        <script src="https://checkout.flutterwave.com/v3.js"></script>

        @php
            $payable_amount = $subscription_plan->plan_price * $flutterwave->currency->currency_rate;
            $payable_amount = round($payable_amount, 2);


        @endphp

        <script>
            "use strict";
            $(function() {
                $("#flutterwavePayment").on("click", function(){

                    var isDemo = "{{ env('APP_MODE') }}"
                    if(isDemo == 'DEMO'){
                        toastr.error('This Is Demo Version. You Can Not Change Anything');
                        return;
                    }

                    FlutterwaveCheckout({
                        public_key: "{{ $flutterwave->public_key }}",
                        tx_ref: "{{ substr(rand(0,time()),0,10) }}",
                        amount: {{ $payable_amount }},
                        currency: "{{ $flutterwave->currency->currency_code }}",
                        country: "{{ $flutterwave->currency->country_code }}",
                        payment_options: " ",
                        customer: {
                        email: "{{ $user->email }}",
                        phone_number: "{{ $user->phone }}",
                        name: "{{ $user->name }}",
                        },
                        callback: function (data) {

                            var tnx_id = data.transaction_id;
                            var _token = "{{ csrf_token() }}";
                            $.ajax({
                                type: 'post',
                                data : {tnx_id,_token},
                                url: "{{ url('pay-via-flutterwave') }}" + "/" + "{{ $subscription_plan->id }}",
                                success: function (response) {

                                    if(response.status == 'success'){
                                        toastr.success(response.message);
                                        window.location.href = "{{ route('user.orders') }}";
                                    }else{
                                        toastr.error(response.message);
                                        window.location.reload();
                                    }
                                },
                                error: function(err) {
                                    toastr.error("{{ __('translate.Something went wrong, please try again') }}");
                                    window.location.reload();
                                }
                            });
                        },
                        customizations: {
                        title: "{{ $flutterwave->title }}",
                        logo: "{{  custom_asset($flutterwave->logo) }}",
                        },
                    });
                })
            });
        </script>

    @endif

    {{-- end flutterwave payment --}}

    {{-- start paystack payment --}}

    @if ($paystack->paystack_status == 1)
        <script src="https://js.paystack.co/v1/inline.js"></script>

        @php

            $public_key = $paystack->paystack_public_key;
            $currency = $paystack->paystack_currency->currency_code;
            $currency = strtoupper($currency);

            $ngn_amount = $subscription_plan->plan_price * $paystack->paystack_currency->currency_rate;
            $ngn_amount = $ngn_amount * 100;
            $ngn_amount = round($ngn_amount);

        @endphp

        <script>
            "use strict";
            $(function() {
                $("#paystackPayment").on("click", function(){

                    var isDemo = "{{ env('APP_MODE') }}"
                    if(isDemo == 'DEMO'){
                        toastr.error('This Is Demo Version. You Can Not Change Anything');
                        return;
                    }

                    var handler = PaystackPop.setup({
                                    key: '{{ $public_key }}',
                                    email: '{{ $user->email }}',
                                    amount: '{{ $ngn_amount }}',
                                    currency: "{{ $currency }}",
                                    callback: function(response){
                                        let reference = response.reference;
                                        let tnx_id = response.transaction;
                                        let _token = "{{ csrf_token() }}";
                                        $.ajax({
                                            type: "get",
                                            data: {reference, tnx_id, _token},
                                            url: "{{ url('pay-via-paystack') }}" + "/" + "{{ $subscription_plan->id }}",
                                            success: function(response) {
                                                if(response.status == 'success'){
                                                    toastr.success(response.message);
                                                    window.location.href = "{{ route('user.orders') }}";
                                                }else{
                                                    toastr.error(response.message);
                                                    window.location.reload();
                                                }
                                            },
                                            error: function(response){
                                                    toastr.error('Server Error');
                                                    window.location.reload();
                                            }
                                        });
                                    },
                                    onClose: function(){
                                        alert('window closed');
                                    }
                                });
                        handler.openIframe();

                })
            });
        </script>

    @endif

    {{-- end paystack payment --}}
@endpush
