<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ env('APP_NAME') }}</title>

    <link rel="shortcut icon" href="{{ asset($setting->favicon) }}">
    <link rel="stylesheet" href="{{ asset('frontend/fontawesome/css/all.css') }}">
    <link rel="stylesheet" href="{{ asset('frontend/css/bootstrap.min.css') }}">
    <link rel="stylesheet" href="{{ asset('frontend/css/style.css') }}">
    <link rel="stylesheet" href="{{ asset('frontend/css/responsive.css') }}">

</head>

<body>

    <main>

        <section class="maintenance common-class">
            <div class="container">
                <div class="row justify-content-center ">
                    <div class="col-lg-6">
                        <div class="maintenance-item">
                            <div class="maintenance-thumb">
                            <img src="{{ custom_asset($setting->maintenance_image, '696x470') }}" alt="img">
                            </div>

                            <div class="maintenance-item-txt">
                                <p>{!! clean(nl2br($setting->maintenance_text)) !!}</p>
                            </div>

                        </div>

                    </div>
                </div>
            </div>
        </section>

    </main>


    <script src="{{ asset('global/js/jquery-3.7.1.min.js') }}"></script>
    <script src="{{ asset('frontend/fontawesome/js/all.js') }}"></script>
    <script src="{{ asset('frontend/assets/js/bootstrap.bundle.min.js') }}"></script>
    <script src="{{ asset('frontend/assets/js/jquery.shuffle.min.js') }}"></script>

</body>

</html>
