@extends('layout')
@section('title')
    <title>{{ __('translate.Reset Password') }}</title>
@endsection

@section('body-content')

<main>

    <!-- inner-bg  part start  -->

    <div class="inner-bg common-class"
    style="    background-image:  url({{ custom_asset($breadcrumb, '1905x408') }});">
        <div class="container">
            <div class="row">
                <div class="col-lg-3">

                    <div class="inner-bg-txt">
                        <h1>{{ __('translate.Reset Password') }}</h1>

                        <ul>
                            <li><a href="{{ route('home') }}">{{ __('translate.Home') }}</a></li>
                            <li><span>
                                    <svg width="6" height="12" viewBox="0 0 6 12" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <path
                                            d="M0.633816 2.7705e-08C0.446997 0.0532405 0.28353 0.143084 0.158011 0.319443C-0.0492418 0.618921 -0.0550799 1.0515 0.155092 1.35098C0.195958 1.40755 0.239744 1.46411 0.286449 1.51735C1.56499 2.97481 2.84645 4.4356 4.125 5.89306C4.15419 5.92633 4.18922 5.95295 4.24176 6.03281C4.20673 6.0561 4.16295 6.06941 4.13375 6.10269C2.84062 7.57346 1.5504 9.04755 0.257258 10.5183C0.0295721 10.7779 -0.0579994 11.0773 0.0412483 11.4367C0.187201 11.9591 0.776848 12.1721 1.16216 11.8427C1.20595 11.8061 1.24682 11.7628 1.28768 11.7196C2.7764 10.0225 4.26511 8.32881 5.75091 6.63177C6.02238 6.32231 6.07492 5.92966 5.89394 5.57361C5.85015 5.4871 5.78594 5.41056 5.72464 5.34069C4.27971 3.69356 2.83478 2.04976 1.39277 0.399304C1.23222 0.216289 1.06875 0.0532405 0.838149 3.66367e-08C0.771011 3.3702e-08 0.703873 3.07673e-08 0.633816 2.7705e-08Z" />
                                    </svg>

                                </span></li>
                            <li><a href="javascript:;" class="active">{{ __('translate.Reset Password') }}</a></li>
                        </ul>
                    </div>

                </div>
            </div>
        </div>
    </div>

    <!-- inner-bg  part end  -->



    <!-- Login part start  -->
    <section class="login common-class">
        <div class="container">


            <div class="row justify-content-center">
                <div class="col-lg-11">
                    <div class="row login-bg">
                        <div class=" col-xxl-6  col-xl-12 col-lg-12">
                            <div class="login-head">
                                <h3>{{ __('translate.Reset Password') }}</h3>

                                <span>{{ __('translate.Welcome to Aadfirst') }}</span>
                            </div>

                            <form method="POST" action="{{ route('reset-password-store', $token) }}" id="login_form">
                                @csrf

                                <div class="login-form-item three">
                                    <div class="login-form-inner">
                                        <label for="" class="form-label">{{ __('translate.Email address') }}
                                            <span>*</span> </label>
                                        <input type="email" class="form-control" id=""
                                            placeholder="{{ __('translate.Email address') }}" name="email" value="{{ $user->email }}">
                                    </div>
                                </div>

                                <div class="login-form-item two">
                                    <div class="login-form-inner">
                                        <label for="" class="form-label">{{ __('translate.Password') }}
                                            <span>*</span> </label>
                                        <input type="password" class="form-control" id="input_password"
                                            placeholder="........" name="password" >

                                        <div class="icon" id="password-field">
                                            <span>
                                                <i class="fa-regular fa-eye-slash"></i>
                                            </span>
                                        </div>
                                    </div>
                                </div>

                                <div class="login-form-item two">
                                    <div class="login-form-inner">
                                        <label for="" class="form-label">{{ __('translate.Password') }}
                                            <span>*</span> </label>
                                        <input type="password" class="form-control" id="input_password_confirm"
                                            placeholder="........" name="password_confirmation" >

                                        <div class="icon" id="password-field-confirm">
                                            <span>
                                                <i class="fa-regular fa-eye-slash"></i>
                                            </span>
                                        </div>
                                    </div>
                                </div>



                                @if($google_recaptcha->status==1)
                                    <div class="login-form-item two">
                                        <div class="login-form-inner">
                                            <div class="g-recaptcha" data-sitekey="{{ $google_recaptcha->site_key }}"></div>
                                        </div>
                                    </div>
                                @endif

                                <div class="login-form-item two">
                                    <a class="main-btn " href="javascript:;" id="login_btn">
                                        <div class="btn_m">
                                            <div class="btn_c">
                                                <div class="btn_t1">{{ __('translate.Reset Password') }}</div>
                                                <div class="btn_t2">{{ __('translate.Reset Password') }}</div>
                                            </div>
                                        </div>
                                    </a>

                                </div>


                            </form>

                            <div class="create-accoun-text">
                                <p>{{ __('translate.Back to sign in page') }}<span><a href="{{ route('login') }}"> {{ __('translate.Click here') }}</a></span>
                                </p>
                            </div>


                        </div>

                        <div class="col-lg-6">
                            <div class="login-img">
                                <img src="{{ custom_asset($setting->login_page_bg, '523x708') }}" alt="img">
                            </div>
                        </div>
                    </div>
                </div>
            </div>





        </div>
    </section>
    <!--Login part end  -->




</main>

@endsection


@push('js_section')

<script src="https://www.google.com/recaptcha/api.js" async defer></script>

<script>

    let is_password = true;
    let is_password_confirm = true;

    (function($) {
        "use strict"
        $(document).ready(function () {

            $("#login_btn").on("click", function(){
                $("#login_form").submit();
            })

            $("#password-field").on("click",function(e){
                is_password = !is_password;
                if(is_password){
                    $("#input_password").attr('type', 'password');

                    $("#password-field").html(`<span>
                                        <i class='fa-regular fa-eye-slash' aria-hidden='true' ></i>
                                    </span>`)

                }else{
                    $("#input_password").attr('type', 'text');
                    $("#password-field").html(`<span>
                                        <i class='fa-regular fa-eye' aria-hidden='true' ></i>
                                    </span>`)
                }
            })

            $("#password-field-confirm").on("click",function(e){
                is_password_confirm = !is_password_confirm;
                if(is_password_confirm){
                    $("#input_password_confirm").attr('type', 'password');

                    $("#password-field-confirm").html(`<span>
                                        <i class='fa-regular fa-eye-slash' aria-hidden='true' ></i>
                                    </span>`)

                }else{
                    $("#input_password_confirm").attr('type', 'text');
                    $("#password-field-confirm").html(`<span>
                                        <i class='fa-regular fa-eye' aria-hidden='true' ></i>
                                    </span>`)
                }
            })

        });
    })(jQuery);
</script>
@endpush
