<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class MenuItemSeeder extends Seeder
{
    public function run(): void
    {
        $menuItems = [
            ['id' => 5, 'menu_id' => 1, 'parent_id' => null, 'title' => 'Home', 'url' => 'home', 'target' => '_self', 'icon' => null, 'css_class' => null, 'sort_order' => 1, 'is_active' => 1, 'created_at' => '2025-08-12 04:55:29', 'updated_at' => '2025-08-12 04:56:03'],
            ['id' => 6, 'menu_id' => 1, 'parent_id' => 5, 'title' => 'Home-01', 'url' => '/?theme=one', 'target' => '_self', 'icon' => null, 'css_class' => null, 'sort_order' => 1, 'is_active' => 1, 'created_at' => '2025-08-12 04:56:59', 'updated_at' => '2025-08-12 07:00:51'],
            ['id' => 7, 'menu_id' => 1, 'parent_id' => 5, 'title' => 'Home-02', 'url' => '/?theme=two', 'target' => '_self', 'icon' => null, 'css_class' => null, 'sort_order' => 2, 'is_active' => 1, 'created_at' => '2025-08-12 06:09:29', 'updated_at' => '2025-08-12 07:01:29'],
            ['id' => 8, 'menu_id' => 1, 'parent_id' => null, 'title' => 'Listing', 'url' => 'listings', 'target' => '_self', 'icon' => null, 'css_class' => null, 'sort_order' => 2, 'is_active' => 1, 'created_at' => '2025-08-12 06:10:04', 'updated_at' => '2025-08-12 06:10:04'],
            ['id' => 9, 'menu_id' => 1, 'parent_id' => 8, 'title' => 'Classified', 'url' => '/listings?category=classified', 'target' => '_self', 'icon' => null, 'css_class' => null, 'sort_order' => 1, 'is_active' => 1, 'created_at' => '2025-08-12 06:10:41', 'updated_at' => '2025-08-12 07:06:06'],
            ['id' => 10, 'menu_id' => 1, 'parent_id' => null, 'title' => 'Page', 'url' => 'page', 'target' => '_self', 'icon' => null, 'css_class' => null, 'sort_order' => 3, 'is_active' => 1, 'created_at' => '2025-08-12 06:14:25', 'updated_at' => '2025-08-12 06:14:25'],
            ['id' => 11, 'menu_id' => 1, 'parent_id' => 10, 'title' => 'About Us', 'url' => '/about-us', 'target' => '_self', 'icon' => null, 'css_class' => null, 'sort_order' => 1, 'is_active' => 1, 'created_at' => '2025-08-12 06:15:54', 'updated_at' => '2025-08-12 06:15:54'],
            ['id' => 12, 'menu_id' => 1, 'parent_id' => null, 'title' => 'Contact Us', 'url' => '/contact-us', 'target' => '_self', 'icon' => null, 'css_class' => null, 'sort_order' => 4, 'is_active' => 1, 'created_at' => '2025-08-12 06:16:26', 'updated_at' => '2025-08-12 06:16:26'],
            ['id' => 14, 'menu_id' => 1, 'parent_id' => 5, 'title' => 'Home-03', 'url' => '/?theme=three', 'target' => '_self', 'icon' => null, 'css_class' => null, 'sort_order' => 3, 'is_active' => 1, 'created_at' => '2025-08-12 07:04:13', 'updated_at' => '2025-08-12 07:04:26'],
            ['id' => 15, 'menu_id' => 1, 'parent_id' => 5, 'title' => 'Home-04', 'url' => '/?theme=four', 'target' => '_self', 'icon' => null, 'css_class' => null, 'sort_order' => 4, 'is_active' => 1, 'created_at' => '2025-08-12 07:05:02', 'updated_at' => '2025-08-12 07:05:02'],
            ['id' => 16, 'menu_id' => 1, 'parent_id' => 8, 'title' => 'Job Post', 'url' => '/listings?category=jobpost', 'target' => '_self', 'icon' => null, 'css_class' => null, 'sort_order' => 2, 'is_active' => 1, 'created_at' => '2025-08-12 07:07:51', 'updated_at' => '2025-08-12 08:05:39'],
            ['id' => 20, 'menu_id' => 1, 'parent_id' => 8, 'title' => 'Real Estate', 'url' => '/listings?category=realestate', 'target' => '_self', 'icon' => null, 'css_class' => null, 'sort_order' => 3, 'is_active' => 1, 'created_at' => '2025-08-12 08:07:36', 'updated_at' => '2025-08-12 08:07:36'],
            ['id' => 21, 'menu_id' => 1, 'parent_id' => 8, 'title' => 'Ecommerce', 'url' => '/listings?category=ecommerce', 'target' => '_self', 'icon' => null, 'css_class' => null, 'sort_order' => 4, 'is_active' => 1, 'created_at' => '2025-08-12 08:08:08', 'updated_at' => '2025-08-12 08:08:08'],
            ['id' => 22, 'menu_id' => 1, 'parent_id' => 10, 'title' => 'Our Blogs', 'url' => '/blogs', 'target' => '_self', 'icon' => null, 'css_class' => null, 'sort_order' => 2, 'is_active' => 1, 'created_at' => '2025-08-12 08:10:10', 'updated_at' => '2025-08-12 08:10:10'],
            ['id' => 23, 'menu_id' => 1, 'parent_id' => 10, 'title' => 'FAQ', 'url' => '/faq', 'target' => '_self', 'icon' => null, 'css_class' => null, 'sort_order' => 3, 'is_active' => 1, 'created_at' => '2025-08-12 08:11:28', 'updated_at' => '2025-08-12 08:11:28'],
            ['id' => 24, 'menu_id' => 1, 'parent_id' => 10, 'title' => 'Subscription Plan', 'url' => '/pricing-plan', 'target' => '_self', 'icon' => null, 'css_class' => null, 'sort_order' => 4, 'is_active' => 1, 'created_at' => '2025-08-12 08:12:17', 'updated_at' => '2025-08-12 08:12:17'],
            ['id' => 25, 'menu_id' => 1, 'parent_id' => 10, 'title' => 'Terms & Conditions', 'url' => '/terms-conditions', 'target' => '_self', 'icon' => null, 'css_class' => null, 'sort_order' => 5, 'is_active' => 1, 'created_at' => '2025-08-12 08:13:23', 'updated_at' => '2025-08-12 08:13:23'],
            ['id' => 26, 'menu_id' => 1, 'parent_id' => 10, 'title' => 'Privacy Policy', 'url' => '/privacy-policy', 'target' => '_self', 'icon' => null, 'css_class' => null, 'sort_order' => 6, 'is_active' => 1, 'created_at' => '2025-08-12 08:14:08', 'updated_at' => '2025-08-12 08:14:08'],
            ['id' => 27, 'menu_id' => 1, 'parent_id' => 10, 'title' => 'Custom Page One', 'url' => '/page/custom-page-one', 'target' => '_self', 'icon' => null, 'css_class' => null, 'sort_order' => 7, 'is_active' => 1, 'created_at' => '2025-08-12 08:15:00', 'updated_at' => '2025-08-12 08:17:31'],
            ['id' => 28, 'menu_id' => 1, 'parent_id' => 10, 'title' => 'Custom Page Two', 'url' => '/page/custom-page-two', 'target' => '_self', 'icon' => null, 'css_class' => null, 'sort_order' => 8, 'is_active' => 1, 'created_at' => '2025-08-12 08:17:18', 'updated_at' => '2025-08-12 08:17:18'],
            ['id' => 30, 'menu_id' => 1, 'parent_id' => null, 'title' => 'Cart ( 0 )', 'url' => '/cart/view', 'target' => '_self', 'icon' => null, 'css_class' => null, 'sort_order' => 5, 'is_active' => 1, 'created_at' => '2025-08-12 08:24:34', 'updated_at' => '2025-08-12 08:25:04'],
            ['id' => 31, 'menu_id' => 2, 'parent_id' => null, 'title' => 'My Profile', 'url' => null, 'target' => '_self', 'icon' => null, 'css_class' => null, 'sort_order' => 1, 'is_active' => 1, 'created_at' => '2025-08-12 09:28:10', 'updated_at' => '2025-08-12 09:28:10'],
            ['id' => 32, 'menu_id' => 2, 'parent_id' => 31, 'title' => 'My Dashboard', 'url' => '/user/dashboard', 'target' => '_self', 'icon' => null, 'css_class' => null, 'sort_order' => 1, 'is_active' => 1, 'created_at' => '2025-08-12 09:29:39', 'updated_at' => '2025-08-12 09:29:39'],
            ['id' => 33, 'menu_id' => 2, 'parent_id' => 31, 'title' => 'Post Your Ad', 'url' => '/user/select-listing-purpose', 'target' => '_self', 'icon' => null, 'css_class' => null, 'sort_order' => 2, 'is_active' => 1, 'created_at' => '2025-08-12 09:30:36', 'updated_at' => '2025-08-12 09:30:36'],
            ['id' => 34, 'menu_id' => 2, 'parent_id' => 31, 'title' => 'Change Password', 'url' => '/user/change-password', 'target' => '_self', 'icon' => null, 'css_class' => null, 'sort_order' => 3, 'is_active' => 1, 'created_at' => '2025-08-12 09:31:59', 'updated_at' => '2025-08-12 09:31:59'],
            ['id' => 35, 'menu_id' => 2, 'parent_id' => 31, 'title' => 'Edit Profile', 'url' => '/user/edit-profile', 'target' => '_self', 'icon' => null, 'css_class' => null, 'sort_order' => 4, 'is_active' => 1, 'created_at' => '2025-08-12 09:33:01', 'updated_at' => '2025-08-12 09:34:23'],
            ['id' => 36, 'menu_id' => 2, 'parent_id' => 31, 'title' => 'Wishlist', 'url' => '/user/wishlists', 'target' => '_self', 'icon' => null, 'css_class' => null, 'sort_order' => 5, 'is_active' => 1, 'created_at' => '2025-08-12 09:34:06', 'updated_at' => '2025-08-12 09:34:34'],
            ['id' => 37, 'menu_id' => 3, 'parent_id' => null, 'title' => 'Useful Links', 'url' => null, 'target' => '_self', 'icon' => null, 'css_class' => null, 'sort_order' => 2, 'is_active' => 1, 'created_at' => '2025-08-12 09:36:38', 'updated_at' => '2025-08-12 09:36:38'],
            ['id' => 38, 'menu_id' => 3, 'parent_id' => 37, 'title' => 'About Us', 'url' => '/about-us', 'target' => '_self', 'icon' => null, 'css_class' => null, 'sort_order' => 1, 'is_active' => 1, 'created_at' => '2025-08-12 09:36:54', 'updated_at' => '2025-08-12 09:36:54'],
            ['id' => 39, 'menu_id' => 3, 'parent_id' => 37, 'title' => 'Contact Us', 'url' => '/contact-us', 'target' => '_self', 'icon' => null, 'css_class' => null, 'sort_order' => 2, 'is_active' => 1, 'created_at' => '2025-08-12 09:37:18', 'updated_at' => '2025-08-12 09:37:18'],
            ['id' => 40, 'menu_id' => 3, 'parent_id' => 37, 'title' => 'Our Blog', 'url' => '/blogs', 'target' => '_self', 'icon' => null, 'css_class' => null, 'sort_order' => 3, 'is_active' => 1, 'created_at' => '2025-08-12 09:37:53', 'updated_at' => '2025-08-12 09:37:53'],
            ['id' => 41, 'menu_id' => 3, 'parent_id' => 37, 'title' => 'FAQ', 'url' => '/faq', 'target' => '_self', 'icon' => null, 'css_class' => null, 'sort_order' => 4, 'is_active' => 1, 'created_at' => '2025-08-12 09:38:26', 'updated_at' => '2025-08-12 09:38:26'],
            ['id' => 42, 'menu_id' => 3, 'parent_id' => 37, 'title' => 'Membership', 'url' => '/pricing-plan', 'target' => '_self', 'icon' => null, 'css_class' => null, 'sort_order' => 5, 'is_active' => 1, 'created_at' => '2025-08-12 09:39:15', 'updated_at' => '2025-08-12 09:39:15'],
        ];

        foreach ($menuItems as $item) {
            $exists = DB::table('menu_items')
                ->where('menu_id', $item['menu_id'])
                ->where('title', $item['title'])
                ->first();

            if ($exists) {
                $this->command->info("Menu item '{$item['title']}' already exists.");
            } else {
                DB::table('menu_items')->insert(array_merge($item, [
                    'created_at' => now(),
                    'updated_at' => now(),
                ]));
                $this->command->info("Menu item '{$item['title']}' inserted.");
            }
        }
    }
}
