<?php

namespace Modules\Page\Http\Controllers;

use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\Page\Entities\HomePage;
use Modules\Page\Entities\HomePageTranslation;
use Modules\Page\Http\Requests\WorkingStepRequest;
use Image, File, Str;

class WorkingStepController extends Controller
{
    /**
     * Display a listing of the resource.
     * @return Renderable
     */
    public function index(Request $request)
    {
        $working_step = HomePage::first();
        $translate = HomePageTranslation::where(['home_page_id' => $working_step->id, 'lang_code' => $request->lang_code])->first();

        return view('page::section.working_step', compact('working_step','translate'));
    }

    public function update(WorkingStepRequest $request)
    {

        $translate = HomePageTranslation::where(['id' => $request->translate_id])->first();

        $translate->working_step_title1 = $request->working_step_title1;
        $translate->working_step_des1 = $request->working_step_des1;

        $translate->working_step_title2 = $request->working_step_title2;
        $translate->working_step_des2 = $request->working_step_des2;

        $translate->working_step_title3 = $request->working_step_title3;
        $translate->working_step_des3 = $request->working_step_des3;

        $translate->working_step_title4 = $request->working_step_title4;
        $translate->working_step_des4 = $request->working_step_des4;

        $translate->working_short_title = $request->working_short_title;
        $translate->working_title = $request->working_title;

        $translate->save();

        $working_step = HomePage::first();

        if($request->lang_code == admin_lang()){
            $working_step->video_id = $request->video_id;
            $working_step->save();
        }

        if ($request->hasFile('working_step_icon1')) {
            $image_path = uploadFile($request->file('working_step_icon1'), 'uploads/website-images', $working_step->working_step_icon1);
            $working_step->working_step_icon1 = $image_path;
            $working_step->save();
        } 
        
        if ($request->hasFile('working_step_icon2')) {
            $image_path = uploadFile($request->file('working_step_icon2'), 'uploads/website-images', $working_step->working_step_icon2);
            $working_step->working_step_icon2 = $image_path;
            $working_step->save();
        } 

        if ($request->hasFile('working_step_icon3')) {
            $image_path = uploadFile($request->file('working_step_icon3'), 'uploads/website-images', $working_step->working_step_icon3);
            $working_step->working_step_icon3 = $image_path;
            $working_step->save();
        } 

        if ($request->hasFile('working_step_icon4')) {
            $image_path = uploadFile($request->file('working_step_icon4'), 'uploads/website-images', $working_step->working_step_icon4);
            $working_step->working_step_icon4 = $image_path;
            $working_step->save();
        } 

        if ($request->hasFile('video_image')) {
            $image_path = uploadFile($request->file('video_image'), 'uploads/website-images', $working_step->video_image);
            $working_step->video_image = $image_path;
            $working_step->save();
        } 

        $notification = trans('translate.Updated Successfully');
        $notification = array('messege'=>$notification,'alert-type'=>'success');
        return redirect()->back()->with($notification);

    }


}
