@extends('layout')
@section('title')
    <title>{{ __('translate.Create Classified Listing') }}</title>
@endsection
@section('body-content')

<main>
    <!-- banner-part-start  -->

    <div class="inner-bg common-class"
    style="    background-image:  url({{  custom_asset($breadcrumb, '1905x408') }});">
        <div class="container">
            <div class="row">
                <div class="col-lg-3">

                    <div class="inner-bg-txt">
                        <h1>{{ __('translate.Classified Listing') }}</h1>

                        <ul>
                            <li><a href={{ route('home') }}">{{ __('translate.Home') }}</a></li>
                            <li><span>
                                    <svg width="6" height="12" viewBox="0 0 6 12" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <path
                                            d="M0.633816 2.7705e-08C0.446997 0.0532405 0.28353 0.143084 0.158011 0.319443C-0.0492418 0.618921 -0.0550799 1.0515 0.155092 1.35098C0.195958 1.40755 0.239744 1.46411 0.286449 1.51735C1.56499 2.97481 2.84645 4.4356 4.125 5.89306C4.15419 5.92633 4.18922 5.95295 4.24176 6.03281C4.20673 6.0561 4.16295 6.06941 4.13375 6.10269C2.84062 7.57346 1.5504 9.04755 0.257258 10.5183C0.0295721 10.7779 -0.0579994 11.0773 0.0412483 11.4367C0.187201 11.9591 0.776848 12.1721 1.16216 11.8427C1.20595 11.8061 1.24682 11.7628 1.28768 11.7196C2.7764 10.0225 4.26511 8.32881 5.75091 6.63177C6.02238 6.32231 6.07492 5.92966 5.89394 5.57361C5.85015 5.4871 5.78594 5.41056 5.72464 5.34069C4.27971 3.69356 2.83478 2.04976 1.39277 0.399304C1.23222 0.216289 1.06875 0.0532405 0.838149 3.66367e-08C0.771011 3.3702e-08 0.703873 3.07673e-08 0.633816 2.7705e-08Z" />
                                    </svg>

                                </span></li>
                            <li><a href="javascript:;" class="active">{{ __('translate.Classified Listing') }}</a></li>
                        </ul>
                    </div>

                </div>
            </div>
        </div>
    </div>
    <!-- banner-part-end -->

    <!-- dashboard-part-start -->
    <section class="dashboard footer-top-pad">
        <div class="container">
            <div class="row">
                @include('profile.sidebar')

                <div class="col-xxl-9 col-xl-8 col-lg-8">
                    <form action="{{ route('user.listing.store') }}" enctype="multipart/form-data" method="POST" id="create_listing_form">
                        @csrf

                        <div class="row g-3">

                            <!-- Upload New Image  -->
                            <div class="col-lg-12">
                                <div class="car-images">
                                    <h3 class="car-images-taitel">{{ __('translate.Upload Thumbnail Image') }}

                                        <i 
                                            class="fas fa-info-circle text-info"
                                            data-toggle="tooltip"
                                            data-placement="right"
                                            title="Recommended size: 315x230"
                                            style="cursor: pointer;"
                                        ></i>
                                    </h3>

                                    <div class="car-images-inner">

                                        <div class="uplode-thumb-main">
                                            <div class="uplode-thumb">
                                                <img src="{{  custom_asset($setting->placeholder_image, '315x230') }}" alt="thumb" id="thumb_image">
                                            </div>
                                            <div class="uplode-thumb-main-item">
                                                <p>{{ __('translate.Select') }} <span>{{ __('translate.New File') }}</span> {{ __('translate.to Upload') }}</p>
                                                <input type="file" id="my-file" onchange="previewImage(event)" name="thumb_image">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- Name & Description Overview  -->
                            <div class="col-lg-12">
                                <div class="car-images">
                                    <h3 class="car-images-taitel">{{ __('translate.Basic Information') }}</h3>

                                    <div class="car-images-inner">


                                        <div class="description-item">
                                            <div class="description-item-inner">
                                                <label class="form-label">{{ __('translate.Title') }}
                                                    <span>*</span> </label>
                                                <input type="text" class="form-control" id="title"
                                                    placeholder="{{ __('translate.Title Here') }}" name="title" value="{{ old('title') }}">
                                                    <input type="hidden" name="category_id" value="1">
                                                    <input type="hidden" name="agent_id" value="{{ Auth::guard('web')->user()->id }}">
                                            </div>

                                            <div class="description-item-inner">
                                                <label class="form-label">{{ __('translate.Slug') }}
                                                    <span>*</span> </label>
                                                <input type="text" class="form-control" id="slug"
                                                    placeholder="{{ __('translate.Slug here') }}" name="slug" value="{{ old('slug') }}">
                                            </div>
                                        </div>

                                        <div class="description-item">
                                            <div class="description-item-inner">
                                                <label class="form-label">{{ __('translate.Sub Category') }}
                                                    <span>*</span> </label>
                                                <select class="form-select" name="sub_category_id" id="sub_category_id">
                                                    <option value="">{{ __('translate.Select') }}</option>
                                                    @foreach ($sub_categories as $sub_category)
                                                        <option  {{ $sub_category->id == old('sub_category_id') ? 'selected' : '' }} value="{{ $sub_category->id }}">{{ $sub_category->translate->name }}</option>
                                                    @endforeach
                                                </select>
                                            </div>

                                            <div class="description-item-inner">
                                                <label class="form-label">{{ __('translate.Child Category') }} </label>
                                                <select class="form-select" name="child_category_id" id="child_category_id">
                                                    <option value="">{{ __('translate.Select') }}</option>
                                                </select>
                                            </div>

                                        </div>



                                        <div class="description-item">


                                            <div class="description-item-inner">
                                                <label class="form-label">{{ __('translate.Country') }} <span>*</span> </label>
                                                <select class="form-select " name="country_id" id="country_id">
                                                    <option value="">{{ __('translate.Select Country') }}</option>
                                                    @foreach ($countries as $country)
                                                        <option {{ $country->id == old('country_id') ? 'selected' : '' }} value="{{ $country->id }}">{{ $country->name }}</option>
                                                    @endforeach
                                                </select>
                                            </div>

                                            <div class="description-item-inner">
                                                <label class="form-label">{{ __('translate.City') }} <span>*</span> </label>
                                                <select class="form-select" name="city_id" id="city_id">
                                                    <option value="">{{ __('translate.Select City') }}</option>
                                                </select>
                                            </div>

                                        </div>

                                        <div class="description-item">

                                            <div class="description-item-inner">
                                                <label class="form-label">{{ __('translate.Price') }}
                                                    <span>*</span> </label>
                                                <input type="text" class="form-control"
                                                    placeholder="{{ __('translate.Start from') }}" name="regular_price" value="{{ old('regular_price') }}">
                                            </div>

                                            <div class="description-item-inner">
                                                <label class="form-label">{{ __('translate.Youtube Video id') }} </label>
                                                <input type="text" class="form-control" name="video_id" value="{{ old('video_id') }}"
                                                    placeholder="{{ __('translate.Youtube video id') }}">
                                            </div>

                                        </div>


                                        <div class="description-item">

                                            <div class="description-item-inner">
                                                <label class="form-label">{{ __('translate.Price') }}
                                                    <span>*</span> </label>
                                                <input type="text" class="form-control"
                                                    placeholder="{{ __('translate.Start from') }}" name="regular_price" value="{{ old('regular_price') }}">
                                            </div>

                                            <div class="description-item-inner">
                                                <label class="form-label">{{ __('translate.Youtube Video id') }} </label>
                                                <input type="text" class="form-control" name="video_id" value="{{ old('video_id') }}"
                                                    placeholder="{{ __('translate.Youtube video id') }}">
                                            </div>

                                        </div>

                                        <div class="description-item">

                                            <div class="description-item-inner">
                                                <label class="form-label">{{ __('translate.Description') }}
                                                    <span>*</span> </label>
                                                    <textarea class="form-control summernote"  name="description" id="description">{!! html_decode(old('description')) !!}</textarea>
                                            </div>

                                        </div>

                                    </div>
                                </div>
                            </div>

                            <!-- Features  -->
                            <div class="col-lg-12">
                                <div class="car-images">
                                    <h3 class="car-images-taitel">{{ __('translate.Aminities') }}</h3>

                                    <div class="car-images-inner">
                                        <div class="crancy__item-form--added">
                                            @foreach ($aminities as $index => $aminity)
                                                <div class="form-group crancy-form-checkbox__added mg-top-15">
                                                    <input class="d-none" type="checkbox" id="add1{{ $index }}" name="features[]" value="{{ $aminity->id }}">
                                                    <label class="crancy-form-labe2" for="add1{{ $index }}">{{ $aminity->translate->name }} <span><i
                                                                class="fas fa-times"></i></span></label>
                                                </div>
                                            @endforeach
                                        </div>
                                    </div>
                                </div>
                            </div>



                            <!-- Locations  -->
                            <div class="col-lg-12">
                                <div class="car-images">
                                    <h3 class="car-images-taitel">{{ __('translate.Address & Google Map') }}</h3>

                                    <div class="car-images-inner two">
                                        <div class="description-item two">
                                            <div class="description-item-inner">
                                                <label class="form-label">{{ __('translate.Address') }}
                                                    <span>*</span> </label>
                                                <input type="email" class="form-control" name="address" id="address" value="{{ old('address') }}" placeholder="{{ __('translate.Type your address') }}">
                                            </div>
                                        </div>
                                        <div class="description-item">
                                            <div class="description-item-inner">
                                                <label class="form-label">{{ __('translate.Google Embed Map Link') }}
                                                    <span>*</span> </label>
                                                <textarea class="form-control" rows="7"
                                                    placeholder="{{ __('translate.Paste google embed map link') }}" name="google_map" id="google_map">{{ old('google_map') }}</textarea>
                                            </div>
                                        </div>


                                    </div>
                                </div>
                            </div>

                            <!-- Locations  -->
                            <div class="col-lg-12">
                                <div class="car-images">
                                    <h3 class="car-images-taitel">{{ __('translate.SEO Information') }}</h3>

                                    <div class="car-images-inner two">
                                        <div class="description-item two">
                                            <div class="description-item-inner">
                                                <label class="form-label">{{ __('translate.SEO Title') }}
                                                    </label>
                                                <input type="email" class="form-control" name="seo_title" id="seo_title" value="{{ old('seo_title') }}" placeholder="{{ __('translate.SEO Title') }}">
                                            </div>
                                        </div>
                                        <div class="description-item">
                                            <div class="description-item-inner">
                                                <label class="form-label">{{ __('translate.SEO Description') }}
                                                    </label>
                                                <textarea class="form-control" rows="7"
                                                    placeholder="{{ __('translate.SEO Description') }}" name="seo_description" id="seo_description">{{ old('seo_description') }}</textarea>
                                            </div>
                                        </div>


                                    </div>
                                </div>
                            </div>


                        </div>
                        <div class="row">
                            <!-- Ad Promotion  -->
                            <div class="col-lg-12">
                                <a class="main-btn " href="javascript:;" id="create_listing_btn">
                                    <div class="btn_m">
                                        <div class="btn_c">
                                            <div class="btn_t1">{{ __('translate.Create Listing') }}</div>
                                            <div class="btn_t2">{{ __('translate.Create Listing') }}</div>
                                        </div>
                                    </div>
                                </a>
                            </div>

                        </div>

                    </form>

                </div>


            </div>
        </div>
        </div>
    </section>

    <!-- dashboard-part-end -->

    @include('profile.logout')



</main>

@endsection




@push('style_section')

    <style>
        .tox .tox-promotion,
        .tox-statusbar__branding{
            display: none !important;
        }
    </style>
@endpush

@push('js_section')

    <script src="{{ asset('global/tinymce/js/tinymce/tinymce.min.js') }}"></script>

    <script>
        (function($) {
            "use strict"
            $(document).ready(function () {
                $("#title").on("keyup",function(e){
                    let inputValue = $(this).val();
                    let slug = inputValue.toLowerCase().replace(/[^\w ]+/g,'').replace(/ +/g,'-');
                    $("#slug").val(slug);
                })

                $("#country_id").on("change", function(e){
                    let country_id = $(this).val();

                    if(country_id){
                        $.ajax({
                            type: "get",
                            url: "{{ url('cities-by-country') }}" + "/" + country_id,
                            success: function(response) {
                                $("#city_id").html(response)

                            },
                            error: function(response){
                                let empty_html = `<option value="">{{ __('translate.Select City') }}</option>`;
                                $("#city_id").html(empty_html)
                            }
                        });
                    }else{
                        let empty_html = `<option value="">{{ __('translate.Select City') }}</option>`;
                        $("#city_id").html(empty_html)
                    }
                })

                $("#sub_category_id").on("change", function(e){
                    let sub_category_id = $(this).val();

                    if(sub_category_id){
                        $.ajax({
                            type: "get",
                            url: "{{ url('child-categories-by-sub-category') }}" + "/" + sub_category_id,
                            success: function(response) {
                                $("#child_category_id").html(response)
                            },
                            error: function(response){
                                let empty_html = `<option value="">{{ __('translate.Select') }}</option>`;
                                $("#child_category_id").html(empty_html)
                            }
                        });
                    }else{
                        let empty_html = `<option value="">{{ __('translate.Select') }}</option>`;
                        $("#child_category_id").html(empty_html)
                    }
                })

                tinymce.init({
                    selector: '.summernote',
                    plugins: 'anchor autolink charmap codesample emoticons image link lists media searchreplace table visualblocks wordcount',
                    toolbar: 'undo redo | blocks fontfamily fontsize | bold italic underline strikethrough | link image media table mergetags | addcomment showcomments | spellcheckdialog a11ycheck typography | align lineheight | checklist numlist bullist indent outdent | emoticons charmap | removeformat',
                    tinycomments_mode: 'embedded',
                    tinycomments_author: 'Author name',
                    mergetags_list: [
                        { value: 'First.Name', title: 'First Name' },
                        { value: 'Email', title: 'Email' },
                    ]
                });

                $("#create_listing_btn").on("click", function(){
                    $("#create_listing_form").submit();

                })

            });
        })(jQuery);

        function previewImage(event) {
            var reader = new FileReader();
            reader.onload = function(){
                var output = document.getElementById('thumb_image');
                output.src = reader.result;
            }

            reader.readAsDataURL(event.target.files[0]);
        };


    </script>


@endpush


