<?php
namespace Modules\SupportTicket\Http\Requests;
use Illuminate\Foundation\Http\FormRequest;
class SupportTicketRequest extends FormRequest
{

    public function rules(): array
    {
        $rules = [
            'subject'=>'required|max:255',
            'priority'=>'required|max:255',
            'message'=>'required',
        ];
        return $rules;
    }

    public function messages(): array
    {
        return [
            'subject.required' => trans('Subject is required'),
            'priority.required' => trans('Priority is required'),
            'message.required' => trans('Message is required'),
        ];
    }

    public function authorize(): bool
    {
        return true;
    }
}
