<?php

namespace Modules\SupportTicket\Entities;

use App\Models\User;
use Illuminate\Database\Eloquent\Model;

class SupportTicket extends Model
{

    protected $fillable = [];
    protected $appends = ['unseen_message'];
    protected $hidden = ['unSeenUserMessage'];

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id')->select('id','name','email','image','phone','address');
    }

    public function unSeenUserMessage()
    {
        return $this->hasMany(TicketMessage::class)->where('seen_by_user', 'no');
    }
    public function getMessages()
    {
        return $this->hasMany(TicketMessage::class);
    }

    public function getUnseenMessageAttribute()
    {
        return $this->unSeenUserMessage->count();
    }
}
