<?php

namespace Modules\Page\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class WorkingStepRequest extends FormRequest
{
    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $rules =  [
            'working_step_title1' => 'required',
            'working_step_des1' => 'required',

            'working_step_title2' => 'required',
            'working_step_des2' => 'required',

            'working_step_title3' => 'required',
            'working_step_des3' => 'required',

            'working_step_title4' => 'required',
            'working_step_des4' => 'required',

            'working_short_title' => 'required',
            'working_title' => 'required',

        ];

        if($this->request->get('lang_code') == admin_lang()){
            $rules['video_id'] = 'required';
        }

        return $rules;
    }

    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    public function messages(): array
    {
        return [
            'working_step_title1.required' => trans('translate.Title is required'),
            'working_step_des1.required' => trans('translate.Description is required'),

            'working_step_title2.required' => trans('translate.Title is required'),
            'working_step_des2.required' => trans('translate.Description is required'),

            'working_step_title3.required' => trans('translate.Title is required'),
            'working_step_des3.required' => trans('translate.Description is required'),

            'working_step_title4.required' => trans('translate.Title is required'),
            'working_step_des4.required' => trans('translate.Description is required'),

            'working_short_title.required' => trans('translate.Short title is required'),
            'working_title.required' => trans('translate.Title is required'),
            'video_id.required' => trans('translate.Video id is required'),

        ];
    }
}
