<?php

namespace Modules\Page\Http\Controllers;

use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\Page\Entities\HomePage;
use Modules\Page\Entities\HomePageTranslation;
use Modules\Page\Http\Requests\IntroRequest;
use Image, File, Str;

class IntroController extends Controller
{
    /**
     * Display a listing of the resource.
     * @return Renderable
     */
    public function index(Request $request)
    {
        $home1_intro = HomePage::first();
        $translate = HomePageTranslation::where(['home_page_id' => $home1_intro->id, 'lang_code' => $request->lang_code])->first();

        return view('page::section.home1_intro', compact('home1_intro','translate'));
    }

    /**
     * Show the form for creating a new resource.
     * @return Renderable
     */
    public function update(IntroRequest $request)
    {

        $translate = HomePageTranslation::where(['id' => $request->translate_id])->first();
        $translate->home1_intro_short_title = $request->short_title;
        $translate->home1_intro_title = $request->intro_title;
        $translate->save();

        $home1_intro = HomePage::first();

        if($request->home1_intro_image){
            $old_image = $home1_intro->home1_intro_image;
            $image_name = 'home1-intro-image'.date('-Y-m-d-h-i-s-').rand(999,9999).'.webp';
            $image_name ='uploads/website-images/'.$image_name;
            Image::make($request->home1_intro_image)
                ->encode('webp', 80)
                ->save(public_path().'/'.$image_name);
            $home1_intro->home1_intro_image = $image_name;
            $home1_intro->save();

            if($old_image){
                if(File::exists(public_path().'/'.$old_image))unlink(public_path().'/'.$old_image);
            }
        }

        $notification = trans('translate.Updated Successfully');
        $notification = array('messege'=>$notification,'alert-type'=>'success');
        return redirect()->back()->with($notification);

    }

    public function home2_intro(Request $request)
    {
        $home2_intro = HomePage::first();
        $translate = HomePageTranslation::where(['home_page_id' => $home2_intro->id, 'lang_code' => $request->lang_code])->first();

        return view('page::section.home2_intro', compact('home2_intro','translate'));
    }

    public function home2_intro_update(IntroRequest $request)
    {

        $translate = HomePageTranslation::where(['id' => $request->translate_id])->first();
        $translate->home2_intro_short_title = $request->short_title;
        $translate->home2_intro_title = $request->intro_title;
        $translate->home2_intro_des = $request->intro_des;
        $translate->save();

        $home2_intro = HomePage::first();

        if($request->home2_intro_image){
            $old_image = $home2_intro->home2_intro_image;
            $image_name = 'home2-intro-image'.date('-Y-m-d-h-i-s-').rand(999,9999).'.webp';
            $image_name ='uploads/website-images/'.$image_name;
            Image::make($request->home2_intro_image)
                ->encode('webp', 80)
                ->save(public_path().'/'.$image_name);
            $home2_intro->home2_intro_image = $image_name;
            $home2_intro->save();

            if($old_image){
                if(File::exists(public_path().'/'.$old_image))unlink(public_path().'/'.$old_image);
            }
        }

        if($request->home2_intro_bg){
            $old_image = $home2_intro->home2_intro_bg;
            $image_name = 'home2-intro-bg'.date('-Y-m-d-h-i-s-').rand(999,9999).'.webp';
            $image_name ='uploads/website-images/'.$image_name;
            Image::make($request->home2_intro_bg)
                ->encode('webp', 80)
                ->save(public_path().'/'.$image_name);
            $home2_intro->home2_intro_bg = $image_name;
            $home2_intro->save();

            if($old_image){
                if(File::exists(public_path().'/'.$old_image))unlink(public_path().'/'.$old_image);
            }
        }

        $notification = trans('translate.Updated Successfully');
        $notification = array('messege'=>$notification,'alert-type'=>'success');
        return redirect()->back()->with($notification);

    }

    public function home3_intro(Request $request)
    {
        $home3_intro = HomePage::first();
        $translate = HomePageTranslation::where(['home_page_id' => $home3_intro->id, 'lang_code' => $request->lang_code])->first();

        return view('page::section.home3_intro', compact('home3_intro','translate'));
    }

    public function home3_intro_update(IntroRequest $request)
    {

        $translate = HomePageTranslation::where(['id' => $request->translate_id])->first();
        $translate->home3_intro_short_title = $request->short_title;
        $translate->home3_intro_title = $request->intro_title;
        $translate->home3_intro_des = $request->intro_des;
        $translate->save();

        $home3_intro = HomePage::first();

        if($request->home3_intro_image){
            $old_image = $home3_intro->home3_intro_image;
            $image_name = 'home3-intro-image'.date('-Y-m-d-h-i-s-').rand(999,9999).'.webp';
            $image_name ='uploads/website-images/'.$image_name;
            Image::make($request->home3_intro_image)
                ->encode('webp', 80)
                ->save(public_path().'/'.$image_name);
            $home3_intro->home3_intro_image = $image_name;
            $home3_intro->save();

            if($old_image){
                if(File::exists(public_path().'/'.$old_image))unlink(public_path().'/'.$old_image);
            }
        }

        if($request->home3_intro_bg){
            $old_image = $home3_intro->home3_intro_bg;
            $image_name = 'home3-intro-bg'.date('-Y-m-d-h-i-s-').rand(999,9999).'.webp';
            $image_name ='uploads/website-images/'.$image_name;
            Image::make($request->home3_intro_bg)
                ->encode('webp', 80)
                ->save(public_path().'/'.$image_name);
            $home3_intro->home3_intro_bg = $image_name;
            $home3_intro->save();

            if($old_image){
                if(File::exists(public_path().'/'.$old_image))unlink(public_path().'/'.$old_image);
            }
        }



        $notification = trans('translate.Updated Successfully');
        $notification = array('messege'=>$notification,'alert-type'=>'success');
        return redirect()->back()->with($notification);

    }

    public function assign_language($lang_code){

        $home_translate = HomePageTranslation::where(['lang_code' => admin_lang()])->first();

        $translate = new HomePageTranslation();
        $translate->home_page_id = $home_translate->home_page_id;
        $translate->lang_code = $lang_code;

        $translate->home1_intro_short_title = $home_translate->home1_intro_short_title;
        $translate->home1_intro_title = $home_translate->home1_intro_title;
        $translate->home2_intro_short_title = $home_translate->home2_intro_short_title;
        $translate->home2_intro_title = $home_translate->home2_intro_title;
        $translate->home3_intro_short_title = $home_translate->home3_intro_short_title;
        $translate->home3_intro_title = $home_translate->home3_intro_title;
        $translate->home3_intro_des = $home_translate->home3_intro_des;

        $translate->working_step_title1 = $home_translate->working_step_title1;
        $translate->working_step_des1 = $home_translate->working_step_des1;
        $translate->working_step_title2 = $home_translate->working_step_title2;
        $translate->working_step_des2 = $home_translate->working_step_des2;
        $translate->working_step_title3 = $home_translate->working_step_title3;
        $translate->working_step_des3 = $home_translate->working_step_des3;
        $translate->working_step_title4 = $home_translate->working_step_title4;
        $translate->working_step_des4 = $home_translate->working_step_des4;

        $translate->counter_title1 = $home_translate->counter_title1;
        $translate->counter_title2 = $home_translate->counter_title2;
        $translate->counter_title3 = $home_translate->counter_title3;
        $translate->counter_title4 = $home_translate->counter_title4;

        $translate->home1_explore_title = $home_translate->home1_explore_title;
        $translate->home1_explore_des = $home_translate->home1_explore_des;
        $translate->home2_explore_title = $home_translate->home2_explore_title;
        $translate->home2_explore_des = $home_translate->home2_explore_des;
        $translate->home3_explore_title = $home_translate->home3_explore_title;

        $translate->save();

    }

    public function home4_intro(Request $request)
    {
        $home4_intro = HomePage::first();
        $translate = HomePageTranslation::where(['home_page_id' => $home4_intro->id, 'lang_code' => $request->lang_code])->first();

        return view('page::section.home4_intro', compact('home4_intro','translate'));
    }

    public function home4_intro_update(Request $request)
    {

        $home4_intro = HomePage::first();

        if($request->home4_bg_image){
            $old_image = $home4_intro->home4_bg_image;
            $image_name = 'home4-bg_image'.date('-Y-m-d-h-i-s-').rand(999,9999).'.webp';
            $image_name ='uploads/website-images/'.$image_name;
            Image::make($request->home4_bg_image)
                ->encode('webp', 80)
                ->save(public_path().'/'.$image_name);
            $home4_intro->home4_bg_image = $image_name;
            $home4_intro->save();

            if($old_image){
                if(File::exists(public_path().'/'.$old_image))unlink(public_path().'/'.$old_image);
            }
        }

        $home4_intro->home4_explore_image = $request->link;
        $home4_intro->save();

        $notification = trans('translate.Updated Successfully');
        $notification = array('messege'=>$notification,'alert-type'=>'success');
        return redirect()->back()->with($notification);
    }


}
